/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.demand.third.u8.api.extend;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.els.common.enumerate.AuditStatusEnum;
import com.els.common.util.DateUtils;
import com.els.config.mybatis.TenantContext;
import com.els.modules.base.api.dto.TemplateHeadDTO;
import com.els.modules.base.api.service.InterfaceCustomExtendRpcService;
import com.els.modules.base.api.service.TemplateRpcService;
import com.els.modules.demand.entity.PurchaseRequestItem;
import com.els.modules.demand.enumerate.PurchaseRequestStatusItemEnum;
import com.els.modules.demand.service.PurchaseRequestHeadService;
import com.els.modules.demand.service.PurchaseRequestItemService;
import com.els.modules.demand.vo.PurchaseRequestHeadVO;
import com.els.modules.material.api.dto.PurchaseMaterialHeadDTO;
import com.els.modules.material.api.service.PurchaseMaterialHeadRpcService;
import com.els.modules.price.api.service.PurchaseInformationRecordsRpcService;
import com.els.rpc.service.InvokeBaseRpcService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

@Service
public class GetPurchaseRequestFromLuoShiU8ServiceImpl
implements InterfaceCustomExtendRpcService {
    private static final Logger log = LoggerFactory.getLogger(GetPurchaseRequestFromLuoShiU8ServiceImpl.class);
    @Resource
    private TemplateRpcService templateRpcService;
    @Resource
    private PurchaseRequestHeadService purchaseRequestHeadService;
    @Resource
    private PurchaseRequestItemService PurchaseRequestItemService;
    @Resource
    private PurchaseInformationRecordsRpcService purchaseInformationRecordsRpcService;
    @Resource
    private InvokeBaseRpcService invokeBaseRpcService;
    @Resource
    private PurchaseMaterialHeadRpcService purchaseMaterialHeadRpcService;

    public JSONObject before(JSONObject obj, Object custom) {
        JSONObject puordervo = new JSONObject();
        puordervo.put("date_begin", (Object)"2023-01-01");
        puordervo.put("date_end", (Object)DateUtils.formatDate((Date)new Date(), (String)"yyyy-MM-dd"));
        puordervo.put("corp", (Object)"02");
        obj.put("body", (Object)puordervo);
        log.info("\u83b7\u53d6U8\u8bf7\u8d2d\u5355\u8bf7\u6c42\u53c2\u6570\uff1a{}", (Object)obj.toJSONString());
        return obj;
    }

    public JSONObject after(JSONObject interfaceResult, JSONObject paramObj, Object custom) {
        log.info("GetPurchaseRequestFromLuoShiU8DbImpl --> after result Data:{}", (Object)interfaceResult.toJSONString());
        String result = this.handlerResultListInfo(interfaceResult);
        JSONObject data = JSON.parseObject((String)result);
        int allcount = data.getIntValue("allcount");
        if (allcount > 0) {
            JSONArray dataArray = data.getJSONArray("datas");
            List templateList = this.templateRpcService.getDefaultTemplateByType("purchaseRequest");
            Assert.notEmpty((Collection)templateList, (String)"\u8bf7\u5148\u914d\u7f6e\u7269\u6599\u4e3b\u6570\u636e\u9ed8\u8ba4\u6a21\u677f");
            TemplateHeadDTO template = (TemplateHeadDTO)templateList.get(0);
            QueryWrapper queryWrapper = new QueryWrapper();
            queryWrapper.eq((Object)"apply_date", (Object)DateUtils.formatDate((Date)new Date(), (String)"yyyy-MM-dd"));
            List oldList = this.purchaseRequestHeadService.list((Wrapper)queryWrapper);
            Set<Object> requestNumbers = new HashSet();
            if (!CollectionUtils.isEmpty((Collection)oldList)) {
                requestNumbers = oldList.stream().map(i -> i.getRequestNumber()).collect(Collectors.toSet());
            }
            for (Object object : dataArray) {
                JSONObject item = (JSONObject)object;
                String parentvo = item.getString("parentvo");
                String childrenvo = item.getString("childrenvo");
                JSONObject jsonObject = JSONObject.parseObject((String)parentvo);
                JSONArray array = JSONObject.parseArray((String)childrenvo);
                Map<String, PurchaseMaterialHeadDTO> materialCodeMap = this.getMaterialCode(array);
                PurchaseRequestHeadVO head = this.initHead(jsonObject, template);
                if (requestNumbers.contains(head.getRequestNumber())) continue;
                List<Object> items = new ArrayList();
                if (array.size() > 0) {
                    items = this.initItems(head, array, materialCodeMap);
                    head.setFbk1(((PurchaseRequestItem)items.get(0)).getProjectNumber());
                    head.setFbk2(((PurchaseRequestItem)items.get(0)).getProjectName());
                }
                this.purchaseRequestHeadService.saveMain(head, items, null);
            }
        }
        return null;
    }

    private Map<String, PurchaseMaterialHeadDTO> getMaterialCode(JSONArray u8ItemList) {
        List materialNumberList = u8ItemList.stream().map(object -> {
            JSONObject json = (JSONObject)object;
            return json.getString("inv_code");
        }).distinct().collect(Collectors.toList());
        List materialNumbers = this.purchaseMaterialHeadRpcService.listByMaterialNumbers(materialNumberList);
        return materialNumbers.stream().filter(master -> StringUtils.isNotBlank((CharSequence)master.getMaterialNumber())).collect(Collectors.toMap(master -> master.getMaterialNumber().toUpperCase(), Function.identity(), (newVal, oldVal) -> oldVal));
    }

    private List<PurchaseRequestItem> initItems(PurchaseRequestHeadVO head, JSONArray array, Map<String, PurchaseMaterialHeadDTO> materialCodeMap) {
        ArrayList<PurchaseRequestItem> requestItemList = new ArrayList<PurchaseRequestItem>();
        for (Object object : array) {
            JSONObject item = (JSONObject)object;
            PurchaseRequestItem requestItem = new PurchaseRequestItem();
            requestItem.setHeadId(head.getId());
            requestItem.setElsAccount(head.getElsAccount());
            requestItem.setRequestNumber(head.getRequestNumber());
            requestItem.setPurchaseType("BZ");
            requestItem.setMaterialNumber(item.getString("inv_code"));
            requestItem.setItemNumber(item.getString("crowno"));
            requestItem.setMaterialName(item.getString("inv_name"));
            requestItem.setMaterialDesc(item.getString("inv_name"));
            requestItem.setMaterialModel(item.getString("invtype"));
            requestItem.setMaterialSpec(item.getString("invspec"));
            requestItem.setQuantity(item.getBigDecimal("npraynum"));
            requestItem.setRepertoryQuantity(item.getBigDecimal("npraynum"));
            requestItem.setTaxCode("\u5546\u4e1a\uff0813 % )");
            requestItem.setTaxRate("13");
            requestItem.setRemark(item.getString("vmemo"));
            requestItem.setDeliveryDate(item.getDate("ddemanddate"));
            requestItem.setSubtotalAmount(item.getBigDecimal("nmoney"));
            requestItem.setPurchaseUnit(item.getString("unitcode"));
            requestItem.setProjectNumber(item.getString("project_code"));
            requestItem.setProjectName(item.getString("project_name"));
            requestItem.setStorageLocation(item.getString("warehouse_code"));
            requestItem.setPrice(item.getBigDecimal("nsuggestprice"));
            List effectiveRecordList = this.purchaseInformationRecordsRpcService.getEffectiveRecordList(requestItem.getMaterialNumber(), null, null, null, null);
            if (CollectionUtils.isEmpty((Collection)effectiveRecordList)) {
                requestItem.setItemStatus(PurchaseRequestStatusItemEnum.DEMAND_POOL.getValue());
            } else {
                requestItem.setItemStatus(PurchaseRequestStatusItemEnum.WAIT_ORDER.getValue());
            }
            PurchaseMaterialHeadDTO purchaseMaterialHeadDTO = materialCodeMap.get(requestItem.getMaterialNumber());
            if (null != purchaseMaterialHeadDTO) {
                requestItem.setCateCode(purchaseMaterialHeadDTO.getCateCode());
                requestItem.setCateName(purchaseMaterialHeadDTO.getCateName());
            }
            requestItemList.add(requestItem);
        }
        return requestItemList;
    }

    private PurchaseRequestHeadVO initHead(JSONObject jsonObject, TemplateHeadDTO template) {
        PurchaseRequestHeadVO head = new PurchaseRequestHeadVO();
        head.setId(IdWorker.getIdStr());
        head.setElsAccount(TenantContext.getTenant());
        head.setTemplateAccount(template.getElsAccount());
        head.setTemplateName(template.getTemplateName());
        head.setTemplateNumber(template.getTemplateNumber());
        head.setTemplateVersion(String.valueOf(template.getTemplateVersion()));
        head.setRequestNumber(jsonObject.getString("vpraycode"));
        head.setApplyDate(jsonObject.getDate("dpraydate"));
        head.setRequestType(jsonObject.getString("ipraytype"));
        head.setCompany(jsonObject.getString("unit_code"));
        head.setPurchaseOrg("LS002");
        head.setApplyDept(jsonObject.getString("cdeptid"));
        head.setApplyDeptName(jsonObject.getString("cdeptid_name"));
        head.setPurchasePrincipal(jsonObject.getString("praypsn_code"));
        head.setSourceType("interface");
        head.setAudit(AuditStatusEnum.AUDIT_FINISH.getValue());
        head.setMustMaterialNumber("1");
        head.setRemark(jsonObject.getString("vmemo"));
        head.setRequestStatus(String.valueOf(3));
        head.setApplyDept(jsonObject.getString("cdeptid_code"));
        head.setApplicant(jsonObject.getString("praypsn_code"));
        head.setPurchaseType(jsonObject.getString("ipraytype"));
        head.setCreateBy(jsonObject.getString("operator_code"));
        head.setCreateTime(jsonObject.getDate("tmaketime"));
        head.setUpdateTime(jsonObject.getDate("taudittime"));
        head.setUpdateBy(jsonObject.getString("auditpsn_name"));
        head.setFbk3(jsonObject.getString("vdef4"));
        head.setFbk4(jsonObject.getString("vdef5"));
        return head;
    }

    private String handlerResultListInfo(JSONObject obj) {
        Assert.isTrue((obj.getIntValue("code") == 200 ? 1 : 0) != 0, (String)obj.getString("message"));
        JSONObject result = obj.getJSONObject("result");
        Assert.isTrue((boolean)result.getString("status").equals("success"), (String)result.getString("message"));
        return result.getString("data");
    }
}

