/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.enquiry.api.service.impl;

import cn.hutool.core.text.CharSequenceUtil;
import com.els.common.im.ImBaseUserRecordRpcService;
import com.els.common.util.I18nUtil;
import com.els.modules.account.api.dto.ImUserDTO;
import com.els.modules.enquiry.entity.EnquirySupplierList;
import com.els.modules.enquiry.entity.PurchaseEnquiryHead;
import com.els.modules.enquiry.entity.SaleEnquiryHead;
import com.els.modules.enquiry.enumerate.EnquiryStatusEnum;
import com.els.modules.enquiry.service.EnquirySupplierListService;
import com.els.modules.enquiry.service.PurchaseEnquiryHeadService;
import com.els.modules.enquiry.service.SaleEnquiryHeadService;
import com.els.modules.im.api.dto.ImRecordDto;
import com.els.modules.im.api.enumerate.ImRecordTypeEnum;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service(value="purchaseEnquiryImUserRecordServiceImpl")
public class PurchaseEnquiryUserRecordInvokeBeanServiceImpl
extends ImBaseUserRecordRpcService {
    @Resource
    private PurchaseEnquiryHeadService purchaseEnquiryHeadService;
    @Resource
    private SaleEnquiryHeadService saleEnquiryHeadService;
    @Resource
    private EnquirySupplierListService enquirySupplierListService;

    public List<ImUserDTO> getRecordPersonInCharge(ImRecordDto imRecordDto) {
        ArrayList<ImUserDTO> resultList = new ArrayList<ImUserDTO>();
        if (ImRecordTypeEnum.PURCHASE_ENQUIRY.getValue().equals(imRecordDto.getType())) {
            PurchaseEnquiryHead dbHead = (PurchaseEnquiryHead)this.purchaseEnquiryHeadService.getById((Serializable)((Object)imRecordDto.getRecordId()));
            Assert.isTrue((null != dbHead ? 1 : 0) != 0, (String)String.format(I18nUtil.translate((String)"i18n_alert_hsutWWWWxMK_ab6b9588", (String)"\u8be2\u62a5\u4ef7\u5355[%s]\u4e0d\u5b58\u5728"), imRecordDto.getRecordId()));
            Assert.isTrue((!EnquiryStatusEnum.NEW.getValue().equals(dbHead.getEnquiryStatus()) ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_alert_VIzEWShRe_3e411e67", (String)"\u65b0\u5efa\u72b6\u6001\uff0c\u65e0\u6cd5\u6c9f\u901a"));
            List supplierList = this.enquirySupplierListService.selectByMainId(imRecordDto.getRecordId());
            return this.queryAllUserWithGroupChat(supplierList.stream().map(EnquirySupplierList::getToElsAccount).filter(CharSequenceUtil::isNotEmpty).collect(Collectors.toList()));
        }
        if (ImRecordTypeEnum.SALE_ENQUIRY.getValue().equals(imRecordDto.getType())) {
            SaleEnquiryHead dbHead = (SaleEnquiryHead)this.saleEnquiryHeadService.getById((Serializable)((Object)imRecordDto.getRecordId()));
            Assert.isTrue((null != dbHead ? 1 : 0) != 0, (String)String.format(I18nUtil.translate((String)"i18n_alert_hsutWWWWxMK_ab6b9588", (String)"\u8be2\u62a5\u4ef7\u5355[%s]\u4e0d\u5b58\u5728"), imRecordDto.getRecordId()));
            String toElsAccount = dbHead.getToElsAccount();
            String subAccount = dbHead.getPublishUser().split("_")[0];
            ImUserDTO e = new ImUserDTO();
            e.setElsAccount(toElsAccount + "_" + subAccount);
            resultList.add(e);
        }
        return resultList;
    }
}

