/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.demand.third.u8.job;

import com.els.common.api.service.JobRpcService;
import com.els.common.exception.ELSBootException;
import com.els.common.system.vo.LoginUser;
import com.els.common.util.I18nUtil;
import com.els.common.util.LoginUserContext;
import com.els.common.util.RedisUtil;
import com.els.common.util.SysUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.demand.service.PurchaseRequestHeadService;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Service;

@Service(value="getPurchaseRequestFromLuoShiU8Job")
public class GetPurchaseRequestFromLuoShiU8Job
implements JobRpcService {
    private static final Logger log = LoggerFactory.getLogger(GetPurchaseRequestFromLuoShiU8Job.class);
    private final String LOCK_PREFIX = "purchaseRequest_schedule_getPurchaseRequestFromLuoShiU8Job";
    private final long EXPIRE_TIME = 50000L;
    @Resource
    private PurchaseRequestHeadService purchaseRequestHeadService;
    @Autowired
    private RedisUtil redisUtil;

    public void execute(String parameter) {
        String requestId;
        TenantContext.setTenant((String)SysUtil.getPurchaseAccount());
        LoginUser loginUser = SysUtil.getLoginUser();
        if (loginUser == null) {
            loginUser = new LoginUser();
            loginUser.setElsAccount(SysUtil.getPurchaseAccount());
            loginUser.setSubAccount("1001");
            LoginUserContext.setUser((LoginUser)loginUser);
        }
        if (!this.redisUtil.tryGetDistributedLock("purchaseRequest_schedule_getPurchaseRequestFromLuoShiU8Job", requestId = "getPurchaseRequestFromLuoShiU8Job", 50000L)) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_LSiKRcWVxPVBRc_38df5694", (String)"\u4efb\u52a1\u6b63\u5728\u6267\u884c\uff0c\u8bf7\u4e0d\u8981\u91cd\u590d\u6267\u884c"));
        }
        try {
            this.purchaseRequestHeadService.getPurchaseRequestByERP();
        }
        catch (Exception e) {
            log.info(Thread.currentThread().getName() + "\u83b7\u53d6U8C\u91c7\u8d2d\u7533\u8bf7\u5355\u51fa\u73b0\u5f02\u5e38:", (Throwable)e);
            throw e;
        }
        finally {
            this.redisUtil.releaseDistributedLock("purchaseRequest_schedule_getPurchaseRequestFromLuoShiU8Job", requestId);
        }
    }

    @Scheduled(cron="0 59 23 * * *")
    public void doScheduled() {
        this.execute(null);
    }
}

