/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.demand.third.u8.api.extend;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.text.CharSequenceUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.els.common.aspect.annotation.SrmTransaction;
import com.els.common.constant.CommonConstant;
import com.els.common.enumerate.AuditStatusEnum;
import com.els.common.exception.ELSBootException;
import com.els.common.util.DateUtils;
import com.els.common.util.I18nUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.account.api.dto.ElsSubAccountDTO;
import com.els.modules.account.api.service.AccountRpcService;
import com.els.modules.base.api.dto.PurchaseAttachmentDTO;
import com.els.modules.base.api.dto.TemplateHeadDTO;
import com.els.modules.base.api.service.InterfaceCustomExtendRpcService;
import com.els.modules.base.api.service.TemplateRpcService;
import com.els.modules.demand.entity.PurchaseRequestItem;
import com.els.modules.demand.enumerate.PurchaseRequestStatusItemEnum;
import com.els.modules.demand.mapper.PurchaseRequestHeadMapper;
import com.els.modules.demand.mapper.PurchaseRequestItemMapper;
import com.els.modules.demand.service.PurchaseRequestHeadService;
import com.els.modules.demand.service.PurchaseRequestItemService;
import com.els.modules.demand.vo.PurchaseRequestHeadVO;
import com.els.modules.integrated.api.dto.IntegratedBusinessDataDTO;
import com.els.modules.integrated.api.dto.IntegratedDocumentDTO;
import com.els.modules.material.api.dto.PurchaseMaterialHeadDTO;
import com.els.modules.material.api.service.PurchaseMaterialHeadRpcService;
import com.els.modules.price.api.service.PurchaseInformationRecordsRpcService;
import com.els.rpc.service.InvokeBaseRpcService;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;

@Service
public class GetPurchaseRequestFromLuoShiU8ServiceImpl
implements InterfaceCustomExtendRpcService {
    private static final Logger log = LoggerFactory.getLogger(GetPurchaseRequestFromLuoShiU8ServiceImpl.class);
    @Resource
    private TemplateRpcService templateRpcService;
    @Resource
    private PurchaseRequestHeadService purchaseRequestHeadService;
    @Resource
    private PurchaseRequestItemService PurchaseRequestItemService;
    @Resource
    private PurchaseInformationRecordsRpcService purchaseInformationRecordsRpcService;
    @Resource
    private InvokeBaseRpcService invokeBaseRpcService;
    @Resource
    private PurchaseMaterialHeadRpcService purchaseMaterialHeadRpcService;
    @Resource
    private PurchaseRequestHeadMapper purchaseRequestHeadMapper;
    @Resource
    private PurchaseRequestItemMapper purchaseRequestItemMapper;
    @Resource
    private AccountRpcService accountRpcService;

    public JSONObject before(JSONObject obj, Object custom) {
        JSONObject puordervo = new JSONObject();
        Calendar calendar = Calendar.getInstance();
        calendar.add(6, -5);
        Date date = calendar.getTime();
        puordervo.put("date_begin", (Object)DateUtils.formatDate((Date)date, (String)"yyyy-MM-dd"));
        puordervo.put("date_end", (Object)DateUtils.formatDate((Date)new Date(), (String)"yyyy-MM-dd"));
        puordervo.put("corp", (Object)"02");
        puordervo.put("forderstatus", (Object)"3");
        obj.put("body", (Object)puordervo);
        log.info("\u83b7\u53d6U8\u8bf7\u8d2d\u5355\u8bf7\u6c42\u53c2\u6570\uff1a{}", (Object)obj.toJSONString());
        return obj;
    }

    @SrmTransaction(rollbackFor={Exception.class})
    public JSONObject after(JSONObject interfaceResult, JSONObject paramObj, Object custom) {
        log.info("GetPurchaseRequestFromLuoShiU8DbImpl --> after result Data:{}", (Object)interfaceResult.toJSONString());
        String elsAccount = TenantContext.getTenant();
        String result = this.handlerResultListInfo(interfaceResult);
        JSONObject data = JSON.parseObject((String)result);
        int allcount = data.getIntValue("allcount");
        if (allcount > 0) {
            JSONArray dataArray = data.getJSONArray("datas");
            List templateList = this.templateRpcService.getDefaultTemplateByType("purchaseRequest");
            Assert.notEmpty((Collection)templateList, (String)"\u8bf7\u5148\u914d\u7f6e\u7269\u6599\u4e3b\u6570\u636e\u9ed8\u8ba4\u6a21\u677f");
            TemplateHeadDTO template = (TemplateHeadDTO)templateList.get(0);
            Map<String, ElsSubAccountDTO> subAccountMap = this.getAccountMap(elsAccount, dataArray);
            Calendar calendar = Calendar.getInstance();
            calendar.add(6, -5);
            Date date = calendar.getTime();
            QueryWrapper queryWrapper = new QueryWrapper();
            queryWrapper.ge((Object)"apply_date", (Object)DateUtils.formatDate((Date)date, (String)"yyyy-MM-dd"));
            List oldList = this.purchaseRequestHeadService.list((Wrapper)queryWrapper);
            Set<Object> requestNumbers = new HashSet();
            if (!CollectionUtils.isEmpty((Collection)oldList)) {
                requestNumbers = oldList.stream().map(i -> i.getRequestNumber()).collect(Collectors.toSet());
            }
            for (Object object : dataArray) {
                JSONObject item = (JSONObject)object;
                String parentvo = item.getString("parentvo");
                String childrenvo = item.getString("childrenvo");
                JSONObject jsonObject = JSONObject.parseObject((String)parentvo);
                JSONArray array = JSONObject.parseArray((String)childrenvo);
                Map<String, PurchaseMaterialHeadDTO> materialCodeMap = this.getMaterialCode(array);
                PurchaseRequestHeadVO head = this.initHead(jsonObject, template, subAccountMap);
                if (requestNumbers.contains(head.getRequestNumber())) continue;
                List<PurchaseRequestItem> items = new ArrayList<PurchaseRequestItem>();
                if (array.size() > 0) {
                    items = this.initItems(head, array, materialCodeMap);
                    head.setFbk1(items.get(0).getProjectNumber());
                    head.setFbk2(items.get(0).getProjectName());
                }
                this.saveRequest(head, items, null);
            }
        }
        return null;
    }

    public void saveRequest(PurchaseRequestHeadVO purchaseRequestHead, List<PurchaseRequestItem> purchaseRequestItemList, List<PurchaseAttachmentDTO> purchaseAttachmentList) {
        Map<String, List> itemMap;
        purchaseRequestHead.setAuditStatus(AuditStatusEnum.AUDIT_FINISH.getValue());
        if (CollectionUtil.isNotEmpty(purchaseRequestItemList) && (itemMap = purchaseRequestItemList.stream().filter(x -> CharSequenceUtil.isNotEmpty((CharSequence)x.getMaterialNumber())).collect(Collectors.groupingBy(PurchaseRequestItem::getMaterialNumber)).entrySet().stream().filter(m -> ((List)m.getValue()).size() > 1).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue))).size() > 0) {
            Set<Map.Entry<String, List>> entries = itemMap.entrySet();
            for (Map.Entry<String, List> entry : entries) {
                long factoryCount;
                List items = entry.getValue();
                int size = items.size();
                if ((long)size == (factoryCount = items.stream().map(x -> x.getMaterialNumber() + "_" + x.getFactory() + "_" + this.parseDateStr(x.getDeliveryDate())).distinct().count())) continue;
                throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_deSL0RHSJAlTxe_60526e5", (String)"\u76f8\u540c\u7269\u6599${0}\uff0c\u5de5\u5382\u6216\u4ea4\u671f\u5fc5\u987b\u4e0d\u540c", (String[])new String[]{entry.getKey()}));
            }
        }
        String idStr = IdWorker.getIdStr();
        purchaseRequestHead.setDocumentId(idStr);
        this.purchaseRequestHeadMapper.insert((Object)purchaseRequestHead);
        IntegratedDocumentDTO integratedDocument = new IntegratedDocumentDTO();
        integratedDocument.setId(idStr);
        integratedDocument.setRequestHeadId(purchaseRequestHead.getId());
        this.invokeBaseRpcService.saveIntegratedDocument(integratedDocument);
        IntegratedBusinessDataDTO integratedBusinessDataDTO = new IntegratedBusinessDataDTO();
        integratedBusinessDataDTO.setBusinessId(purchaseRequestHead.getId());
        integratedBusinessDataDTO.setBusinessType("purchaseRequest");
        integratedBusinessDataDTO.setIntegratedId(idStr);
        this.invokeBaseRpcService.saveIntegratedData(integratedBusinessDataDTO);
        this.purchaseRequestItemMapper.insertBatchSomeColumn(purchaseRequestItemList);
    }

    private String parseDateStr(Date date) {
        if (null == date) {
            return "";
        }
        return DateUtils.formatDate((Date)date);
    }

    private Map<String, PurchaseMaterialHeadDTO> getMaterialCode(JSONArray u8ItemList) {
        List materialNumberList = u8ItemList.stream().map(object -> {
            JSONObject json = (JSONObject)object;
            return json.getString("inv_code");
        }).distinct().collect(Collectors.toList());
        List materialNumbers = this.purchaseMaterialHeadRpcService.listByMaterialNumbers(materialNumberList);
        return materialNumbers.stream().filter(master -> StringUtils.isNotBlank((CharSequence)master.getMaterialNumber())).collect(Collectors.toMap(master -> master.getMaterialNumber().toUpperCase(), Function.identity(), (newVal, oldVal) -> oldVal));
    }

    private List<PurchaseRequestItem> initItems(PurchaseRequestHeadVO head, JSONArray array, Map<String, PurchaseMaterialHeadDTO> materialCodeMap) {
        ArrayList<PurchaseRequestItem> requestItemList = new ArrayList<PurchaseRequestItem>();
        for (Object object : array) {
            JSONObject item = (JSONObject)object;
            PurchaseRequestItem requestItem = new PurchaseRequestItem();
            requestItem.setHeadId(head.getId());
            requestItem.setElsAccount(head.getElsAccount());
            requestItem.setRequestNumber(head.getRequestNumber());
            requestItem.setRequestType(head.getRequestType());
            requestItem.setPurchaseType(head.getPurchaseType());
            requestItem.setPurchaseOrg(head.getPurchaseOrg());
            requestItem.setFactory(head.getFactory());
            requestItem.setCompany(head.getCompany());
            requestItem.setMaterialNumber(item.getString("inv_code"));
            requestItem.setItemNumber(item.getString("crowno"));
            requestItem.setMaterialName(item.getString("inv_name"));
            requestItem.setMaterialDesc(item.getString("inv_name"));
            requestItem.setMaterialModel(item.getString("invtype"));
            requestItem.setMaterialSpec(item.getString("invspec"));
            requestItem.setQuantity(item.getBigDecimal("npraynum"));
            requestItem.setRepertoryQuantity(item.getBigDecimal("npraynum"));
            requestItem.setTaxCode("\u5546\u4e1a\uff0813 % )");
            requestItem.setTaxRate("13");
            requestItem.setRemark(item.getString("vmemo"));
            requestItem.setDeliveryDate(item.getDate("ddemanddate"));
            requestItem.setSubtotalAmount(item.getBigDecimal("nmoney"));
            requestItem.setProjectNumber(item.getString("project_code"));
            requestItem.setProjectName(item.getString("project_name"));
            requestItem.setStorageLocation(item.getString("warehouse_code"));
            requestItem.setPrice(item.getBigDecimal("nsuggestprice"));
            requestItem.setDeleted(CommonConstant.NO_0);
            requestItem.setCreateBy(head.getCreateBy());
            requestItem.setApplicant(head.getApplicant());
            requestItem.setCreateTime(head.getCreateTime());
            requestItem.setUpdateTime(head.getUpdateTime());
            requestItem.setUpdateBy(head.getUpdateBy());
            List effectiveRecordList = this.purchaseInformationRecordsRpcService.getEffectiveRecordList(requestItem.getMaterialNumber(), null, null, null, null);
            if (CollectionUtils.isEmpty((Collection)effectiveRecordList)) {
                requestItem.setItemStatus(PurchaseRequestStatusItemEnum.DEMAND_POOL.getValue());
            } else {
                requestItem.setItemStatus(PurchaseRequestStatusItemEnum.WAIT_ORDER.getValue());
            }
            PurchaseMaterialHeadDTO purchaseMaterialHeadDTO = materialCodeMap.get(requestItem.getMaterialNumber());
            if (null != purchaseMaterialHeadDTO) {
                requestItem.setCateCode(purchaseMaterialHeadDTO.getCateCode());
                requestItem.setCateName(purchaseMaterialHeadDTO.getCateName());
                requestItem.setPurchaseUnit(purchaseMaterialHeadDTO.getPurchaseUnit());
            }
            requestItemList.add(requestItem);
        }
        return requestItemList;
    }

    private PurchaseRequestHeadVO initHead(JSONObject jsonObject, TemplateHeadDTO template, Map<String, ElsSubAccountDTO> subAccountMap) {
        PurchaseRequestHeadVO head = new PurchaseRequestHeadVO();
        head.setId(IdWorker.getIdStr());
        head.setElsAccount(TenantContext.getTenant());
        head.setTemplateAccount(template.getElsAccount());
        head.setTemplateName(template.getTemplateName());
        head.setTemplateNumber(template.getTemplateNumber());
        head.setTemplateVersion(String.valueOf(template.getTemplateVersion()));
        head.setRequestNumber(jsonObject.getString("vpraycode"));
        head.setApplyDate(jsonObject.getDate("dpraydate"));
        head.setRequestType(jsonObject.getString("ipraytype"));
        head.setCompany(jsonObject.getString("unit_code"));
        head.setPurchaseOrg("LS002");
        head.setFactory("0201");
        head.setApplyDeptName(jsonObject.getString("cdeptid_name"));
        head.setPurchasePrincipal(jsonObject.getString("praypsn_code"));
        head.setSourceType("interface");
        head.setAudit(AuditStatusEnum.AUDIT_FINISH.getValue());
        head.setMustMaterialNumber("1");
        head.setRemark(jsonObject.getString("vmemo"));
        head.setRequestStatus(String.valueOf(3));
        head.setApplyDept(jsonObject.getString("cdeptid_code"));
        head.setApplicant(jsonObject.getString("praypsn_name"));
        head.setPurchaseType("BZ");
        head.setCreateBy(jsonObject.getString("operator_code"));
        ElsSubAccountDTO elsSubAccountDTO = subAccountMap.get(jsonObject.getString("operator_code"));
        if (!ObjectUtils.isEmpty((Object)elsSubAccountDTO)) {
            head.setCreateById(elsSubAccountDTO.getId());
            head.setCreateBy(elsSubAccountDTO.getSubAccount());
            head.setUpdateBy(elsSubAccountDTO.getSubAccount());
            head.setUpdateById(elsSubAccountDTO.getId());
        }
        head.setCreateTime(jsonObject.getDate("tmaketime"));
        head.setUpdateTime(jsonObject.getDate("taudittime"));
        head.setFbk3(jsonObject.getString("vdef4"));
        head.setFbk4(jsonObject.getString("vdef5"));
        head.setDeleted(CommonConstant.NO_0);
        return head;
    }

    private String handlerResultListInfo(JSONObject obj) {
        Assert.isTrue((obj.getIntValue("code") == 200 ? 1 : 0) != 0, (String)obj.getString("message"));
        JSONObject result = obj.getJSONObject("result");
        Assert.isTrue((boolean)result.getString("status").equals("success"), (String)result.getString("message"));
        return result.getString("data");
    }

    private Map<String, ElsSubAccountDTO> getAccountMap(String elsAccount, JSONArray u8ItemList) {
        List subAccountList = u8ItemList.stream().filter(object -> {
            JSONObject json = (JSONObject)object;
            JSONObject jsonObject = JSONObject.parseObject((String)json.getString("parentvo"));
            return StringUtils.isNotBlank((CharSequence)jsonObject.getString("operator_code"));
        }).map(object -> {
            JSONObject json = (JSONObject)object;
            JSONObject jsonObject = JSONObject.parseObject((String)json.getString("parentvo"));
            return jsonObject.getString("operator_code");
        }).distinct().collect(Collectors.toList());
        if (CollectionUtil.isNotEmpty(subAccountList)) {
            List accountList = this.accountRpcService.getAccountList(elsAccount, subAccountList);
            Map<String, ElsSubAccountDTO> elsSubAccountDTOMap = accountList.stream().collect(Collectors.toMap(ElsSubAccountDTO::getSubAccount, Function.identity(), (o1, o2) -> o1));
            return elsSubAccountDTOMap;
        }
        return new HashMap<String, ElsSubAccountDTO>();
    }
}

