/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.logisticspurchase.ebidding.impl;

import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSONObject;
import com.els.common.api.service.JobRpcService;
import com.els.common.aspect.annotation.SrmTransaction;
import com.els.common.util.DateUtils;
import com.els.common.util.SpringContextUtils;
import com.els.config.mybatis.TenantContext;
import com.els.modules.ebidding.enumerate.EbiddingStatusEnum;
import com.els.modules.logisticspurchase.ebidding.job.utils.LpEbiddingJobUtil;
import com.els.modules.logisticspurchase.ebidding.service.PurchaseEbiddingHeadLpService;
import com.els.modules.logisticspurchase.ebidding.service.SaleEbiddingHeadLpService;
import com.els.modules.logisticspurchase.ebidding.service.impl.PurchaseEbiddingHeadLpServiceImpl;
import com.els.modules.logisticspurchase.ebidding.service.impl.SaleEbiddingHeadLpServiceImpl;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="logisticsPurchaseEbiddingBeginJobBeanServiceImpl")
public class LogisticsPurchaseEbiddingBeginJobBeanServiceImpl
implements JobRpcService {
    private static final Logger log = LoggerFactory.getLogger(LogisticsPurchaseEbiddingBeginJobBeanServiceImpl.class);

    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void execute(String parameter) {
        log.info("\u7ade\u4ef7\u5f00\u542f\u5b9a\u65f6\u4efb\u52a1 logisticsPurchaseEbiddingBeginJobBeanServiceImpl \u5f00\u59cb\u6267\u884c\u65f6\u95f4:" + DateUtils.getTimestamp() + parameter);
        if (StrUtil.isEmpty((CharSequence)parameter)) {
            log.error("parameter must not be null.");
            return;
        }
        JSONObject paramObj = JSONObject.parseObject((String)parameter);
        String id = paramObj.getString("id");
        if (StrUtil.isEmpty((CharSequence)id)) {
            log.error("parameter must contain id.");
            return;
        }
        String tenantId = StrUtil.isBlank((CharSequence)paramObj.getString("tenantId")) ? "100000" : paramObj.getString("tenantId");
        TenantContext.setTenant((String)tenantId);
        SaleEbiddingHeadLpService saleEbiddingHeadService = (SaleEbiddingHeadLpService)SpringContextUtils.getBean(SaleEbiddingHeadLpServiceImpl.class);
        List saleEbiddingHeadList = saleEbiddingHeadService.getByRelationId(id);
        if (saleEbiddingHeadList != null && saleEbiddingHeadList.size() > 0) {
            List waitBiddingList = saleEbiddingHeadList.stream().filter(x -> EbiddingStatusEnum.WAIT_BIDDING.getValue().equals(x.getEbiddingStatus())).collect(Collectors.toList());
            if (waitBiddingList != null && waitBiddingList.size() > 0) {
                PurchaseEbiddingHeadLpService purchaseEbiddingHeadService = (PurchaseEbiddingHeadLpService)SpringContextUtils.getBean(PurchaseEbiddingHeadLpServiceImpl.class);
                purchaseEbiddingHeadService.startBidding(id);
                String jobKey = paramObj.getString("jobKey");
                LpEbiddingJobUtil.deleteJob((String)jobKey);
            } else {
                log.error("\u7269\u6d41\u91c7\u8d2d-\u7ade\u4ef7\u5f00\u542f\u5b9a\u65f6\u4efb\u52a1\uff0c\u67e5\u8be2\u7684\u4f9b\u5e94\u5546\u5f85\u7ade\u4ef7\u6570\u636e\u4e3a0\uff0c\u505c\u6b62\u6267\u884c\u5b9a\u65f6\u4efb\u52a1\uff0c\u5bf9\u5e94\u7684\u7ade\u4ef7\u5355\u5934ID\u4e3a\uff1a" + id);
            }
        } else {
            log.error("\u7269\u6d41\u91c7\u8d2d-\u7ade\u4ef7\u5f00\u542f\u5b9a\u65f6\u4efb\u52a1\uff0c\u67e5\u8be2\u53c2\u52a0\u7ade\u4ef7\u7684\u4f9b\u5e94\u5546\u6570\u636e\u4e3a0\uff0c\u505c\u6b62\u6267\u884c\u5b9a\u65f6\u4efb\u52a1\uff0c\u5bf9\u5e94\u7684\u7ade\u4ef7\u5355\u5934ID\u4e3a\uff1a" + id);
        }
        log.info("\u7269\u6d41\u91c7\u8d2d-\u7ade\u4ef7\u5f00\u542f\u5b9a\u65f6\u4efb\u52a1 logisticsPurchaseEbiddingBeginJobBeanServiceImpl \u6267\u884c\u5b8c\u6210\u65f6\u95f4:" + DateUtils.getTimestamp() + parameter);
    }
}

