/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.ebidding.api.service.impl;

import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSONObject;
import com.els.common.api.service.JobRpcService;
import com.els.common.aspect.annotation.SrmTransaction;
import com.els.common.util.DateUtils;
import com.els.common.util.SpringContextUtils;
import com.els.config.mybatis.TenantContext;
import com.els.modules.ebidding.entity.PurchaseEbiddingHead;
import com.els.modules.ebidding.enumerate.EbiddingStatusEnum;
import com.els.modules.ebidding.job.utils.EbiddingJobUtil;
import com.els.modules.ebidding.service.PurchaseEbiddingHeadService;
import com.els.modules.ebidding.service.impl.PurchaseEbiddingHeadServiceImpl;
import java.io.Serializable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="srmEbiddingFailedJobServiceImpl")
public class SrmEbiddingFailedJobBeanServiceImpl
implements JobRpcService {
    private static final Logger log = LoggerFactory.getLogger(SrmEbiddingFailedJobBeanServiceImpl.class);

    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void execute(String parameter) {
        log.info(" \u7ade\u4ef7\u6d41\u6807\u5b9a\u65f6\u4efb\u52a1 SrmEbiddingFailedJobBeanServiceImpl \u5f00\u59cb\u6267\u884c\u65f6\u95f4:" + DateUtils.getTimestamp() + parameter);
        if (StrUtil.isEmpty((CharSequence)parameter)) {
            log.error("parameter must not be null.");
            return;
        }
        JSONObject paramObj = JSONObject.parseObject((String)parameter);
        String id = paramObj.getString("id");
        if (StrUtil.isEmpty((CharSequence)id)) {
            log.error("parameter must contain id.");
            return;
        }
        String tenantId = StrUtil.isBlank((CharSequence)paramObj.getString("tenantId")) ? "100000" : paramObj.getString("tenantId");
        TenantContext.setTenant((String)tenantId);
        PurchaseEbiddingHeadService purchaseEbiddingHeadService = (PurchaseEbiddingHeadService)SpringContextUtils.getBean(PurchaseEbiddingHeadServiceImpl.class);
        PurchaseEbiddingHead dbHead = (PurchaseEbiddingHead)purchaseEbiddingHeadService.getById((Serializable)((Object)id));
        if (dbHead.getReplyQuantity() == null || dbHead.getReplyQuantity() < dbHead.getParticipateQuantity()) {
            purchaseEbiddingHeadService.failed(dbHead);
        } else {
            dbHead.setEbiddingStatus(EbiddingStatusEnum.WAIT_BIDDING.getValue());
            purchaseEbiddingHeadService.updateById((Object)dbHead);
        }
        String jobKey = paramObj.getString("jobKey");
        EbiddingJobUtil.deleteJob((String)jobKey);
        log.info(" \u7ade\u4ef7\u6d41\u6807\u5b9a\u65f6\u4efb\u52a1 SrmEbiddingFailedJobBeanServiceImpl \u6267\u884c\u5b8c\u6210\u65f6\u95f4:" + DateUtils.getTimestamp() + parameter);
    }
}

