/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.enquiry.api.service.impl;

import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSONObject;
import com.els.common.api.service.JobRpcService;
import com.els.common.constant.CommonConstant;
import com.els.common.util.DateUtils;
import com.els.modules.enquiry.job.utils.EnquiryJobUtil;
import com.els.modules.enquiry.service.PublicEnquiryService;
import com.els.modules.job.api.dto.QuartzJobDTO;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="jutongbaoEnquiryJobServiceImpl")
public class JutongbaoEnquiryJobBeanServiceImpl
implements JobRpcService {
    private static final Logger log = LoggerFactory.getLogger(JutongbaoEnquiryJobBeanServiceImpl.class);
    @Autowired
    private PublicEnquiryService enquiryService;

    public void execute(String parameter) {
        log.info(" \u5927\u4f01\u6c47\u62a5\u4ef7\u67e5\u8be2 \u5f00\u59cb\u6267\u884c\u65f6\u95f4:" + DateUtils.getTimestamp() + parameter);
        if (StrUtil.isEmpty((CharSequence)parameter)) {
            log.error("parameter must not be null.");
            return;
        }
        JSONObject paramObj = JSONObject.parseObject((String)parameter);
        String supplierMemberIds = this.enquiryService.jutongbaoQuote(parameter);
        paramObj.put("supplierMemberIds", (Object)supplierMemberIds);
        QuartzJobDTO job = new QuartzJobDTO();
        long currentTime = System.currentTimeMillis();
        Date executeDate = new Date(currentTime += 14400000L);
        job.setCronExpression(DateUtil.format((Date)executeDate, (String)"ss mm HH dd MM ? yyyy"));
        job.setJobClassName("com.els.modules.quartz.job.BusinessJob");
        job.setStatus(CommonConstant.STATUS_NORMAL);
        String JOB_NAME = "jutongbaoEnquiryJobServiceImpl";
        String jobNameKey = "jutongbaoEnquiryJobServiceImpl_" + paramObj.getString("buyofferId") + "_" + paramObj.getString("elsAccount");
        job.setJobNameKey(jobNameKey);
        job.setParameter(paramObj.toJSONString());
        job.setElsAccount(paramObj.getString("elsAccount"));
        EnquiryJobUtil.createJob((QuartzJobDTO)job);
        log.info("\u5927\u4f01\u6c47\u62a5\u4ef7\u67e5\u8be2 \u6267\u884c\u5b8c\u6210\u65f6\u95f4:" + DateUtils.getTimestamp() + parameter);
    }
}

