/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.bidding.controller;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.els.common.api.vo.Result;
import com.els.common.aspect.annotation.AutoLog;
import com.els.common.system.base.controller.BaseController;
import com.els.common.system.query.QueryGenerator;
import com.els.config.mybatis.TenantContext;
import com.els.modules.base.api.dto.PurchaseAttachmentDTO;
import com.els.modules.bidding.entity.BiddingEvaluationTemplateHead;
import com.els.modules.bidding.entity.BiddingEvaluationTemplateItem;
import com.els.modules.bidding.enumerate.BiddingEvaluationTemplateStatusEnum;
import com.els.modules.bidding.service.BiddingEvaluationTemplateHeadService;
import com.els.modules.bidding.service.BiddingEvaluationTemplateItemService;
import com.els.modules.bidding.service.PurchaseBiddingHeadService;
import com.els.modules.bidding.vo.BiddingEvaluationTemplateHeadVO;
import com.els.rpc.service.InvokeBaseRpcService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/bidding/biddingEvaluationTemplateHead"})
@Api(tags={"\u8bc4\u6807\u6a21\u677f\u5934"})
public class BiddingEvaluationTemplateHeadController
extends BaseController<BiddingEvaluationTemplateHead, BiddingEvaluationTemplateHeadService> {
    @Autowired
    private BiddingEvaluationTemplateHeadService biddingEvaluationTemplateHeadService;
    @Autowired
    private BiddingEvaluationTemplateItemService biddingEvaluationTemplateItemService;
    @Autowired
    private InvokeBaseRpcService invokeBaseRpcService;
    @Autowired
    private PurchaseBiddingHeadService purchaseBiddingHeadService;

    @ApiOperation(value="\u5206\u9875\u5217\u8868\u67e5\u8be2", notes="\u5206\u9875\u5217\u8868\u67e5\u8be2")
    @GetMapping(value={"/list"})
    public Result<?> queryPageList(BiddingEvaluationTemplateHead biddingEvaluationTemplateHead, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)biddingEvaluationTemplateHead), (Map)req.getParameterMap());
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        queryWrapper.eq((Object)"els_account", (Object)TenantContext.getTenant());
        IPage pageList = this.biddingEvaluationTemplateHeadService.page((IPage)page, (Wrapper)queryWrapper);
        List heads = pageList.getRecords();
        if (heads != null) {
            for (BiddingEvaluationTemplateHead head : heads) {
                QueryWrapper wrapper = new QueryWrapper();
                wrapper.eq((Object)"bid_evaluation_number", (Object)head.getEvaluationNumber());
                wrapper.eq((Object)"is_deleted", (Object)"0");
                int count = this.purchaseBiddingHeadService.count((Wrapper)wrapper);
                if (count <= 0) continue;
                head.setUsed("1");
            }
        }
        return Result.ok((Object)pageList);
    }

    @AutoLog(value="\u8bc4\u6807\u6a21\u677f\u5934-\u6dfb\u52a0")
    @ApiOperation(value="\u6dfb\u52a0", notes="\u6dfb\u52a0")
    @PostMapping(value={"/add"})
    public Result<?> add(@RequestBody BiddingEvaluationTemplateHeadVO biddingEvaluationTemplateHeadPage) {
        BiddingEvaluationTemplateHead biddingEvaluationTemplateHead = new BiddingEvaluationTemplateHead();
        BeanUtils.copyProperties((Object)((Object)biddingEvaluationTemplateHeadPage), (Object)((Object)biddingEvaluationTemplateHead));
        this.biddingEvaluationTemplateHeadService.saveMain(biddingEvaluationTemplateHead, biddingEvaluationTemplateHeadPage.getBiddingEvaluationTemplateItemList());
        return Result.ok((Object)((Object)biddingEvaluationTemplateHead));
    }

    @AutoLog(value="\u8bc4\u6807\u6a21\u677f\u5934-\u7f16\u8f91")
    @ApiOperation(value="\u7f16\u8f91", notes="\u7f16\u8f91")
    @PostMapping(value={"/edit"})
    public Result<?> edit(@RequestBody BiddingEvaluationTemplateHeadVO biddingEvaluationTemplateHeadPage) {
        BiddingEvaluationTemplateHead biddingEvaluationTemplateHead = new BiddingEvaluationTemplateHead();
        BeanUtils.copyProperties((Object)((Object)biddingEvaluationTemplateHeadPage), (Object)((Object)biddingEvaluationTemplateHead));
        this.biddingEvaluationTemplateHeadService.updateMain(biddingEvaluationTemplateHead, biddingEvaluationTemplateHeadPage.getBiddingEvaluationTemplateItemList());
        return this.commonSuccessResult(3);
    }

    @AutoLog(value="\u8bc4\u6807\u6a21\u677f\u5934-\u901a\u8fc7id\u5220\u9664")
    @ApiOperation(value="\u901a\u8fc7id\u5220\u9664", notes="\u901a\u8fc7id\u5220\u9664")
    @GetMapping(value={"/delete"})
    public Result<?> delete(@RequestParam(name="id") String id) {
        this.biddingEvaluationTemplateHeadService.delMain(id);
        return this.commonSuccessResult(4);
    }

    @AutoLog(value="\u8bc4\u6807\u6a21\u677f\u5934-\u6279\u91cf\u5220\u9664")
    @ApiOperation(value="\u6279\u91cf\u5220\u9664", notes="\u6279\u91cf\u5220\u9664")
    @GetMapping(value={"/deleteBatch"})
    public Result<?> deleteBatch(@RequestParam(name="ids") String ids) {
        this.biddingEvaluationTemplateHeadService.delBatchMain(Arrays.asList(ids.split(",")));
        return this.commonSuccessResult(4);
    }

    @ApiOperation(value="\u901a\u8fc7id\u67e5\u8be2", notes="\u901a\u8fc7id\u67e5\u8be2")
    @GetMapping(value={"/queryById"})
    public Result<?> queryById(@RequestParam(name="id") String id) {
        BiddingEvaluationTemplateHead biddingEvaluationTemplateHead = (BiddingEvaluationTemplateHead)((Object)this.biddingEvaluationTemplateHeadService.getById((Serializable)((Object)id)));
        BiddingEvaluationTemplateHeadVO biddingEvaluationTemplateHeadVO = new BiddingEvaluationTemplateHeadVO();
        BeanUtils.copyProperties((Object)((Object)biddingEvaluationTemplateHead), (Object)((Object)biddingEvaluationTemplateHeadVO));
        List<BiddingEvaluationTemplateItem> biddingEvaluationTemplateItemList = this.biddingEvaluationTemplateItemService.selectByMainId(id);
        biddingEvaluationTemplateHeadVO.setBiddingEvaluationTemplateItemList(biddingEvaluationTemplateItemList);
        if (biddingEvaluationTemplateItemList != null && biddingEvaluationTemplateItemList.size() > 0) {
            ArrayList<PurchaseAttachmentDTO> purchaseAttachments = new ArrayList<PurchaseAttachmentDTO>();
            for (BiddingEvaluationTemplateItem biddingEvaluationTemplateItem : biddingEvaluationTemplateItemList) {
                List attachments = this.invokeBaseRpcService.selectPurchaseAttachmentByMainId(biddingEvaluationTemplateItem.getRegulationId());
                if (attachments == null) continue;
                for (PurchaseAttachmentDTO purchaseAttachment : attachments) {
                    purchaseAttachment.setFbk1(biddingEvaluationTemplateItem.getRegulationName());
                }
                purchaseAttachments.addAll(attachments);
            }
            biddingEvaluationTemplateHeadVO.setAttachments(purchaseAttachments);
        }
        return Result.ok((Object)((Object)biddingEvaluationTemplateHeadVO));
    }

    @ApiOperation(value="\u901a\u8fc7\u8bc4\u6807\u6a21\u677f\u5934id\u67e5\u8be2\u8bc4\u6807\u6a21\u677f\u884c", notes="\u901a\u8fc7\u8bc4\u6807\u6a21\u677f\u5934id\u67e5\u8be2\u8bc4\u6807\u6a21\u677f\u884c")
    @GetMapping(value={"/queryBiddingEvaluationTemplateItemByMainId"})
    public Result<?> queryBiddingEvaluationTemplateItemListByMainId(@RequestParam(name="id") String id) {
        List<BiddingEvaluationTemplateItem> biddingEvaluationTemplateItemList = this.biddingEvaluationTemplateItemService.selectByMainId(id);
        return Result.ok(biddingEvaluationTemplateItemList);
    }

    @AutoLog(value="\u8bc4\u6807\u6a21\u677f\u5934-\u5931\u6548\u64cd\u4f5c")
    @ApiOperation(value="\u5931\u6548", notes="\u5931\u6548")
    @GetMapping(value={"/loseEfficacy"})
    public Result<?> loseEfficacy(@RequestParam(name="id") String id) {
        BiddingEvaluationTemplateHead evaluationTemplateHead = (BiddingEvaluationTemplateHead)((Object)this.biddingEvaluationTemplateHeadService.getById((Serializable)((Object)id)));
        if (evaluationTemplateHead != null) {
            evaluationTemplateHead.setTemplateStatus(BiddingEvaluationTemplateStatusEnum.LOSE_EFFICACY.getValue());
            this.biddingEvaluationTemplateHeadService.updateById((Object)evaluationTemplateHead);
            return Result.ok((String)"\u5931\u6548\u64cd\u4f5c\u6210\u529f\uff01");
        }
        return Result.error((String)"\u8be5\u6a21\u677f\u5df2\u4e0d\u5b58\u5728\uff0c\u65e0\u6cd5\u8fdb\u884c\u5931\u6548\u64cd\u4f5c");
    }
}

