/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.bidding.service.impl;

import cn.hutool.core.bean.BeanUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.els.common.enumerate.AuditStatusEnum;
import com.els.common.exception.ELSBootException;
import com.els.common.system.vo.LoginUser;
import com.els.common.util.I18nUtil;
import com.els.common.util.IPUtils;
import com.els.modules.bidding.entity.BiddingSupplier;
import com.els.modules.bidding.entity.PurchaseBiddingHead;
import com.els.modules.bidding.entity.PurchaseBiddingItem;
import com.els.modules.bidding.entity.PurchaseBiddingSpecialist;
import com.els.modules.bidding.entity.SaleBiddingHead;
import com.els.modules.bidding.entity.SaleBiddingItem;
import com.els.modules.bidding.enumerate.BiddingItemStatusEnum;
import com.els.modules.bidding.enumerate.BiddingStatusEnum;
import com.els.modules.bidding.enumerate.MemberRoleEnum;
import com.els.modules.bidding.enumerate.MemberTypeEnum;
import com.els.modules.bidding.enumerate.ReplyStatusEnum;
import com.els.modules.bidding.mapper.BiddingSupplierMapper;
import com.els.modules.bidding.mapper.PurchaseBiddingHeadMapper;
import com.els.modules.bidding.mapper.PurchaseBiddingItemMapper;
import com.els.modules.bidding.mapper.PurchaseBiddingSpecialistMapper;
import com.els.modules.bidding.mapper.SaleBiddingHeadMapper;
import com.els.modules.bidding.mapper.SaleBiddingItemMapper;
import com.els.modules.bidding.service.BiddingSupplierService;
import com.els.modules.bidding.vo.BiddingSupplierVO;
import com.els.modules.inquiry.enumerate.PriceCreateWayEnum;
import com.els.modules.inquiry.rpc.service.InquiryInvokeMainDataRpcService;
import com.els.modules.price.api.dto.PurchaseInformationRecordsDTO;
import com.els.modules.price.api.enumerate.PriceSourceTypeEnum;
import com.els.modules.price.api.enumerate.PurchaseInformationPriceTypeEnum;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.shiro.SecurityUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class BiddingSupplierServiceImpl
extends ServiceImpl<BiddingSupplierMapper, BiddingSupplier>
implements BiddingSupplierService {
    @Resource
    private BiddingSupplierMapper biddingSupplierMapper;
    @Resource
    private PurchaseBiddingHeadMapper purchaseBiddingHeadMapper;
    @Resource
    private PurchaseBiddingItemMapper purchaseBiddingItemMapper;
    @Resource
    private SaleBiddingHeadMapper saleBiddingHeadMapper;
    @Resource
    private SaleBiddingItemMapper saleBiddingItemMapper;
    @Resource
    private PurchaseBiddingSpecialistMapper purchaseBiddingSpecialistMapper;
    @Resource
    private InquiryInvokeMainDataRpcService inquiryInvokeMainDataRpcService;

    @Override
    public List<BiddingSupplier> selectByMainId(String mainId) {
        return this.biddingSupplierMapper.selectByMainId(mainId);
    }

    private void check(String id) {
        LoginUser user = (LoginUser)SecurityUtils.getSubject().getPrincipal();
        List specialistList = this.purchaseBiddingSpecialistMapper.selectByMainId(id).stream().filter(o -> MemberTypeEnum.PROJECT.getValue().equals(o.getMemberType())).filter(o -> MemberRoleEnum.BID_PRINCIPAL.getValue().equals(o.getMemberRole())).map(PurchaseBiddingSpecialist::getSubAccount).collect(Collectors.toList());
        if (!specialistList.contains(user.getSubAccount())) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_oper_no_bidding_principal_bidding", (String)"\u53ea\u6709\u62db\u6807\u8d1f\u8d23\u4eba\u53ef\u4ee5\u64cd\u4f5c\uff01"));
        }
    }

    private void checkParam(PurchaseBiddingHead head, List<BiddingSupplierVO> list) {
        this.check(head.getId());
        String quoteWay = head.getQuotaWay();
        HashMap<String, BigDecimal> checkQuotaMap = new HashMap<String, BigDecimal>();
        for (BiddingSupplierVO supplierVO : list) {
            List<PurchaseBiddingItem> purchaseBiddingItemList = supplierVO.getPurchaseBiddingItemList();
            for (PurchaseBiddingItem item : purchaseBiddingItemList) {
                if (!"1".equals(quoteWay)) {
                    if (BiddingItemStatusEnum.BIDDING_WIN.getValue().equals(item.getItemStatus())) {
                        if (item.getPrice() == null) {
                            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_oper_no_quotation_bidding", (String)"\u672a\u62a5\u4ef7\u7684\u884c\u9879\u4e0d\u80fd\u8bbe\u7f6e\u4e2d\u6807\uff01"));
                        }
                        if (item.getQuota() == null) {
                            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_empty_no_input_split_proportion_bidding", (String)"\u8bf7\u8f93\u5165\u5bf9\u5e94\u4e2d\u6807\u9879\u7684\u62c6\u5206\u6bd4\u7387%\uff01"));
                        }
                        if (checkQuotaMap.containsKey(item.getItemNumber())) {
                            checkQuotaMap.put(item.getItemNumber(), ((BigDecimal)checkQuotaMap.get(item.getItemNumber())).add(item.getQuota()));
                            continue;
                        }
                        checkQuotaMap.put(item.getItemNumber(), item.getQuota());
                        continue;
                    }
                    if (item.getQuota() == null) continue;
                    throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_fail_input_split_proportion_no_win_bid_bidding", (String)"\u672a\u4e2d\u6807\u9879\u4e0d\u80fd\u5f55\u5165\u62c6\u5206\u6bd4\u7387%\uff01"));
                }
                if (BiddingItemStatusEnum.BIDDING_WIN.getValue().equals(item.getItemStatus())) {
                    if (item.getPrice() == null) {
                        throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_oper_no_quotation_bidding", (String)"\u672a\u62a5\u4ef7\u7684\u884c\u9879\u4e0d\u80fd\u8bbe\u7f6e\u4e2d\u6807\uff01"));
                    }
                    item.setQuota(BigDecimal.valueOf(100L));
                    if (checkQuotaMap.containsKey(item.getItemNumber())) {
                        checkQuotaMap.put(item.getItemNumber(), ((BigDecimal)checkQuotaMap.get(item.getItemNumber())).add(item.getQuota()));
                        continue;
                    }
                    checkQuotaMap.put(item.getItemNumber(), item.getQuota());
                    continue;
                }
                if (item.getQuota() == null || item.getQuota().compareTo(BigDecimal.ZERO) == 0) continue;
                throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_fail_input_split_proportion_no_win_bid_bidding", (String)"\u672a\u4e2d\u6807\u9879\u4e0d\u80fd\u5f55\u5165\u62c6\u5206\u6bd4\u7387%\uff01"));
            }
        }
        for (String itemNumber : checkQuotaMap.keySet()) {
            BigDecimal quota = (BigDecimal)checkQuotaMap.get(itemNumber);
            if (quota == null || quota.compareTo(BigDecimal.valueOf(100L)) == 0) continue;
            if (!"1".equals(quoteWay)) {
                throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_fail_split_proportion_no_eq_100_bidding", (String)"\u4e2d\u6807\u6bd4\u7387\u4e4b\u548c\u5fc5\u987b\u7b49\u4e8e100%"));
            }
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_fail_must_select_one_supplier_bidding", (String)"\u53ea\u80fd\u9009\u62e9\u4e00\u5bb6\u4f9b\u5e94\u5546\u4e2d\u6807\uff01"));
        }
    }

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void confirmBid(String headId, List<BiddingSupplierVO> list) {
        PurchaseBiddingHead head = (PurchaseBiddingHead)((Object)this.purchaseBiddingHeadMapper.selectById((Serializable)((Object)headId)));
        this.optConfirmBid(head, list);
    }

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void saveConfirmBid(String headId, List<BiddingSupplierVO> list) {
        PurchaseBiddingHead head = (PurchaseBiddingHead)((Object)this.purchaseBiddingHeadMapper.selectById((Serializable)((Object)headId)));
        this.optConfirmBid(head, list);
    }

    private void optConfirmBid(PurchaseBiddingHead head, List<BiddingSupplierVO> list) {
        if (!BiddingStatusEnum.EVA_BIDDING.getValue().equals(head.getBiddingStatus()) && !BiddingStatusEnum.CONFIRM_ING.getValue().equals(head.getBiddingStatus())) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_fail_status_can_not_determine_bid_bidding", (String)"\u5f53\u524d\u72b6\u6001\u4e0d\u80fd\u5b9a\u6807\uff01"));
        }
        this.checkParam(head, list);
        for (BiddingSupplierVO supplierVO : list) {
            List<PurchaseBiddingItem> purchaseBiddingItemList = supplierVO.getPurchaseBiddingItemList();
            for (PurchaseBiddingItem item : purchaseBiddingItemList) {
                if (!BiddingItemStatusEnum.BIDDING_WIN.getValue().equals(item.getItemStatus())) {
                    item.setItemStatus(BiddingItemStatusEnum.BIDDING_FAIL.getValue());
                }
                this.purchaseBiddingItemMapper.updateById((Object)item);
            }
        }
        LoginUser user = (LoginUser)SecurityUtils.getSubject().getPrincipal();
        PurchaseBiddingHead purchaseBiddingHead = new PurchaseBiddingHead();
        purchaseBiddingHead.setId(head.getId());
        purchaseBiddingHead.setBiddingStatus(BiddingStatusEnum.CONFIRM_ED.getValue());
        purchaseBiddingHead.setConfirmBidIp(IPUtils.getIpAddr());
        purchaseBiddingHead.setConfirmBidBy(user.getSubAccount());
        this.purchaseBiddingHeadMapper.updateById((Object)purchaseBiddingHead);
        String resultAudit = head.getResultAudit();
        if (!"1".equals(resultAudit)) {
            this.publish(head.getId());
        }
    }

    @Override
    public List<BiddingSupplierVO> findConfirmBidList(String headId, boolean isCheck) {
        if (isCheck) {
            this.check(headId);
        }
        List biddingSupplierList = this.biddingSupplierMapper.selectByMainId(headId).stream().filter(o -> o.getReplyStatus().equals(ReplyStatusEnum.QUOTE_BID.getValue())).collect(Collectors.toList());
        List<PurchaseBiddingItem> purchaseBiddingItemList = this.purchaseBiddingItemMapper.selectByMainId(headId);
        Map<String, List<PurchaseBiddingItem>> itemMap = purchaseBiddingItemList.stream().collect(Collectors.groupingBy(PurchaseBiddingItem::getToElsAccount));
        ArrayList<BiddingSupplierVO> resultList = new ArrayList<BiddingSupplierVO>();
        for (BiddingSupplier supplier : biddingSupplierList) {
            BiddingSupplierVO supplierVO = new BiddingSupplierVO();
            BeanUtil.copyProperties((Object)((Object)supplier), (Object)((Object)supplierVO), (String[])new String[0]);
            supplierVO.setPurchaseBiddingItemList(itemMap.get(supplier.getToElsAccount()));
            resultList.add(supplierVO);
        }
        return resultList;
    }

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void publish(String headId) {
        BigDecimal budgetAmount;
        List<BiddingSupplier> biddingSupplierList = this.biddingSupplierMapper.selectByMainId(headId);
        List<PurchaseBiddingItem> purchaseBiddingItemList = this.purchaseBiddingItemMapper.selectByMainId(headId);
        SaleBiddingHead saleBiddingHead = new SaleBiddingHead();
        saleBiddingHead.setRelationId(headId);
        saleBiddingHead.setBiddingStatus(BiddingStatusEnum.CONFIRM_ED.getValue());
        this.saleBiddingHeadMapper.update((Object)saleBiddingHead, (Wrapper)new QueryWrapper().eq((Object)"relation_id", (Object)headId));
        HashMap<String, String> supplierMap = new HashMap<String, String>();
        BigDecimal totalAmount = BigDecimal.ZERO;
        for (PurchaseBiddingItem item : purchaseBiddingItemList) {
            SaleBiddingItem saleItem = new SaleBiddingItem();
            saleItem.setId(item.getRelationId());
            saleItem.setItemStatus(item.getItemStatus());
            saleItem.setQuota(item.getQuota());
            this.saleBiddingItemMapper.updateById((Object)saleItem);
            if (!BiddingItemStatusEnum.BIDDING_WIN.getValue().equals(item.getItemStatus())) continue;
            supplierMap.put(item.getToElsAccount(), "true");
            BigDecimal price = item.getPrice();
            BigDecimal quota = item.getQuota();
            BigDecimal quantity = item.getRequireQuantity() == null ? BigDecimal.valueOf(1L) : item.getRequireQuantity();
            BigDecimal amount = price.multiply(quota.divide(BigDecimal.valueOf(100L)).multiply(quantity));
            totalAmount = totalAmount.add(amount);
        }
        for (BiddingSupplier supplier : biddingSupplierList) {
            BiddingSupplier updateSupplier = new BiddingSupplier();
            updateSupplier.setId(supplier.getId());
            if (supplierMap.containsKey(supplier.getToElsAccount())) {
                updateSupplier.setBiddingStatus(BiddingItemStatusEnum.BIDDING_WIN.getValue());
            } else {
                updateSupplier.setBiddingStatus(BiddingItemStatusEnum.BIDDING_FAIL.getValue());
            }
            this.biddingSupplierMapper.updateById((Object)updateSupplier);
        }
        PurchaseBiddingHead head = (PurchaseBiddingHead)((Object)this.purchaseBiddingHeadMapper.selectById((Serializable)((Object)headId)));
        String priceCreateWay = head.getPriceCreateWay();
        if (PriceCreateWayEnum.AUTO.getValue().equals(priceCreateWay)) {
            this.createPriceInfo(head, purchaseBiddingItemList);
        }
        if ((budgetAmount = head.getBudgetAmount()) != null) {
            BigDecimal economyAmount = budgetAmount.subtract(totalAmount);
            BigDecimal economyRate = economyAmount.divide(budgetAmount, 4, 4).multiply(BigDecimal.valueOf(100L));
            PurchaseBiddingHead updateHead = new PurchaseBiddingHead();
            updateHead.setEconomyAmount(economyAmount);
            updateHead.setEconomyRate(economyRate);
            updateHead.setId(head.getId());
            this.purchaseBiddingHeadMapper.updateById((Object)updateHead);
        }
    }

    private void createPriceInfo(PurchaseBiddingHead head, List<PurchaseBiddingItem> purchaseBiddingItemList) {
        List acceptList = purchaseBiddingItemList.stream().filter(o -> BiddingItemStatusEnum.BIDDING_WIN.getValue().equals(o.getItemStatus())).collect(Collectors.toList());
        ArrayList<PurchaseInformationRecordsDTO> recordsList = new ArrayList<PurchaseInformationRecordsDTO>();
        for (PurchaseBiddingItem item : acceptList) {
            PurchaseInformationRecordsDTO records = new PurchaseInformationRecordsDTO();
            BeanUtils.copyProperties((Object)((Object)item), (Object)records);
            records.setSourceType(PriceSourceTypeEnum.BIDDING.getValue());
            records.setSourceNumber(head.getBiddingNumber());
            records.setSourceItemNumber(item.getItemNumber());
            records.setAuditStatus(AuditStatusEnum.AUDIT_FINISH.getValue());
            records.setPriceType(PurchaseInformationPriceTypeEnum.MATERIAL.getValue());
            recordsList.add(records);
        }
        this.inquiryInvokeMainDataRpcService.insertPurchaseInformationRecordBatchSomeColumn(recordsList);
    }

    @Override
    public void manualCreatePrce(String headId) {
        this.check(headId);
        PurchaseBiddingHead head = (PurchaseBiddingHead)((Object)this.purchaseBiddingHeadMapper.selectById((Serializable)((Object)headId)));
        if (!BiddingStatusEnum.CONFIRM_ED.getValue().equals(head.getBiddingStatus())) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_fail_status_can_not_add_price_record", (String)"\u5f53\u524d\u72b6\u6001\u4e0d\u80fd\u751f\u6210\u4ef7\u683c\u8bb0\u5f55\uff01"));
        }
        String resultAudit = head.getResultAudit();
        if ("1".equals(resultAudit) && !AuditStatusEnum.AUDIT_FINISH.getValue().equals(head.getResultAuditStatus())) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_fail_add_price_record_by_approved", (String)"\u5b9a\u4ef7\u5ba1\u6279\u901a\u8fc7\u540e\u624d\u80fd\u751f\u6210\u4ef7\u683c\u8bb0\u5f55\uff01"));
        }
        List<PurchaseBiddingItem> purchaseBiddingItemList = this.purchaseBiddingItemMapper.selectByMainId(headId);
        this.createPriceInfo(head, purchaseBiddingItemList);
    }
}

