/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.ebidding.adapter;

import com.alibaba.fastjson.JSONObject;
import com.els.common.enumerate.AuditStatusEnum;
import com.els.modules.ebidding.entity.PurchaseEbiddingHead;
import com.els.modules.ebidding.entity.PurchaseEbiddingItem;
import com.els.modules.ebidding.entity.PurchaseEbiddingSupplier;
import com.els.modules.ebidding.enumerate.EbiddingStatusEnum;
import com.els.modules.ebidding.service.PurchaseEbiddingHeadService;
import com.els.modules.ebidding.service.PurchaseEbiddingItemService;
import com.els.modules.ebidding.service.PurchaseEbiddingSupplierService;
import com.els.modules.ebidding.service.impl.PurchaseEbiddingHeadServiceImpl;
import com.els.modules.ebidding.vo.PurchaseEbiddingHeadVO;
import com.els.modules.uflo.dto.AuditInputParamDTO;
import com.els.modules.uflo.dto.AuditOutputParamDTO;
import com.els.modules.uflo.rpc.service.AuditOptCallBackService;
import com.els.rpc.service.InvokeBaseRpcService;
import java.io.Serializable;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

@Component
public class PublishEbiddingAdapter
implements AuditOptCallBackService {
    @Autowired
    private PurchaseEbiddingHeadService purchaseEbiddingHeadService;
    @Autowired
    private PurchaseEbiddingItemService purchaseEbiddingItemService;
    @Autowired
    private PurchaseEbiddingSupplierService purchaseEbiddingSupplierService;
    @Resource
    private InvokeBaseRpcService invokeBaseRpcService;

    public void startCallBack(AuditInputParamDTO inputParamVO, AuditOutputParamDTO outputParamVO) {
        String param = StringUtils.isEmpty((Object)inputParamVO.getParams()) ? "{}" : inputParamVO.getParams();
        PurchaseEbiddingHeadVO headVO = (PurchaseEbiddingHeadVO)((Object)JSONObject.parseObject((String)param, PurchaseEbiddingHeadVO.class));
        PurchaseEbiddingHeadServiceImpl.checkAndSetParam(headVO);
        PurchaseEbiddingHead head = new PurchaseEbiddingHead();
        BeanUtils.copyProperties((Object)((Object)headVO), (Object)((Object)head));
        head.setEbiddingStatus(EbiddingStatusEnum.NEW.getValue());
        head.setPublishTime(null);
        head.setPublishUser(null);
        this.purchaseEbiddingHeadService.updateMain(head, headVO.getPurchaseEbiddingItemList(), headVO.getPurchaseEbiddingSupplierList(), headVO.getPurchaseAttachmentDemandList());
        this.updateAuditStatus(inputParamVO, outputParamVO);
    }

    public void completeCallBack(AuditInputParamDTO inputParamVO, AuditOutputParamDTO outputParamVO) {
        this.updateAuditStatus(inputParamVO, outputParamVO);
        if (AuditStatusEnum.AUDIT_FINISH.getValue().equals(outputParamVO.getAuditStatus())) {
            PurchaseEbiddingHeadVO headVO = new PurchaseEbiddingHeadVO();
            String id = inputParamVO.getBusinessId();
            PurchaseEbiddingHead dbHead = (PurchaseEbiddingHead)((Object)this.purchaseEbiddingHeadService.getById((Serializable)((Object)id)));
            BeanUtils.copyProperties((Object)((Object)dbHead), (Object)((Object)headVO));
            List<PurchaseEbiddingItem> itemList = this.purchaseEbiddingItemService.selectByMainId(id);
            headVO.setPurchaseEbiddingItemList(itemList);
            List<PurchaseEbiddingSupplier> supplierList = this.purchaseEbiddingSupplierService.selectByMainId(id);
            headVO.setPurchaseEbiddingSupplierList(supplierList);
            List demandList = this.invokeBaseRpcService.selectPurchaseAttachmentDemandByMainId(id);
            headVO.setPurchaseAttachmentDemandList(demandList);
            this.purchaseEbiddingHeadService.publish(headVO);
        }
    }

    public void rejectCallBack(AuditInputParamDTO inputParamVO, AuditOutputParamDTO outputParamVO) {
        this.updateAuditStatus(inputParamVO, outputParamVO);
    }

    public void cancelCallBack(AuditInputParamDTO inputParamVO, AuditOutputParamDTO outputParamVO) {
        this.updateAuditStatus(inputParamVO, outputParamVO);
    }

    private void updateAuditStatus(AuditInputParamDTO inputParamVO, AuditOutputParamDTO outputParamVO) {
        PurchaseEbiddingHead updateHead = new PurchaseEbiddingHead();
        updateHead.setId(inputParamVO.getBusinessId());
        updateHead.setFlowId(outputParamVO.getProcessRootId());
        updateHead.setAuditStatus(outputParamVO.getAuditStatus());
        this.purchaseEbiddingHeadService.updateById((Object)updateHead);
    }
}

