/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.inquiry.qualification.service.impl;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.els.common.util.I18nUtil;
import com.els.modules.inquiry.qualification.entity.PurchaseQualificationReview;
import com.els.modules.inquiry.qualification.enumerate.ReviewStatusEnum;
import com.els.modules.inquiry.qualification.enumerate.SourceTypeEnum;
import com.els.modules.inquiry.qualification.mapper.PurchaseQualificationReviewMapper;
import com.els.modules.inquiry.qualification.service.PurchaseExecuteReviewService;
import com.els.modules.inquiry.qualification.service.PurchaseQualificationReviewService;
import com.els.rpc.service.InvokeBaseRpcService;
import java.io.Serializable;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

@Service
public class PurchaseQualificationReviewServiceImpl
extends ServiceImpl<PurchaseQualificationReviewMapper, PurchaseQualificationReview>
implements PurchaseQualificationReviewService {
    @Resource
    private InvokeBaseRpcService invokeBaseRpcService;

    @Override
    public void add(PurchaseQualificationReview review) {
        String reviewNumber = this.invokeBaseRpcService.getNextCode("qualificationReview", (Object)review);
        review.setQuaReviewNumber(reviewNumber);
        review.setReviewStatus(ReviewStatusEnum.NEW.getValue());
        ((PurchaseQualificationReviewMapper)this.baseMapper).insert((Object)review);
    }

    @Override
    public void update(PurchaseQualificationReview review) {
        ((PurchaseQualificationReviewMapper)this.baseMapper).updateById((Object)review);
    }

    @Override
    @Transactional
    public void review(PurchaseQualificationReview review) {
        PurchaseQualificationReview dbReview = (PurchaseQualificationReview)((Object)((PurchaseQualificationReviewMapper)this.baseMapper).selectById((Serializable)((Object)review.getId())));
        Assert.isTrue((boolean)ReviewStatusEnum.NEW.getValue().equals(dbReview.getReviewStatus()), (String)I18nUtil.translate((String)"i18n_alert_fail_documents_no_review_repeat", (String)"\u5df2\u7ecf\u5ba1\u67e5\u8fc7\u7684\u5355\u636e\uff0c\u4e0d\u53ef\u91cd\u590d\u5ba1\u67e5"));
        Assert.isTrue((boolean)dbReview.getReviewTime().after(new Date()), (String)I18nUtil.translate((String)"i18n_alert_fail_documents_reviewtime_timeout", (String)"\u8d44\u683c\u5ba1\u67e5\u65f6\u95f4\u5df2\u8fc7\uff0c\u4e0d\u53ef\u5ba1\u67e5"));
        dbReview.setReviewStatus(review.getReviewStatus());
        dbReview.setRemark(review.getRemark());
        ((PurchaseQualificationReviewMapper)this.baseMapper).updateById((Object)dbReview);
        if (ReviewStatusEnum.PASS.getValue().equals(review.getReviewStatus())) {
            PurchaseExecuteReviewService executeReviewService = SourceTypeEnum.getExecuteService(dbReview.getSourceType());
            executeReviewService.executeReview(dbReview);
        }
    }

    @Override
    public List<PurchaseQualificationReview> selectByMainId(String id) {
        return ((PurchaseQualificationReviewMapper)this.baseMapper).selectByMainId(id);
    }
}

