/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.inquiry.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.els.common.api.vo.Result;
import com.els.common.exception.ELSBootException;
import com.els.common.system.vo.LoginUser;
import com.els.common.util.I18nUtil;
import com.els.common.util.encryption.RsaEncryptUtil;
import com.els.modules.base.api.dto.PurchaseAttachmentDTO;
import com.els.modules.enquiry.entity.PurchaseEnquiryHead;
import com.els.modules.enquiry.entity.PurchaseEnquiryItem;
import com.els.modules.inquiry.service.PublishToB2BService;
import com.els.rpc.service.InvokeAccountRpcService;
import com.els.rpc.service.InvokeBaseRpcService;
import java.io.File;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.apache.shiro.SecurityUtils;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service
public class PublishToB2BServiceImpl
implements PublishToB2BService {
    @Resource
    private InvokeAccountRpcService invokeAccountRpcService;
    @Resource
    private InvokeBaseRpcService invokeBaseRpcService;
    @Value(value="${els.path.upload}")
    private String uploadPath;
    private String[] pictures = new String[]{".BMP", ".JPG", ".JPEG", ".PNG", ".GIF"};

    @Override
    public void publishToB2B(JSONObject body, JSONArray itemList) {
        LoginUser user = (LoginUser)SecurityUtils.getSubject().getPrincipal();
        body.put("purchaserCompany", (Object)user.getEnterpriseName());
        body.put("srmUserId", (Object)user.getId());
        body.put("linkman", (Object)user.getRealname());
        body.put("phone", (Object)user.getPhone());
        body.put("wechat", (Object)"");
        body.put("email", (Object)user.getEmail());
        body.put("materials", (Object)itemList);
        JSONArray attachments = new JSONArray();
        List attachmentList = this.invokeBaseRpcService.selectPurchaseAttachmentByMainId(body.getString("srmId"));
        for (PurchaseAttachmentDTO attachment : attachmentList) {
            String fileName = attachment.getFileName();
            JSONObject obj = new JSONObject();
            obj.put("url", (Object)(this.uploadPath + File.separator + attachment.getFilePath()));
            obj.put("name", (Object)fileName);
            obj.put("type", (Object)this.getFileType(fileName));
            attachments.add((Object)obj);
        }
        body.put("attachments", (Object)attachments);
        JSONObject data = new JSONObject();
        data.put("body", (Object)body);
        data.put("header", (Object)this.getHeader());
        Result result = this.invokeBaseRpcService.callInterfacePost("publish_inquiry_to_B2B", data);
        Assert.isTrue((boolean)result.isSuccess(), (String)I18nUtil.translate((String)"i18n_alert_fail_request_platform_interface", (String)("\u8c03\u7528\u63a5\u53e3\u5e73\u53f0\u5931\u8d25\uff1a" + result.getMessage())));
        JSONObject response = JSON.parseObject((String)result.getMessage());
        Assert.isTrue((boolean)response.getBoolean("success"), (String)I18nUtil.translate((String)"i18n_alert_fail_publish_source_documents_to_b2b_platform", (String)("\u53d1\u5e03\u5bfb\u6e90\u5355\u636e\u5230B2B\u5e73\u53f0\u5931\u8d25\uff1a" + response.getString("msg"))));
    }

    private JSONObject getHeader() {
        try {
            JSONObject header = new JSONObject();
            String publicKey = "MIGfMA0GCSqGSIb3DQEBAQUAA4GNADCBiQKBgQCN1m4v9Cq7z/Y4hDEpfhB4I3xCYl5KROPE30IWmwA21/gduXgfFGEi0HGKsOjJE/kO1nmoQQi/IKqh14RX9CLnQW0klnEbInvgwQ+L9yzCxWGifM156W6Puw9aYA0Eo5ZKClhWDOfS1HYWCCJWqqs+nZPxCyPtFHszPH3vJp3PxQIDAQAB";
            String str = "ENrbw+bFAUkwO/2CAEnn+g==";
            header.put("secure", (Object)RsaEncryptUtil.encrypt((String)str, (String)publicKey));
            return header;
        }
        catch (Exception e) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_fail_encryption", (String)"\u52a0\u5bc6\u5931\u8d25"));
        }
    }

    private Integer getFileType(String fileName) {
        for (String picture : this.pictures) {
            if (!fileName.toUpperCase().endsWith(picture)) continue;
            return 2;
        }
        return 1;
    }

    private String getTimeString(Date date) {
        if (date != null) {
            LocalDateTime time = LocalDateTime.ofInstant(date.toInstant(), ZoneId.systemDefault());
            DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
            return formatter.format(time);
        }
        return null;
    }

    @Override
    public void publishToB2B(PurchaseEnquiryHead head, List<PurchaseEnquiryItem> itemList) {
        JSONObject body = new JSONObject();
        body.put("srmId", (Object)head.getId());
        body.put("srmBusinessNo", (Object)head.getEnquiryNumber());
        body.put("offerEndTime", (Object)this.getTimeString(head.getApplyEndTime()));
        body.put("validityDate", (Object)this.getTimeString(head.getQuoteEndTime()));
        body.put("moreInfo", (Object)head.getRemark());
        body.put("type", (Object)1);
        JSONArray materialList = new JSONArray();
        for (PurchaseEnquiryItem item : itemList) {
            JSONObject material = new JSONObject();
            material.put("name", (Object)item.getMaterialDesc());
            material.put("brand", (Object)item.getMaterialSpec());
            material.put("purchaseQuantity", (Object)item.getRequireQuantity());
            material.put("description", (Object)item.getPurchaseRemark());
            material.put("orders", (Object)item.getItemNumber());
            material.put("unit", (Object)item.getPriceUnit());
            materialList.add((Object)material);
        }
        this.publishToB2B(body, materialList);
    }
}

