/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.bidding.service.impl;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.util.SysUtil;
import com.els.modules.base.api.dto.PurchaseAttachmentDTO;
import com.els.modules.bidding.entity.BiddingEvaluationRegulation;
import com.els.modules.bidding.entity.BiddingEvaluationRegulationSelection;
import com.els.modules.bidding.enumerate.QuestionTypesEnum;
import com.els.modules.bidding.mapper.BiddingEvaluationRegulationMapper;
import com.els.modules.bidding.mapper.BiddingEvaluationRegulationSelectionMapper;
import com.els.modules.bidding.service.BiddingEvaluationRegulationService;
import com.els.rpc.service.InvokeBaseRpcService;
import io.micrometer.core.instrument.util.StringUtils;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class BiddingEvaluationRegulationServiceImpl
extends ServiceImpl<BiddingEvaluationRegulationMapper, BiddingEvaluationRegulation>
implements BiddingEvaluationRegulationService {
    @Autowired
    private BiddingEvaluationRegulationMapper biddingEvaluationRegulationMapper;
    @Autowired
    private BiddingEvaluationRegulationSelectionMapper biddingEvaluationRegulationSelectionMapper;
    @Autowired
    private InvokeBaseRpcService invokeBaseRpcService;

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void saveMain(BiddingEvaluationRegulation biddingEvaluationRegulation, List<BiddingEvaluationRegulationSelection> biddingEvaluationRegulationSelectionList, List<PurchaseAttachmentDTO> attachmentList) {
        biddingEvaluationRegulation.setRegulationNumber(this.invokeBaseRpcService.getNextCode("biddingRegulationNumber", (Object)biddingEvaluationRegulation));
        this.biddingEvaluationRegulationMapper.insert((Object)biddingEvaluationRegulation);
        this.insertData(biddingEvaluationRegulation, biddingEvaluationRegulationSelectionList, attachmentList);
    }

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void updateMain(BiddingEvaluationRegulation biddingEvaluationRegulation, List<BiddingEvaluationRegulationSelection> biddingEvaluationRegulationSelectionList, List<PurchaseAttachmentDTO> attachmentList) {
        if (biddingEvaluationRegulationSelectionList != null && biddingEvaluationRegulationSelectionList.size() > 0 && StringUtils.isNotBlank((String)biddingEvaluationRegulation.getInputType()) && !biddingEvaluationRegulation.getInputType().equals(QuestionTypesEnum.SHORT_ANSWER.getValue())) {
            BigDecimal fullMark = new BigDecimal(0.0);
            if (QuestionTypesEnum.CHOOSE_ONE.getValue().equals(biddingEvaluationRegulation.getInputType())) {
                for (BiddingEvaluationRegulationSelection selection : biddingEvaluationRegulationSelectionList) {
                    if (selection.getScore() == null || fullMark.compareTo(selection.getScore()) != -1) continue;
                    fullMark = selection.getScore();
                }
            }
            if (QuestionTypesEnum.CHOOSE_MORE.getValue().equals(biddingEvaluationRegulation.getInputType())) {
                for (BiddingEvaluationRegulationSelection selection : biddingEvaluationRegulationSelectionList) {
                    if (selection.getScore() == null) continue;
                    fullMark = selection.getScore().add(fullMark);
                }
            }
            biddingEvaluationRegulation.setFullMark(fullMark);
        }
        this.biddingEvaluationRegulationMapper.updateById((Object)biddingEvaluationRegulation);
        this.biddingEvaluationRegulationSelectionMapper.deleteByMainId(biddingEvaluationRegulation.getId());
        this.insertData(biddingEvaluationRegulation, biddingEvaluationRegulationSelectionList, attachmentList);
    }

    private void insertData(BiddingEvaluationRegulation biddingEvaluationRegulation, List<BiddingEvaluationRegulationSelection> biddingEvaluationRegulationSelectionList, List<PurchaseAttachmentDTO> attachmentList) {
        if (biddingEvaluationRegulationSelectionList != null) {
            for (BiddingEvaluationRegulationSelection entity : biddingEvaluationRegulationSelectionList) {
                entity.setHeadId(biddingEvaluationRegulation.getId());
                SysUtil.setSysParam((BaseEntity)entity, (BaseEntity)biddingEvaluationRegulation);
            }
            if (!biddingEvaluationRegulationSelectionList.isEmpty()) {
                this.biddingEvaluationRegulationSelectionMapper.insertBatchSomeColumn(biddingEvaluationRegulationSelectionList);
            }
        }
    }

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void delMain(String id) {
        this.biddingEvaluationRegulationSelectionMapper.deleteByMainId(id);
        this.biddingEvaluationRegulationMapper.deleteById((Serializable)((Object)id));
    }

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void delBatchMain(List<String> idList) {
        for (Serializable serializable : idList) {
            this.biddingEvaluationRegulationSelectionMapper.deleteByMainId(serializable.toString());
            this.biddingEvaluationRegulationMapper.deleteById(serializable);
        }
    }
}

