/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.demand.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.conditions.update.LambdaUpdateChainWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.els.common.enumerate.AuditStatusEnum;
import com.els.common.exception.ELSBootException;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.vo.LoginUser;
import com.els.common.util.I18nUtil;
import com.els.common.util.SpringContextUtils;
import com.els.common.util.SysUtil;
import com.els.modules.base.api.dto.BaseDTO;
import com.els.modules.base.api.dto.PurchaseAttachmentDTO;
import com.els.modules.demand.entity.PurchaseRequestHead;
import com.els.modules.demand.entity.PurchaseRequestItem;
import com.els.modules.demand.enumerate.PurchaseRequestStatusEnum;
import com.els.modules.demand.enumerate.PurchaseRequestStatusItemEnum;
import com.els.modules.demand.mapper.PurchaseRequestHeadMapper;
import com.els.modules.demand.mapper.PurchaseRequestItemMapper;
import com.els.modules.demand.rpc.PurchaseInformationRecordsLocalRpcService;
import com.els.modules.demand.rpc.PurchaseMaterialHeadLocalRpcService;
import com.els.modules.demand.rpc.PurchaseMaterialSourceLocalRpcService;
import com.els.modules.demand.rpc.PurchaseOrganizationInfoLocalRpcService;
import com.els.modules.demand.service.PurchaseRequestHeadService;
import com.els.modules.demand.service.PurchaseRequestItemService;
import com.els.modules.demand.vo.PurchaseRequestHeadVO;
import com.els.modules.demand.vo.RequestMatchInfomationVO;
import com.els.modules.material.api.dto.PurchaseMaterialHeadDTO;
import com.els.modules.material.api.dto.PurchaseMaterialHeadExtendDTO;
import com.els.modules.material.api.dto.PurchaseMaterialItemDTO;
import com.els.modules.material.api.dto.PurchaseMaterialSourceDTO;
import com.els.modules.material.api.enumerate.MaterialSourceStatusEnum;
import com.els.modules.org.api.dto.PurchaseOrganizationInfoDTO;
import com.els.modules.price.api.dto.PurchaseInformationRecordsDTO;
import com.els.modules.price.api.enumerate.PriceStatusEnum;
import com.els.rpc.service.InvokeBaseRpcService;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.apache.shiro.SecurityUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

@Service
public class PurchaseRequestHeadServiceImpl
extends ServiceImpl<PurchaseRequestHeadMapper, PurchaseRequestHead>
implements PurchaseRequestHeadService {
    public static final String HAD_SOURCE = "HADSOURCE";
    public static final String NO_HAD_SOURCE = "NOHAHSOURCE";
    @Resource
    private PurchaseRequestHeadMapper purchaseRequestHeadMapper;
    @Resource
    private PurchaseRequestItemMapper purchaseRequestItemMapper;
    @Autowired
    private PurchaseRequestItemService purchaseRequestItemService;
    @Resource
    private PurchaseMaterialHeadLocalRpcService purchaseMaterialHeadMapper;
    @Resource
    private PurchaseInformationRecordsLocalRpcService purchaseInformationRecordsService;
    @Resource
    private PurchaseOrganizationInfoLocalRpcService purchaseOrganizationInfoService;
    @Resource
    private PurchaseMaterialSourceLocalRpcService purchaseMaterialSourceMapper;
    @Autowired
    private InvokeBaseRpcService invokeBaseRpcService;

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void saveMain(PurchaseRequestHeadVO purchaseRequestHead, List<PurchaseRequestItem> purchaseRequestItemList, List<PurchaseAttachmentDTO> purchaseAttachmentList) {
        List<PurchaseOrganizationInfoDTO> list;
        if (StringUtils.isBlank((CharSequence)purchaseRequestHead.getRequestNumber())) {
            String nextCode = this.invokeBaseRpcService.getNextCode("srmPurchaseRequestNumber", (Object)purchaseRequestHead);
            purchaseRequestHead.setRequestNumber(nextCode);
        }
        purchaseRequestHead.setApplyDate(new Date());
        purchaseRequestHead.setRequestStatus(PurchaseRequestStatusEnum.REQUEST_NEW.getValue());
        purchaseRequestHead.setAuditStatus(AuditStatusEnum.AUDIT_NEW.getValue());
        LoginUser loginUser = (LoginUser)SecurityUtils.getSubject().getPrincipal();
        purchaseRequestHead.setApplicant(loginUser.getSubAccount() + "_" + loginUser.getRealname());
        if (StringUtils.isNotBlank((CharSequence)loginUser.getOrgCode()) && loginUser.getOrgCode().split(",").length == 1 && !CollectionUtils.isEmpty(list = this.purchaseOrganizationInfoService.listByIdAndCateCode(loginUser.getOrgCode().split(",")[0], loginUser.getElsAccount(), "dept"))) {
            purchaseRequestHead.setApplyDept(list.get(0).getOrgCode() + "_" + list.get(0).getOrgName());
        }
        this.purchaseRequestHeadMapper.insert((Object)purchaseRequestHead);
        this.insertData(purchaseRequestHead, purchaseRequestItemList, purchaseAttachmentList);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void updateMain(PurchaseRequestHeadVO purchaseRequestHead, List<PurchaseRequestItem> purchaseRequestItemList, List<PurchaseAttachmentDTO> purchaseAttachmentList) {
        if (!CollectionUtils.isEmpty(purchaseRequestItemList)) {
            BigDecimal total = purchaseRequestItemList.stream().filter(p -> p.getSubtotalAmount() != null).map(PurchaseRequestItem::getSubtotalAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
            purchaseRequestHead.setTotalAmount(total);
        }
        if ("0".equals(purchaseRequestHead.getAudit())) {
            purchaseRequestHead.setAuditStatus(AuditStatusEnum.NO_AUDIT_REQUIRED.getValue());
        } else if ("1".equals(purchaseRequestHead.getAudit()) && AuditStatusEnum.NO_AUDIT_REQUIRED.getValue().equals(purchaseRequestHead.getAuditStatus())) {
            purchaseRequestHead.setAuditStatus(AuditStatusEnum.AUDIT_NEW.getValue());
        }
        this.purchaseRequestHeadMapper.updateById((Object)purchaseRequestHead);
        this.purchaseRequestItemMapper.deleteByMainId(purchaseRequestHead.getId());
        this.invokeBaseRpcService.deletePurchaseAttachmentByMainId(purchaseRequestHead.getId());
        this.insertData(purchaseRequestHead, purchaseRequestItemList, purchaseAttachmentList);
    }

    private void insertData(PurchaseRequestHead purchaseRequestHead, List<PurchaseRequestItem> purchaseRequestItemList, List<PurchaseAttachmentDTO> purchaseAttachmentList) {
        if (!CollectionUtils.isEmpty(purchaseRequestItemList)) {
            int count = 1;
            for (PurchaseRequestItem entity : purchaseRequestItemList) {
                entity.setUpdateBy(null);
                entity.setUpdateTime(null);
                if (null == entity.getId()) {
                    entity.setCreateBy(null);
                    entity.setCreateTime(null);
                }
                entity.setAuditStatus(purchaseRequestHead.getAuditStatus());
                entity.setHeadId(purchaseRequestHead.getId());
                entity.setItemNumber(count + "");
                entity.setId(null);
                if (PurchaseRequestStatusItemEnum.SEND_BACK.getValue().equals(entity.getItemStatus())) {
                    entity.setItemStatus(PurchaseRequestStatusItemEnum.APPROVED.getValue());
                    entity.setRole(null);
                    entity.setPurchasePrincipal(null);
                    entity.setResponsibleGroup(null);
                }
                entity.setRequestNumber(purchaseRequestHead.getRequestNumber());
                entity.setPurchaseGroup(purchaseRequestHead.getPurchaseGroup());
                entity.setRequestType(purchaseRequestHead.getRequestType());
                entity.setPurchaseType(purchaseRequestHead.getPurchaseType());
                entity.setApplyDept(purchaseRequestHead.getApplyDept());
                if (StringUtils.isNotBlank((CharSequence)entity.getFactory())) {
                    entity.setFactory(purchaseRequestHead.getFactory());
                }
                entity.setApplyDate(purchaseRequestHead.getApplyDate());
                entity.setApplicant(purchaseRequestHead.getApplicant());
                entity.setPurchaseOrg(purchaseRequestHead.getPurchaseOrg());
                entity.setSourceNumber(purchaseRequestHead.getRequestNumber());
                entity.setSourceItemNumber(count + "");
                ++count;
                SysUtil.setSysParam((BaseEntity)entity, (BaseEntity)purchaseRequestHead);
            }
            if (!purchaseRequestItemList.isEmpty()) {
                this.purchaseRequestItemMapper.insertBatchSomeColumn(purchaseRequestItemList);
            }
        }
        if (!CollectionUtils.isEmpty(purchaseAttachmentList)) {
            for (PurchaseAttachmentDTO entity : purchaseAttachmentList) {
                entity.setCreateTime(null);
                entity.setCreateBy(null);
                entity.setUpdateBy(null);
                entity.setUpdateTime(null);
                entity.setHeadId(purchaseRequestHead.getId());
                SysUtil.setSysParam((BaseDTO)entity, (BaseEntity)purchaseRequestHead);
            }
            if (!purchaseAttachmentList.isEmpty()) {
                this.invokeBaseRpcService.insertPurchaseAttachmentBatchSomeColumn(purchaseAttachmentList);
            }
        }
    }

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void delMain(String id) {
        this.purchaseRequestItemMapper.deleteByMainId(id);
        this.purchaseRequestHeadMapper.deleteById((Serializable)((Object)id));
        this.invokeBaseRpcService.deletePurchaseAttachmentByMainId(id);
    }

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void delBatchMain(List<String> idList) {
        for (Serializable serializable : idList) {
            this.purchaseRequestItemMapper.deleteByMainId(serializable.toString());
            this.purchaseRequestHeadMapper.deleteById(serializable);
            this.invokeBaseRpcService.deletePurchaseAttachmentByMainId(serializable.toString());
        }
    }

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void updateStatus(PurchaseRequestHead head) {
        PurchaseRequestHead updateBuyHead = new PurchaseRequestHead();
        updateBuyHead.setId(head.getId());
        updateBuyHead.setRequestStatus(head.getRequestStatus());
        if (PurchaseRequestStatusEnum.REQUEST_CANCAL.getValue().equals(head.getRequestStatus())) {
            ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.purchaseRequestItemService.lambdaUpdate().set(PurchaseRequestItem::getItemStatus, (Object)PurchaseRequestStatusItemEnum.CANCEL.getValue())).eq(PurchaseRequestItem::getHeadId, (Object)head.getId())).update();
        }
        this.purchaseRequestHeadMapper.updateById((Object)updateBuyHead);
    }

    @Override
    public void matchPrice(List<PurchaseRequestItem> purchaseRequestItemList) {
        ArrayList<PurchaseRequestItem> list = new ArrayList<PurchaseRequestItem>();
        for (PurchaseRequestItem item : purchaseRequestItemList) {
            List<PurchaseInformationRecordsDTO> effectiveRecordList = this.purchaseInformationRecordsService.getEffectiveRecordList(item.getMaterialNumber(), null, item.getFactory(), item.getPurchaseOrg(), null);
            if (CollectionUtils.isEmpty(effectiveRecordList) || effectiveRecordList.size() <= 0) continue;
            PurchaseRequestItem item1 = new PurchaseRequestItem();
            item1.setId(item.getId());
            item1.setItemStatus(PurchaseRequestStatusItemEnum.WAIT_ORDER.getValue());
            list.add(item1);
        }
        if (!CollectionUtils.isEmpty(list)) {
            this.purchaseRequestItemMapper.updateBatchById(list);
        }
    }

    @Override
    public List<RequestMatchInfomationVO> matchInformationRecords(List<PurchaseRequestItem> purchaseRequestItemList) {
        ArrayList<RequestMatchInfomationVO> requestMatchInfomationVOList = new ArrayList<RequestMatchInfomationVO>();
        try {
            com.els.common.util.Assert.isNotEmpty(purchaseRequestItemList, (String)"\u9700\u6c42\u6c60\u8f6c\u8ba2\u7684\u884c\u4e0d\u80fd\u4e3a\u7a7a!");
            List ids = purchaseRequestItemList.stream().map(BaseEntity::getId).collect(Collectors.toList());
            PurchaseRequestItemService purchaseRequestItemService = (PurchaseRequestItemService)SpringContextUtils.getBean(PurchaseRequestItemService.class);
            List dbPurchaseRequestItems = purchaseRequestItemService.listByIds(ids);
            if (CollectionUtil.isEmpty((Collection)dbPurchaseRequestItems) || dbPurchaseRequestItems.size() != purchaseRequestItemList.size()) {
                throw new ELSBootException(I18nUtil.translate((String)"", (String)"\u9009\u62e9\u7684\u90e8\u5206\u8bf7\u9700\u6c42\u5728\u7cfb\u7edf\u67e5\u8be2\u4e0d\u5230\u5355\u636e"));
            }
            for (PurchaseRequestItem requestItem : dbPurchaseRequestItems) {
                BigDecimal toOrderQuantity = requestItem.getToOrderQuantity() == null ? BigDecimal.ZERO : requestItem.getToOrderQuantity();
                if (toOrderQuantity.compareTo(requestItem.getQuantity()) < 0) continue;
                throw new ELSBootException(I18nUtil.translate((String)"", (String)("\u9700\u6c42\u5355[" + requestItem.getRequestNumber() + "]\u884c\u53f7[" + requestItem.getItemNumber() + "]\u7684\u5df2\u8f6c\u8ba2\u5355\u6570\u91cf\u5fc5\u987b\u5c0f\u4e8e\u9700\u6c42\u6570\u91cf!")));
            }
            Map<String, PurchaseMaterialHeadExtendDTO> purchaseMaterialHeadExtendMap = this.getPurchaseMaterialHeadMap(purchaseRequestItemList);
            String hadSource = HAD_SOURCE;
            String noHadSource = NO_HAD_SOURCE;
            HashMap goodsMaterialNumberMap = new HashMap();
            goodsMaterialNumberMap.put(hadSource, new ArrayList());
            goodsMaterialNumberMap.put(noHadSource, new ArrayList());
            if (CollectionUtil.isNotEmpty(purchaseRequestItemList)) {
                List<RequestMatchInfomationVO> requestMatchInfomationVOS;
                for (PurchaseRequestItem requestItem : purchaseRequestItemList) {
                    String key = requestItem.getMaterialNumber() + "_" + requestItem.getFactory();
                    PurchaseMaterialHeadExtendDTO purchaseMaterialHeadExtend = purchaseMaterialHeadExtendMap.get(key);
                    if ("1".equals(purchaseMaterialHeadExtend.getSource())) {
                        ((List)goodsMaterialNumberMap.get(hadSource)).add(requestItem);
                        continue;
                    }
                    ((List)goodsMaterialNumberMap.get(noHadSource)).add(requestItem);
                }
                if (CollectionUtil.isNotEmpty((Collection)((Collection)goodsMaterialNumberMap.get(hadSource)))) {
                    requestMatchInfomationVOS = this.doHadSourceRequest((List)goodsMaterialNumberMap.get(hadSource), purchaseMaterialHeadExtendMap);
                    requestMatchInfomationVOList.addAll(requestMatchInfomationVOS);
                }
                if (CollectionUtil.isNotEmpty((Collection)((Collection)goodsMaterialNumberMap.get(noHadSource)))) {
                    requestMatchInfomationVOS = this.doNoHadSourceRequest((List)goodsMaterialNumberMap.get(noHadSource), purchaseMaterialHeadExtendMap);
                    requestMatchInfomationVOList.addAll(requestMatchInfomationVOS);
                }
            }
        }
        catch (Exception e) {
            throw new ELSBootException(e.getMessage(), (Throwable)e, new String[0]);
        }
        return requestMatchInfomationVOList;
    }

    private List<RequestMatchInfomationVO> doNoHadSourceRequest(List<PurchaseRequestItem> purchaseRequestItemList, Map<String, PurchaseMaterialHeadExtendDTO> purchaseMaterialHeadExtendMap) {
        ArrayList<RequestMatchInfomationVO> requestMatchInfomationVOList = new ArrayList<RequestMatchInfomationVO>();
        if (CollectionUtil.isNotEmpty(purchaseRequestItemList)) {
            List<String> materialNumbers = purchaseRequestItemList.stream().map(PurchaseRequestItem::getMaterialNumber).distinct().collect(Collectors.toList());
            List headIds = purchaseRequestItemList.stream().map(PurchaseRequestItem::getHeadId).distinct().collect(Collectors.toList());
            if (CollectionUtil.isNotEmpty(materialNumbers)) {
                QueryWrapper informationRecordsQueryWrapper = new QueryWrapper();
                informationRecordsQueryWrapper.in((Object)"material_number", materialNumbers);
                informationRecordsQueryWrapper.eq((Object)"audit_status", (Object)AuditStatusEnum.AUDIT_FINISH.getValue());
                informationRecordsQueryWrapper.eq((Object)"record_status", (Object)PriceStatusEnum.NORMAL.getValue());
                informationRecordsQueryWrapper.le((Object)"effective_date", (Object)new Date());
                informationRecordsQueryWrapper.ge((Object)"expiry_date", (Object)new Date());
                informationRecordsQueryWrapper.last("and purchase_org is not null and purchase_org!='' ");
                List purchaseRequestHeadList = this.purchaseRequestHeadMapper.selectBatchIds(headIds);
                Map requestHeadMap = purchaseRequestHeadList.stream().collect(Collectors.toMap(PurchaseRequestHead::getRequestNumber, Function.identity()));
                List<PurchaseInformationRecordsDTO> purchaseInformationRecordsList = this.purchaseInformationRecordsService.selectListNoOrg(AuditStatusEnum.AUDIT_FINISH.getValue(), PriceStatusEnum.NORMAL.getValue(), new Date(), new Date(), materialNumbers);
                com.els.common.util.Assert.isNotEmpty(purchaseInformationRecordsList, (String)("\u7269\u6599\u7f16\u7801[" + materialNumbers.get(0) + "]\u6ca1\u6709\u5339\u914d\u5230\u5408\u9002\u7684\u4ef7\u683c\u4fe1\u606f\u8bb0\u5f55"));
                if (CollectionUtil.isNotEmpty(purchaseInformationRecordsList)) {
                    Map<String, List<PurchaseInformationRecordsDTO>> materialNumberMaptoInfomationRecord = purchaseInformationRecordsList.parallelStream().collect(Collectors.groupingBy(PurchaseInformationRecordsDTO::getMaterialNumber));
                    for (PurchaseRequestItem requestItem : purchaseRequestItemList) {
                        PurchaseRequestHead purchaseRequestHead = (PurchaseRequestHead)((Object)requestHeadMap.get(requestItem.getRequestNumber()));
                        List materialInfomationRecords = materialNumberMaptoInfomationRecord.get(requestItem.getMaterialNumber()).stream().filter(item -> item.getPurchaseOrg().equals(purchaseRequestHead.getPurchaseOrg())).collect(Collectors.toList());
                        com.els.common.util.Assert.isNotEmpty(materialInfomationRecords, (String)("\u7269\u6599\u7f16\u7801[" + requestItem.getMaterialNumber() + "]\u6ca1\u6709\u5339\u914d\u5230\u5408\u9002\u7684\u4ef7\u683c\u4fe1\u606f\u8bb0\u5f55"));
                        PurchaseMaterialHeadExtendDTO purchaseMaterialHeadExtend = purchaseMaterialHeadExtendMap.get(requestItem.getMaterialNumber() + "_" + requestItem.getFactory());
                        for (PurchaseInformationRecordsDTO informationRecords : materialInfomationRecords) {
                            RequestMatchInfomationVO requestMatchInfomationVO = new RequestMatchInfomationVO();
                            requestMatchInfomationVO.setRequestNumber(requestItem.getRequestNumber());
                            requestMatchInfomationVO.setRequestItemNumber(requestItem.getItemNumber());
                            requestMatchInfomationVO.setMaterialNumber(requestItem.getMaterialNumber());
                            requestMatchInfomationVO.setMaterialDesc(requestItem.getMaterialDesc());
                            requestMatchInfomationVO.setToElsAccount(informationRecords.getToElsAccount());
                            requestMatchInfomationVO.setSupplierName(informationRecords.getSupplierName());
                            BigDecimal toOrderQuantity = requestItem.getToOrderQuantity() == null ? BigDecimal.ZERO : requestItem.getToOrderQuantity();
                            requestMatchInfomationVO.setQuantity(requestItem.getQuantity().subtract(toOrderQuantity));
                            requestMatchInfomationVO.setPreferredSupplier("0");
                            requestMatchInfomationVO.setTaxRate(informationRecords.getTaxRate());
                            requestMatchInfomationVO.setTaxCode(informationRecords.getTaxCode());
                            requestMatchInfomationVO.setToOrderQuantity(BigDecimal.ZERO);
                            requestMatchInfomationVO.setPrice(informationRecords.getPrice());
                            requestMatchInfomationVO.setNetPirce(informationRecords.getNetPrice());
                            requestMatchInfomationVO.setEffectiveDate(informationRecords.getEffectiveDate());
                            requestMatchInfomationVO.setExpiryDate(informationRecords.getExpiryDate());
                            requestMatchInfomationVO.setPurchaseOrg(purchaseRequestHead.getPurchaseOrg());
                            requestMatchInfomationVO.setPurchaseGroup(purchaseRequestHead.getPurchaseGroup());
                            requestMatchInfomationVO.setCompany(purchaseRequestHead.getCompany());
                            requestMatchInfomationVO.setJit(purchaseMaterialHeadExtend.getJit());
                            if (StringUtils.isNotBlank((CharSequence)purchaseMaterialHeadExtend.getItemFactory())) {
                                requestMatchInfomationVO.setJit(purchaseMaterialHeadExtend.getItemJit());
                            }
                            requestMatchInfomationVO.setCurrency(requestItem.getCurrency());
                            requestMatchInfomationVO.setFactory(requestItem.getFactory());
                            requestMatchInfomationVO.setStorageLocation(requestItem.getStorageLocation());
                            requestMatchInfomationVO.setRequestItemId(requestItem.getId());
                            requestMatchInfomationVO.setEstimate(informationRecords.getTemporaryPrice());
                            requestMatchInfomationVO.setLadderPriceJson(informationRecords.getLadderPriceJson());
                            requestMatchInfomationVOList.add(requestMatchInfomationVO);
                        }
                    }
                }
            }
        }
        return requestMatchInfomationVOList;
    }

    private List<RequestMatchInfomationVO> doHadSourceRequest(List<PurchaseRequestItem> purchaseRequestItemList, Map<String, PurchaseMaterialHeadExtendDTO> purchaseMaterialHeadExtendMap) {
        QueryWrapper purchaseMaterialSourceQueryWrapper = new QueryWrapper();
        List<String> materialNumbers = purchaseRequestItemList.stream().map(PurchaseRequestItem::getMaterialNumber).distinct().collect(Collectors.toList());
        List headIds = purchaseRequestItemList.stream().map(PurchaseRequestItem::getHeadId).distinct().collect(Collectors.toList());
        List<PurchaseMaterialSourceDTO> purchaseMaterialSourceList = this.purchaseMaterialSourceMapper.selectList(materialNumbers, MaterialSourceStatusEnum.NORMAL.getValue(), new Date(), new Date());
        List purchaseRequestHeadList = this.purchaseRequestHeadMapper.selectBatchIds(headIds);
        Map<String, List<PurchaseMaterialSourceDTO>> materialNumberMapToSource = purchaseMaterialSourceList.parallelStream().collect(Collectors.groupingBy(PurchaseMaterialSourceDTO::getMaterialNumber));
        Map requestHeadMap = purchaseRequestHeadList.stream().collect(Collectors.toMap(PurchaseRequestHead::getRequestNumber, Function.identity()));
        ArrayList<RequestMatchInfomationVO> requestMatchInfomationVOList = new ArrayList<RequestMatchInfomationVO>();
        for (PurchaseRequestItem requestItem : purchaseRequestItemList) {
            List<PurchaseMaterialSourceDTO> materialSources = materialNumberMapToSource.get(requestItem.getMaterialNumber());
            PurchaseRequestHead purchaseRequestHead = (PurchaseRequestHead)((Object)requestHeadMap.get(requestItem.getRequestNumber()));
            PurchaseMaterialHeadExtendDTO purchaseMaterialHeadExtend = purchaseMaterialHeadExtendMap.get(requestItem.getMaterialNumber() + "_" + requestItem.getFactory());
            if (CollectionUtil.isEmpty(materialSources)) {
                throw new ELSBootException(I18nUtil.translate((String)"", (String)("\u7269\u6599\u7f16\u7801[" + requestItem.getMaterialNumber() + "]\u7684\u9700\u6c42\u884c\u5728\u8d27\u6e90\u6e05\u5355\u67e5\u8be2\u4e0d\u5230\u5bf9\u5e94\u7684\u4f9b\u5e94\u5546\u6570\u636e\uff0c\u8bf7\u68c0\u67e5\u7269\u6599\u914d\u7f6e\u662f\u5426\u6b63\u786e")));
            }
            List<String> toElsAccounts = materialSources.stream().map(PurchaseMaterialSourceDTO::getToElsAccount).distinct().collect(Collectors.toList());
            Map<String, List<PurchaseMaterialSourceDTO>> materialSourceMap = materialSources.parallelStream().collect(Collectors.groupingBy(PurchaseMaterialSourceDTO::getToElsAccount));
            QueryWrapper purchaseInformationRecordsQueryWrapper = new QueryWrapper();
            purchaseInformationRecordsQueryWrapper.in((Object)"to_els_account", toElsAccounts);
            purchaseInformationRecordsQueryWrapper.eq((Object)"audit_status", (Object)AuditStatusEnum.AUDIT_FINISH.getValue());
            purchaseInformationRecordsQueryWrapper.eq((Object)"record_status", (Object)PriceStatusEnum.NORMAL.getValue());
            purchaseInformationRecordsQueryWrapper.le((Object)"effective_date", (Object)new Date());
            purchaseInformationRecordsQueryWrapper.ge((Object)"expiry_date", (Object)new Date());
            purchaseInformationRecordsQueryWrapper.eq((Object)"material_number", (Object)requestItem.getMaterialNumber());
            purchaseInformationRecordsQueryWrapper.eq((Object)"purchase_org", (Object)purchaseRequestHead.getPurchaseOrg());
            List<Object> informationRecordsList = this.purchaseInformationRecordsService.selectList(toElsAccounts, AuditStatusEnum.AUDIT_FINISH.getValue(), PriceStatusEnum.NORMAL.getValue(), new Date(), new Date(), requestItem.getMaterialNumber(), purchaseRequestHead.getPurchaseOrg());
            informationRecordsList = informationRecordsList.stream().filter(item -> StringUtils.isBlank((CharSequence)item.getFactory()) || item.getFactory().equals(requestItem.getFactory())).collect(Collectors.toList());
            com.els.common.util.Assert.isNotEmpty(informationRecordsList, (String)("\u7269\u6599\u7f16\u7801[" + requestItem.getMaterialNumber() + "]\u7684\u9700\u6c42\u884c\u8d27\u6e90\u6e05\u5355\u4e2d\u6307\u5b9a\u7684\u4f9b\u5e94\u5546" + toElsAccounts.toString() + "\u4e0b\u6ca1\u6709\u6709\u6548\u7684\u4ef7\u683c\u8bb0\u5f55,\u8bf7\u5148\u53bb\u5bfb\u6e90\u6216\u8005\u521b\u5efa\u4ef7\u683c"));
            for (PurchaseInformationRecordsDTO purchaseInformationRecordsDTO : informationRecordsList) {
                PurchaseMaterialSourceDTO purchaseMaterialSource = materialSourceMap.get(purchaseInformationRecordsDTO.getToElsAccount()).get(0);
                RequestMatchInfomationVO requestMatchInfomationVO = new RequestMatchInfomationVO();
                requestMatchInfomationVO.setRequestNumber(requestItem.getRequestNumber());
                requestMatchInfomationVO.setRequestItemNumber(requestItem.getItemNumber());
                requestMatchInfomationVO.setMaterialNumber(requestItem.getMaterialNumber());
                requestMatchInfomationVO.setMaterialDesc(requestItem.getMaterialDesc());
                requestMatchInfomationVO.setToElsAccount(purchaseInformationRecordsDTO.getToElsAccount());
                requestMatchInfomationVO.setSupplierName(purchaseInformationRecordsDTO.getSupplierName());
                BigDecimal toOrderQuantity = requestItem.getToOrderQuantity() == null ? BigDecimal.ZERO : requestItem.getToOrderQuantity();
                requestMatchInfomationVO.setQuantity(requestItem.getQuantity().subtract(toOrderQuantity));
                if (StringUtils.isNotBlank((CharSequence)purchaseMaterialSource.getPreferredSupplier()) && "1".equals(purchaseMaterialSource.getPreferredSupplier())) {
                    requestMatchInfomationVO.setPreferredSupplier("1");
                    requestMatchInfomationVO.setToOrderQuantity(requestItem.getQuantity().subtract(toOrderQuantity));
                } else {
                    requestMatchInfomationVO.setPreferredSupplier("0");
                    requestMatchInfomationVO.setToOrderQuantity(BigDecimal.ZERO);
                }
                requestMatchInfomationVO.setPrice(purchaseInformationRecordsDTO.getPrice());
                requestMatchInfomationVO.setNetPirce(purchaseInformationRecordsDTO.getNetPrice());
                requestMatchInfomationVO.setTaxRate(purchaseInformationRecordsDTO.getTaxRate());
                requestMatchInfomationVO.setTaxCode(purchaseInformationRecordsDTO.getTaxCode());
                requestMatchInfomationVO.setEffectiveDate(purchaseInformationRecordsDTO.getEffectiveDate());
                requestMatchInfomationVO.setExpiryDate(purchaseInformationRecordsDTO.getExpiryDate());
                requestMatchInfomationVO.setPurchaseOrg(purchaseRequestHead.getPurchaseOrg());
                requestMatchInfomationVO.setPurchaseGroup(purchaseRequestHead.getPurchaseGroup());
                requestMatchInfomationVO.setCompany(purchaseRequestHead.getCompany());
                requestMatchInfomationVO.setJit(purchaseMaterialHeadExtend.getJit());
                requestMatchInfomationVO.setLadderPriceJson(purchaseInformationRecordsDTO.getLadderPriceJson());
                if (StringUtils.isNotBlank((CharSequence)purchaseMaterialHeadExtend.getItemFactory())) {
                    requestMatchInfomationVO.setJit(purchaseMaterialHeadExtend.getItemJit());
                }
                requestMatchInfomationVO.setCurrency(requestItem.getCurrency());
                requestMatchInfomationVO.setFactory(requestItem.getFactory());
                requestMatchInfomationVO.setStorageLocation(requestItem.getStorageLocation());
                requestMatchInfomationVO.setRequestItemId(requestItem.getId());
                requestMatchInfomationVO.setEstimate(purchaseInformationRecordsDTO.getTemporaryPrice());
                requestMatchInfomationVOList.add(requestMatchInfomationVO);
            }
        }
        return requestMatchInfomationVOList;
    }

    private Map<String, PurchaseMaterialHeadExtendDTO> getPurchaseMaterialHeadMap(List<PurchaseRequestItem> purchaseRequestItemList) {
        if (CollectionUtil.isNotEmpty(purchaseRequestItemList)) {
            HashMap<String, PurchaseMaterialHeadExtendDTO> purchaseMaterialHeadExtendMap = new HashMap<String, PurchaseMaterialHeadExtendDTO>();
            List<String> materialNumbers = purchaseRequestItemList.stream().map(PurchaseRequestItem::getMaterialNumber).distinct().collect(Collectors.toList());
            List<PurchaseMaterialHeadDTO> purchaseMaterialHeadList = this.purchaseMaterialHeadMapper.listByMaterialNumbers(materialNumbers);
            Map materialByNumberMap = purchaseMaterialHeadList.stream().collect(Collectors.toMap(PurchaseMaterialHeadDTO::getMaterialNumber, Function.identity()));
            for (PurchaseRequestItem requestItem : purchaseRequestItemList) {
                String key = requestItem.getMaterialNumber() + "_" + requestItem.getFactory();
                if (purchaseMaterialHeadExtendMap.containsKey(key)) continue;
                PurchaseMaterialHeadExtendDTO purchaseMaterialHeadExtend = new PurchaseMaterialHeadExtendDTO();
                PurchaseMaterialHeadDTO purchaseMaterialHead = (PurchaseMaterialHeadDTO)materialByNumberMap.get(requestItem.getMaterialNumber());
                BeanUtils.copyProperties((Object)purchaseMaterialHead, (Object)purchaseMaterialHeadExtend);
                if (StringUtils.isNotBlank((CharSequence)requestItem.getFactory())) {
                    List<PurchaseMaterialItemDTO> purchaseMaterialItemList = this.purchaseMaterialHeadMapper.selectByMainIdAndFactory(purchaseMaterialHead.getId(), requestItem.getFactory());
                    PurchaseMaterialItemDTO purchaseMaterialItem = null;
                    if (CollectionUtil.isNotEmpty(purchaseMaterialItemList)) {
                        purchaseMaterialItem = purchaseMaterialItemList.get(0);
                    }
                    if (purchaseMaterialItem != null) {
                        purchaseMaterialHeadExtend.setSource(purchaseMaterialItem.getSource());
                        purchaseMaterialHeadExtend.setItemJit(purchaseMaterialItem.getJit());
                        purchaseMaterialHeadExtend.setItemFactory(purchaseMaterialItem.getFactory());
                    }
                }
                purchaseMaterialHeadExtendMap.put(key, purchaseMaterialHeadExtend);
            }
            return purchaseMaterialHeadExtendMap;
        }
        return null;
    }

    @Override
    public void syncRequestToOrderQuantity(List<PurchaseRequestItem> purchaseRequestItemList) {
        if (CollectionUtil.isNotEmpty(purchaseRequestItemList)) {
            ArrayList<PurchaseRequestItem> requestItemList = new ArrayList<PurchaseRequestItem>();
            for (PurchaseRequestItem requestItem : purchaseRequestItemList) {
                PurchaseRequestItem purchaseRequestItem = new PurchaseRequestItem();
                BigDecimal toOrderQuantitySum = this.purchaseRequestItemMapper.selectToOrderQuantitySum(requestItem);
                if (toOrderQuantitySum == null) {
                    toOrderQuantitySum = BigDecimal.ZERO;
                }
                purchaseRequestItem.setId(requestItem.getId());
                purchaseRequestItem.setToOrderQuantity(toOrderQuantitySum);
                requestItemList.add(purchaseRequestItem);
            }
            this.purchaseRequestItemMapper.updateBatchById(requestItemList);
        }
    }

    @Override
    public void syncRequestatus(List<PurchaseRequestItem> requestItemList) {
        List ids = requestItemList.stream().map(BaseEntity::getId).collect(Collectors.toList());
        List purchaseRequestItems = this.purchaseRequestItemMapper.selectBatchIds(ids);
        if (CollectionUtil.isNotEmpty((Collection)purchaseRequestItems)) {
            ArrayList<PurchaseRequestItem> purchaseRequestItems1 = new ArrayList<PurchaseRequestItem>();
            for (PurchaseRequestItem requestItem : purchaseRequestItems) {
                PurchaseRequestItem purchaseRequestItem = new PurchaseRequestItem();
                purchaseRequestItem.setId(requestItem.getId());
                if (BigDecimal.ZERO.compareTo(requestItem.getToOrderQuantity()) == 0) {
                    purchaseRequestItem.setItemStatus(PurchaseRequestStatusItemEnum.WAIT_ORDER.getValue());
                } else if (BigDecimal.ZERO.compareTo(requestItem.getToOrderQuantity()) < 0) {
                    purchaseRequestItem.setItemStatus(PurchaseRequestStatusItemEnum.ORDER_BUILT.getValue());
                }
                purchaseRequestItems1.add(purchaseRequestItem);
            }
            this.purchaseRequestItemMapper.updateBatchById(purchaseRequestItems1);
        }
    }

    @Override
    public void toDemandPool(String id) {
        List<PurchaseRequestItem> purchaseRequestItems = this.purchaseRequestItemMapper.selectByMainId(id);
        if (CollectionUtils.isEmpty(purchaseRequestItems)) {
            throw new ELSBootException(I18nUtil.translate((String)"", (String)"\u63d0\u4ea4\u5230\u9700\u6c42\u6c60\u81f3\u5c11\u6709\u4e00\u4e2a\u884c\u9879\u76ee"));
        }
        HashMap itemStatusMap = new HashMap();
        purchaseRequestItems.forEach(item -> {
            Assert.isTrue((boolean)StringUtils.isNotBlank((CharSequence)item.getMaterialNumber()), (String)I18nUtil.translate((String)"", (String)"\u884c\u7269\u6599\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a"));
            Assert.isTrue((item.getQuantity() != null ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_alert_empty_notQuantity", (String)"\u884c\u6570\u91cf\u4e0d\u80fd\u4e3a\u7a7a"));
            Assert.isTrue((item.getQuantity().compareTo(BigDecimal.ZERO) > 0 ? 1 : 0) != 0, (String)I18nUtil.translate((String)"", (String)"\u884c\u6570\u91cf\u5c0f\u4e8e\u7b49\u4e8e0"));
            itemStatusMap.put(item.getId(), Integer.parseInt(item.getAuditStatus()));
        });
        PurchaseRequestHead purchaseRequestHead = (PurchaseRequestHead)((Object)this.getById((Serializable)((Object)id)));
        PurchaseRequestHeadVO purchaseRequestHeadVO = new PurchaseRequestHeadVO();
        BeanUtils.copyProperties((Object)((Object)purchaseRequestHead), (Object)((Object)purchaseRequestHeadVO));
        List<PurchaseRequestItem> purchaseRequestItemList = this.purchaseRequestItemService.selectByMainId(id);
        purchaseRequestHeadVO.setPurchaseRequestItemList(purchaseRequestItemList);
        if (!CollectionUtils.isEmpty(purchaseRequestItems)) {
            this.purchaseRequestItemService.toDemandPool(purchaseRequestHeadVO);
        }
        if (!CollectionUtils.isEmpty(purchaseRequestItems)) {
            LambdaQueryWrapper wrapper = Wrappers.lambdaQuery();
            wrapper.select(new SFunction[]{BaseEntity::getId, PurchaseRequestItem::getItemStatus});
            wrapper.in(BaseEntity::getId, itemStatusMap.keySet());
            List items = this.purchaseRequestItemService.list((Wrapper)wrapper);
            List ids = items.stream().filter(i -> PurchaseRequestStatusItemEnum.APPROVED.getValue().equals(i.getItemStatus()) || PurchaseRequestStatusItemEnum.SEND_BACK.getValue().equals(i.getItemStatus())).map(BaseEntity::getId).collect(Collectors.toList());
            if (!CollectionUtils.isEmpty(ids)) {
                LambdaUpdateWrapper updateWrapper = Wrappers.lambdaUpdate();
                updateWrapper.set(PurchaseRequestItem::getTacticsEntity, null);
                updateWrapper.set(PurchaseRequestItem::getTacticsObject, null);
                updateWrapper.set(PurchaseRequestItem::getItemStatus, (Object)PurchaseRequestStatusItemEnum.DEMAND_POOL.getValue());
                updateWrapper.in(BaseEntity::getId, ids);
                this.purchaseRequestItemService.update((Wrapper)updateWrapper);
            }
        }
        this.matchPrice(purchaseRequestItems);
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().eq(BaseEntity::getId, (Object)purchaseRequestHeadVO.getId())).set(PurchaseRequestHead::getRequestStatus, (Object)PurchaseRequestStatusEnum.REQUEST_DEMAND.getValue())).update();
    }
}

