/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.ebidding.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.els.common.api.vo.Result;
import com.els.common.system.vo.LoginUser;
import com.els.common.util.I18nUtil;
import com.els.common.util.SpringContextUtils;
import com.els.config.mybatis.TenantContext;
import com.els.modules.base.api.dto.AttachmentSendDTO;
import com.els.modules.base.api.dto.ElsInitialTableDTO;
import com.els.modules.base.api.dto.PurchaseAttachmentDTO;
import com.els.modules.base.api.dto.PurchaseAttachmentDemandDTO;
import com.els.modules.bidding.enumerate.StageTypeEnum;
import com.els.modules.ebidding.entity.PurchaseEbiddingHead;
import com.els.modules.ebidding.entity.PurchaseEbiddingItem;
import com.els.modules.ebidding.entity.PurchaseEbiddingSupplier;
import com.els.modules.ebidding.mapper.PurchaseEbiddingHeadMapper;
import com.els.modules.ebidding.service.PublicEbiddingService;
import com.els.modules.ebidding.service.PurchaseEbiddingHeadService;
import com.els.modules.ebidding.service.PurchaseEbiddingSupplierService;
import com.els.modules.ebidding.service.impl.PurchaseEbiddingHeadServiceImpl;
import com.els.modules.ebidding.vo.PurchaseEbiddingHeadVO;
import com.els.modules.inquiry.enumerate.QualificationReviewEnum;
import com.els.modules.inquiry.qualification.entity.PurchaseQualificationReview;
import com.els.modules.inquiry.qualification.enumerate.SourceTypeEnum;
import com.els.modules.inquiry.qualification.service.PurchaseQualificationReviewService;
import com.els.modules.inquiry.rpc.service.InquiryInvokeMainDataRpcService;
import com.els.modules.inquiry.rpc.service.InquiryInvokeMessageRpcService;
import com.els.modules.inquiry.rpc.service.InquiryInvokeSupplierRpcService;
import com.els.modules.inquiry.service.PublicInquiryService;
import com.els.modules.inquiry.vo.PublicInquiryVO;
import com.els.modules.notice.api.dto.PurchaseNoticeDTO;
import com.els.modules.notice.api.enumerate.NoticeScopeEnum;
import com.els.modules.supplier.api.dto.SupplierMasterDataDTO;
import com.els.rpc.service.InvokeBaseRpcService;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.shiro.SecurityUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

@Service
public class PublicEbiddingServiceImpl
extends ServiceImpl<PurchaseEbiddingHeadMapper, PurchaseEbiddingHead>
implements PublicEbiddingService,
PublicInquiryService {
    @Autowired
    private PurchaseQualificationReviewService reviewService;
    @Autowired
    private PurchaseEbiddingSupplierService supplierService;
    @Resource
    private InvokeBaseRpcService invokeBaseRpcService;
    @Resource
    private InquiryInvokeMessageRpcService inquiryInvokeMessageRpcService;
    @Resource
    private InquiryInvokeMainDataRpcService inquiryInvokeMainDataRpcService;
    @Resource
    private InquiryInvokeSupplierRpcService inquiryInvokeSupplierRpcService;

    @Override
    public void publishNotice(PurchaseEbiddingHead dbHead) {
        LoginUser user = (LoginUser)SecurityUtils.getSubject().getPrincipal();
        String projectName = dbHead.getProjectName() == null ? "" : dbHead.getProjectName();
        PurchaseNoticeDTO notice = new PurchaseNoticeDTO();
        notice.setBusAccount(dbHead.getBusAccount());
        notice.setNoticeTitle(user.getEnterpriseName() + projectName + "\u516c\u5f00\u7ade\u4ef7");
        notice.setNoticeContent("\u6709\u610f\u5411\u8005\u53ef\u53c2\u4e0e\u62a5\u540d");
        notice.setNoticeType("2");
        notice.setNoticeScope(NoticeScopeEnum.IN_STATION_OPEN.getValue());
        notice.setTop("1");
        notice.setEffectiveTime(new Date());
        notice.setBusinessId(dbHead.getId());
        notice.setBusinessType(SourceTypeEnum.EBIDDING.getValue());
        notice.setTemplateNumber(dbHead.getTemplateNumber());
        notice.setTemplateVersion(dbHead.getTemplateVersion());
        notice.setExpiryTime(dbHead.getApplyEndTime());
        notice.setTemplateAccount(dbHead.getTemplateAccount());
        PurchaseNoticeDTO notice1 = new PurchaseNoticeDTO();
        BeanUtils.copyProperties((Object)notice, (Object)notice1);
        notice1.setNoticeContent("\u6ce8\u518c\u540e\u5373\u53ef\u4e8e\u7cfb\u7edf\u5185\u516c\u544a\u5904\u53c2\u4e0e\u62a5\u540d");
        notice1.setNoticeScope(NoticeScopeEnum.OPEN.getValue());
        this.inquiryInvokeMessageRpcService.publish(notice, Lists.newArrayList(), Lists.newArrayList());
        this.inquiryInvokeMessageRpcService.publish(notice1, Lists.newArrayList(), Lists.newArrayList());
    }

    @Override
    public Result<?> getPublicResult(String headId) {
        PurchaseEbiddingHead dbHead = (PurchaseEbiddingHead)((Object)this.getById((Serializable)((Object)headId)));
        PurchaseEbiddingHeadVO headVO = new PurchaseEbiddingHeadVO();
        BeanUtils.copyProperties((Object)((Object)dbHead), (Object)((Object)headVO));
        ElsInitialTableDTO initInfo = this.invokeBaseRpcService.selectElsInitialTableOne(headId);
        List initItemList = JSON.parseArray((String)initInfo.getBusinessInfoJson(), PurchaseEbiddingItem.class);
        headVO.setInitItemList(initItemList);
        List demandList = this.invokeBaseRpcService.selectPurchaseAttachmentDemandByMainId(headId);
        headVO.setPurchaseAttachmentDemandList(demandList);
        headVO.setPurchaseAttachmentList(this.invokeBaseRpcService.toPurchaseAttachment(headId));
        return Result.ok((Object)((Object)headVO));
    }

    @Override
    @Transactional
    public void apply(PublicInquiryVO inquiryVO) {
        String headId = inquiryVO.getId();
        PurchaseEbiddingHead dbHead = (PurchaseEbiddingHead)((Object)this.getById((Serializable)((Object)headId)));
        String supplierAccount = TenantContext.getTenant();
        List toElsAccountList = this.supplierService.selectByMainId(headId).stream().map(PurchaseEbiddingSupplier::getToElsAccount).collect(Collectors.toList());
        Assert.isTrue((!toElsAccountList.contains(supplierAccount) ? 1 : 0) != 0, (String)I18nUtil.translate((String)"", (String)"\u5df2\u88ab\u9080\u8bf7\u53c2\u4e0e\u672c\u6b21\u7ade\u4ef7\u6216\u8d44\u8d28\u5ba1\u67e5\u5df2\u901a\u8fc7\uff0c\u65e0\u9700\u62a5\u540d"));
        List reviewList = this.reviewService.selectByMainId(headId).stream().filter(review -> supplierAccount.equals(review.getToElsAccount())).collect(Collectors.toList());
        Assert.isTrue((boolean)CollectionUtil.isEmpty(reviewList), (String)I18nUtil.translate((String)"i18n_alert_fail_registration_repeat", (String)"\u65e0\u9700\u91cd\u590d\u62a5\u540d"));
        Assert.isTrue((boolean)dbHead.getApplyEndTime().after(new Date()), (String)I18nUtil.translate((String)"i18n_alert_fail_registration_time_time_out", (String)"\u62a5\u540d\u622a\u6b62\u65f6\u95f4\u5df2\u8fc7\uff0c\u4e0d\u53ef\u62a5\u540d"));
        List demandList = this.invokeBaseRpcService.selectPurchaseAttachmentDemandByMainId(headId).stream().filter(demand -> "1".equals(demand.getRequired())).filter(demand -> StageTypeEnum.APPLY.getValue().equals(demand.getStageType())).collect(Collectors.toList());
        List<PurchaseAttachmentDTO> attachmentList = inquiryVO.getAttachmentList();
        Map<String, List<PurchaseAttachmentDTO>> checkMap = attachmentList.stream().filter(attachment -> !StringUtils.isEmpty((Object)attachment.getFileType())).collect(Collectors.groupingBy(PurchaseAttachmentDTO::getFileType));
        for (PurchaseAttachmentDemandDTO demand2 : demandList) {
            Assert.isTrue((boolean)checkMap.containsKey(demand2.getFileType()), (String)I18nUtil.translate((String)"", (String)"\u8bf7\u6309\u7167\u8981\u6c42\u4e0a\u4f20\u5bf9\u5e94\u7c7b\u578b\u7684\u6587\u4ef6\uff01"));
        }
        SupplierMasterDataDTO masterData = this.inquiryInvokeSupplierRpcService.getByAccount(dbHead.getElsAccount(), supplierAccount);
        if (masterData == null) {
            masterData = this.inquiryInvokeSupplierRpcService.addUnfamiliarSupplier(dbHead.getElsAccount());
        }
        LoginUser user = (LoginUser)SecurityUtils.getSubject().getPrincipal();
        PurchaseQualificationReview review2 = new PurchaseQualificationReview();
        review2.setElsAccount(dbHead.getElsAccount());
        review2.setRelationId(dbHead.getId());
        review2.setSupplierQualification(dbHead.getSupplierQualification());
        review2.setContacts(inquiryVO.getContacts());
        review2.setPhone(inquiryVO.getPhone());
        review2.setEmail(inquiryVO.getEmail());
        review2.setAddress(inquiryVO.getAddress());
        review2.setToElsAccount(supplierAccount);
        review2.setSupplierCode(masterData.getSupplierCode());
        review2.setSupplierName(masterData.getSupplierName());
        review2.setBidder(user.getSubAccount() + "_" + user.getRealname());
        review2.setSourceType(SourceTypeEnum.EBIDDING.getValue());
        review2.setSourceNumber(dbHead.getEbiddingNumber());
        Date reviewTime = "1".equals(dbHead.getNeedEcho()) ? dbHead.getEchoEndTime() : dbHead.getBeginTime();
        review2.setReviewTime(reviewTime);
        this.reviewService.add(review2);
        AttachmentSendDTO sendVO = new AttachmentSendDTO();
        sendVO.setHeadId(dbHead.getId());
        sendVO.setElsAccount(supplierAccount);
        ConcurrentHashMap<String, String> toSend = new ConcurrentHashMap<String, String>();
        toSend.put(dbHead.getId(), dbHead.getElsAccount());
        sendVO.setToSend(toSend);
        this.invokeBaseRpcService.sendSaleFile(sendVO);
        if (QualificationReviewEnum.BEFORE_QUOTE.getValue().equals(dbHead.getQualificationReview())) {
            PurchaseEbiddingHeadService purchaseEbiddingHeadService = (PurchaseEbiddingHeadService)SpringContextUtils.getBean(PurchaseEbiddingHeadServiceImpl.class);
            purchaseEbiddingHeadService.executeReview(dbHead, review2);
        }
    }
}

