/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.ebidding.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.els.common.system.vo.LoginUser;
import com.els.modules.ebidding.entity.PurchaseEbiddingItemHis;
import com.els.modules.ebidding.entity.PurchaseEbiddingSupplier;
import com.els.modules.ebidding.entity.SaleEbiddingHead;
import com.els.modules.ebidding.entity.SaleEbiddingItem;
import com.els.modules.ebidding.entity.SaleEbiddingItemHis;
import com.els.modules.ebidding.enumerate.EbiddingWayEnum;
import com.els.modules.ebidding.mapper.PurchaseEbiddingItemHisMapper;
import com.els.modules.ebidding.mapper.SaleEbiddingItemHisMapper;
import com.els.modules.ebidding.service.SaleEbiddingItemHisService;
import com.els.modules.ebidding.service.SaleEbiddingItemService;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.shiro.SecurityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SaleEbiddingItemHisServiceImpl
extends ServiceImpl<SaleEbiddingItemHisMapper, SaleEbiddingItemHis>
implements SaleEbiddingItemHisService {
    private static final Logger log = LoggerFactory.getLogger(SaleEbiddingItemHisServiceImpl.class);
    @Resource
    private PurchaseEbiddingItemHisMapper purchaseEbiddingItemHisMapper;
    @Autowired
    private SaleEbiddingItemService saleEbiddingItemService;

    @Override
    public List<SaleEbiddingItemHis> queryBidLobbyDetail(SaleEbiddingHead head) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        if (EbiddingWayEnum.SINGLE.getValue().equals(head.getEbiddingWay())) {
            queryWrapper.eq(SaleEbiddingItemHis::getItemNumber, (Object)head.getCurrentItemNumber());
        }
        queryWrapper.eq(SaleEbiddingItemHis::getCurrentRound, (Object)head.getCurrentRound());
        queryWrapper.eq(SaleEbiddingItemHis::getEbiddingNumber, (Object)head.getEbiddingNumber());
        queryWrapper.eq(SaleEbiddingItemHis::getToElsAccount, (Object)head.getToElsAccount());
        queryWrapper.orderByDesc(SaleEbiddingItemHis::getQuoteTime);
        return this.list((Wrapper)queryWrapper);
    }

    @Override
    public void save(SaleEbiddingHead head, SaleEbiddingItem quoteItem, PurchaseEbiddingSupplier supplier) {
        SaleEbiddingItemHis updateSale = new SaleEbiddingItemHis();
        updateSale.setLastQuote("0");
        updateSale.setInjectionEls(false);
        ((SaleEbiddingItemHisMapper)this.baseMapper).update((Object)updateSale, (Wrapper)new LambdaQueryWrapper().eq(SaleEbiddingItemHis::getItemId, (Object)quoteItem.getId()));
        PurchaseEbiddingItemHis updatePurchase = new PurchaseEbiddingItemHis();
        updatePurchase.setLastQuote("0");
        updatePurchase.setInjectionEls(false);
        this.purchaseEbiddingItemHisMapper.update((Object)updatePurchase, (Wrapper)new LambdaQueryWrapper().eq(PurchaseEbiddingItemHis::getItemId, (Object)quoteItem.getRelationId()));
        SaleEbiddingItemHis his = new SaleEbiddingItemHis();
        BeanUtils.copyProperties((Object)((Object)quoteItem), (Object)((Object)his));
        his.setId(null);
        his.setItemId(quoteItem.getId());
        his.setHeadId(head.getId());
        his.setLastQuote("1");
        his.setQuoteType(head.getQuoteType());
        his.setEbiddingWay(head.getEbiddingWay());
        try {
            LoginUser sysUser = (LoginUser)SecurityUtils.getSubject().getPrincipal();
            his.setQuoteSubAccount(sysUser.getSubAccount());
            his.setQuoteUser(sysUser.getRealname());
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        if (EbiddingWayEnum.PACKAGE.getValue().equals(head.getEbiddingWay())) {
            List<SaleEbiddingItem> itemList = this.saleEbiddingItemService.selectByMainId(head.getId());
            String materialNumber = itemList.parallelStream().map(SaleEbiddingItem::getMaterialNumber).distinct().collect(Collectors.joining(","));
            his.setMaterialNumber(materialNumber);
            his.setMaterialDesc(EbiddingWayEnum.PACKAGE.getDesc());
        }
        ((SaleEbiddingItemHisMapper)this.baseMapper).insert((Object)his);
        PurchaseEbiddingItemHis purchaseHis = new PurchaseEbiddingItemHis();
        BeanUtils.copyProperties((Object)((Object)his), (Object)((Object)purchaseHis));
        purchaseHis.setId(null);
        purchaseHis.setRelationId(his.getId());
        purchaseHis.setHeadId(head.getRelationId());
        purchaseHis.setItemId(quoteItem.getRelationId());
        purchaseHis.setElsAccount(head.getToElsAccount());
        purchaseHis.setToElsAccount(head.getElsAccount());
        purchaseHis.setSupplierName(supplier.getSupplierName());
        this.purchaseEbiddingItemHisMapper.insert((Object)purchaseHis);
    }
}

