/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.bidding.service.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.date.DateTime;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.els.common.aspect.annotation.SrmTransaction;
import com.els.common.exception.ELSBootException;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.vo.LoginUser;
import com.els.common.util.I18nUtil;
import com.els.common.util.SysUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.base.api.dto.PurchaseAttachmentDTO;
import com.els.modules.bidding.entity.PurchaseBiddingChange;
import com.els.modules.bidding.entity.PurchaseBiddingChangeItem;
import com.els.modules.bidding.entity.PurchaseBiddingHead;
import com.els.modules.bidding.entity.PurchaseBiddingSpecialist;
import com.els.modules.bidding.entity.PurchaseClarificationInfo;
import com.els.modules.bidding.entity.SaleBiddingHead;
import com.els.modules.bidding.enumerate.BiddingChangeFieldEnum;
import com.els.modules.bidding.enumerate.BiddingStatusEnum;
import com.els.modules.bidding.enumerate.BusinessBillTypeEnum;
import com.els.modules.bidding.enumerate.MemberRoleEnum;
import com.els.modules.bidding.enumerate.MemberTypeEnum;
import com.els.modules.bidding.job.BiddingJobUtil;
import com.els.modules.bidding.mapper.PurchaseBiddingChangeItemMapper;
import com.els.modules.bidding.mapper.PurchaseBiddingChangeMapper;
import com.els.modules.bidding.mapper.PurchaseBiddingHeadMapper;
import com.els.modules.bidding.mapper.PurchaseBiddingSpecialistMapper;
import com.els.modules.bidding.mapper.SaleBiddingHeadMapper;
import com.els.modules.bidding.service.PurchaseBiddingChangeService;
import com.els.modules.bidding.service.PurchaseClarificationInfoService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PurchaseBiddingChangeServiceImpl
extends ServiceImpl<PurchaseBiddingChangeMapper, PurchaseBiddingChange>
implements PurchaseBiddingChangeService {
    @Resource
    private PurchaseBiddingChangeMapper purchaseBiddingChangeMapper;
    @Resource
    private PurchaseBiddingChangeItemMapper purchaseBiddingChangeItemMapper;
    @Resource
    private PurchaseBiddingHeadMapper purchaseBiddingHeadMapper;
    @Resource
    private SaleBiddingHeadMapper saleBiddingHeadMapper;
    @Autowired
    private PurchaseClarificationInfoService purchaseClarificationInfoService;
    @Resource
    private PurchaseBiddingSpecialistMapper purchaseBiddingSpecialistMapper;

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void saveMain(PurchaseBiddingChange purchaseBiddingChange, List<PurchaseBiddingChangeItem> purchaseBiddingChangeItemList) {
        this.checkPermission(purchaseBiddingChange.getRelationId());
        this.purchaseBiddingChangeMapper.insert((Object)purchaseBiddingChange);
        this.insertData(purchaseBiddingChange, purchaseBiddingChangeItemList);
    }

    private void checkPermission(String id) {
        LoginUser user = SysUtil.getLoginUser();
        List specialistList = this.purchaseBiddingSpecialistMapper.selectByMainId(id).stream().filter(o -> MemberTypeEnum.PROJECT.getValue().equals(o.getMemberType())).filter(o -> MemberRoleEnum.BID_PRINCIPAL.getValue().equals(o.getMemberRole())).map(PurchaseBiddingSpecialist::getSubAccount).collect(Collectors.toList());
        if (!specialistList.contains(user.getSubAccount())) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_oper_no_bidding_principal_bidding", (String)"\u53ea\u6709\u62db\u6807\u8d1f\u8d23\u4eba\u53ef\u4ee5\u64cd\u4f5c\uff01"));
        }
        PurchaseBiddingHead dbHBiddingHead = (PurchaseBiddingHead)((Object)this.purchaseBiddingHeadMapper.selectById((Serializable)((Object)id)));
        String biddingStatus = dbHBiddingHead.getBiddingStatus();
        ArrayList<String> passStatusList = new ArrayList<String>();
        passStatusList.add(BiddingStatusEnum.BIDDING.getValue());
        passStatusList.add(BiddingStatusEnum.OPEN_BID_ED.getValue());
        passStatusList.add(BiddingStatusEnum.EVA_BIDDING.getValue());
        passStatusList.add(BiddingStatusEnum.CONFIRM_ING.getValue());
        if (!passStatusList.contains(biddingStatus)) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_oper_can_not_create_bidding_change_record_bidding", (String)"\u5f53\u524d\u72b6\u6001\u4e0d\u80fd\u521b\u5efa\u62db\u6807\u53d8\u66f4\uff01"));
        }
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void updateMain(PurchaseBiddingChange purchaseBiddingChange, List<PurchaseBiddingChangeItem> purchaseBiddingChangeItemList) {
        this.checkPermission(purchaseBiddingChange.getRelationId());
        this.purchaseBiddingChangeMapper.updateById((Object)purchaseBiddingChange);
        this.purchaseBiddingChangeItemMapper.deleteByMainId(purchaseBiddingChange.getId());
        this.insertData(purchaseBiddingChange, purchaseBiddingChangeItemList);
    }

    private void insertData(PurchaseBiddingChange purchaseBiddingChange, List<PurchaseBiddingChangeItem> purchaseBiddingChangeItemList) {
        for (PurchaseBiddingChangeItem entity : purchaseBiddingChangeItemList) {
            entity.setHeadId(purchaseBiddingChange.getId());
            SysUtil.setSysParam((BaseEntity)entity, (BaseEntity)purchaseBiddingChange);
            entity.setElsAccount(TenantContext.getTenant());
        }
        if (!purchaseBiddingChangeItemList.isEmpty()) {
            this.purchaseBiddingChangeItemMapper.insertBatchSomeColumn(purchaseBiddingChangeItemList);
        }
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void delMain(String id) {
        this.purchaseBiddingChangeItemMapper.deleteByMainId(id);
        this.purchaseBiddingChangeMapper.deleteById((Serializable)((Object)id));
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void delBatchMain(List<String> idList) {
        for (Serializable serializable : idList) {
            this.purchaseBiddingChangeItemMapper.deleteByMainId(serializable.toString());
            this.purchaseBiddingChangeMapper.deleteById(serializable);
        }
    }

    @Override
    public void publish(String id) {
        PurchaseBiddingChange dbHead = (PurchaseBiddingChange)((Object)this.purchaseBiddingChangeMapper.selectById((Serializable)((Object)id)));
        PurchaseBiddingChange head = new PurchaseBiddingChange();
        head.setEffectivetime(new Date());
        head.setId(id);
        this.purchaseBiddingChangeMapper.updateById((Object)head);
        List<PurchaseBiddingChangeItem> itemList = this.purchaseBiddingChangeItemMapper.selectByMainId(id);
        List list = itemList.stream().filter(o -> StrUtil.isNotBlank((CharSequence)o.getFieldValue())).collect(Collectors.toList());
        String biddingId = dbHead.getRelationId();
        JSONObject object = new JSONObject();
        for (PurchaseBiddingChangeItem item : list) {
            object.put(item.getFieldCode(), (Object)item.getFieldValue());
        }
        PurchaseBiddingHead biddingHead = (PurchaseBiddingHead)((Object)JSONObject.parseObject((String)object.toString(), PurchaseBiddingHead.class));
        biddingHead.setId(biddingId);
        this.purchaseBiddingHeadMapper.updateById((Object)biddingHead);
        SaleBiddingHead saleBiddingHead = new SaleBiddingHead();
        BeanUtil.copyProperties((Object)((Object)biddingHead), (Object)((Object)saleBiddingHead), (String[])new String[0]);
        saleBiddingHead.setRelationId(biddingId);
        this.saleBiddingHeadMapper.update((Object)saleBiddingHead, (Wrapper)new LambdaUpdateWrapper().eq(SaleBiddingHead::getRelationId, (Object)saleBiddingHead.getRelationId()));
        PurchaseBiddingHead dbHBiddingHead = (PurchaseBiddingHead)((Object)this.purchaseBiddingHeadMapper.selectById((Serializable)((Object)biddingId)));
        if (biddingHead.getPlanOpenBidTime() != null) {
            this.editOpenBidAlertJob(dbHBiddingHead);
        }
        PurchaseClarificationInfo clarificationInfo = new PurchaseClarificationInfo();
        clarificationInfo.setBusinessId(dbHBiddingHead.getId());
        clarificationInfo.setBusinessType(BusinessBillTypeEnum.CALL_BIDS.getValue());
        clarificationInfo.setBusinessNumber(dbHBiddingHead.getBiddingNumber());
        clarificationInfo.setBusinessName(dbHBiddingHead.getBiddingDesc());
        clarificationInfo.setMatterTitel("\u62db\u6807\u53d8\u66f4");
        StringBuilder stringBuilder = new StringBuilder("\u53d8\u66f4\u5185\u5bb9\uff1a");
        for (PurchaseBiddingChangeItem item : list) {
            BiddingChangeFieldEnum changeFieldEnum = BiddingChangeFieldEnum.getByValue(item.getFieldCode());
            if (changeFieldEnum == null) continue;
            stringBuilder.append(changeFieldEnum.getDesc()).append(" \u539f\u503c\uff1a").append(item.getFieldOriginalValue()).append(", \u53d8\u66f4\u503c\uff1a").append(item.getFieldValue()).append("; ");
        }
        clarificationInfo.setClarificationMatter(stringBuilder.toString());
        this.purchaseClarificationInfoService.publish(clarificationInfo, new ArrayList<PurchaseAttachmentDTO>());
    }

    private void editOpenBidAlertJob(PurchaseBiddingHead head) {
        Date planOpenBidTime = head.getPlanOpenBidTime();
        int openBidAlertMinute = 5;
        if (head.getOpenBidAlertMinute() != null) {
            openBidAlertMinute = head.getOpenBidAlertMinute();
        }
        DateTime alertTime = DateUtil.offsetMinute((Date)planOpenBidTime, (int)(0 - openBidAlertMinute));
        BiddingJobUtil.updateEndJob(head, (Date)alertTime);
    }
}

