/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.bidding.service.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.date.DateTime;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.els.api.dto.BaseDTO;
import com.els.common.aspect.annotation.SrmTransaction;
import com.els.common.enumerate.AuditStatusEnum;
import com.els.common.exception.ELSBootException;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.system.vo.LoginUser;
import com.els.common.util.I18nUtil;
import com.els.common.util.MqUtil;
import com.els.common.util.SpringContextUtils;
import com.els.common.util.SysUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.account.api.dto.ElsSubAccountDTO;
import com.els.modules.base.api.dto.AttachmentSendDTO;
import com.els.modules.base.api.dto.ElsInitialTableDTO;
import com.els.modules.base.api.dto.PurchaseAttachmentDTO;
import com.els.modules.base.api.dto.PurchaseAttachmentDemandDTO;
import com.els.modules.base.api.dto.SaleAttachmentDemandDTO;
import com.els.modules.bidding.entity.BiddingSupplier;
import com.els.modules.bidding.entity.PurchaseBiddingHead;
import com.els.modules.bidding.entity.PurchaseBiddingItem;
import com.els.modules.bidding.entity.PurchaseBiddingSpecialist;
import com.els.modules.bidding.entity.SaleBiddingHead;
import com.els.modules.bidding.entity.SaleBiddingItem;
import com.els.modules.bidding.enumerate.BiddingStatusEnum;
import com.els.modules.bidding.enumerate.BiddingTypeEnum;
import com.els.modules.bidding.enumerate.BusinessBillTypeEnum;
import com.els.modules.bidding.enumerate.MemberRoleEnum;
import com.els.modules.bidding.enumerate.MemberTypeEnum;
import com.els.modules.bidding.enumerate.ReplyStatusEnum;
import com.els.modules.bidding.enumerate.SupplierSourceTypeEnum;
import com.els.modules.bidding.job.BiddingJobUtil;
import com.els.modules.bidding.mapper.BiddingSupplierMapper;
import com.els.modules.bidding.mapper.PurchaseBiddingHeadMapper;
import com.els.modules.bidding.mapper.PurchaseBiddingItemMapper;
import com.els.modules.bidding.mapper.PurchaseBiddingSpecialistMapper;
import com.els.modules.bidding.mapper.SaleBiddingHeadMapper;
import com.els.modules.bidding.mapper.SaleBiddingItemMapper;
import com.els.modules.bidding.service.PurchaseBiddingHeadService;
import com.els.modules.bidding.service.PurchaseClarificationInfoService;
import com.els.modules.bidding.service.impl.PurchaseClarificationInfoServiceImpl;
import com.els.modules.bidding.vo.PurchaseBiddingHeadVO;
import com.els.modules.demand.enumerate.PurchaseRequestStatusItemEnum;
import com.els.modules.demand.service.PurchaseRequestItemService;
import com.els.modules.inquiry.enumerate.QualificationReviewEnum;
import com.els.modules.inquiry.enumerate.SourceTypeEnum;
import com.els.modules.inquiry.qualification.entity.PurchaseQualificationReview;
import com.els.modules.inquiry.qualification.service.PurchaseExecuteReviewService;
import com.els.modules.inquiry.rpc.service.InquiryInvokeMainDataRpcService;
import com.els.modules.inquiry.rpc.service.InquiryInvokeMessageRpcService;
import com.els.modules.material.api.dto.PurchaseMaterialRelationDTO;
import com.els.modules.message.api.dto.PurchaseNoticeSupplierDTO;
import com.els.modules.notice.api.dto.PurchaseNoticeDTO;
import com.els.modules.notice.api.enumerate.NoticeScopeEnum;
import com.els.rpc.service.InvokeAccountRpcService;
import com.els.rpc.service.InvokeBaseRpcService;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service
public class PurchaseBiddingHeadServiceImpl
extends BaseServiceImpl<PurchaseBiddingHeadMapper, PurchaseBiddingHead>
implements PurchaseBiddingHeadService,
PurchaseExecuteReviewService {
    @Resource
    private PurchaseBiddingHeadMapper purchaseBiddingHeadMapper;
    @Resource
    private PurchaseBiddingItemMapper purchaseBiddingItemMapper;
    @Resource
    private BiddingSupplierMapper biddingSupplierMapper;
    @Resource
    private PurchaseBiddingSpecialistMapper purchaseBiddingSpecialistMapper;
    @Resource
    private SaleBiddingHeadMapper saleBiddingHeadMapper;
    @Resource
    private SaleBiddingItemMapper saleBiddingItemMapper;
    @Autowired
    private PurchaseRequestItemService purchaseRequestItemService;
    @Resource
    private InvokeBaseRpcService invokeBaseRpcService;
    @Resource
    private InvokeAccountRpcService invokeAccountRpcService;
    @Resource
    private InquiryInvokeMessageRpcService inquiryInvokeMessageRpcService;
    @Resource
    private InquiryInvokeMainDataRpcService inquiryInvokeMainDataRpcService;

    @Override
    @SrmTransaction
    public void saveMain(PurchaseBiddingHead purchaseBiddingHead, List<PurchaseBiddingItem> purchaseBiddingItemList, List<BiddingSupplier> biddingSupplierList, List<PurchaseBiddingSpecialist> purchaseBiddingSpecialistList, List<PurchaseAttachmentDemandDTO> purchaseAttachmentDemandList, List<PurchaseAttachmentDTO> purchaseAttachmentList) {
        purchaseBiddingHead.setBusAccount(TenantContext.getTenant());
        purchaseBiddingHead.setBiddingStatus(BiddingStatusEnum.NEW.getValue());
        purchaseBiddingHead.setCurrentRound(1);
        this.purchaseBiddingHeadMapper.insert((Object)purchaseBiddingHead);
        this.insertData(purchaseBiddingHead, purchaseBiddingItemList, biddingSupplierList, purchaseBiddingSpecialistList, purchaseAttachmentDemandList, purchaseAttachmentList);
        this.goBackDemand(purchaseBiddingItemList, PurchaseRequestStatusItemEnum.TENDERS_BUILT.getValue());
    }

    private void goBackDemand(List<PurchaseBiddingItem> purchaseBiddingItemList, String status) {
        List<String> idList = purchaseBiddingItemList.stream().filter(o -> SourceTypeEnum.REQUEST.getValue().equals(o.getSourceType())).filter(o -> StrUtil.isNotBlank((CharSequence)o.getId())).map(PurchaseBiddingItem::getSourceItemId).collect(Collectors.toList());
        if (!idList.isEmpty()) {
            this.purchaseRequestItemService.updateStatusById(idList, status);
        }
    }

    @Override
    @SrmTransaction
    public void updateMain(PurchaseBiddingHead purchaseBiddingHead, List<PurchaseBiddingItem> purchaseBiddingItemList, List<BiddingSupplier> biddingSupplierList, List<PurchaseBiddingSpecialist> purchaseBiddingSpecialistList, List<PurchaseAttachmentDemandDTO> purchaseAttachmentDemandList, List<PurchaseAttachmentDTO> purchaseAttachmentList) {
        this.purchaseBiddingHeadMapper.updateById((Object)purchaseBiddingHead);
        this.purchaseBiddingItemMapper.deleteByMainId(purchaseBiddingHead.getId());
        this.biddingSupplierMapper.deleteByMainId(purchaseBiddingHead.getId());
        this.purchaseBiddingSpecialistMapper.deleteByMainId(purchaseBiddingHead.getId());
        this.invokeBaseRpcService.deletePurchaseAttachmentDemandByMainId(purchaseBiddingHead.getId());
        this.invokeBaseRpcService.deletePurchaseAttachmentByMainId(purchaseBiddingHead.getId());
        this.insertData(purchaseBiddingHead, purchaseBiddingItemList, biddingSupplierList, purchaseBiddingSpecialistList, purchaseAttachmentDemandList, purchaseAttachmentList);
    }

    private void insertData(PurchaseBiddingHead purchaseBiddingHead, List<PurchaseBiddingItem> purchaseBiddingItemList, List<BiddingSupplier> biddingSupplierList, List<PurchaseBiddingSpecialist> purchaseBiddingSpecialistList, List<PurchaseAttachmentDemandDTO> purchaseAttachmentDemandList, List<PurchaseAttachmentDTO> purchaseAttachmentList) {
        int itemNumber = 1;
        for (PurchaseBiddingItem purchaseBiddingItem : purchaseBiddingItemList) {
            purchaseBiddingItem.setId(null);
            purchaseBiddingItem.setHeadId(purchaseBiddingHead.getId());
            purchaseBiddingItem.setBiddingNumber(purchaseBiddingHead.getBiddingNumber());
            purchaseBiddingItem.setAuditStatus(AuditStatusEnum.AUDIT_NEW.getValue());
            purchaseBiddingItem.setItemNumber(itemNumber + "");
            purchaseBiddingItem.setCurrentRound(1);
            ++itemNumber;
            SysUtil.setSysParam((BaseEntity)purchaseBiddingItem, (BaseEntity)purchaseBiddingHead);
        }
        if (!purchaseBiddingItemList.isEmpty()) {
            this.purchaseBiddingItemMapper.insertBatchSomeColumn(purchaseBiddingItemList);
        }
        itemNumber = 1;
        for (BiddingSupplier biddingSupplier : biddingSupplierList) {
            biddingSupplier.setId(null);
            biddingSupplier.setHeadId(purchaseBiddingHead.getId());
            biddingSupplier.setBiddingNumber(purchaseBiddingHead.getBiddingNumber());
            biddingSupplier.setItemNumber(itemNumber + "");
            biddingSupplier.setCurrentRound(1);
            ++itemNumber;
            SysUtil.setSysParam((BaseEntity)biddingSupplier, (BaseEntity)purchaseBiddingHead);
        }
        if (!biddingSupplierList.isEmpty()) {
            this.biddingSupplierMapper.insertBatchSomeColumn(biddingSupplierList);
        }
        for (PurchaseBiddingSpecialist purchaseBiddingSpecialist : purchaseBiddingSpecialistList) {
            purchaseBiddingSpecialist.setId(null);
            purchaseBiddingSpecialist.setHeadId(purchaseBiddingHead.getId());
            purchaseBiddingSpecialist.setElsAccount(TenantContext.getTenant());
            SysUtil.setSysParam((BaseEntity)purchaseBiddingSpecialist, (BaseEntity)purchaseBiddingHead);
        }
        if (!purchaseBiddingSpecialistList.isEmpty()) {
            this.purchaseBiddingSpecialistMapper.insertBatchSomeColumn(purchaseBiddingSpecialistList);
        }
        for (PurchaseAttachmentDemandDTO purchaseAttachmentDemandDTO : purchaseAttachmentDemandList) {
            purchaseAttachmentDemandDTO.setHeadId(purchaseBiddingHead.getId());
            purchaseAttachmentDemandDTO.setBusinessType("bidding");
            purchaseAttachmentDemandDTO.setElsAccount(purchaseBiddingHead.getElsAccount());
            purchaseAttachmentDemandDTO.setCreateBy(purchaseBiddingHead.getCreateBy());
            purchaseAttachmentDemandDTO.setUpdateBy(purchaseBiddingHead.getUpdateBy());
            purchaseAttachmentDemandDTO.setCreateTime(purchaseBiddingHead.getCreateTime());
            purchaseAttachmentDemandDTO.setUpdateTime(purchaseBiddingHead.getUpdateTime());
        }
        if (!purchaseAttachmentDemandList.isEmpty()) {
            this.invokeBaseRpcService.insertPurchaseAttachmentDemandBatchSomeColumn(purchaseAttachmentDemandList);
        }
        for (PurchaseAttachmentDTO purchaseAttachmentDTO : purchaseAttachmentList) {
            purchaseAttachmentDTO.setHeadId(purchaseBiddingHead.getId());
            purchaseAttachmentDTO.setBusinessType("bidding");
            purchaseAttachmentDTO.setElsAccount(purchaseBiddingHead.getElsAccount());
            purchaseAttachmentDTO.setCreateBy(purchaseBiddingHead.getCreateBy());
            purchaseAttachmentDTO.setUpdateBy(purchaseBiddingHead.getUpdateBy());
            purchaseAttachmentDTO.setCreateTime(purchaseBiddingHead.getCreateTime());
            purchaseAttachmentDTO.setUpdateTime(purchaseBiddingHead.getUpdateTime());
        }
        if (!purchaseAttachmentList.isEmpty()) {
            this.invokeBaseRpcService.insertPurchaseAttachmentBatchSomeColumn(purchaseAttachmentList);
        }
    }

    @Override
    @SrmTransaction
    public void delMain(String id) {
        List<PurchaseBiddingItem> itemList = this.purchaseBiddingItemMapper.selectByMainId(id);
        this.goBackDemand(itemList, PurchaseRequestStatusItemEnum.DEMAND_POOL.getValue());
        this.purchaseBiddingItemMapper.deleteByMainId(id);
        this.biddingSupplierMapper.deleteByMainId(id);
        this.purchaseBiddingSpecialistMapper.deleteByMainId(id);
        this.invokeBaseRpcService.deletePurchaseAttachmentDemandByMainId(id);
        this.invokeBaseRpcService.deletePurchaseAttachmentByMainId(id);
        this.purchaseBiddingHeadMapper.deleteById((Serializable)((Object)id));
    }

    @Override
    @SrmTransaction
    public void delBatchMain(List<String> idList) {
        for (Serializable serializable : idList) {
            this.purchaseBiddingItemMapper.deleteByMainId(serializable.toString());
            this.biddingSupplierMapper.deleteByMainId(serializable.toString());
            this.purchaseBiddingSpecialistMapper.deleteByMainId(serializable.toString());
            this.invokeBaseRpcService.deletePurchaseAttachmentDemandByMainId(serializable.toString());
            this.invokeBaseRpcService.deletePurchaseAttachmentByMainId(serializable.toString());
            this.purchaseBiddingHeadMapper.deleteById(serializable);
        }
    }

    public static void checkAndSetParam(PurchaseBiddingHeadVO head) {
        LoginUser loginUser = SysUtil.getLoginUser();
        head.setBiddingStatus(BiddingStatusEnum.BIDDING.getValue());
        head.setPublishTime(new Date());
        head.setPublishUser(loginUser.getSubAccount());
        head.setCurrentRound(1);
        head.setResultAuditStatus(AuditStatusEnum.AUDIT_NEW.getValue());
        head.setAuditStatus(AuditStatusEnum.AUDIT_NEW.getValue());
        String needEcho = head.getNeedEcho();
        Date echoEndTime = head.getEchoEndTime();
        Date applyEndTime = head.getApplyEndTime();
        String biddingType = head.getBiddingType();
        Assert.hasText((String)biddingType, (String)I18nUtil.translate((String)"i18n_alert_empty_bid_type_not_empty_bidding", (String)"\u62db\u6807\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\uff01"));
        if (BiddingTypeEnum.PUBLIC.getValue().equals(biddingType)) {
            Assert.notNull((Object)applyEndTime, (String)I18nUtil.translate((String)"i18n_alert_empty_registration_time_not_empty", (String)"\u62a5\u540d\u622a\u6b62\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a\uff01"));
        }
        if (!"1".equals(head.getPublishAudit())) {
            head.setAuditStatus(AuditStatusEnum.NO_AUDIT_REQUIRED.getValue());
        }
        if (!"1".equals(head.getResultAudit())) {
            head.setResultAuditStatus(AuditStatusEnum.NO_AUDIT_REQUIRED.getValue());
        }
        Date buyBidDocBeginTime = head.getBuyBidDocBeginTime();
        Date buyBidDocEndTime = head.getBuyBidDocEndTime();
        Assert.notNull((Object)buyBidDocBeginTime, (String)I18nUtil.translate((String)"i18n_alert_empty_tender_buy_time_not_empty_bidding", (String)"\u6807\u4e66\u8d2d\u4e70\u5f00\u59cb\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a\uff01"));
        Assert.notNull((Object)buyBidDocEndTime, (String)I18nUtil.translate((String)"i18n_alert_empty_tender_buy_cut_off_time_not_empty_bidding", (String)"\u6807\u4e66\u8d2d\u4e70\u622a\u6b62\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a\uff01"));
        Assert.isTrue((boolean)buyBidDocEndTime.after(buyBidDocBeginTime), (String)I18nUtil.translate((String)"i18n_alert_fail_tender_buy_time_gt_cut_off_time_bidding", (String)"\u6807\u4e66\u8d2d\u4e70\u5f00\u59cb\u65f6\u95f4\u4e0d\u80fd\u5927\u4e8e\u6807\u4e66\u8d2d\u4e70\u622a\u6b62\u65f6\u95f4\uff01"));
        if ("1".equals(needEcho)) {
            Assert.notNull((Object)echoEndTime, (String)I18nUtil.translate((String)"i18n_alert_empty_should_be_marked_not_empty_bidding", (String)"\u5e94\u6807\u622a\u6b62\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a\uff01"));
        }
        Date bidBeginTime = head.getBidBeginTime();
        Date bidEndTime = head.getBidEndTime();
        Assert.notNull((Object)bidBeginTime, (String)I18nUtil.translate((String)"i18n_alert_empty_tender_start_time_not_empty_bidding", (String)"\u6295\u6807\u5f00\u59cb\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a\uff01"));
        Assert.notNull((Object)bidEndTime, (String)I18nUtil.translate((String)"i18n_alert_empty_tender_cut_off_time_not_empty_bidding", (String)"\u6295\u6807\u622a\u6b62\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a\uff01"));
        Assert.isTrue((boolean)bidEndTime.after(bidBeginTime), (String)I18nUtil.translate((String)"i18n_alert_fail_tender_start_time_gt_end_time_bidding", (String)"\u6295\u6807\u5f00\u59cb\u65f6\u95f4\u4e0d\u80fd\u5927\u4e8e\u6295\u6807\u622a\u6b62\u65f6\u95f4\uff01"));
        Date planOpenBidTime = head.getPlanOpenBidTime();
        Assert.notNull((Object)planOpenBidTime, (String)I18nUtil.translate((String)"i18n_alert_empty_bid_open_time_not_empty_bidding", (String)"\u8ba1\u5212\u5f00\u6807\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a\uff01"));
        Assert.isTrue((boolean)planOpenBidTime.after(bidEndTime), (String)I18nUtil.translate((String)"i18n_alert_fail_tender_cut_off_time_gt_open_time_bidding", (String)"\u6295\u6807\u622a\u6b62\u65f6\u95f4\u4e0d\u80fd\u5927\u4e8e\u8ba1\u5212\u5f00\u6807\u65f6\u95f4\uff01"));
        Date evaEndTime = head.getEvaEndTime();
        Assert.notNull((Object)evaEndTime, (String)I18nUtil.translate((String)"i18n_alert_empty_evaluation_of_bids_cut_off_time_bidding", (String)"\u8bc4\u6807\u622a\u6b62\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a\uff01"));
        Assert.isTrue((boolean)evaEndTime.after(planOpenBidTime), (String)I18nUtil.translate((String)"i18n_alert_fail_bid_open_time_gt_cut_off_time_bidding", (String)"\u8ba1\u5212\u5f00\u6807\u65f6\u95f4\u4e0d\u80fd\u5927\u4e8e\u8bc4\u6807\u622a\u6b62\u65f6\u95f4\uff01"));
        String purchasePrincipal = head.getPurchasePrincipal();
        Assert.hasText((String)purchasePrincipal, (String)I18nUtil.translate((String)"i18n_alert_empty_principal", (String)"\u8d1f\u8d23\u4eba\u4e0d\u80fd\u4e3a\u7a7a\uff01"));
        Assert.notEmpty(head.getPurchaseBiddingItemList(), (String)I18nUtil.translate((String)"i18n_alert_oper_must_create_one_row", (String)"\u81f3\u5c11\u6dfb\u52a0\u4e00\u4e2a\u884c\u9879\u76ee\uff01"));
        Integer participateQuantity = head.getParticipateQuantity();
        Assert.isTrue((participateQuantity != null && participateQuantity > 0 ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_alert_fail_parameter_num_must_gt_zero", (String)"\u53c2\u4e0e\u6570\u91cf\u5fc5\u987b\u5927\u4e8e0\uff01"));
        if (BiddingTypeEnum.INVITE.getValue().equals(biddingType)) {
            head.setInviteQuantity(head.getBiddingSupplierList().size());
            Assert.isTrue((head.getInviteQuantity() >= participateQuantity ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_alert_fail_supplier_num_must_gt_parameter_num_bidding", (String)"\u9080\u8bf7\u62db\u6807\u65f6\uff0c\u9009\u62e9\u4f9b\u5e94\u5546\u6570\u91cf\u5fc5\u987b\u5927\u4e8e\u7b49\u4e8e\u53c2\u4e0e\u6570\u91cf\uff01"));
        }
    }

    private void saveBiddingSpecialist(PurchaseBiddingHead head, List<PurchaseBiddingSpecialist> purchaseBiddingSpecialistList) {
        for (PurchaseBiddingSpecialist entity : purchaseBiddingSpecialistList) {
            entity.setId(null);
            entity.setHeadId(head.getId());
            entity.setElsAccount(TenantContext.getTenant());
            entity.setMemberType(MemberTypeEnum.EVA_BID.getValue());
            SysUtil.setSysParam((BaseEntity)entity, (BaseEntity)head);
        }
        String purchasePrincipal = head.getPurchasePrincipal();
        String[] array = purchasePrincipal.split("_");
        PurchaseBiddingSpecialist specialist = new PurchaseBiddingSpecialist();
        specialist.setHeadId(head.getId());
        specialist.setElsAccount(TenantContext.getTenant());
        specialist.setMemberType(MemberTypeEnum.PROJECT.getValue());
        SysUtil.setSysParam((BaseEntity)specialist, (BaseEntity)head);
        specialist.setMemberRole(MemberRoleEnum.BID_PRINCIPAL.getValue());
        specialist.setSubAccount(array[0]);
        if (array.length > 1) {
            specialist.setName(array[1]);
        }
        specialist.setMobileTelephone(head.getContactNumber());
        purchaseBiddingSpecialistList.add(specialist);
        this.purchaseBiddingSpecialistMapper.insertBatchSomeColumn(purchaseBiddingSpecialistList);
    }

    private void saveBiddingSupplier(PurchaseBiddingHead head, List<BiddingSupplier> biddingSupplierList) {
        BigDecimal bidingDocCost = head.getBidingDocCost();
        String bidCheck = "0";
        if (bidingDocCost == null || bidingDocCost.compareTo(BigDecimal.ZERO) == 0) {
            bidCheck = "1";
        }
        BigDecimal securityCost = head.getSecurityCost();
        String bidQuote = "0";
        if (securityCost == null || securityCost.compareTo(BigDecimal.ZERO) == 0) {
            bidQuote = "1";
        }
        String needEcho = head.getNeedEcho();
        String replyStatus = ReplyStatusEnum.NOT_NEED.getValue();
        if ("1".equals(needEcho)) {
            replyStatus = ReplyStatusEnum.WAIT_REPLY.getValue();
        }
        int itemNumber = 1;
        for (BiddingSupplier entity : biddingSupplierList) {
            entity.setId(null);
            entity.setHeadId(head.getId());
            entity.setBiddingNumber(head.getBiddingNumber());
            entity.setItemNumber(itemNumber + "");
            entity.setSourceType(StrUtil.isBlank((CharSequence)entity.getSourceType()) ? SupplierSourceTypeEnum.INVITE.getValue() : entity.getSourceType());
            entity.setReplyStatus(StrUtil.isBlank((CharSequence)entity.getReplyStatus()) ? replyStatus : entity.getReplyStatus());
            entity.setQuaCheckResult("1");
            entity.setBidCheck(bidCheck);
            entity.setBidQuote(bidQuote);
            entity.setCurrentRound(head.getCurrentRound());
            ++itemNumber;
            SysUtil.setSysParam((BaseEntity)entity, (BaseEntity)head);
        }
        if (!biddingSupplierList.isEmpty()) {
            this.biddingSupplierMapper.insertBatchSomeColumn(biddingSupplierList);
        }
    }

    private void savePurchaseAttachmentDemand(PurchaseBiddingHead head, List<PurchaseAttachmentDemandDTO> purchaseAttachmentDemandList) {
        int itemNumber = 1;
        for (PurchaseAttachmentDemandDTO entity : purchaseAttachmentDemandList) {
            entity.setHeadId(head.getId());
            entity.setItemNumber(itemNumber + "");
            ++itemNumber;
            entity.setBusinessType("bidding");
            entity.setElsAccount(head.getElsAccount());
            entity.setCreateBy(head.getCreateBy());
            entity.setUpdateBy(head.getUpdateBy());
            entity.setCreateTime(head.getCreateTime());
            entity.setUpdateTime(head.getUpdateTime());
        }
        if (!purchaseAttachmentDemandList.isEmpty()) {
            this.invokeBaseRpcService.insertPurchaseAttachmentDemandBatchSomeColumn(purchaseAttachmentDemandList);
        }
    }

    private void savePurchaseBiddingItem(PurchaseBiddingHead head, List<PurchaseBiddingItem> purchaseBiddingItemList) {
        int itemNumber = 1;
        for (PurchaseBiddingItem entity : purchaseBiddingItemList) {
            entity.setId(null);
            entity.setHeadId(head.getId());
            entity.setBiddingNumber(head.getBiddingNumber());
            entity.setAuditStatus(AuditStatusEnum.AUDIT_NEW.getValue());
            entity.setItemNumber(itemNumber + "");
            entity.setCurrentRound(head.getCurrentRound());
            ++itemNumber;
            SysUtil.setSysParam((BaseEntity)entity, (BaseEntity)head);
        }
        if (!purchaseBiddingItemList.isEmpty()) {
            this.purchaseBiddingItemMapper.insertBatchSomeColumn(purchaseBiddingItemList);
        }
    }

    private void insertInitTable(String headId, List<PurchaseBiddingItem> itemList) {
        ElsInitialTableDTO elsInitialTable = new ElsInitialTableDTO();
        elsInitialTable.setRelationId(headId);
        elsInitialTable.setBusinessInfoJson(JSON.toJSONString(itemList));
        this.invokeBaseRpcService.addElsInitialTable(elsInitialTable);
    }

    private void sendMsg(PurchaseBiddingHead head, List<String> toElsAccountList, String operateType, Map<String, JSONObject> receiveParamMap) {
        try {
            super.sendMsg(head.getElsAccount(), toElsAccountList, (Object)head, receiveParamMap, "bidding", operateType);
        }
        catch (Exception e) {
            this.log.error("sendMsg failed:", (Throwable)e);
        }
    }

    private AttachmentSendDTO publishBidding(PurchaseBiddingHead purchaseBiddingHead, List<PurchaseBiddingItem> purchaseBiddingItemList, List<BiddingSupplier> biddingSupplierList, List<PurchaseAttachmentDemandDTO> purchaseAttachmentDemandList) {
        LoginUser loginUser = SysUtil.getLoginUser();
        this.saveBiddingSupplier(purchaseBiddingHead, biddingSupplierList);
        ArrayList<SaleBiddingHead> insertSalebBiddingHeadList = new ArrayList<SaleBiddingHead>();
        ArrayList<PurchaseBiddingItem> insertPurchaseBiddingItemList = new ArrayList<PurchaseBiddingItem>();
        ArrayList<SaleBiddingItem> insertSaleBiddingItemList = new ArrayList<SaleBiddingItem>();
        ArrayList<SaleAttachmentDemandDTO> insertSaleAttachmentDemandList = new ArrayList<SaleAttachmentDemandDTO>();
        HashMap<String, String> toSend = new HashMap<String, String>();
        HashMap<String, JSONObject> receiveParamMap = new HashMap<String, JSONObject>();
        List<String> toElsAccountList = biddingSupplierList.stream().map(BiddingSupplier::getToElsAccount).collect(Collectors.toList());
        List<String> materialNumberList = purchaseBiddingItemList.stream().filter(o -> StrUtil.isNotBlank((CharSequence)o.getMaterialNumber())).map(PurchaseBiddingItem::getMaterialNumber).collect(Collectors.toList());
        Map<String, PurchaseMaterialRelationDTO> relationMap = this.inquiryInvokeMainDataRpcService.findByMaterialAndAccount(materialNumberList, toElsAccountList);
        for (BiddingSupplier supplier : biddingSupplierList) {
            SaleBiddingHead saleBiddingHead = new SaleBiddingHead();
            BeanUtil.copyProperties((Object)((Object)purchaseBiddingHead), (Object)((Object)saleBiddingHead), (String[])new String[0]);
            saleBiddingHead.setElsAccount(supplier.getToElsAccount());
            saleBiddingHead.setToElsAccount(purchaseBiddingHead.getElsAccount());
            saleBiddingHead.setId(IdWorker.getIdStr());
            saleBiddingHead.setRelationId(purchaseBiddingHead.getId());
            saleBiddingHead.setSupplierListId(supplier.getId());
            saleBiddingHead.setPurchaseName(loginUser.getEnterpriseName());
            insertSalebBiddingHeadList.add(saleBiddingHead);
            toSend.put(saleBiddingHead.getId(), supplier.getToElsAccount());
            JSONObject urlParam = new JSONObject();
            urlParam.put("id", (Object)saleBiddingHead.getId());
            urlParam.put("templateNumber", (Object)saleBiddingHead.getTemplateNumber());
            urlParam.put("templateVersion", (Object)saleBiddingHead.getTemplateVersion());
            urlParam.put("busAccount", (Object)saleBiddingHead.getBusAccount());
            receiveParamMap.put(supplier.getToElsAccount(), urlParam);
            int itemNumber = 1;
            for (PurchaseBiddingItem item : purchaseBiddingItemList) {
                PurchaseMaterialRelationDTO relation;
                PurchaseBiddingItem purchaseBiddingItem = new PurchaseBiddingItem();
                BeanUtil.copyProperties((Object)((Object)item), (Object)((Object)purchaseBiddingItem), (String[])new String[0]);
                SysUtil.setSysParam((BaseEntity)purchaseBiddingItem, (BaseEntity)purchaseBiddingHead);
                purchaseBiddingItem.setId(IdWorker.getIdStr());
                purchaseBiddingItem.setHeadId(purchaseBiddingHead.getId());
                purchaseBiddingItem.setRelationId(IdWorker.getIdStr());
                purchaseBiddingItem.setBiddingNumber(purchaseBiddingHead.getBiddingNumber());
                purchaseBiddingItem.setReplyStatus(ReplyStatusEnum.REPLYED.getValue());
                purchaseBiddingItem.setCurrentRound(purchaseBiddingHead.getCurrentRound());
                purchaseBiddingItem.setItemNumber(itemNumber + "");
                ++itemNumber;
                purchaseBiddingItem.setElsAccount(purchaseBiddingHead.getElsAccount());
                purchaseBiddingItem.setToElsAccount(supplier.getToElsAccount());
                purchaseBiddingItem.setSupplierCode(supplier.getSupplierCode());
                purchaseBiddingItem.setSupplierName(supplier.getSupplierName());
                if (StrUtil.isNotBlank((CharSequence)item.getMaterialNumber()) && (relation = relationMap.get(item.getMaterialNumber() + supplier.getToElsAccount())) != null) {
                    purchaseBiddingItem.setSaleMaterialNumber(relation.getSaleMaterialNumber());
                }
                insertPurchaseBiddingItemList.add(purchaseBiddingItem);
                SaleBiddingItem saleBiddingItem = new SaleBiddingItem();
                BeanUtil.copyProperties((Object)((Object)purchaseBiddingItem), (Object)((Object)saleBiddingItem), (String[])new String[0]);
                saleBiddingItem.setId(purchaseBiddingItem.getRelationId());
                saleBiddingItem.setRelationId(purchaseBiddingItem.getId());
                saleBiddingItem.setHeadId(saleBiddingHead.getId());
                saleBiddingItem.setElsAccount(purchaseBiddingItem.getToElsAccount());
                saleBiddingItem.setToElsAccount(purchaseBiddingItem.getElsAccount());
                insertSaleBiddingItemList.add(saleBiddingItem);
            }
            for (PurchaseAttachmentDemandDTO demand : purchaseAttachmentDemandList) {
                SaleAttachmentDemandDTO saleAttachmentDemand = new SaleAttachmentDemandDTO();
                BeanUtil.copyProperties((Object)demand, (Object)saleAttachmentDemand, (String[])new String[0]);
                saleAttachmentDemand.setId(IdWorker.getIdStr());
                saleAttachmentDemand.setElsAccount(supplier.getToElsAccount());
                saleAttachmentDemand.setHeadId(saleBiddingHead.getId());
                insertSaleAttachmentDemandList.add(saleAttachmentDemand);
            }
        }
        AttachmentSendDTO sendVO = new AttachmentSendDTO();
        sendVO.setElsAccount(purchaseBiddingHead.getElsAccount());
        sendVO.setHeadId(purchaseBiddingHead.getId());
        sendVO.setToSend(toSend);
        if (biddingSupplierList.isEmpty()) {
            this.savePurchaseBiddingItem(purchaseBiddingHead, purchaseBiddingItemList);
        } else {
            this.saleBiddingHeadMapper.insertBatchSomeColumn(insertSalebBiddingHeadList);
            this.saleBiddingItemMapper.insertBatchSomeColumn(insertSaleBiddingItemList);
            if (!insertSaleAttachmentDemandList.isEmpty()) {
                this.invokeBaseRpcService.insertSaleAttachmentDemandBatchSomeColumn(insertSaleAttachmentDemandList);
            }
            this.purchaseBiddingItemMapper.insertBatchSomeColumn(insertPurchaseBiddingItemList);
            this.invokeBaseRpcService.sendPurchaseFile(sendVO, true);
            this.sendMsg(purchaseBiddingHead, toElsAccountList, "publish", receiveParamMap);
        }
        return sendVO;
    }

    private void publishNotice(PurchaseBiddingHead head, List<BiddingSupplier> biddingSupplierList) {
        LoginUser loginUser = SysUtil.getLoginUser();
        String purchaseName = StrUtil.isBlank((CharSequence)loginUser.getEnterpriseName()) ? "" : loginUser.getEnterpriseName();
        String projectName = StrUtil.isBlank((CharSequence)head.getProjectName()) ? "" : head.getProjectName();
        String biddingType = head.getBiddingType();
        PurchaseNoticeDTO notice = new PurchaseNoticeDTO();
        notice.setBusAccount(head.getBusAccount());
        notice.setNoticeTitle(purchaseName + projectName + "\u62db\u6807\u516c\u544a");
        notice.setNoticeContent("\u62db\u6807\u5185\u5bb9\u89c1\u8be6\u7ec6");
        notice.setNoticeType("2");
        notice.setTop("1");
        notice.setEffectiveTime(new Date());
        notice.setBusinessId(head.getId());
        notice.setBusinessType(com.els.modules.inquiry.qualification.enumerate.SourceTypeEnum.BIDDING.getValue());
        notice.setTemplateNumber(head.getTemplateNumber());
        notice.setTemplateVersion(head.getTemplateVersion());
        notice.setTemplateAccount(head.getTemplateAccount());
        if ("1".equals(head.getNeedEcho())) {
            notice.setExpiryTime(head.getEchoEndTime());
        } else {
            notice.setExpiryTime(head.getBidBeginTime());
        }
        if (BiddingTypeEnum.INVITE.getValue().equals(biddingType)) {
            notice.setNoticeScope(NoticeScopeEnum.ASSIGN_SUPPLIER.getValue());
            ArrayList<PurchaseNoticeSupplierDTO> purchaseNoticeSupplierList = new ArrayList<PurchaseNoticeSupplierDTO>();
            for (BiddingSupplier supplier : biddingSupplierList) {
                PurchaseNoticeSupplierDTO noticeSupplier = new PurchaseNoticeSupplierDTO();
                BeanUtils.copyProperties((Object)((Object)supplier), (Object)noticeSupplier);
                noticeSupplier.setId(null);
                purchaseNoticeSupplierList.add(noticeSupplier);
            }
            this.inquiryInvokeMessageRpcService.publish(notice, purchaseNoticeSupplierList, new ArrayList<PurchaseAttachmentDTO>());
        } else {
            notice.setNoticeScope(NoticeScopeEnum.IN_STATION_OPEN.getValue());
            PurchaseNoticeDTO notice1 = new PurchaseNoticeDTO();
            BeanUtils.copyProperties((Object)notice, (Object)notice1);
            notice1.setNoticeContent("\u6ce8\u518c\u540e\u5373\u53ef\u4e8e\u7cfb\u7edf\u5185\u516c\u544a\u5904\u53c2\u4e0e\u62a5\u540d");
            notice1.setNoticeScope(NoticeScopeEnum.OPEN.getValue());
            this.inquiryInvokeMessageRpcService.publish(notice, new ArrayList<PurchaseNoticeSupplierDTO>(), new ArrayList<PurchaseAttachmentDTO>());
            this.inquiryInvokeMessageRpcService.publish(notice1, new ArrayList<PurchaseNoticeSupplierDTO>(), new ArrayList<PurchaseAttachmentDTO>());
        }
    }

    @Override
    @SrmTransaction
    public void publish(PurchaseBiddingHead purchaseBiddingHead, List<PurchaseBiddingItem> purchaseBiddingItemList, List<BiddingSupplier> biddingSupplierList, List<PurchaseBiddingSpecialist> purchaseBiddingSpecialistList, List<PurchaseAttachmentDemandDTO> purchaseAttachmentDemandList, List<PurchaseAttachmentDTO> purchaseAttachmentList) {
        PurchaseBiddingHeadVO headVO = new PurchaseBiddingHeadVO();
        BeanUtil.copyProperties((Object)((Object)purchaseBiddingHead), (Object)((Object)headVO), (String[])new String[0]);
        headVO.setPurchaseBiddingItemList(purchaseBiddingItemList);
        headVO.setBiddingSupplierList(biddingSupplierList);
        PurchaseBiddingHeadServiceImpl.checkAndSetParam(headVO);
        BeanUtil.copyProperties((Object)((Object)headVO), (Object)((Object)purchaseBiddingHead), (String[])new String[0]);
        if ("1".equals(purchaseBiddingHead.getPublishAudit())) {
            Assert.isTrue((boolean)AuditStatusEnum.AUDIT_FINISH.getValue().equals(purchaseBiddingHead.getAuditStatus()), (String)I18nUtil.translate((String)"i18n_alert_fail_publish_no_approved", (String)"\u5ba1\u6279\u901a\u8fc7\u540e\u624d\u53ef\u53d1\u5e03"));
        }
        if (StrUtil.isBlank((CharSequence)purchaseBiddingHead.getId())) {
            this.purchaseBiddingHeadMapper.insert((Object)purchaseBiddingHead);
        } else {
            this.purchaseBiddingHeadMapper.updateById((Object)purchaseBiddingHead);
            this.purchaseBiddingItemMapper.deleteByMainId(purchaseBiddingHead.getId());
            this.biddingSupplierMapper.deleteByMainId(purchaseBiddingHead.getId());
            this.purchaseBiddingSpecialistMapper.deleteByMainId(purchaseBiddingHead.getId());
            this.invokeBaseRpcService.deletePurchaseAttachmentDemandByMainId(purchaseBiddingHead.getId());
        }
        this.insertInitTable(purchaseBiddingHead.getId(), purchaseBiddingItemList);
        this.saveBiddingSpecialist(purchaseBiddingHead, purchaseBiddingSpecialistList);
        this.savePurchaseAttachmentDemand(purchaseBiddingHead, purchaseAttachmentDemandList);
        this.publishBidding(purchaseBiddingHead, purchaseBiddingItemList, biddingSupplierList, purchaseAttachmentDemandList);
        this.publishNotice(purchaseBiddingHead, biddingSupplierList);
        this.createOpenBidAlertJob(purchaseBiddingHead);
        if ("1".equals(purchaseBiddingHead.getNeedEcho())) {
            BiddingJobUtil.createFailureBidByReplyJob(purchaseBiddingHead, purchaseBiddingHead.getEchoEndTime());
        }
        BiddingJobUtil.createFailureBidByQuoteJob(purchaseBiddingHead, purchaseBiddingHead.getBidEndTime());
    }

    private void createOpenBidAlertJob(PurchaseBiddingHead head) {
        Date planOpenBidTime = head.getPlanOpenBidTime();
        int openBidAlertMinute = 5;
        if (head.getOpenBidAlertMinute() != null) {
            openBidAlertMinute = head.getOpenBidAlertMinute();
        }
        DateTime alertTime = DateUtil.offsetMinute((Date)planOpenBidTime, (int)(0 - openBidAlertMinute));
        BiddingJobUtil.createOpenBidAlertJob(head, (Date)alertTime);
    }

    @Override
    @SrmTransaction
    public void openPermission(PurchaseBiddingHead purchaseBiddingHead, List<BiddingSupplier> biddingSupplierList) {
        this.checkPermission(purchaseBiddingHead.getId());
        for (BiddingSupplier supplier : biddingSupplierList) {
            BiddingSupplier updateItem = new BiddingSupplier();
            updateItem.setElsAccount(supplier.getElsAccount());
            updateItem.setId(supplier.getId());
            updateItem.setBidCheck(supplier.getBidCheck());
            updateItem.setBidQuote(supplier.getBidQuote());
            this.biddingSupplierMapper.updateById((Object)updateItem);
        }
    }

    @Override
    public void executeReview(PurchaseQualificationReview review) {
        String headId = review.getRelationId();
        PurchaseBiddingHead dbHead = (PurchaseBiddingHead)((Object)this.getById((Serializable)((Object)headId)));
        Date applyEndTime = "1".equals(dbHead.getNeedEcho()) ? dbHead.getEchoEndTime() : dbHead.getBidBeginTime();
        Assert.isTrue((boolean)applyEndTime.after(new Date()), (String)I18nUtil.translate((String)"i18n_alert_fail_approved_approve_time_time_out_bidding", (String)"\u5ba1\u67e5\u65f6\u95f4\u5df2\u8fc7\uff0c\u4e0d\u53ef\u5ba1\u67e5"));
        if (QualificationReviewEnum.BEFORE_QUOTE.getValue().equals(dbHead.getQualificationReview())) {
            return;
        }
        this.executeReview(dbHead, review);
    }

    @Override
    public void executeReview(PurchaseBiddingHead dbHead, PurchaseQualificationReview review) {
        String headId = dbHead.getId();
        ElsInitialTableDTO initInfo = this.invokeBaseRpcService.selectElsInitialTableOne(headId);
        List initItemList = JSON.parseArray((String)initInfo.getBusinessInfoJson(), PurchaseBiddingItem.class);
        List initAttachmentItemList = this.invokeBaseRpcService.selectPurchaseAttachmentDemandByMainId(headId);
        ArrayList supplierList = Lists.newArrayList();
        BiddingSupplier supplier = new BiddingSupplier();
        supplier.setToElsAccount(review.getToElsAccount());
        supplier.setSupplierCode(review.getSupplierCode());
        supplier.setSupplierName(review.getSupplierName());
        supplier.setSourceType(SupplierSourceTypeEnum.PUBLIC.getValue());
        supplier.setContacts(review.getContacts());
        supplier.setPhone(review.getPhone());
        supplier.setEmail(review.getEmail());
        supplier.setReplyStatus(ReplyStatusEnum.REPLYED.getValue());
        supplier.setReplyTime(review.getCreateTime());
        supplierList.add(supplier);
        List<PurchaseBiddingItem> dbItemList = this.purchaseBiddingItemMapper.selectByMainId(headId);
        if (StrUtil.isBlank((CharSequence)dbItemList.get(0).getToElsAccount())) {
            this.purchaseBiddingItemMapper.deleteByMainId(headId);
        }
        AttachmentSendDTO sendVO = this.publishBidding(dbHead, initItemList, supplierList, initAttachmentItemList);
        PurchaseClarificationInfoService purchaseClarificationInfoService = (PurchaseClarificationInfoService)SpringContextUtils.getBean(PurchaseClarificationInfoServiceImpl.class);
        purchaseClarificationInfoService.addClarificationInfoForSupplier(BusinessBillTypeEnum.CALL_BIDS.getValue(), dbHead.getBiddingNumber(), supplier.getToElsAccount(), supplier.getSupplierName());
        this.invokeBaseRpcService.updateSaleFile(sendVO);
    }

    private void checkPermission(String id) {
        LoginUser user = SysUtil.getLoginUser();
        List specialistList = this.purchaseBiddingSpecialistMapper.selectByMainId(id).stream().filter(o -> MemberTypeEnum.PROJECT.getValue().equals(o.getMemberType())).filter(o -> MemberRoleEnum.BID_PRINCIPAL.getValue().equals(o.getMemberRole())).map(PurchaseBiddingSpecialist::getSubAccount).collect(Collectors.toList());
        if (!specialistList.contains(user.getSubAccount())) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_oper_no_bidding_principal_bidding", (String)"\u53ea\u6709\u62db\u6807\u8d1f\u8d23\u4eba\u53ef\u4ee5\u64cd\u4f5c\uff01"));
        }
    }

    @Override
    @SrmTransaction
    public void openBidding(String id) {
        this.checkPermission(id);
        PurchaseBiddingHead dbHead = (PurchaseBiddingHead)((Object)this.purchaseBiddingHeadMapper.selectById((Serializable)((Object)id)));
        if (dbHead.getPlanOpenBidTime().after(new Date())) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_fail_bid_open_time_not_arrived_bidding", (String)"\u5f00\u6807\u65f6\u95f4\u672a\u5230\uff0c\u6682\u4e0d\u80fd\u5f00\u6807\uff01"));
        }
        PurchaseBiddingHead updateHead = new PurchaseBiddingHead();
        updateHead.setId(id);
        updateHead.setRealityOpenBidTime(new Date());
        updateHead.setBiddingStatus(BiddingStatusEnum.EVA_BIDDING.getValue());
        this.purchaseBiddingHeadMapper.updateById((Object)updateHead);
        List<String> specialistList = this.purchaseBiddingSpecialistMapper.selectByMainId(id).stream().filter(o -> MemberTypeEnum.EVA_BID.getValue().equals(o.getMemberType())).map(PurchaseBiddingSpecialist::getSubAccount).collect(Collectors.toList());
        this.sendOpenBidMsg(dbHead, specialistList, "openBid");
    }

    @Override
    @SrmTransaction
    public void openBidAlert(String id) {
        PurchaseBiddingHead dbHead = (PurchaseBiddingHead)((Object)this.purchaseBiddingHeadMapper.selectById((Serializable)((Object)id)));
        List<String> specialistList = this.purchaseBiddingSpecialistMapper.selectByMainId(id).stream().filter(o -> MemberTypeEnum.PROJECT.getValue().equals(o.getMemberType())).filter(o -> MemberRoleEnum.BID_PRINCIPAL.getValue().equals(o.getMemberRole())).map(PurchaseBiddingSpecialist::getSubAccount).collect(Collectors.toList());
        String elsAccount = dbHead.getElsAccount();
        TenantContext.setTenant((String)elsAccount);
        this.sendOpenBidMsg(dbHead, specialistList, "openBidAlert");
    }

    @Override
    @SrmTransaction
    public void failureBidAlert(String id, String type) {
        List quoteList;
        PurchaseBiddingHead head = (PurchaseBiddingHead)((Object)this.purchaseBiddingHeadMapper.selectById((Serializable)((Object)id)));
        List<BiddingSupplier> biddingSupplierList = this.biddingSupplierMapper.selectByMainId(id);
        if ("1".equals(type)) {
            List replyList;
            if ("1".equals(head.getNeedEcho()) && (replyList = biddingSupplierList.stream().filter(supplier -> ReplyStatusEnum.REPLYED.getValue().equals(supplier.getReplyStatus()) || ReplyStatusEnum.PART_REPLYED.getValue().equals(supplier.getReplyStatus()) || ReplyStatusEnum.QUOTE_BID.getValue().equals(supplier.getReplyStatus())).collect(Collectors.toList())).size() < head.getParticipateQuantity()) {
                head.setBiddingStatus(BiddingStatusEnum.BID_FAILURE.getValue());
                this.purchaseBiddingHeadMapper.updateById((Object)head);
            }
        } else if ("2".equals(type) && (quoteList = biddingSupplierList.stream().filter(supplier -> ReplyStatusEnum.QUOTE_BID.getValue().equals(supplier.getReplyStatus())).collect(Collectors.toList())).size() < head.getParticipateQuantity()) {
            head.setBiddingStatus(BiddingStatusEnum.BID_FAILURE.getValue());
            this.purchaseBiddingHeadMapper.updateById((Object)head);
        }
    }

    private void sendOpenBidMsg(PurchaseBiddingHead dbHead, List<String> specialistList, String optType) {
        List accountList = this.invokeAccountRpcService.getAccountList(dbHead.getElsAccount(), specialistList);
        JSONObject msgObj = new JSONObject();
        msgObj.put("msgKey", (Object)IdWorker.getIdStr());
        msgObj.put("busAccount", (Object)TenantContext.getTenant());
        msgObj.put("businessType", (Object)"bidding");
        msgObj.put("operateType", (Object)"openBid");
        msgObj.put("businessObj", (Object)dbHead);
        msgObj.put("sendObj", (Object)SysUtil.getLoginUser());
        Map<String, List<ElsSubAccountDTO>> accountMap = accountList.stream().collect(Collectors.groupingBy(BaseDTO::getElsAccount));
        JSONArray array = new JSONArray();
        for (String elsAccount : accountMap.keySet()) {
            List<ElsSubAccountDTO> list = accountMap.get(elsAccount);
            JSONObject receiveObj = new JSONObject();
            receiveObj.put("elsAccount", (Object)elsAccount);
            receiveObj.put("urlParam", (Object)"");
            receiveObj.put("toSubAccountList", list);
            array.add((Object)receiveObj);
        }
        msgObj.put("receiveList", (Object)array);
        MqUtil.sendBusMsg((String)msgObj.toJSONString());
    }
}

