/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.forecast.controller;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.els.aspect.DictAspect;
import com.els.common.api.vo.Result;
import com.els.common.aspect.annotation.AutoLog;
import com.els.common.system.base.controller.BaseController;
import com.els.common.system.query.QueryGenerator;
import com.els.modules.forecast.entity.PurchaseForecastHead;
import com.els.modules.forecast.entity.PurchaseForecastMonthItem;
import com.els.modules.forecast.entity.PurchaseForecastWeekItem;
import com.els.modules.forecast.service.PurchaseForecastHeadService;
import com.els.modules.forecast.service.PurchaseForecastMonthItemService;
import com.els.modules.forecast.service.PurchaseForecastWeekItemService;
import com.els.modules.forecast.vo.PurchaseForecastHeadVO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/forecast/purchaseForecastHead"})
@Api(tags={"\u91c7\u8d2d\u9700\u6c42\u9884\u6d4b\u5934"})
public class PurchaseForecastHeadController
extends BaseController<PurchaseForecastHead, PurchaseForecastHeadService> {
    private static final Logger log = LoggerFactory.getLogger(PurchaseForecastHeadController.class);
    @Autowired
    private PurchaseForecastHeadService purchaseForecastHeadService;
    @Autowired
    private PurchaseForecastMonthItemService purchaseForecastMonthItemService;
    @Autowired
    private PurchaseForecastWeekItemService purchaseForecastWeekItemService;
    @Autowired
    private DictAspect dictAspect;

    @ApiOperation(value="\u5206\u9875\u5217\u8868\u67e5\u8be2", notes="\u5206\u9875\u5217\u8868\u67e5\u8be2")
    @GetMapping(value={"/list"})
    public Result<?> queryPageList(PurchaseForecastHead head, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)head), (Map)req.getParameterMap());
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        IPage pageList = this.purchaseForecastHeadService.page((IPage)page, (Wrapper)queryWrapper);
        return Result.ok((Object)pageList);
    }

    @AutoLog(busModule="\u91c7\u8d2d\u9700\u6c42\u9884\u6d4b\u5934", value="\u53d1\u5e03")
    @ApiOperation(value="\u53d1\u5e03", notes="\u53d1\u5e03")
    @PostMapping(value={"/publish"})
    public Result<?> publish(@RequestBody PurchaseForecastHeadVO headVO) {
        PurchaseForecastHead head = new PurchaseForecastHead();
        BeanUtils.copyProperties((Object)((Object)headVO), (Object)((Object)head));
        this.purchaseForecastHeadService.publish(head, headVO.getMonthItemList(), headVO.getWeekItemList());
        return this.commonSuccessResult(3);
    }

    @AutoLog(busModule="\u91c7\u8d2d\u9700\u6c42\u9884\u6d4b\u5934", value="\u4f5c\u5e9f")
    @ApiOperation(value="\u4f5c\u5e9f", notes="\u4f5c\u5e9f")
    @GetMapping(value={"/cancel"})
    public Result<?> cancel(@RequestParam(name="id") String id) {
        this.purchaseForecastHeadService.cancel(id);
        return this.commonSuccessResult(4);
    }

    @ApiOperation(value="\u901a\u8fc7id\u67e5\u8be2", notes="\u901a\u8fc7id\u67e5\u8be2")
    @GetMapping(value={"/queryById"})
    public Result<?> queryById(@RequestParam(name="id") String id) {
        PurchaseForecastHead head = (PurchaseForecastHead)((Object)this.purchaseForecastHeadService.getById((Serializable)((Object)id)));
        PurchaseForecastHeadVO headVO = new PurchaseForecastHeadVO();
        BeanUtils.copyProperties((Object)((Object)head), (Object)((Object)headVO));
        List<PurchaseForecastMonthItem> monthItemList = this.purchaseForecastMonthItemService.selectByMainId(id);
        headVO.setMonthItemList(monthItemList);
        List<PurchaseForecastWeekItem> weekItemList = this.purchaseForecastWeekItemService.selectByMainId(id);
        headVO.setWeekItemList(weekItemList);
        Result result = Result.ok((Object)((Object)headVO));
        this.dictAspect.parseDictText((Object)result);
        JSONObject object = (JSONObject)result.getResult();
        ArrayList monthList = new ArrayList();
        JSONArray purchaseForecastMonthItemList = object.getJSONArray("monthItemList");
        for (Object obj : purchaseForecastMonthItemList) {
            JSONObject monthItem = (JSONObject)obj;
            JSONObject requireMonthJSON = JSONObject.parseObject((String)monthItem.getString("requireMonthJson"));
            monthItem.putAll((Map)requireMonthJSON);
            monthList.addAll(requireMonthJSON.keySet());
        }
        List sortMonthList = monthList.stream().distinct().sorted(Comparator.comparing(String::length).thenComparing(String::compareTo)).collect(Collectors.toList());
        object.put("monthColumn", sortMonthList);
        ArrayList weekList = new ArrayList();
        JSONArray purchaseForecastWeekItemList = object.getJSONArray("weekItemList");
        for (Object obj : purchaseForecastWeekItemList) {
            JSONObject weekItem = (JSONObject)obj;
            JSONObject requireWeekJson = JSONObject.parseObject((String)weekItem.getString("requireWeekJson"));
            weekItem.putAll((Map)requireWeekJson);
            weekList.addAll(requireWeekJson.keySet());
        }
        List sortWeekList = weekList.stream().distinct().sorted(Comparator.comparing(String::length).thenComparing(String::compareTo)).collect(Collectors.toList());
        object.put("weekColumn", sortWeekList);
        return Result.ok((Object)object);
    }
}

