/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.forecast.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.util.SpringContextUtils;
import com.els.common.util.SysUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.base.api.dto.TemplateHeadDTO;
import com.els.modules.forecast.entity.PurchaseForecastHead;
import com.els.modules.forecast.entity.PurchaseForecastMonthItem;
import com.els.modules.forecast.entity.PurchaseForecastWeekItem;
import com.els.modules.forecast.entity.SaleForecastHead;
import com.els.modules.forecast.entity.SaleForecastMonthItem;
import com.els.modules.forecast.entity.SaleForecastWeekItem;
import com.els.modules.forecast.enumerate.ForecastStatusEnum;
import com.els.modules.forecast.enumerate.PublishStatusEnum;
import com.els.modules.forecast.mapper.PurchaseForecastHeadMapper;
import com.els.modules.forecast.service.PurchaseForecastHeadService;
import com.els.modules.forecast.service.PurchaseForecastMonthItemService;
import com.els.modules.forecast.service.PurchaseForecastWeekItemService;
import com.els.modules.forecast.service.SaleForecastHeadService;
import com.els.modules.forecast.service.impl.SaleForecastHeadServiceImpl;
import com.els.rpc.service.InvokeBaseRpcService;
import java.io.Serializable;
import java.time.LocalDate;
import java.time.temporal.WeekFields;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import javax.annotation.Resource;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
public class PurchaseForecastHeadServiceImpl
extends BaseServiceImpl<PurchaseForecastHeadMapper, PurchaseForecastHead>
implements PurchaseForecastHeadService {
    @Resource
    private PurchaseForecastMonthItemService purchaseForecastMonthItemService;
    @Resource
    private PurchaseForecastWeekItemService purchaseForecastWeekItemService;
    @Resource
    private InvokeBaseRpcService invokeBaseRpcService;

    @Override
    public void add(PurchaseForecastHead head, List<PurchaseForecastMonthItem> monthItemList, List<PurchaseForecastWeekItem> weekItemList) {
        List templateList = this.invokeBaseRpcService.getDefaultTemplateByType("requireForecast");
        head.setTemplateNumber(((TemplateHeadDTO)templateList.get(0)).getTemplateNumber());
        head.setTemplateName(((TemplateHeadDTO)templateList.get(0)).getTemplateName());
        head.setTemplateVersion(((TemplateHeadDTO)templateList.get(0)).getTemplateVersion());
        head.setTemplateAccount(((TemplateHeadDTO)templateList.get(0)).getElsAccount());
        head.setElsAccount(TenantContext.getTenant());
        head.setBusAccount(TenantContext.getTenant());
        String forecastNumber = this.invokeBaseRpcService.getNextCode("srmRequireForecastNumber", (Object)head);
        head.setForecastNumber(forecastNumber);
        head.setForecastStatus(ForecastStatusEnum.NEW.getValue());
        head.setPublishStatus(PublishStatusEnum.UNPUBLISHED.getValue());
        super.setHeadDefaultValue((BaseEntity)head);
        ((PurchaseForecastHeadMapper)this.baseMapper).insert((Object)head);
        this.insertData(head, monthItemList, weekItemList);
    }

    private void insertData(PurchaseForecastHead head, List<PurchaseForecastMonthItem> monthItemList, List<PurchaseForecastWeekItem> weekItemList) {
        int itemNumber;
        if (!CollectionUtils.isEmpty(monthItemList)) {
            itemNumber = 1;
            int month = LocalDate.now().getMonthValue();
            for (PurchaseForecastMonthItem monthItem : monthItemList) {
                monthItem.setId(null);
                monthItem.setHeadId(head.getId());
                monthItem.setForecastNumber(head.getForecastNumber());
                monthItem.setItemNumber(String.valueOf(itemNumber++));
                monthItem.setCurrentMonth(month < 10 ? "0" + month : String.valueOf(month));
                SysUtil.setSysParam((BaseEntity)monthItem, (BaseEntity)head);
            }
            if (!monthItemList.isEmpty()) {
                this.purchaseForecastMonthItemService.saveBatch(monthItemList);
            }
        }
        if (!CollectionUtils.isEmpty(weekItemList)) {
            itemNumber = 1;
            int week = LocalDate.now().get(WeekFields.of(Locale.getDefault()).weekOfWeekBasedYear());
            for (PurchaseForecastWeekItem weekItem : weekItemList) {
                weekItem.setId(null);
                weekItem.setHeadId(head.getId());
                weekItem.setForecastNumber(head.getForecastNumber());
                weekItem.setItemNumber(String.valueOf(itemNumber++));
                weekItem.setCurrentWeek(String.valueOf(week));
                SysUtil.setSysParam((BaseEntity)weekItem, (BaseEntity)head);
            }
            if (!weekItemList.isEmpty()) {
                this.purchaseForecastWeekItemService.saveBatch(weekItemList);
            }
        }
    }

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void publish(PurchaseForecastHead head, List<PurchaseForecastMonthItem> monthItemList, List<PurchaseForecastWeekItem> weekItemList) {
        head.setPublishStatus(PublishStatusEnum.PUBLISHED.getValue());
        head.setPublishTime(new Date());
        head.setPublishUser(super.getLoginSubAndName());
        ((PurchaseForecastHeadMapper)this.baseMapper).updateById((Object)head);
        monthItemList.forEach(monthItem -> monthItem.setRelationId(IdWorker.getIdStr()));
        this.purchaseForecastMonthItemService.updateBatchById(monthItemList);
        weekItemList.forEach(weekItem -> weekItem.setRelationId(IdWorker.getIdStr()));
        this.purchaseForecastWeekItemService.updateBatchById(weekItemList);
        SaleForecastHeadService saleForecastHeadService = (SaleForecastHeadService)SpringContextUtils.getBean(SaleForecastHeadServiceImpl.class);
        saleForecastHeadService.add(head, monthItemList, weekItemList);
    }

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void delMain(String id) {
        this.purchaseForecastMonthItemService.deleteByMainId(id);
        this.purchaseForecastWeekItemService.deleteByMainId(id);
        ((PurchaseForecastHeadMapper)this.baseMapper).deleteById((Serializable)((Object)id));
    }

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void cancel(String id) {
        PurchaseForecastHead dbHead = (PurchaseForecastHead)((Object)((PurchaseForecastHeadMapper)this.baseMapper).selectById((Serializable)((Object)id)));
        dbHead.setForecastStatus(ForecastStatusEnum.CANCEL.getValue());
        ((PurchaseForecastHeadMapper)this.baseMapper).updateById((Object)dbHead);
        if (PublishStatusEnum.PUBLISHED.getValue().equals(dbHead.getPublishStatus())) {
            SaleForecastHeadService saleForecastHeadService = (SaleForecastHeadService)SpringContextUtils.getBean(SaleForecastHeadServiceImpl.class);
            saleForecastHeadService.update((Wrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().eq(SaleForecastHead::getRelationId, (Object)id)).set(SaleForecastHead::getForecastStatus, (Object)ForecastStatusEnum.CANCEL.getValue()));
        }
    }

    @Override
    public void confirm(SaleForecastHead saleForecastHead, List<SaleForecastMonthItem> saleForecastMonthItemList, List<SaleForecastWeekItem> saleForecastWeekItemList) {
        PurchaseForecastHead head = new PurchaseForecastHead();
        BeanUtils.copyProperties((Object)((Object)saleForecastHead), (Object)((Object)head));
        head.setId(saleForecastHead.getRelationId());
        head.setElsAccount(saleForecastHead.getToElsAccount());
        ((PurchaseForecastHeadMapper)this.baseMapper).updateById((Object)head);
        ArrayList<PurchaseForecastMonthItem> monthItemList = new ArrayList<PurchaseForecastMonthItem>();
        for (SaleForecastMonthItem saleMonthItem : saleForecastMonthItemList) {
            PurchaseForecastMonthItem monthItem = new PurchaseForecastMonthItem();
            BeanUtils.copyProperties((Object)((Object)saleMonthItem), (Object)((Object)monthItem));
            monthItem.setId(saleMonthItem.getRelationId());
            monthItem.setElsAccount(saleMonthItem.getToElsAccount());
            monthItem.setToElsAccount(saleMonthItem.getElsAccount());
            monthItem.setRelationId(saleMonthItem.getId());
            monthItem.setHeadId(null);
            monthItemList.add(monthItem);
        }
        this.purchaseForecastMonthItemService.updateBatchById(monthItemList);
        ArrayList<PurchaseForecastWeekItem> weekItemList = new ArrayList<PurchaseForecastWeekItem>();
        for (SaleForecastWeekItem saleWeekItem : saleForecastWeekItemList) {
            PurchaseForecastWeekItem weekItem = new PurchaseForecastWeekItem();
            BeanUtils.copyProperties((Object)((Object)saleWeekItem), (Object)((Object)weekItem));
            weekItem.setId(saleWeekItem.getRelationId());
            weekItem.setElsAccount(saleWeekItem.getToElsAccount());
            weekItem.setToElsAccount(saleWeekItem.getElsAccount());
            weekItem.setRelationId(saleWeekItem.getId());
            weekItem.setHeadId(null);
            weekItemList.add(weekItem);
        }
        this.purchaseForecastWeekItemService.updateBatchById(weekItemList);
    }
}

