/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.forecast.service.impl;

import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.util.I18nUtil;
import com.els.modules.forecast.entity.PurchaseForecastWeekItem;
import com.els.modules.forecast.mapper.PurchaseForecastWeekItemMapper;
import com.els.modules.forecast.service.PurchaseForecastWeekItemService;
import com.els.modules.forecast.vo.ReportVO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service
public class PurchaseForecastWeekItemServiceImpl
extends BaseServiceImpl<PurchaseForecastWeekItemMapper, PurchaseForecastWeekItem>
implements PurchaseForecastWeekItemService {
    @Override
    public List<PurchaseForecastWeekItem> selectByMainId(String mainId) {
        return ((PurchaseForecastWeekItemMapper)this.baseMapper).selectByMainId(mainId);
    }

    @Override
    public void deleteByMainId(String mainId) {
        ((PurchaseForecastWeekItemMapper)this.baseMapper).deleteByMainId(mainId);
    }

    @Override
    public Map<String, BigDecimal> getReportData(List<String> headIdList, Map<String, List<String>> headMap, ReportVO vo) {
        HashMap<String, BigDecimal> resultMap = new HashMap<String, BigDecimal>();
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)queryWrapper.eq(PurchaseForecastWeekItem::getMaterialNumber, (Object)vo.getMaterialNumber())).in(PurchaseForecastWeekItem::getHeadId, headIdList);
        if (StrUtil.isNotBlank((CharSequence)vo.getFactory())) {
            queryWrapper.eq(PurchaseForecastWeekItem::getFactory, (Object)vo.getFactory());
        }
        if (StrUtil.isNotBlank((CharSequence)vo.getToElsAccount())) {
            queryWrapper.eq(PurchaseForecastWeekItem::getToElsAccount, (Object)vo.getToElsAccount());
        }
        List dbList = ((PurchaseForecastWeekItemMapper)this.baseMapper).selectList((Wrapper)queryWrapper);
        Assert.notEmpty((Collection)dbList, (String)I18nUtil.translate((String)"", (String)"\u5f53\u524d\u6761\u4ef6\u4e0b\uff0c\u6682\u65e0\u9700\u6c42\u9884\u6d4b\u884c\u4fe1\u606f"));
        Map<String, List<PurchaseForecastWeekItem>> groupMap = dbList.stream().collect(Collectors.groupingBy(PurchaseForecastWeekItem::getHeadId));
        for (String headKey : headMap.keySet()) {
            List<String> sameDateIdList = headMap.get(headKey);
            List<PurchaseForecastWeekItem> sameDateList = this.getSameDateList(sameDateIdList, groupMap);
            BigDecimal requireQuantity = this.getRequireQuantity(vo, sameDateList);
            resultMap.put(headKey, requireQuantity);
        }
        return resultMap;
    }

    private List<PurchaseForecastWeekItem> getSameDateList(List<String> sameDateIdList, Map<String, List<PurchaseForecastWeekItem>> groupMap) {
        ArrayList<PurchaseForecastWeekItem> list = new ArrayList<PurchaseForecastWeekItem>();
        for (String headId : sameDateIdList) {
            list.addAll((Collection<PurchaseForecastWeekItem>)groupMap.get(headId));
        }
        return list;
    }

    private BigDecimal getRequireQuantity(ReportVO vo, List<PurchaseForecastWeekItem> sameDateList) {
        BigDecimal result = BigDecimal.ZERO;
        String beginWeek = vo.getBeginYear() + "_" + vo.getBeginWeek();
        String endWeek = vo.getEndYear() + "_" + vo.getEndWeek();
        for (PurchaseForecastWeekItem item : sameDateList) {
            JSONObject weekJson = StrUtil.isBlank((CharSequence)item.getRequireWeekJson()) ? new JSONObject() : JSONObject.parseObject((String)item.getRequireWeekJson());
            for (String key : weekJson.keySet()) {
                if (key.compareTo(beginWeek) < 0 || key.compareTo(endWeek) > 0) continue;
                result = result.add(weekJson.getBigDecimal(key));
            }
        }
        return result;
    }
}

