/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.demand.controller;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.conditions.update.LambdaUpdateChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.els.common.api.vo.Result;
import com.els.common.aspect.annotation.AutoLog;
import com.els.common.aspect.annotation.PermissionDataView;
import com.els.common.enumerate.AuditStatusEnum;
import com.els.common.system.base.controller.BaseController;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.query.QueryGenerator;
import com.els.modules.demand.entity.PurchaseRequestHead;
import com.els.modules.demand.entity.PurchaseRequestItem;
import com.els.modules.demand.enumerate.PurchaseRequestStatusEnum;
import com.els.modules.demand.enumerate.PurchaseRequestStatusItemEnum;
import com.els.modules.demand.service.PurchaseRequestHeadService;
import com.els.modules.demand.service.PurchaseRequestItemService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/demand/purchaseDemandPool"})
@Api(tags={"\u91c7\u8d2d\u7533\u8bf7\u5934"})
public class PurchaseDemandPoolController
extends BaseController<PurchaseRequestItem, PurchaseRequestItemService> {
    private static final Logger log = LoggerFactory.getLogger(PurchaseDemandPoolController.class);
    @Autowired
    private PurchaseRequestHeadService purchaseRequestHeadService;
    @Autowired
    private PurchaseRequestItemService purchaseRequestItemService;

    @GetMapping(value={"/list"})
    @PermissionDataView(businessType="demandPool")
    public Result<?> queryPageList(PurchaseRequestItem purchaseRequestItem, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)purchaseRequestItem), (Map)req.getParameterMap());
        queryWrapper.notIn((Object)"item_status", Arrays.asList(PurchaseRequestStatusItemEnum.APPROVED.getValue(), PurchaseRequestStatusItemEnum.SEND_BACK.getValue(), PurchaseRequestStatusItemEnum.CANCEL.getValue()));
        queryWrapper.lambda().orderByDesc(BaseEntity::getCreateTime);
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        IPage pageList = this.purchaseRequestItemService.page((IPage)page, (Wrapper)queryWrapper);
        return Result.ok((Object)pageList);
    }

    @ApiOperation(value="\u5408\u540c\u67e5\u8be2\u91c7\u8d2d\u7533\u8bf7\u884c\u5206\u9875\u4fe1\u606f", notes="\u5408\u540c\u67e5\u8be2\u91c7\u8d2d\u7533\u8bf7\u884c\u5206\u9875\u4fe1\u606f")
    @GetMapping(value={"/contractQueryRequest"})
    public Result<?> contractQueryRequest(PurchaseRequestItem item, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)item), (Map)req.getParameterMap());
        queryWrapper.eq((Object)"audit_status", (Object)AuditStatusEnum.AUDIT_FINISH.getValue());
        queryWrapper.inSql((Object)"request_number", "select request_number from purchase_request_head where request_status <> " + PurchaseRequestStatusEnum.REQUEST_CANCAL.getValue());
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        IPage pageList = this.purchaseRequestItemService.page((IPage)page, (Wrapper)queryWrapper);
        return Result.ok((Object)pageList);
    }

    @ApiOperation(value="\u91c7\u8d2d\u7533\u8bf7\u884c-\u4f5c\u5e9f", notes="\u91c7\u8d2d\u7533\u8bf7\u884c-\u4f5c\u5e9f")
    @PostMapping(value={"/cancel"})
    public Result<?> cancel(@RequestBody PurchaseRequestItem head) {
        this.purchaseRequestItemService.updateStatus(Arrays.asList(head), PurchaseRequestStatusItemEnum.CANCEL.getValue());
        return this.commonSuccessResult(7);
    }

    @ApiOperation(value="\u91c7\u8d2d\u7533\u8bf7\u884c-\u9000\u56de", notes="\u91c7\u8d2d\u7533\u8bf7\u884c-\u9000\u56de")
    @AutoLog(busModule="\u9700\u6c42\u6c60\u7ba1\u7406", value="\u9000\u56de")
    @PostMapping(value={"/returnItem"})
    public Result<?> returnItem(@RequestBody PurchaseRequestItem head) {
        if ("sample".equals(head.getSourceType())) {
            this.purchaseRequestItemService.returnSample(head);
            return this.commonSuccessResult(3);
        }
        QueryWrapper purchaseRequestHeadQueryWrapper = new QueryWrapper();
        ((LambdaQueryWrapper)purchaseRequestHeadQueryWrapper.lambda().eq(PurchaseRequestHead::getRequestNumber, (Object)head.getRequestNumber())).eq(BaseEntity::getElsAccount, (Object)head.getElsAccount());
        this.purchaseRequestItemService.returnItem(head);
        List list = this.purchaseRequestHeadService.list((Wrapper)purchaseRequestHeadQueryWrapper);
        if (!CollectionUtils.isEmpty((Collection)list)) {
            for (PurchaseRequestHead purchaseRequestHead : list) {
                String status = PurchaseRequestStatusEnum.REQUEST_RETURN.getValue();
                List<PurchaseRequestItem> purchaseRequestItems = this.purchaseRequestItemService.selectByMainId(purchaseRequestHead.getId());
                List collect = purchaseRequestItems.parallelStream().filter(item -> item.getItemStatus().equals(PurchaseRequestStatusItemEnum.SEND_BACK.getValue())).collect(Collectors.toList());
                if (collect.size() == purchaseRequestItems.size()) {
                    status = PurchaseRequestStatusEnum.ALL_RETURN.getValue();
                }
                if (purchaseRequestHead.getAudit().equals("1")) {
                    ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.purchaseRequestHeadService.lambdaUpdate().eq(BaseEntity::getId, (Object)purchaseRequestHead.getId())).set(PurchaseRequestHead::getRequestStatus, (Object)status)).set(PurchaseRequestHead::getAuditStatus, (Object)AuditStatusEnum.AUDIT_NEW.getValue())).update();
                    continue;
                }
                ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.purchaseRequestHeadService.lambdaUpdate().eq(BaseEntity::getId, (Object)purchaseRequestHead.getId())).set(PurchaseRequestHead::getRequestStatus, (Object)status)).update();
            }
        }
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.purchaseRequestItemService.lambdaUpdate().eq(BaseEntity::getId, (Object)head.getId())).set(PurchaseRequestItem::getBackRemark, (Object)head.getBackRemark())).set(PurchaseRequestItem::getTacticsObject, null)).set(PurchaseRequestItem::getTacticsEntity, null)).update();
        return this.commonSuccessResult(7);
    }

    @ApiOperation(value="\u7f16\u8f91", notes="\u7f16\u8f91")
    @AutoLog(busModule="\u9700\u6c42\u6c60\u7ba1\u7406", value="\u8f6c\u529e")
    @PostMapping(value={"/edit"})
    public Result<?> edit(@RequestBody PurchaseRequestItem requestItem) {
        this.purchaseRequestItemService.updateItem(requestItem);
        return this.commonSuccessResult(3);
    }

    public Result<?> updateStatus(List<PurchaseRequestItem> itemList, String status) {
        this.purchaseRequestItemService.updateStatus(itemList, status);
        return this.commonSuccessResult(3);
    }
}

