/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.enquiry.controller;

import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.els.common.api.vo.Result;
import com.els.common.aspect.annotation.AutoLog;
import com.els.common.system.base.controller.BaseController;
import com.els.common.system.query.QueryGenerator;
import com.els.common.util.I18nUtil;
import com.els.modules.base.api.dto.SaleAttachmentDTO;
import com.els.modules.base.api.dto.SaleAttachmentDemandDTO;
import com.els.modules.bidding.enumerate.StageTypeEnum;
import com.els.modules.enquiry.entity.SaleEnquiryHead;
import com.els.modules.enquiry.entity.SaleEnquiryItem;
import com.els.modules.enquiry.enumerate.EnquiryStatusEnum;
import com.els.modules.enquiry.service.SaleEnquiryHeadService;
import com.els.modules.enquiry.service.SaleEnquiryItemService;
import com.els.modules.enquiry.vo.SaleEnquiryHeadVO;
import com.els.rpc.service.InvokeBaseRpcService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.Assert;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/enquiry/saleEnquiryHead"})
@Api(tags={"\u4f9b\u65b9\u8be2\u4ef7\u5934"})
public class SaleEnquiryHeadController
extends BaseController<SaleEnquiryHead, SaleEnquiryHeadService> {
    private static final Logger log = LoggerFactory.getLogger(SaleEnquiryHeadController.class);
    @Autowired
    private SaleEnquiryHeadService saleEnquiryHeadService;
    @Autowired
    private SaleEnquiryItemService saleEnquiryItemService;
    @Resource
    private InvokeBaseRpcService invokeBaseRpcService;

    @ApiOperation(value="\u5206\u9875\u5217\u8868\u67e5\u8be2", notes="\u5206\u9875\u5217\u8868\u67e5\u8be2")
    @GetMapping(value={"/list"})
    public Result<?> queryPageList(SaleEnquiryHead saleEnquiryHead, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)saleEnquiryHead), (Map)req.getParameterMap());
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        IPage pageList = this.saleEnquiryHeadService.page((IPage)page, (Wrapper)queryWrapper);
        return Result.ok((Object)pageList);
    }

    @ApiOperation(value="\u79fb\u52a8\u7aef\u72b6\u6001\u6570\u91cf\u67e5\u8be2", notes="\u79fb\u52a8\u7aef\u72b6\u6001\u6570\u91cf\u67e5\u8be2")
    @GetMapping(value={"/count"})
    public Result<?> queryStatusCount(SaleEnquiryHead saleEnquiryHead, HttpServletRequest req) {
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)saleEnquiryHead), (Map)req.getParameterMap());
        queryWrapper.lambda().in(SaleEnquiryHead::getEnquiryStatus, new Object[]{EnquiryStatusEnum.QUOTING.getValue(), EnquiryStatusEnum.QUOTED.getValue(), EnquiryStatusEnum.NO_QUOTE.getValue(), EnquiryStatusEnum.BARGAIN.getValue()});
        List list = ((SaleEnquiryHeadService)this.service).list((Wrapper)queryWrapper);
        long quoting = list.stream().filter(head -> EnquiryStatusEnum.QUOTING.getValue().equals(head.getEnquiryStatus())).count();
        long quoted = list.stream().filter(head -> EnquiryStatusEnum.QUOTED.getValue().equals(head.getEnquiryStatus())).count();
        long noQuote = list.stream().filter(head -> EnquiryStatusEnum.NO_QUOTE.getValue().equals(head.getEnquiryStatus())).count();
        long bargain = list.stream().filter(head -> EnquiryStatusEnum.BARGAIN.getValue().equals(head.getEnquiryStatus())).count();
        HashMap<String, Long> result = new HashMap<String, Long>();
        result.put("quoting", quoting);
        result.put("quoted", quoted);
        result.put("noQuote", noQuote);
        result.put("bargain", bargain);
        return Result.ok(result);
    }

    @ApiOperation(value="\u901a\u8fc7id\u67e5\u8be2\u8be6\u60c5", notes="\u901a\u8fc7id\u67e5\u8be2\u8be6\u60c5")
    @GetMapping(value={"/queryById"})
    public Result<?> queryById(@RequestParam(name="id") String id) {
        SaleEnquiryHead dbHead = (SaleEnquiryHead)((Object)this.saleEnquiryHeadService.getById((Serializable)((Object)id)));
        SaleEnquiryHeadVO headVO = new SaleEnquiryHeadVO();
        BeanUtils.copyProperties((Object)((Object)dbHead), (Object)((Object)headVO));
        List<SaleEnquiryItem> saleEnquiryItemList = this.saleEnquiryItemService.selectByMainId(id);
        headVO.setSaleEnquiryItemList(saleEnquiryItemList);
        List saleAttachmentList = this.invokeBaseRpcService.selectSaleAttachmentByMainId(id);
        headVO.setSaleAttachmentList(saleAttachmentList);
        List demandList = this.invokeBaseRpcService.selectSaleAttachmentDemandByMainId(id);
        headVO.setSaleAttachmentDemandList(demandList);
        return Result.ok((Object)((Object)headVO));
    }

    @AutoLog(value="\u4f9b\u65b9\u8be2\u4ef7\u5934-\u4fdd\u5b58")
    @ApiOperation(value="\u4fdd\u5b58", notes="\u4fdd\u5b58")
    @PostMapping(value={"/save"})
    public Result<?> save(@RequestBody SaleEnquiryHeadVO saleHeadVO) {
        SaleEnquiryHead head = new SaleEnquiryHead();
        BeanUtils.copyProperties((Object)((Object)saleHeadVO), (Object)((Object)head));
        SaleEnquiryHead saleHead = (SaleEnquiryHead)((Object)this.saleEnquiryHeadService.getById((Serializable)((Object)saleHeadVO.getId())));
        Assert.isTrue((boolean)new Date().before(saleHead.getQuoteEndTime()), (String)I18nUtil.translate((String)"i18n_alert_suIyRWxqtk_b5b5a585", (String)"\u62a5\u4ef7\u5df2\u622a\u6b62\uff0c\u4e0d\u53ef\u64cd\u4f5c"));
        this.saleEnquiryHeadService.save(head, saleHeadVO.getSaleEnquiryItemList());
        return this.commonSuccessResult(3);
    }

    @AutoLog(value="\u4f9b\u65b9\u8be2\u4ef7\u5934-\u62a5\u4ef7")
    @ApiOperation(value="\u62a5\u4ef7", notes="\u62a5\u4ef7")
    @PostMapping(value={"/quote"})
    public Result<?> quote(@RequestBody SaleEnquiryHeadVO saleHeadVO) {
        Assert.notEmpty(saleHeadVO.getSaleEnquiryItemList(), (String)I18nUtil.translate((String)"i18n_alert_cdIxOLV_e4453e71", (String)"\u884c\u9879\u76ee\u4e0d\u80fd\u4e3a\u7a7a"));
        Assert.hasText((String)saleHeadVO.getId(), (String)I18nUtil.translate((String)"i18n_alert_empty_header_id", (String)"\u5934\u4fe1\u606fid\u4e0d\u80fd\u4e3a\u7a7a"));
        SaleEnquiryHead saleHead = (SaleEnquiryHead)((Object)this.saleEnquiryHeadService.getById((Serializable)((Object)saleHeadVO.getId())));
        Assert.isTrue((boolean)new Date().before(saleHead.getQuoteEndTime()), (String)I18nUtil.translate((String)"", (String)"\u62a5\u4ef7\u5df2\u622a\u6b62\uff0c\u4e0d\u53ef\u62a5\u4ef7"));
        List demandList = this.invokeBaseRpcService.selectSaleAttachmentDemandByMainId(saleHead.getId()).stream().filter(demand -> "1".equals(demand.getRequired())).filter(demand -> StageTypeEnum.QUOTE.getValue().equals(demand.getStageType())).collect(Collectors.toList());
        List saleAttachmentList = this.invokeBaseRpcService.selectSaleAttachmentByMainId(saleHead.getId());
        Map<String, List<SaleAttachmentDTO>> checkMap = saleAttachmentList.stream().filter(attachment -> StrUtil.isNotBlank((CharSequence)attachment.getFileType())).collect(Collectors.groupingBy(SaleAttachmentDTO::getFileType));
        for (SaleAttachmentDemandDTO demand2 : demandList) {
            Assert.isTrue((boolean)checkMap.containsKey(demand2.getFileType()), (String)I18nUtil.translate((String)"", (String)"\u8bf7\u6309\u7167\u8981\u6c42\u4e0a\u4f20\u5bf9\u5e94\u7c7b\u578b\u7684\u6587\u4ef6\uff01"));
        }
        this.saleEnquiryHeadService.quote(saleHead, saleHeadVO.getSaleEnquiryItemList());
        return this.commonSuccessResult(3);
    }
}

