/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.bidding.controller;

import cn.hutool.core.date.DateUnit;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.els.common.api.vo.Result;
import com.els.common.aspect.annotation.AutoLog;
import com.els.common.enumerate.AuditStatusEnum;
import com.els.common.system.base.controller.BaseController;
import com.els.common.system.query.QueryGenerator;
import com.els.common.system.vo.LoginUser;
import com.els.common.util.I18nUtil;
import com.els.common.vo.CountVO;
import com.els.modules.base.api.dto.DictDTO;
import com.els.modules.base.api.dto.PurchaseAttachmentDTO;
import com.els.modules.base.api.dto.PurchaseAttachmentDemandDTO;
import com.els.modules.bidding.entity.BiddingSupplier;
import com.els.modules.bidding.entity.PurchaseBiddingHead;
import com.els.modules.bidding.entity.PurchaseBiddingItem;
import com.els.modules.bidding.entity.PurchaseBiddingSpecialist;
import com.els.modules.bidding.enumerate.BiddingItemStatusEnum;
import com.els.modules.bidding.enumerate.BiddingStatusEnum;
import com.els.modules.bidding.service.BiddingSupplierService;
import com.els.modules.bidding.service.PurchaseBiddingHeadService;
import com.els.modules.bidding.service.PurchaseBiddingItemService;
import com.els.modules.bidding.service.PurchaseBiddingSpecialistService;
import com.els.modules.bidding.vo.BiddingMemberVO;
import com.els.modules.bidding.vo.BiddingSupplierVO;
import com.els.modules.bidding.vo.ConfirmBidVO;
import com.els.modules.bidding.vo.PurchaseBiddingHeadVO;
import com.els.modules.demand.entity.PurchaseRequestItem;
import com.els.modules.demand.vo.PurchaseRequestHeadVO;
import com.els.modules.inquiry.enumerate.SourceTypeEnum;
import com.els.rpc.service.InvokeBaseRpcService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.Assert;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/bidding/purchaseBiddingHead"})
@Api(tags={"\u91c7\u8d2d\u62db\u6807\u5355"})
public class PurchaseBiddingHeadController
extends BaseController<PurchaseBiddingHead, PurchaseBiddingHeadService> {
    @Autowired
    private PurchaseBiddingHeadService purchaseBiddingHeadService;
    @Autowired
    private PurchaseBiddingItemService purchaseBiddingItemService;
    @Autowired
    private BiddingSupplierService biddingSupplierService;
    @Autowired
    private PurchaseBiddingSpecialistService purchaseBiddingSpecialistService;
    @Autowired
    private InvokeBaseRpcService invokeBaseRpcService;

    @ApiOperation(value="\u5206\u9875\u5217\u8868\u67e5\u8be2", notes="\u5206\u9875\u5217\u8868\u67e5\u8be2")
    @GetMapping(value={"/list"})
    public Result<?> queryPageList(PurchaseBiddingHead purchaseBiddingHead, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)purchaseBiddingHead), (Map)req.getParameterMap());
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        IPage pageList = this.purchaseBiddingHeadService.page((IPage)page, (Wrapper)queryWrapper);
        return Result.ok((Object)pageList);
    }

    @ApiOperation(value="\u901a\u8fc7\u5217\u8868\u9875\u9875\u7b7e\u6570\u91cf\u67e5\u8be2", notes="\u5217\u8868\u9875\u9875\u7b7e\u6570\u91cf\u67e5\u8be2")
    @GetMapping(value={"/counts"})
    public Result<?> queryTabsCount(PurchaseBiddingHead purchaseBiddingHead, HttpServletRequest req) {
        ArrayList<CountVO> result = new ArrayList<CountVO>();
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)purchaseBiddingHead), (Map)req.getParameterMap());
        queryWrapper.select(new String[]{"bidding_status", "count(0) as participate_quantity"});
        queryWrapper.groupBy((Object)"bidding_status");
        List list = ((PurchaseBiddingHeadService)this.service).list((Wrapper)queryWrapper);
        Map<String, Integer> countMap = list.stream().collect(Collectors.toMap(PurchaseBiddingHead::getBiddingStatus, PurchaseBiddingHead::getParticipateQuantity));
        Integer all = 0;
        for (Map.Entry<String, Integer> entry : countMap.entrySet()) {
            all = all + entry.getValue();
        }
        result.add(new CountVO(I18nUtil.translate((String)"", (String)"\u5168\u90e8"), "biddingStatus", null, all));
        List srmRectificationAppealStatus = this.invokeBaseRpcService.queryDictItemsByCode("srmBiddingStatus", "307000");
        for (DictDTO status : srmRectificationAppealStatus) {
            Integer total = countMap.get(status.getValue()) == null ? Integer.valueOf(0) : countMap.get(status.getValue());
            result.add(new CountVO(I18nUtil.translate((String)status.getTextI18nKey(), (String)status.getText()), "biddingStatus", status.getValue(), total));
        }
        return Result.ok(result);
    }

    @ApiOperation(value="\u5206\u9875\u5217\u8868\u67e5\u8be2", notes="\u5206\u9875\u5217\u8868\u67e5\u8be2")
    @GetMapping(value={"/contractQueryBidding"})
    public Result<?> contractQueryBidding(PurchaseBiddingItem item, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)item), (Map)req.getParameterMap());
        ((QueryWrapper)queryWrapper.eq((Object)"audit_status", (Object)AuditStatusEnum.AUDIT_FINISH.getValue())).eq((Object)"item_status", (Object)BiddingStatusEnum.CONFIRM_ED.getValue());
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        IPage pageList = this.purchaseBiddingItemService.page((IPage)page, (Wrapper)queryWrapper);
        return Result.ok((Object)pageList);
    }

    @AutoLog(busModule="\u91c7\u8d2d\u62db\u6807\u7ba1\u7406", value="\u6dfb\u52a0")
    @ApiOperation(value="\u6dfb\u52a0", notes="\u6dfb\u52a0")
    @PostMapping(value={"/add"})
    public Result<?> add(@RequestBody PurchaseBiddingHeadVO purchaseBiddingHeadPage) {
        PurchaseBiddingHead purchaseBiddingHead = new PurchaseBiddingHead();
        BeanUtils.copyProperties((Object)((Object)purchaseBiddingHeadPage), (Object)((Object)purchaseBiddingHead));
        purchaseBiddingHead.setBiddingNumber(this.invokeBaseRpcService.getNextCode("srmBiddingNumber", (Object)purchaseBiddingHead));
        this.purchaseBiddingHeadService.saveMain(purchaseBiddingHead, purchaseBiddingHeadPage.getPurchaseBiddingItemList(), purchaseBiddingHeadPage.getBiddingSupplierList(), purchaseBiddingHeadPage.getPurchaseBiddingSpecialistList(), purchaseBiddingHeadPage.getPurchaseAttachmentDemandList(), purchaseBiddingHeadPage.getPurchaseAttachmentList());
        return Result.ok((Object)((Object)purchaseBiddingHead));
    }

    @AutoLog(busModule="\u91c7\u8d2d\u62db\u6807\u7ba1\u7406", value="\u7f16\u8f91")
    @ApiOperation(value="\u7f16\u8f91", notes="\u7f16\u8f91")
    @PostMapping(value={"/edit"})
    public Result<?> edit(@RequestBody PurchaseBiddingHeadVO purchaseBiddingHeadPage) {
        PurchaseBiddingHead purchaseBiddingHead = new PurchaseBiddingHead();
        BeanUtils.copyProperties((Object)((Object)purchaseBiddingHeadPage), (Object)((Object)purchaseBiddingHead));
        this.purchaseBiddingHeadService.updateMain(purchaseBiddingHead, purchaseBiddingHeadPage.getPurchaseBiddingItemList(), purchaseBiddingHeadPage.getBiddingSupplierList(), purchaseBiddingHeadPage.getPurchaseBiddingSpecialistList(), purchaseBiddingHeadPage.getPurchaseAttachmentDemandList(), purchaseBiddingHeadPage.getPurchaseAttachmentList());
        return this.commonSuccessResult(3);
    }

    @AutoLog(busModule="\u91c7\u8d2d\u62db\u6807\u7ba1\u7406", value="\u53d1\u5e03")
    @ApiOperation(value="\u53d1\u5e03", notes="\u53d1\u5e03")
    @PostMapping(value={"/publish"})
    public Result<?> publish(@RequestBody PurchaseBiddingHeadVO purchaseBiddingHeadPage) {
        PurchaseBiddingHead purchaseBiddingHead = new PurchaseBiddingHead();
        BeanUtils.copyProperties((Object)((Object)purchaseBiddingHeadPage), (Object)((Object)purchaseBiddingHead));
        if (StrUtil.isBlank((CharSequence)purchaseBiddingHead.getBiddingNumber())) {
            purchaseBiddingHead.setBiddingNumber(this.invokeBaseRpcService.getNextCode("srmBiddingNumber", (Object)purchaseBiddingHead));
        }
        if ("1".equals(purchaseBiddingHead.getNeedEcho()) && DateUtil.between((Date)new Date(), (Date)purchaseBiddingHead.getEchoEndTime(), (DateUnit)DateUnit.MINUTE, (boolean)false) < 5L) {
            Assert.isTrue((boolean)false, (String)I18nUtil.translate((String)"", (String)"\u5e94\u6807\u65f6\u95f4\u8bbe\u7f6e\u8fc7\u8fd1"));
        }
        if (DateUtil.between((Date)new Date(), (Date)purchaseBiddingHead.getBidEndTime(), (DateUnit)DateUnit.MINUTE, (boolean)false) < 5L) {
            Assert.isTrue((boolean)false, (String)I18nUtil.translate((String)"", (String)"\u6295\u6807\u622a\u6b62\u65f6\u95f4\u8bbe\u7f6e\u8fc7\u8fd1"));
        }
        if (DateUtil.between((Date)new Date(), (Date)purchaseBiddingHead.getPlanOpenBidTime(), (DateUnit)DateUnit.MINUTE, (boolean)false) < (long)(5 + (purchaseBiddingHead.getOpenBidAlertMinute() != null ? purchaseBiddingHead.getOpenBidAlertMinute() : 0))) {
            Assert.isTrue((boolean)false, (String)I18nUtil.translate((String)"", (String)"\u5f00\u6807\u65f6\u95f4\u8bbe\u7f6e\u8fc7\u8fd1"));
        }
        this.purchaseBiddingHeadService.publish(purchaseBiddingHead, purchaseBiddingHeadPage.getPurchaseBiddingItemList(), purchaseBiddingHeadPage.getBiddingSupplierList(), purchaseBiddingHeadPage.getPurchaseBiddingSpecialistList(), purchaseBiddingHeadPage.getPurchaseAttachmentDemandList(), purchaseBiddingHeadPage.getPurchaseAttachmentList());
        return this.commonSuccessResult(3);
    }

    @AutoLog(busModule="\u91c7\u8d2d\u62db\u6807\u7ba1\u7406", value="\u9700\u6c42\u6c60\u8f6c\u62db\u6807")
    @ApiOperation(value="\u9700\u6c42\u6c60\u8f6c\u62db\u6807", notes="\u9700\u6c42\u6c60\u8f6c\u62db\u6807")
    @PostMapping(value={"/requestToBidding"})
    public Result<?> requestToBidding(@RequestBody PurchaseRequestHeadVO requestHeadVO) {
        String templateNumber = requestHeadVO.getTemplateNumber();
        String templateVersion = requestHeadVO.getTemplateVersion();
        Assert.hasText((String)templateNumber, (String)I18nUtil.translate((String)"i18n_alert_empty_template_num_no_null_template", (String)"\u6a21\u677f\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a"));
        Assert.hasText((String)templateVersion, (String)I18nUtil.translate((String)"i18n_alert_empty_template_version_num_template", (String)"\u6a21\u677f\u7248\u672c\u53f7\u4e0d\u80fd\u4e3a\u7a7a"));
        PurchaseBiddingHead head = new PurchaseBiddingHead();
        head.setTemplateNumber(templateNumber);
        head.setTemplateVersion(Integer.valueOf(templateVersion));
        head.setTemplateName(requestHeadVO.getTemplateName());
        head.setTemplateAccount(requestHeadVO.getTemplateAccount());
        ArrayList<PurchaseBiddingItem> itemList = new ArrayList<PurchaseBiddingItem>();
        List<PurchaseRequestItem> requestItemList = requestHeadVO.getPurchaseRequestItemList();
        List orgList = requestItemList.stream().map(item -> item.getPurchaseOrg() == null ? "" : item.getPurchaseOrg()).distinct().collect(Collectors.toList());
        Assert.isTrue((orgList.size() == 1 ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_alert_oper_no_the_same_purchase_organization", (String)"\u76f8\u540c\u91c7\u8d2d\u7ec4\u7ec7\u624d\u53ef\u8f6c\u5355"));
        for (PurchaseRequestItem requestItem : requestItemList) {
            PurchaseBiddingItem item2 = new PurchaseBiddingItem();
            BeanUtils.copyProperties((Object)((Object)requestItem), (Object)((Object)item2));
            item2.setId(null);
            item2.setSourceType(SourceTypeEnum.REQUEST.getValue());
            item2.setSourceNumber(requestItem.getRequestNumber());
            item2.setSourceItemNumber(requestItem.getItemNumber());
            item2.setSourceItemId(requestItem.getId());
            item2.setPriceUnit(requestItem.getUnitPrice());
            item2.setQuantityUnit(requestItem.getUnitQuantity());
            item2.setRequireQuantity(requestItem.getQuantity());
            item2.setRequireDate(requestItem.getApplyDate());
            itemList.add(item2);
        }
        head.setCompany(requestItemList.get(0).getCompany());
        head.setPurchaseGroup(requestItemList.get(0).getPurchaseGroup());
        head.setPurchaseOrg(requestItemList.get(0).getPurchaseOrg());
        if ("person".equals(requestItemList.get(0).getTacticsEntity())) {
            head.setPurchasePrincipal(requestItemList.get(0).getTacticsObject());
        } else {
            LoginUser sysUser = this.getCurrentUser();
            head.setPurchasePrincipal(sysUser.getSubAccount() + "_" + sysUser.getRealname());
        }
        head.setBiddingNumber(this.invokeBaseRpcService.getNextCode("srmBiddingNumber", (Object)head));
        this.purchaseBiddingHeadService.saveMain(head, itemList, new ArrayList<BiddingSupplier>(), new ArrayList<PurchaseBiddingSpecialist>(), new ArrayList<PurchaseAttachmentDemandDTO>(), new ArrayList<PurchaseAttachmentDTO>());
        return Result.ok((String)("\u8f6c\u62db\u6807\u6210\u529f,\u62db\u6807\u5355\u53f7\u4e3a:" + head.getBiddingNumber()));
    }

    @AutoLog(busModule="\u91c7\u8d2d\u62db\u6807\u7ba1\u7406", value="\u5f00\u901a\u6743\u9650")
    @ApiOperation(value="\u5f00\u901a\u6743\u9650", notes="\u5f00\u901a\u6743\u9650")
    @PostMapping(value={"/openPermission"})
    public Result<?> openPermission(@RequestBody PurchaseBiddingHeadVO purchaseBiddingHeadPage) {
        PurchaseBiddingHead purchaseBiddingHead = new PurchaseBiddingHead();
        BeanUtils.copyProperties((Object)((Object)purchaseBiddingHeadPage), (Object)((Object)purchaseBiddingHead));
        this.purchaseBiddingHeadService.openPermission(purchaseBiddingHead, purchaseBiddingHeadPage.getBiddingSupplierList());
        return this.commonSuccessResult(3);
    }

    @AutoLog(busModule="\u91c7\u8d2d\u62db\u6807\u7ba1\u7406", value="\u901a\u8fc7id\u5220\u9664")
    @ApiOperation(value="\u901a\u8fc7id\u5220\u9664", notes="\u901a\u8fc7id\u5220\u9664")
    @GetMapping(value={"/delete"})
    public Result<?> delete(@RequestParam(name="id") String id) {
        this.purchaseBiddingHeadService.delMain(id);
        return this.commonSuccessResult(4);
    }

    @ApiOperation(value="\u901a\u8fc7id\u67e5\u8be2", notes="\u901a\u8fc7id\u67e5\u8be2")
    @GetMapping(value={"/queryById"})
    public Result<?> queryById(@RequestParam(name="id") String id) {
        PurchaseBiddingHead purchaseBiddingHead = (PurchaseBiddingHead)((Object)this.purchaseBiddingHeadService.getById((Serializable)((Object)id)));
        PurchaseBiddingHeadVO purchaseBiddingHeadVO = new PurchaseBiddingHeadVO();
        BeanUtils.copyProperties((Object)((Object)purchaseBiddingHead), (Object)((Object)purchaseBiddingHeadVO));
        List<PurchaseBiddingItem> purchaseBiddingItemList = this.purchaseBiddingItemService.selectByMainId(id);
        List distinctList = purchaseBiddingItemList.parallelStream().collect(Collectors.collectingAndThen(Collectors.toCollection(() -> new TreeSet<PurchaseBiddingItem>(Comparator.comparing(PurchaseBiddingItem::getItemNumber))), ArrayList::new));
        purchaseBiddingHeadVO.setPurchaseBiddingItemList(distinctList);
        List<BiddingSupplier> biddingSupplierList = this.biddingSupplierService.selectByMainId(id);
        purchaseBiddingHeadVO.setBiddingSupplierList(biddingSupplierList);
        List<PurchaseBiddingSpecialist> purchaseBiddingSpecialistList = this.purchaseBiddingSpecialistService.selectByMainId(id);
        purchaseBiddingHeadVO.setPurchaseBiddingSpecialistList(purchaseBiddingSpecialistList);
        List purchaseAttachmentDemandList = this.invokeBaseRpcService.selectPurchaseAttachmentDemandByMainId(id);
        purchaseBiddingHeadVO.setPurchaseAttachmentDemandList(purchaseAttachmentDemandList);
        List purchaseAttachmentList = this.invokeBaseRpcService.selectPurchaseAttachmentByMainId(id);
        purchaseBiddingHeadVO.setPurchaseAttachmentList(purchaseAttachmentList);
        return Result.ok((Object)((Object)purchaseBiddingHeadVO));
    }

    @ApiOperation(value="\u901a\u8fc7id\u67e5\u8be2\u6295\u6807\u8be6\u60c5", notes="\u901a\u8fc7id\u67e5\u8be2\u6295\u6807\u8be6\u60c5")
    @GetMapping(value={"/queryQuoteById"})
    public Result<?> queryQuoteById(@RequestParam(name="id") String id) {
        PurchaseBiddingHead purchaseBiddingHead = (PurchaseBiddingHead)((Object)this.purchaseBiddingHeadService.getById((Serializable)((Object)id)));
        PurchaseBiddingHeadVO purchaseBiddingHeadVO = new PurchaseBiddingHeadVO();
        BeanUtils.copyProperties((Object)((Object)purchaseBiddingHead), (Object)((Object)purchaseBiddingHeadVO));
        List<PurchaseBiddingItem> purchaseBiddingItemList = this.purchaseBiddingItemService.selectByMainId(id);
        purchaseBiddingHeadVO.setPurchaseBiddingItemList(purchaseBiddingItemList);
        List<BiddingSupplier> biddingSupplierList = this.biddingSupplierService.selectByMainId(id);
        purchaseBiddingHeadVO.setBiddingSupplierList(biddingSupplierList);
        List<PurchaseBiddingSpecialist> purchaseBiddingSpecialistList = this.purchaseBiddingSpecialistService.selectByMainId(id);
        purchaseBiddingHeadVO.setPurchaseBiddingSpecialistList(purchaseBiddingSpecialistList);
        List purchaseAttachmentDemandList = this.invokeBaseRpcService.selectPurchaseAttachmentDemandByMainId(id);
        purchaseBiddingHeadVO.setPurchaseAttachmentDemandList(purchaseAttachmentDemandList);
        List purchaseAttachmentList = this.invokeBaseRpcService.selectPurchaseAttachmentByMainId(id);
        purchaseBiddingHeadVO.setPurchaseAttachmentList(purchaseAttachmentList);
        return Result.ok((Object)((Object)purchaseBiddingHeadVO));
    }

    @ApiOperation(value="\u901a\u8fc7id\u67e5\u8be2\u53c2\u4e0e\u4eba\u5458", notes="\u901a\u8fc7id\u67e5\u8be2\u53c2\u4e0e\u4eba\u5458")
    @GetMapping(value={"/queryMemberById"})
    public Result<?> queryMemberById(@RequestParam(name="id") String id) {
        List<PurchaseBiddingSpecialist> purchaseBiddingSpecialistList = this.purchaseBiddingSpecialistService.selectByMainId(id);
        return Result.ok(purchaseBiddingSpecialistList);
    }

    @AutoLog(busModule="\u91c7\u8d2d\u62db\u6807\u7ba1\u7406", value="\u4fdd\u5b58\u53c2\u4e0e\u4eba\u5458")
    @ApiOperation(value="\u4fdd\u5b58\u53c2\u4e0e\u4eba\u5458", notes="\u4fdd\u5b58\u53c2\u4e0e\u4eba\u5458")
    @PostMapping(value={"/saveMember"})
    public Result<?> saveMember(@RequestBody BiddingMemberVO memberVO) {
        this.purchaseBiddingSpecialistService.saveMember(memberVO.getId(), memberVO.getPurchaseBiddingSpecialistList());
        return this.commonSuccessResult(3);
    }

    @AutoLog(busModule="\u91c7\u8d2d\u62db\u6807\u7ba1\u7406", value="\u901a\u8fc7id\u5f00\u6807")
    @ApiOperation(value="\u901a\u8fc7id\u5f00\u6807", notes="\u901a\u8fc7id\u5f00\u6807")
    @GetMapping(value={"/openBiddingById"})
    public Result<?> openBiddingById(@RequestParam(name="id") String id) {
        this.purchaseBiddingHeadService.openBidding(id);
        return this.commonSuccessResult(3);
    }

    @ApiOperation(value="\u901a\u8fc7id\u67e5\u8be2\u5b9a\u6807\u4fe1\u606f", notes="\u901a\u8fc7id\u67e5\u8be2\u5b9a\u6807\u4fe1\u606f")
    @GetMapping(value={"/queryConfirmBidById"})
    public Result<?> queryConfirmBidById(@RequestParam(name="id") String id) {
        List<BiddingSupplierVO> supplierList = this.biddingSupplierService.findConfirmBidList(id, true);
        ConfirmBidVO bidVO = new ConfirmBidVO();
        bidVO.setId(id);
        bidVO.setBiddingSupplierList(supplierList);
        return Result.ok((Object)bidVO);
    }

    @ApiOperation(value="\u901a\u8fc7id\u67e5\u8be2\u5b9a\u6807\u4fe1\u606f(\u4e0d\u6821\u9a8c\u8d1f\u8d23\u4eba)", notes="\u901a\u8fc7id\u67e5\u8be2\u5b9a\u6807\u4fe1\u606f(\u4e0d\u6821\u9a8c\u8d1f\u8d23\u4eba)")
    @GetMapping(value={"/queryConfirmBidByIdIgnore"})
    public Result<?> queryConfirmBidByIdIgnore(@RequestParam(name="id") String id) {
        List<BiddingSupplierVO> supplierList = this.biddingSupplierService.findConfirmBidList(id, false);
        ConfirmBidVO bidVO = new ConfirmBidVO();
        bidVO.setId(id);
        bidVO.setBiddingSupplierList(supplierList);
        return Result.ok((Object)bidVO);
    }

    @AutoLog(busModule="\u91c7\u8d2d\u62db\u6807\u7ba1\u7406", value="\u4fdd\u5b58\u5b9a\u6807\u7ed3\u679c")
    @ApiOperation(value="\u4fdd\u5b58\u5b9a\u6807\u7ed3\u679c", notes="\u4fdd\u5b58\u5b9a\u6807\u7ed3\u679c")
    @PostMapping(value={"/saveConfirmBid"})
    public Result<?> saveConfirmBid(@RequestBody ConfirmBidVO bidVO) {
        this.biddingSupplierService.confirmBid(bidVO.getId(), bidVO.getBiddingSupplierList());
        return this.commonSuccessResult(3);
    }

    @AutoLog(busModule="\u91c7\u8d2d\u62db\u6807\u7ba1\u7406", value="\u624b\u52a8\u751f\u6210\u4ef7\u683c\u8bb0\u5f55")
    @ApiOperation(value="\u624b\u52a8\u751f\u6210\u4ef7\u683c\u8bb0\u5f55", notes="\u624b\u52a8\u751f\u6210\u4ef7\u683c\u8bb0\u5f55")
    @GetMapping(value={"/manualCreatePrce"})
    public Result<?> manualCreatePrce(@RequestParam(name="id") String id) {
        this.biddingSupplierService.manualCreatePrce(id);
        return this.commonSuccessResult(3);
    }

    @AutoLog(busModule="\u91c7\u8d2d\u62db\u6807\u7ba1\u7406", value="\u67e5\u8be2\u4f9b\u5e94\u5546\u753b\u50cf\u53c2\u4e0e\u4fe1\u606f")
    @ApiOperation(value="\u67e5\u8be2\u4f9b\u5e94\u5546\u753b\u50cf\u53c2\u4e0e\u4fe1\u606f", notes="\u67e5\u8be2\u4f9b\u5e94\u5546\u753b\u50cf\u53c2\u4e0e\u4fe1\u606f")
    @GetMapping(value={"/queryByAccount"})
    public Result<?> queryByAccount(@RequestParam(name="toElsAccount") String toElsAccount) {
        List biddingSupplierList = this.biddingSupplierService.list((Wrapper)new QueryWrapper().eq((Object)"to_els_account", (Object)toElsAccount));
        List biddingWinList = biddingSupplierList.stream().filter(o -> BiddingItemStatusEnum.BIDDING_WIN.getValue().equals(o.getBiddingStatus())).collect(Collectors.toList());
        HashMap<String, Integer> resultMap = new HashMap<String, Integer>();
        resultMap.put("participationCount", biddingSupplierList.size());
        resultMap.put("biddingWinCount", biddingWinList.size());
        return Result.ok(resultMap);
    }
}

