/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.enquiry.handler;

import com.els.common.util.I18nUtil;
import com.els.modules.base.api.dto.TemplateConfigItemDTO;
import com.els.modules.base.api.dto.TemplateHeadDTO;
import com.els.modules.base.api.service.ExcelItemByConfigRpcService;
import com.els.modules.enquiry.entity.SaleEnquiryHead;
import com.els.modules.enquiry.entity.SaleEnquiryItem;
import com.els.modules.enquiry.enumerate.EnquiryQuoteWayEnum;
import com.els.modules.enquiry.service.SaleEnquiryHeadService;
import com.els.modules.enquiry.service.SaleEnquiryItemService;
import com.els.modules.inquiry.enumerate.QuoteTypeEnum;
import com.els.rpc.service.InvokeBaseRpcService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service(value="saleEnquiryItemExcelServiceImpl")
public class SaleEnquiryItemExcelServiceImpl
implements ExcelItemByConfigRpcService {
    @Autowired
    private SaleEnquiryHeadService saleEnquiryHeadService;
    @Autowired
    private SaleEnquiryItemService saleEnquiryItemService;
    @Resource
    private InvokeBaseRpcService invokeBaseRpcService;
    private String headId;

    public TemplateHeadDTO getTemplate(String headId) {
        this.headId = headId;
        SaleEnquiryHead dbHead = (SaleEnquiryHead)((Object)this.saleEnquiryHeadService.getById((Serializable)((Object)headId)));
        String account = StringUtils.isNotBlank((CharSequence)dbHead.getTemplateAccount()) ? dbHead.getTemplateAccount() : dbHead.getBusAccount();
        String templateVersion = String.valueOf(dbHead.getTemplateVersion());
        return this.invokeBaseRpcService.getTemplateConfig(account, dbHead.getTemplateNumber(), templateVersion);
    }

    public List<Object> getExportData(String headId) {
        List<SaleEnquiryItem> itemList = this.saleEnquiryItemService.selectByMainId(headId);
        return new ArrayList<SaleEnquiryItem>(itemList);
    }

    public void importExcel(List<Map<String, Object>> dataList) {
        SaleEnquiryHead dbHead = (SaleEnquiryHead)((Object)this.saleEnquiryHeadService.getById((Serializable)((Object)this.headId)));
        List<String> excludeColumn = Arrays.asList("price", "netPrice", "taxCode", "taxRate");
        List editColumn = this.getTemplate(this.headId).getTemplateConfigItemList().stream().filter(item -> "1".equals(item.getSaleEdit())).filter(item -> !excludeColumn.contains(item.getFieldName())).map(TemplateConfigItemDTO::getFieldName).collect(Collectors.toList());
        if ("1".equals(dbHead.getSupplierTaxRate())) {
            editColumn.add("taxCode");
        }
        if (QuoteTypeEnum.TAX_INCLUDING.getValue().equals(dbHead.getQuoteType())) {
            editColumn.add("price");
        } else {
            editColumn.add("netPrice");
        }
        Map taxMap = this.invokeBaseRpcService.getAllTax(dbHead.getToElsAccount());
        for (Map<String, Object> data : dataList) {
            String taxCode;
            for (String field : data.keySet()) {
                if (editColumn.contains(field)) continue;
                data.put(field, null);
            }
            if (!EnquiryQuoteWayEnum.NORMAL.getValue().equals(data.get("quotePriceWay"))) {
                data.put("price", null);
                data.put("netPrice", null);
            }
            if (!StringUtils.isNotBlank((CharSequence)(taxCode = (String)data.get("taxCode")))) continue;
            Assert.isTrue((boolean)taxMap.containsKey(taxCode), (String)I18nUtil.translate((String)"", (String)("\u7a0e\u7801\uff1a" + taxCode + "\u4e0d\u5b58\u5728")));
            data.put("taxRate", taxMap.get(taxCode));
        }
    }
}

