/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.demand.excel;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.text.CharSequenceUtil;
import com.alibaba.fastjson.JSON;
import com.els.common.enumerate.AuditStatusEnum;
import com.els.common.util.I18nUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.base.api.dto.TemplateHeadDTO;
import com.els.modules.base.api.service.ExcelImportRpcService;
import com.els.modules.demand.entity.PurchaseRequestHead;
import com.els.modules.demand.enumerate.PurchaseRequestStatusEnum;
import com.els.modules.demand.service.PurchaseRequestHeadService;
import com.els.rpc.service.InvokeBaseRpcService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service(value="purchaseRequestHeadExcelImportServiceImpl")
public class PurchaseRequestHeadExcelImportServiceImpl
implements ExcelImportRpcService {
    @Autowired
    private InvokeBaseRpcService invokeBaseRpcService;
    @Autowired
    PurchaseRequestHeadService purchaseRequestHeadService;

    public void importExcel(List<Map<String, Object>> dataList) {
        List templateList = this.invokeBaseRpcService.getDefaultTemplateByType("purchaseRequest");
        Assert.notEmpty((Collection)templateList, (String)I18nUtil.translate((String)"", (String)"\u8bf7\u5148\u914d\u7f6e\u91c7\u8d2d\u7533\u8bf7\u4e1a\u52a1\u6a21\u677f"));
        ArrayList<PurchaseRequestHead> entityList = new ArrayList<PurchaseRequestHead>();
        for (Map<String, Object> data : dataList) {
            PurchaseRequestHead entity = (PurchaseRequestHead)((Object)JSON.parseObject((String)JSON.toJSONString(data), PurchaseRequestHead.class));
            entity.setElsAccount(TenantContext.getTenant());
            entity.setTemplateName(((TemplateHeadDTO)templateList.get(0)).getTemplateName());
            entity.setTemplateNumber(((TemplateHeadDTO)templateList.get(0)).getTemplateNumber());
            entity.setTemplateAccount(((TemplateHeadDTO)templateList.get(0)).getElsAccount());
            entity.setApplyDate(new Date());
            entity.setRequestStatus(PurchaseRequestStatusEnum.REQUEST_NEW.getValue());
            entity.setAuditStatus(AuditStatusEnum.AUDIT_NEW.getValue());
            if ("0".equals(entity.getAudit())) {
                entity.setAuditStatus(AuditStatusEnum.NO_AUDIT_REQUIRED.getValue());
            } else if ("1".equals(entity.getAudit()) && AuditStatusEnum.NO_AUDIT_REQUIRED.getValue().equals(entity.getAuditStatus())) {
                entity.setAuditStatus(AuditStatusEnum.AUDIT_NEW.getValue());
            }
            entityList.add(entity);
        }
        if (CollUtil.isEmpty(entityList)) {
            return;
        }
        PurchaseRequestHead head = (PurchaseRequestHead)((Object)entityList.get(0));
        long size = entityList.stream().map(PurchaseRequestHead::getRequestNumber).filter(CharSequenceUtil::isNotEmpty).count();
        List nextCodes = this.invokeBaseRpcService.getNextCodes("srmPurchaseRequestNumber", (Object)head, (int)size);
        int codeIndex = 0;
        for (PurchaseRequestHead e : entityList) {
            if (!CharSequenceUtil.isEmpty((CharSequence)e.getRequestNumber())) continue;
            e.setRequestNumber((String)nextCodes.get(codeIndex++));
        }
        this.purchaseRequestHeadService.saveBatch(entityList);
    }
}

