/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.specialist.service.impl;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.els.common.aspect.annotation.SrmTransaction;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.util.SysUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.org.api.dto.PurchaseOrganizationInfoDTO;
import com.els.modules.specialist.entity.SpecialistEducationExperienceInfo;
import com.els.modules.specialist.entity.SpecialistHistoryBiddingInfo;
import com.els.modules.specialist.entity.SpecialistInfo;
import com.els.modules.specialist.entity.SpecialistProfessionalResumeInfo;
import com.els.modules.specialist.entity.SpecialistProfessionalSuccessInfo;
import com.els.modules.specialist.mapper.SpecialistEducationExperienceInfoMapper;
import com.els.modules.specialist.mapper.SpecialistHistoryBiddingInfoMapper;
import com.els.modules.specialist.mapper.SpecialistInfoMapper;
import com.els.modules.specialist.mapper.SpecialistProfessionalResumeInfoMapper;
import com.els.modules.specialist.mapper.SpecialistProfessionalSuccessInfoMapper;
import com.els.modules.specialist.rpc.service.SpecialistInvokeOrgRpcService;
import com.els.modules.specialist.service.SpecialistInfoService;
import java.io.Serializable;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SpecialistInfoServiceImpl
extends ServiceImpl<SpecialistInfoMapper, SpecialistInfo>
implements SpecialistInfoService {
    @Autowired
    private SpecialistInfoMapper specialistInfoMapper;
    @Autowired
    private SpecialistEducationExperienceInfoMapper specialistEducationExperienceInfoMapper;
    @Autowired
    private SpecialistHistoryBiddingInfoMapper specialistHistoryBiddingInfoMapper;
    @Autowired
    private SpecialistProfessionalResumeInfoMapper specialistProfessionalResumeInfoMapper;
    @Autowired
    private SpecialistProfessionalSuccessInfoMapper specialistProfessionalSuccessInfoMapper;
    @Autowired
    private SpecialistInvokeOrgRpcService specialistInvokeOrgRpcService;

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void saveMain(SpecialistInfo specialistInfo, List<SpecialistEducationExperienceInfo> specialistEducationExperienceInfoList, List<SpecialistHistoryBiddingInfo> specialistHistoryBiddingInfoList, List<SpecialistProfessionalResumeInfo> specialistProfessionalResumeInfoList, List<SpecialistProfessionalSuccessInfo> specialistProfessionalSuccessInfoList) {
        this.specialistInfoMapper.insert((Object)specialistInfo);
        this.insertData(specialistInfo, specialistEducationExperienceInfoList, specialistHistoryBiddingInfoList, specialistProfessionalResumeInfoList, specialistProfessionalSuccessInfoList);
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void updateMain(SpecialistInfo specialistInfo, List<SpecialistEducationExperienceInfo> specialistEducationExperienceInfoList, List<SpecialistHistoryBiddingInfo> specialistHistoryBiddingInfoList, List<SpecialistProfessionalResumeInfo> specialistProfessionalResumeInfoList, List<SpecialistProfessionalSuccessInfo> specialistProfessionalSuccessInfoList) {
        if (StringUtils.isNotBlank((CharSequence)specialistInfo.getPurchaseOrg())) {
            String orgDesc = "";
            if (specialistInfo.getPurchaseOrg().contains(",")) {
                String[] orgs;
                for (String string : orgs = specialistInfo.getPurchaseOrg().split(",")) {
                    PurchaseOrganizationInfoDTO organizationInfo = this.specialistInvokeOrgRpcService.selectByElsAccountAndCode(TenantContext.getTenant(), "purchaseOrganization", string);
                    if (organizationInfo == null) {
                        organizationInfo = this.specialistInvokeOrgRpcService.selectByElsAccountAndCode("100000", "purchaseOrganization", string);
                    }
                    orgDesc = orgDesc + string + "_" + organizationInfo.getOrgName() + ",";
                }
            } else {
                PurchaseOrganizationInfoDTO organizationInfo = this.specialistInvokeOrgRpcService.selectByElsAccountAndCode(TenantContext.getTenant(), "purchaseOrganization", specialistInfo.getPurchaseOrg());
                if (organizationInfo == null) {
                    organizationInfo = this.specialistInvokeOrgRpcService.selectByElsAccountAndCode("100000", "purchaseOrganization", specialistInfo.getPurchaseOrg());
                }
                orgDesc = specialistInfo.getPurchaseOrg() + "_" + organizationInfo.getOrgName();
            }
            specialistInfo.setPurchaseOrgDesc(orgDesc);
        }
        this.specialistInfoMapper.updateById((Object)specialistInfo);
        this.specialistEducationExperienceInfoMapper.deleteByMainId(specialistInfo.getId());
        this.specialistHistoryBiddingInfoMapper.deleteByMainId(specialistInfo.getId());
        this.specialistProfessionalResumeInfoMapper.deleteByMainId(specialistInfo.getId());
        this.specialistProfessionalSuccessInfoMapper.deleteByMainId(specialistInfo.getId());
        this.insertData(specialistInfo, specialistEducationExperienceInfoList, specialistHistoryBiddingInfoList, specialistProfessionalResumeInfoList, specialistProfessionalSuccessInfoList);
    }

    private void insertData(SpecialistInfo specialistInfo, List<SpecialistEducationExperienceInfo> specialistEducationExperienceInfoList, List<SpecialistHistoryBiddingInfo> specialistHistoryBiddingInfoList, List<SpecialistProfessionalResumeInfo> specialistProfessionalResumeInfoList, List<SpecialistProfessionalSuccessInfo> specialistProfessionalSuccessInfoList) {
        if (specialistEducationExperienceInfoList != null) {
            for (SpecialistEducationExperienceInfo specialistEducationExperienceInfo : specialistEducationExperienceInfoList) {
                specialistEducationExperienceInfo.setHeadId(specialistInfo.getId());
                SysUtil.setSysParam((BaseEntity)specialistEducationExperienceInfo, (BaseEntity)specialistInfo);
            }
            if (!specialistEducationExperienceInfoList.isEmpty()) {
                this.specialistEducationExperienceInfoMapper.insertBatchSomeColumn(specialistEducationExperienceInfoList);
            }
        }
        if (specialistHistoryBiddingInfoList != null) {
            for (SpecialistHistoryBiddingInfo specialistHistoryBiddingInfo : specialistHistoryBiddingInfoList) {
                specialistHistoryBiddingInfo.setHeadId(specialistInfo.getId());
                SysUtil.setSysParam((BaseEntity)specialistHistoryBiddingInfo, (BaseEntity)specialistInfo);
            }
            if (!specialistHistoryBiddingInfoList.isEmpty()) {
                this.specialistHistoryBiddingInfoMapper.insertBatchSomeColumn(specialistHistoryBiddingInfoList);
            }
        }
        if (specialistProfessionalResumeInfoList != null) {
            for (SpecialistProfessionalResumeInfo specialistProfessionalResumeInfo : specialistProfessionalResumeInfoList) {
                specialistProfessionalResumeInfo.setHeadId(specialistInfo.getId());
                SysUtil.setSysParam((BaseEntity)specialistProfessionalResumeInfo, (BaseEntity)specialistInfo);
            }
            if (!specialistProfessionalResumeInfoList.isEmpty()) {
                this.specialistProfessionalResumeInfoMapper.insertBatchSomeColumn(specialistProfessionalResumeInfoList);
            }
        }
        if (specialistProfessionalSuccessInfoList != null) {
            for (SpecialistProfessionalSuccessInfo specialistProfessionalSuccessInfo : specialistProfessionalSuccessInfoList) {
                specialistProfessionalSuccessInfo.setHeadId(specialistInfo.getId());
                SysUtil.setSysParam((BaseEntity)specialistProfessionalSuccessInfo, (BaseEntity)specialistInfo);
            }
            if (!specialistProfessionalSuccessInfoList.isEmpty()) {
                this.specialistProfessionalSuccessInfoMapper.insertBatchSomeColumn(specialistProfessionalSuccessInfoList);
            }
        }
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void delMain(String id) {
        this.specialistEducationExperienceInfoMapper.deleteByMainId(id);
        this.specialistHistoryBiddingInfoMapper.deleteByMainId(id);
        this.specialistProfessionalResumeInfoMapper.deleteByMainId(id);
        this.specialistProfessionalSuccessInfoMapper.deleteByMainId(id);
        this.specialistInfoMapper.deleteById((Serializable)((Object)id));
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void delBatchMain(List<String> idList) {
        for (Serializable serializable : idList) {
            this.specialistEducationExperienceInfoMapper.deleteByMainId(serializable.toString());
            this.specialistHistoryBiddingInfoMapper.deleteByMainId(serializable.toString());
            this.specialistProfessionalResumeInfoMapper.deleteByMainId(serializable.toString());
            this.specialistProfessionalSuccessInfoMapper.deleteByMainId(serializable.toString());
            this.specialistInfoMapper.deleteById(serializable);
        }
    }
}

