/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.forecast.excel;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.els.common.util.I18nUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.base.api.service.ExcelImportRpcService;
import com.els.modules.demand.rpc.PurchaseMaterialHeadLocalRpcService;
import com.els.modules.forecast.entity.PurchaseForecastDetail;
import com.els.modules.forecast.service.PurchaseForecastDetailService;
import com.els.modules.material.api.dto.PurchaseMaterialHeadDTO;
import com.els.modules.supplier.api.dto.SupplierMasterDataDTO;
import com.els.rpc.service.CoreInvokeSupplierRpcService;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service
public class ForecastExcelImportServiceImpl
implements ExcelImportRpcService {
    @Autowired
    private PurchaseForecastDetailService purchaseForecastDetailService;
    @Resource
    private PurchaseMaterialHeadLocalRpcService purchaseMaterialHeadLocalRpcService;
    @Resource
    private CoreInvokeSupplierRpcService coreInvokeSupplierRpcService;

    public void importExcel(List<Map<String, Object>> dataList) {
        ArrayList<String> materialNumberList = new ArrayList<String>();
        ArrayList<String> toElsAccountList = new ArrayList<String>();
        for (Map<String, Object> map : dataList) {
            PurchaseForecastDetail detail = (PurchaseForecastDetail)((Object)JSON.parseObject((String)JSON.toJSONString(map), PurchaseForecastDetail.class));
            String materialNumber = detail.getMaterialNumber();
            Assert.hasText((String)materialNumber, (String)I18nUtil.translate((String)"", (String)"\u7269\u6599\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a"));
            materialNumberList.add(materialNumber);
            String toElsAccount = detail.getToElsAccount();
            toElsAccountList.add(toElsAccount);
        }
        List<PurchaseMaterialHeadDTO> materialList = this.purchaseMaterialHeadLocalRpcService.listByMaterialNumbers(materialNumberList);
        Map materialMap = materialList.stream().collect(Collectors.toMap(PurchaseMaterialHeadDTO::getMaterialNumber, Function.identity(), (newVal, oldVal) -> oldVal));
        Map<Object, Object> supplierMap = new HashMap();
        if (CollectionUtil.isNotEmpty(toElsAccountList)) {
            List supplierList = this.coreInvokeSupplierRpcService.selectSupplerList(TenantContext.getTenant(), toElsAccountList);
            supplierMap = supplierList.stream().collect(Collectors.toMap(SupplierMasterDataDTO::getToElsAccount, Function.identity(), (newVal, oldVal) -> oldVal));
        }
        for (Map<String, Object> map : dataList) {
            PurchaseForecastDetail detail = (PurchaseForecastDetail)((Object)JSON.parseObject((String)JSON.toJSONString(map), PurchaseForecastDetail.class));
            String materialNumber = detail.getMaterialNumber();
            PurchaseMaterialHeadDTO materialHead = (PurchaseMaterialHeadDTO)materialMap.get(materialNumber);
            Assert.notNull((Object)materialHead, (String)I18nUtil.translate((String)"", (String)"\u7269\u6599\u7f16\u7801\uff1a${0}\u4e0d\u5b58\u5728", (String[])new String[]{materialNumber}));
            detail.setMaterialName(materialHead.getMaterialName());
            detail.setMaterialDesc(materialHead.getMaterialDesc());
            detail.setMaterialGroup(materialHead.getMaterialGroup());
            detail.setMaterialGroupName(materialHead.getMaterialGroupName());
            detail.setMaterialCateCode(materialHead.getCateCode());
            detail.setMaterialCateName(materialHead.getCateName());
            String toElsAccount = detail.getToElsAccount();
            if (StrUtil.isNotBlank((CharSequence)toElsAccount)) {
                SupplierMasterDataDTO supplier = (SupplierMasterDataDTO)supplierMap.get(toElsAccount);
                Assert.notNull((Object)supplier, (String)I18nUtil.translate((String)"", (String)"\u4f9b\u5e94\u5546\uff1a${0}\u4e0d\u5b58\u5728", (String[])new String[]{toElsAccount}));
                detail.setSupplierName(supplier.getSupplierName());
                detail.setSupplierCode(supplier.getSupplierCode());
            }
            this.purchaseForecastDetailService.add(detail);
            if (!StrUtil.isNotBlank((CharSequence)toElsAccount)) continue;
            this.purchaseForecastDetailService.submit(detail);
        }
    }
}

