/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.forecast.service.impl;

import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.config.mybatis.TenantContext;
import com.els.modules.forecast.entity.PurchaseForecastWhitelist;
import com.els.modules.forecast.enumerate.WhitelistStatusEnum;
import com.els.modules.forecast.mapper.PurchaseForecastWhitelistMapper;
import com.els.modules.forecast.service.PurchaseForecastWhitelistService;
import com.els.rpc.service.InvokeBaseRpcService;
import java.io.Serializable;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

@Service
public class PurchaseForecastWhitelistServiceImpl
extends BaseServiceImpl<PurchaseForecastWhitelistMapper, PurchaseForecastWhitelist>
implements PurchaseForecastWhitelistService {
    @Resource
    private InvokeBaseRpcService invokeBaseRpcService;

    @Override
    public void add(PurchaseForecastWhitelist whitelist) {
        whitelist.setElsAccount(TenantContext.getTenant());
        whitelist.setBusAccount(TenantContext.getTenant());
        String whitelistNumber = this.invokeBaseRpcService.getNextCode("srmForecastWhitelistNumber", (Object)whitelist);
        whitelist.setWhitelistNumber(whitelistNumber);
        whitelist.setWhitelistStatus(WhitelistStatusEnum.NEW.getValue());
        ((PurchaseForecastWhitelistMapper)this.baseMapper).insert((Object)whitelist);
    }

    @Override
    public void submit(PurchaseForecastWhitelist whitelist) {
        whitelist.setElsAccount(TenantContext.getTenant());
        whitelist.setBusAccount(TenantContext.getTenant());
        whitelist.setWhitelistStatus(WhitelistStatusEnum.ENABLE.getValue());
        whitelist.setMaterialGroup(StringUtils.isBlank((CharSequence)whitelist.getMaterialGroup()) ? "all" : whitelist.getMaterialGroup());
        ((PurchaseForecastWhitelistMapper)this.baseMapper).updateById((Object)whitelist);
    }

    @Override
    public void delete(String id) {
        ((PurchaseForecastWhitelistMapper)this.baseMapper).deleteById((Serializable)((Object)id));
    }

    @Override
    public void enable(String id) {
        PurchaseForecastWhitelist whitelist = new PurchaseForecastWhitelist();
        whitelist.setId(id);
        whitelist.setWhitelistStatus(WhitelistStatusEnum.ENABLE.getValue());
        ((PurchaseForecastWhitelistMapper)this.baseMapper).updateById((Object)whitelist);
    }

    @Override
    public void disable(String id) {
        PurchaseForecastWhitelist whitelist = new PurchaseForecastWhitelist();
        whitelist.setId(id);
        whitelist.setWhitelistStatus(WhitelistStatusEnum.DISABLE.getValue());
        ((PurchaseForecastWhitelistMapper)this.baseMapper).updateById((Object)whitelist);
    }
}

