/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.enquiry.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.util.SpringContextUtils;
import com.els.config.mybatis.TenantContext;
import com.els.modules.enquiry.entity.PurchaseEnquiryHead;
import com.els.modules.enquiry.entity.PurchaseEnquiryItemHis;
import com.els.modules.enquiry.entity.SaleEnquiryHead;
import com.els.modules.enquiry.entity.SaleEnquiryItem;
import com.els.modules.enquiry.mapper.PurchaseEnquiryItemHisMapper;
import com.els.modules.enquiry.service.PurchaseEnquiryHeadService;
import com.els.modules.enquiry.service.PurchaseEnquiryItemHisService;
import com.els.modules.enquiry.vo.CurrentQuoteTrendVO;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;

@Service
public class PurchaseEnquiryItemHisServiceImpl
extends ServiceImpl<PurchaseEnquiryItemHisMapper, PurchaseEnquiryItemHis>
implements PurchaseEnquiryItemHisService {
    @Override
    public void saveQuoteItemHis(SaleEnquiryHead saleHead, List<SaleEnquiryItem> needRecordList) {
        ArrayList<PurchaseEnquiryItemHis> purchaseItemHisList = new ArrayList<PurchaseEnquiryItemHis>();
        for (SaleEnquiryItem saleItem : needRecordList) {
            PurchaseEnquiryItemHis purchaseHis = new PurchaseEnquiryItemHis();
            BeanUtils.copyProperties((Object)((Object)saleItem), (Object)((Object)purchaseHis));
            purchaseHis.setId(null);
            purchaseHis.setElsAccount(saleItem.getToElsAccount());
            purchaseHis.setRelationId(null);
            purchaseHis.setHeadId(saleHead.getRelationId());
            purchaseHis.setItemId(saleItem.getRelationId());
            purchaseHis.setToElsAccount(saleItem.getElsAccount());
            purchaseItemHisList.add(purchaseHis);
        }
        ((PurchaseEnquiryItemHisMapper)this.baseMapper).insertBatchSomeColumn(purchaseItemHisList);
    }

    @Override
    public CurrentQuoteTrendVO findQuoteHis(String enquiryNumber, String itemNumber) {
        String elsAccount = TenantContext.getTenant();
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)queryWrapper.eq(BaseEntity::getElsAccount, (Object)elsAccount)).eq(PurchaseEnquiryItemHis::getEnquiryNumber, (Object)enquiryNumber);
        if (StrUtil.isNotBlank((CharSequence)itemNumber)) {
            queryWrapper.eq(PurchaseEnquiryItemHis::getItemNumber, (Object)itemNumber);
        }
        queryWrapper.orderByAsc(PurchaseEnquiryItemHis::getQuoteCount);
        CurrentQuoteTrendVO trendVO = new CurrentQuoteTrendVO();
        List list = ((PurchaseEnquiryItemHisMapper)this.baseMapper).selectList((Wrapper)queryWrapper);
        this.hidePrice(list);
        List<String> legendData = list.parallelStream().map(PurchaseEnquiryItemHis::getSupplierName).distinct().collect(Collectors.toList());
        trendVO.setLegendData(legendData);
        List<Integer> xAxisData = list.parallelStream().map(PurchaseEnquiryItemHis::getQuoteCount).distinct().collect(Collectors.toList());
        trendVO.setXAxisData(xAxisData);
        Map<String, List<PurchaseEnquiryItemHis>> itemMap = list.parallelStream().collect(Collectors.groupingBy(PurchaseEnquiryItemHis::getSupplierName));
        JSONArray array = new JSONArray();
        for (String supplierName : itemMap.keySet()) {
            JSONObject object = new JSONObject();
            object.put("name", (Object)supplierName);
            object.put("type", (Object)"bar");
            List<PurchaseEnquiryItemHis> itemList = itemMap.get(supplierName);
            List priceList = itemList.parallelStream().filter(item -> item.getPrice() != null).map(PurchaseEnquiryItemHis::getPrice).collect(Collectors.toList());
            object.put("data", priceList);
            array.add((Object)object);
        }
        trendVO.setSeries(array);
        return trendVO;
    }

    private void hidePrice(List<PurchaseEnquiryItemHis> list) {
        if (CollectionUtil.isNotEmpty(list)) {
            boolean showPrice;
            PurchaseEnquiryHead dbHead = (PurchaseEnquiryHead)((Object)((PurchaseEnquiryHeadService)SpringContextUtils.getBean(PurchaseEnquiryHeadService.class)).getById((Serializable)((Object)list.get(0).getHeadId())));
            boolean bl = showPrice = !"0".equals(dbHead.getSeePrice()) || "1".equals(dbHead.getOpenBidStatus()) || dbHead.getQuoteEndTime().before(new Date());
            if (!showPrice) {
                for (PurchaseEnquiryItemHis item : list) {
                    item.setPrice(null);
                    item.setNetPrice(null);
                    item.setTaxAmount(null);
                    item.setNetAmount(null);
                }
            }
        }
    }
}

