/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.demand.controller;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.conditions.update.LambdaUpdateChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.els.common.api.vo.JiMuResult;
import com.els.common.api.vo.Result;
import com.els.common.aspect.annotation.AutoLog;
import com.els.common.aspect.annotation.PermissionDataOpt;
import com.els.common.aspect.annotation.PermissionDataView;
import com.els.common.enumerate.AuditStatusEnum;
import com.els.common.exception.ELSBootException;
import com.els.common.system.base.controller.BaseController;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.query.QueryGenerator;
import com.els.common.util.I18nUtil;
import com.els.common.vo.CountVO;
import com.els.modules.base.api.dto.DictDTO;
import com.els.modules.base.api.dto.TemplateHeadDTO;
import com.els.modules.demand.entity.PurchaseRequestHead;
import com.els.modules.demand.entity.PurchaseRequestItem;
import com.els.modules.demand.enumerate.PurchaseRequestStatusEnum;
import com.els.modules.demand.enumerate.PurchaseRequestStatusItemEnum;
import com.els.modules.demand.rpc.BudgetManageLocalRpcService;
import com.els.modules.demand.rpc.PurchaseMaterialHeadLocalRpcService;
import com.els.modules.demand.rpc.PurchaseProductInventoryLocalRpcService;
import com.els.modules.demand.rpc.PurchaseUserCartLocalRpcService;
import com.els.modules.demand.rpc.TemplateLocalRpcService;
import com.els.modules.demand.service.PurchaseRequestHeadService;
import com.els.modules.demand.service.PurchaseRequestItemService;
import com.els.modules.demand.vo.PurchaseRequestHeadVO;
import com.els.modules.material.api.dto.PurchaseMaterialHeadDTO;
import com.els.modules.product.api.dto.PurchaseProductInventoryDTO;
import com.els.modules.product.api.dto.PurchaseUserCartDTO;
import com.els.rpc.service.InvokeBaseRpcService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/demand/purchaseRequestHead"})
@Api(tags={"\u91c7\u8d2d\u7533\u8bf7\u5934"})
public class PurchaseRequestHeadController
extends BaseController<PurchaseRequestHead, PurchaseRequestHeadService> {
    private static final Logger log = LoggerFactory.getLogger(PurchaseRequestHeadController.class);
    @Autowired
    private PurchaseRequestHeadService purchaseRequestHeadService;
    @Autowired
    private PurchaseRequestItemService purchaseRequestItemService;
    @Resource
    private InvokeBaseRpcService invokeBaseRpcService;
    @Resource
    private BudgetManageLocalRpcService budgetManageRpcService;
    @Resource
    private TemplateLocalRpcService templateHeadService;
    @Resource
    private PurchaseUserCartLocalRpcService purchaseUserCartService;
    @Resource
    private PurchaseProductInventoryLocalRpcService purchaseProductInventoryService;
    @Resource
    private PurchaseMaterialHeadLocalRpcService purchaseMaterialHeadService;

    @GetMapping(value={"/list"})
    @PermissionDataView(businessType="purchaseRequest")
    public Result<?> queryPageList(PurchaseRequestHead purchaseRequestHead, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)purchaseRequestHead), (Map)req.getParameterMap());
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        IPage pageList = this.purchaseRequestHeadService.page((IPage)page, (Wrapper)queryWrapper);
        return Result.ok((Object)pageList);
    }

    @GetMapping(value={"/queryPageJimuList"})
    @PermissionDataView(businessType="purchaseRequest")
    public JiMuResult<?> queryPageJimuList(PurchaseRequestHead purchaseRequestHead, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)purchaseRequestHead), (Map)req.getParameterMap());
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        IPage pageList = this.purchaseRequestHeadService.page((IPage)page, (Wrapper)queryWrapper);
        return JiMuResult.ok((Object)pageList);
    }

    @AutoLog(value="\u8f6c\u8ba2\u5355-\u5339\u914d\u4ef7\u683c\u4fe1\u606f\u8bb0\u5f55")
    @ApiOperation(value="\u9700\u6c42\u5355\u5339\u914d\u4ef7\u683c\u4fe1\u606f\u8bb0\u5f55", notes="\u9700\u6c42\u5355\u5339\u914d\u4ef7\u683c\u4fe1\u606f\u8bb0\u5f55")
    @PostMapping(value={"/requestMatchInfomationRecord"})
    public Result<?> requestMatchInfomationRecord(@RequestBody List<PurchaseRequestItem> requestItemList) {
        Assert.notEmpty(requestItemList, (String)I18nUtil.translate((String)"i18n_alert_empty_toOrderLine", (String)"\u9009\u62e9\u7684\u8f6c\u8ba2\u5355\u7684\u9700\u6c42\u884c\u4e0d\u80fd\u4e3a\u7a7a"));
        String res = this.purchaseRequestHeadService.matchInformationRecords(requestItemList);
        return Result.ok((String)res);
    }

    @ApiOperation(value="\u5408\u540c\u67e5\u8be2\u91c7\u8d2d\u7533\u8bf7\u884c\u5206\u9875\u4fe1\u606f", notes="\u5408\u540c\u67e5\u8be2\u91c7\u8d2d\u7533\u8bf7\u884c\u5206\u9875\u4fe1\u606f")
    @GetMapping(value={"/contractQueryRequest"})
    public Result<?> contractQueryRequest(PurchaseRequestItem item, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)item), (Map)req.getParameterMap());
        queryWrapper.and(qw -> {
            QueryWrapper cfr_ignored_0 = (QueryWrapper)((QueryWrapper)((QueryWrapper)qw.eq((Object)"audit_status", (Object)AuditStatusEnum.AUDIT_FINISH.getValue())).or()).eq((Object)"audit_status", (Object)AuditStatusEnum.NO_AUDIT_REQUIRED.getValue());
        });
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        IPage pageList = this.purchaseRequestItemService.page((IPage)page, (Wrapper)queryWrapper);
        return Result.ok((Object)pageList);
    }

    @ApiOperation(value="\u6dfb\u52a0", notes="\u6dfb\u52a0")
    @AutoLog(busModule="\u91c7\u8d2d\u7533\u8bf7\u7ba1\u7406", value="\u6dfb\u52a0")
    @PostMapping(value={"/add"})
    @RequiresPermissions(value={"purchaseRequestHead:add"})
    @PermissionDataOpt(businessType="purchaseRequest", beanClass=PurchaseRequestHeadService.class)
    public Result<?> add(@RequestBody PurchaseRequestHeadVO purchaseRequestHeadPage) {
        PurchaseRequestHeadVO purchaseRequestHead = new PurchaseRequestHeadVO();
        BeanUtils.copyProperties((Object)((Object)purchaseRequestHeadPage), (Object)((Object)purchaseRequestHead));
        this.purchaseRequestHeadService.saveMain(purchaseRequestHead, purchaseRequestHeadPage.getPurchaseRequestItemList(), purchaseRequestHeadPage.getPurchaseAttachmentList());
        return Result.ok((Object)((Object)purchaseRequestHead));
    }

    @ApiOperation(value="\u7f16\u8f91", notes="\u7f16\u8f91")
    @PostMapping(value={"/edit"})
    @AutoLog(busModule="\u9700\u6c42\u6c60\u7ba1\u7406", value="\u7f16\u8f91")
    @RequiresPermissions(value={"purchaseRequestHead:edit"})
    @PermissionDataOpt(businessType="purchaseRequest", beanClass=PurchaseRequestHeadService.class)
    public Result<?> edit(@RequestBody PurchaseRequestHeadVO purchaseRequestHeadPage) {
        PurchaseRequestHeadVO purchaseRequestHead = new PurchaseRequestHeadVO();
        BeanUtils.copyProperties((Object)((Object)purchaseRequestHeadPage), (Object)((Object)purchaseRequestHead));
        this.purchaseRequestHeadService.updateMain(purchaseRequestHead, purchaseRequestHeadPage.getPurchaseRequestItemList(), purchaseRequestHeadPage.getPurchaseAttachmentList());
        return Result.ok((Object)((Object)purchaseRequestHead));
    }

    @ApiOperation(value="\u91c7\u8d2d\u7533\u8bf7\u5934-\u4f5c\u5e9f", notes="\u91c7\u8d2d\u7533\u8bf7\u5934-\u4f5c\u5e9f")
    @PostMapping(value={"/cancel"})
    @AutoLog(busModule="\u9700\u6c42\u6c60\u7ba1\u7406", value="\u4f5c\u5e9f")
    @RequiresPermissions(value={"purchaseRequestHead:cancel"})
    @PermissionDataOpt(businessType="purchaseRequest", beanClass=PurchaseRequestHeadService.class)
    public Result<?> cancel(@RequestBody PurchaseRequestHeadVO head) {
        head.setRequestStatus(PurchaseRequestStatusEnum.REQUEST_CANCAL.getValue());
        this.purchaseRequestHeadService.updateStatus(head);
        return this.commonSuccessResult(7);
    }

    @AutoLog(busModule="\u9700\u6c42\u6c60\u7ba1\u7406", value="\u63d0\u4ea4")
    @ApiOperation(value="\u91c7\u8d2d\u7533\u8bf7-\u63d0\u4ea4\u9700\u6c42\u6c60", notes="\u91c7\u8d2d\u7533\u8bf7-\u63d0\u4ea4\u9700\u6c42\u6c60")
    @PostMapping(value={"/toDemandPool"})
    public Result<?> toDemandPool(@RequestBody PurchaseRequestHeadVO purchaseRequestHeadPage) {
        this.edit(purchaseRequestHeadPage);
        List<PurchaseRequestItem> purchaseRequestItems = this.purchaseRequestItemService.selectByMainId(purchaseRequestHeadPage.getId());
        if (CollectionUtils.isEmpty(purchaseRequestItems)) {
            throw new ELSBootException(I18nUtil.translate((String)"", (String)"\u63d0\u4ea4\u5230\u9700\u6c42\u6c60\u81f3\u5c11\u6709\u4e00\u4e2a\u884c\u9879\u76ee"));
        }
        HashMap itemStatusMap = new HashMap();
        purchaseRequestItems.forEach(item -> {
            Assert.isTrue((boolean)StringUtils.isNotBlank((CharSequence)item.getMaterialNumber()), (String)I18nUtil.translate((String)"", (String)"\u884c\u7269\u6599\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a"));
            Assert.isTrue((item.getQuantity() != null ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_alert_empty_notQuantity", (String)"\u884c\u9700\u6c42\u6570\u91cf\u4e0d\u80fd\u4e3a\u7a7a"));
            Assert.isTrue((item.getQuantity().compareTo(BigDecimal.ZERO) > 0 ? 1 : 0) != 0, (String)I18nUtil.translate((String)"", (String)"\u884c\u9700\u6c42\u6570\u91cf\u5fc5\u987b\u5927\u4e8e0"));
            Assert.isTrue((boolean)StringUtils.isNotBlank((CharSequence)item.getPurchaseOrg()), (String)"\u884c\u4e0a\u7684\u91c7\u8d2d\u7ec4\u7ec7\u4e0d\u80fd\u4e3a\u7a7a,\u8bf7\u5728\u8ba2\u5355\u6743\u9650\u4e2d\u7ef4\u62a4,\u6216\u8005\u7ec4\u7ec7\u8bbe\u7f6e\u4e2d\u7ef4\u62a4\u5de5\u5382\u5bf9\u5e94\u7684\u5173\u8054\u7ec4\u7ec7!");
            Assert.isTrue((boolean)StringUtils.isNotBlank((CharSequence)item.getCompany()), (String)"\u884c\u4e0a\u7684\u516c\u53f8\u4ee3\u7801\u4e0d\u80fd\u4e3a\u7a7a,\u8bf7\u5728\u7ec4\u7ec7\u8bbe\u7f6e\u4e2d\u7ef4\u62a4\u5de5\u5382\u5bf9\u5e94\u7684\u4e0a\u7ea7\u4e1a\u52a1\u7ec4\u7ec7!");
            itemStatusMap.put(item.getId(), Integer.parseInt(item.getAuditStatus()));
        });
        if (!CollectionUtils.isEmpty(purchaseRequestItems)) {
            this.purchaseRequestItemService.toDemandPool(purchaseRequestHeadPage);
        }
        if (!CollectionUtils.isEmpty(purchaseRequestItems)) {
            LambdaQueryWrapper wrapper = Wrappers.lambdaQuery();
            wrapper.select(new SFunction[]{BaseEntity::getId, PurchaseRequestItem::getItemStatus});
            wrapper.in(BaseEntity::getId, itemStatusMap.keySet());
            List items = this.purchaseRequestItemService.list((Wrapper)wrapper);
            List ids = items.stream().filter(i -> PurchaseRequestStatusItemEnum.APPROVED.getValue().equals(i.getItemStatus()) || PurchaseRequestStatusItemEnum.SEND_BACK.getValue().equals(i.getItemStatus())).map(BaseEntity::getId).collect(Collectors.toList());
            if (!CollectionUtils.isEmpty(ids)) {
                LambdaUpdateWrapper updateWrapper = Wrappers.lambdaUpdate();
                updateWrapper.set(PurchaseRequestItem::getTacticsEntity, null);
                updateWrapper.set(PurchaseRequestItem::getTacticsObject, null);
                updateWrapper.set(PurchaseRequestItem::getItemStatus, (Object)PurchaseRequestStatusItemEnum.DEMAND_POOL.getValue());
                updateWrapper.in(BaseEntity::getId, ids);
                this.purchaseRequestItemService.update((Wrapper)updateWrapper);
            }
        }
        this.purchaseRequestHeadService.matchPrice(purchaseRequestItems);
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.purchaseRequestHeadService.lambdaUpdate().eq(BaseEntity::getId, (Object)purchaseRequestHeadPage.getId())).set(PurchaseRequestHead::getRequestStatus, (Object)PurchaseRequestStatusEnum.REQUEST_DEMAND.getValue())).update();
        return this.commonSuccessResult(3);
    }

    @ApiOperation(value="\u901a\u8fc7id\u5220\u9664", notes="\u901a\u8fc7id\u5220\u9664")
    @AutoLog(busModule="\u9700\u6c42\u6c60\u7ba1\u7406", value="\u5220\u9664")
    @GetMapping(value={"/delete"})
    @RequiresPermissions(value={"purchaseRequestHead:delete"})
    @PermissionDataOpt(businessType="purchaseRequest", beanClass=PurchaseRequestHeadService.class)
    public Result<?> delete(@RequestParam(name="id", required=true) String id) {
        this.budgetManageRpcService.refundOfOccupiedAmount(id);
        this.purchaseRequestHeadService.delMain(id);
        return this.commonSuccessResult(4);
    }

    @AutoLog(value="\u6279\u91cf\u5220\u9664")
    @ApiOperation(value="\u6279\u91cf\u5220\u9664", notes="\u6279\u91cf\u5220\u9664")
    @GetMapping(value={"/deleteBatch"})
    public Result<?> deleteBatch(@RequestParam(name="ids", required=true) String ids) {
        this.purchaseRequestHeadService.delBatchMain(Arrays.asList(ids.split(",")));
        return this.commonSuccessResult(4);
    }

    @ApiOperation(value="\u901a\u8fc7id\u67e5\u8be2", notes="\u901a\u8fc7id\u67e5\u8be2")
    @GetMapping(value={"/queryById"})
    public Result<?> queryById(@RequestParam(name="id", required=true) String id) {
        PurchaseRequestHead purchaseRequestHead = (PurchaseRequestHead)((Object)this.purchaseRequestHeadService.getById((Serializable)((Object)id)));
        PurchaseRequestHeadVO purchaseRequestHeadVO = new PurchaseRequestHeadVO();
        BeanUtils.copyProperties((Object)((Object)purchaseRequestHead), (Object)((Object)purchaseRequestHeadVO));
        List<PurchaseRequestItem> purchaseRequestItemList = this.purchaseRequestItemService.selectByMainId(id);
        purchaseRequestHeadVO.setPurchaseRequestItemList(purchaseRequestItemList);
        List purchaseAttachmentList = this.invokeBaseRpcService.selectPurchaseAttachmentByMainId(id);
        purchaseRequestHeadVO.setPurchaseAttachmentList(purchaseAttachmentList);
        return Result.ok((Object)((Object)purchaseRequestHeadVO));
    }

    @ApiOperation(value="\u901a\u8fc7\u91c7\u8d2d\u7533\u8bf7\u5934id\u67e5\u8be2\u91c7\u8d2d\u7533\u8bf7\u884c", notes="\u901a\u8fc7\u91c7\u8d2d\u7533\u8bf7\u5934id\u67e5\u8be2\u91c7\u8d2d\u7533\u8bf7\u884c")
    @GetMapping(value={"/queryPurchaseRequestItemByMainId"})
    public Result<?> queryPurchaseRequestItemListByMainId(@RequestParam(name="id", required=true) String id) {
        List<PurchaseRequestItem> purchaseRequestItemList = this.purchaseRequestItemService.selectByMainId(id);
        return Result.ok(purchaseRequestItemList);
    }

    @ApiOperation(value="\u901a\u8fc7\u91c7\u8d2d\u7533\u8bf7\u5934id\u67e5\u8be2\u91c7\u8d2d\u7533\u8bf7\u6587\u4ef6", notes="\u901a\u8fc7\u91c7\u8d2d\u7533\u8bf7\u5934id\u67e5\u8be2\u91c7\u8d2d\u7533\u8bf7\u6587\u4ef6")
    @GetMapping(value={"/queryPurchaseAttachmentByMainId"})
    public Result<?> queryPurchaseAttachmentListByMainId(@RequestParam(name="id", required=true) String id) {
        List purchaseAttachmentList = this.invokeBaseRpcService.selectPurchaseAttachmentByMainId(id);
        return Result.ok((Object)purchaseAttachmentList);
    }

    @AutoLog(value="\u91c7\u8d2d\u7533\u8bf7-\u5546\u54c1\u8f6c\u91c7\u8d2d\u7533\u8bf7")
    @ApiOperation(value="\u5546\u54c1\u8f6c\u91c7\u8d2d\u7533\u8bf7", notes="\u5546\u54c1\u8f6c\u91c7\u8d2d\u7533\u8bf7")
    @PostMapping(value={"/createRequestByProduct"})
    public Result<?> createRequestByProduct(@RequestBody List<PurchaseUserCartDTO> purchaseUserCarts) {
        List<TemplateHeadDTO> templateHeadList = this.templateHeadService.getDefaultTemplateByType("purchaseRequest");
        if (org.apache.commons.collections.CollectionUtils.isEmpty(templateHeadList)) {
            return Result.error((String)"\u4e0d\u5b58\u5728\u9ed8\u8ba4\u7684\u91c7\u8d2d\u7533\u8bf7\u6a21\u677f\uff0c\u8bf7\u8bbe\u7f6e\u9ed8\u8ba4\u6a21\u677f");
        }
        PurchaseRequestHeadVO purchaseRequestHeadVO = new PurchaseRequestHeadVO();
        TemplateHeadDTO templateHead = templateHeadList.get(0);
        purchaseRequestHeadVO.setTemplateNumber(templateHead.getTemplateNumber());
        purchaseRequestHeadVO.setTemplateName(templateHead.getTemplateName());
        purchaseRequestHeadVO.setTemplateAccount(templateHead.getElsAccount());
        purchaseRequestHeadVO.setTemplateVersion(String.valueOf(templateHead.getTemplateVersion()));
        purchaseRequestHeadVO.setElsAccount(this.getTenantId());
        purchaseRequestHeadVO.setCreateBy(this.getCurrentUser().getSubAccount());
        purchaseRequestHeadVO.setCreateTime(new Date());
        purchaseRequestHeadVO.setSourceType("mall");
        purchaseRequestHeadVO.setDeleted(0);
        purchaseRequestHeadVO.setRequestType("requestOne");
        ArrayList<PurchaseRequestItem> purchaseRequestItemList = new ArrayList<PurchaseRequestItem>();
        ArrayList<String> cartIds = new ArrayList<String>();
        for (PurchaseUserCartDTO cart : purchaseUserCarts) {
            PurchaseRequestItem item = new PurchaseRequestItem();
            if (StringUtils.isBlank((CharSequence)cart.getProductInventoryId())) {
                return Result.error((String)"\u5e93\u5b58\u4fe1\u606f\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\uff01");
            }
            PurchaseProductInventoryDTO purchaseProductInventory = this.purchaseProductInventoryService.getById(cart.getProductInventoryId());
            if (null == purchaseProductInventory) {
                return Result.error((String)"\u5e93\u5b58\u4fe1\u606f\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\uff01");
            }
            if (StringUtils.isBlank((CharSequence)purchaseProductInventory.getProductMaterialCode())) {
                return Result.error((String)"\u5e93\u5b58\u4fe1\u606f\u91cc\u9762\u6ca1\u6709\u5173\u8054\u7684\u7269\u6599\u7f16\u7801\uff0c\u8bf7\u68c0\u67e5\uff01");
            }
            PurchaseMaterialHeadDTO material = this.purchaseMaterialHeadService.getMaterialHeadByNumber(purchaseProductInventory.getProductMaterialCode());
            if (null == material) {
                return Result.error((String)"\u7269\u6599\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\uff01");
            }
            item.setMaterialNumber(material.getMaterialNumber());
            item.setMaterialDesc(material.getMaterialDesc());
            item.setMaterialName(material.getMaterialName());
            item.setCateLevelCode(material.getCateLevelCode());
            item.setMaterialSpec(material.getMaterialSpec());
            item.setMaterialType(material.getMaterialType());
            item.setMaterialTypeName(material.getMaterialTypeName());
            item.setBrand(cart.getBrandName());
            item.setBaseUnit(cart.getBasicUnit());
            item.setNetWeight(material.getNetWeight());
            item.setMaterialGroup(material.getMaterialGroup());
            item.setCateCode(material.getCateCode());
            item.setCateName(material.getCateName());
            item.setFactory(material.getFactory());
            item.setQuantity(cart.getProductCount());
            item.setSubtotalAmount(cart.getProductPrice().multiply(cart.getProductCount()));
            item.setNetPrice(cart.getProductPrice());
            item.setPrice(cart.getProductPrice());
            item.setSourceType("mall");
            item.setItemStatus("0");
            item.setDeleted(0);
            purchaseRequestItemList.add(item);
            cartIds.add(cart.getId());
        }
        BigDecimal total = purchaseRequestItemList.stream().filter(p -> p.getSubtotalAmount() != null).map(PurchaseRequestItem::getSubtotalAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
        purchaseRequestHeadVO.setTotalAmount(total);
        purchaseRequestHeadVO.setPurchaseRequestItemList(purchaseRequestItemList);
        this.purchaseRequestHeadService.saveMain(purchaseRequestHeadVO, purchaseRequestItemList, purchaseRequestHeadVO.getPurchaseAttachmentList());
        this.purchaseUserCartService.delBatchPurchaseUserCart(cartIds);
        return Result.ok((Object)((Object)purchaseRequestHeadVO));
    }

    @ApiOperation(value="\u901a\u8fc7\u5217\u8868\u9875\u9875\u7b7e\u6570\u91cf\u67e5\u8be2", notes="\u5217\u8868\u9875\u9875\u7b7e\u6570\u91cf\u67e5\u8be2")
    @GetMapping(value={"/counts"})
    public Result<?> queryTabsCount(PurchaseRequestHead purchaseRequestHead, HttpServletRequest req) {
        ArrayList<CountVO> result = new ArrayList<CountVO>();
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)purchaseRequestHead), (Map)req.getParameterMap());
        queryWrapper.select(new String[]{"request_status", "count(0) as participateQuantity"});
        queryWrapper.groupBy((Object)"request_status");
        List list = ((PurchaseRequestHeadService)this.service).list((Wrapper)queryWrapper);
        Map<String, Integer> countMap = list.stream().collect(Collectors.toMap(PurchaseRequestHead::getRequestStatus, PurchaseRequestHead::getParticipateQuantity));
        Integer all = 0;
        for (Map.Entry<String, Integer> entry : countMap.entrySet()) {
            all = all + entry.getValue();
        }
        result.add(new CountVO(I18nUtil.translate((String)"", (String)"\u5168\u90e8"), "requestStatus", null, all));
        List srmRequestStatus = this.invokeBaseRpcService.queryDictItemsByCode("srmRequestStatus", "307000");
        for (DictDTO status : srmRequestStatus) {
            Integer total = countMap.get(status.getValue()) == null ? Integer.valueOf(0) : countMap.get(status.getValue());
            result.add(new CountVO(I18nUtil.translate((String)status.getTextI18nKey(), (String)status.getText()), "requestStatus", status.getValue(), total));
        }
        return Result.ok(result);
    }
}

