/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.bidding.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.els.common.aspect.annotation.SrmTransaction;
import com.els.common.constant.CommonConstant;
import com.els.common.exception.ELSBootException;
import com.els.common.system.vo.LoginUser;
import com.els.common.util.I18nUtil;
import com.els.common.util.SysUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.bidding.entity.PurchaseBiddingEvaResult;
import com.els.modules.bidding.entity.PurchaseBiddingHead;
import com.els.modules.bidding.entity.PurchaseBiddingSpecialist;
import com.els.modules.bidding.enumerate.MemberRoleEnum;
import com.els.modules.bidding.enumerate.MemberTypeEnum;
import com.els.modules.bidding.mapper.PurchaseBiddingEvaResultMapper;
import com.els.modules.bidding.mapper.PurchaseBiddingHeadMapper;
import com.els.modules.bidding.mapper.PurchaseBiddingSpecialistMapper;
import com.els.modules.bidding.service.PurchaseBiddingSpecialistService;
import java.io.Serializable;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PurchaseBiddingSpecialistServiceImpl
extends ServiceImpl<PurchaseBiddingSpecialistMapper, PurchaseBiddingSpecialist>
implements PurchaseBiddingSpecialistService {
    @Autowired
    private PurchaseBiddingSpecialistMapper purchaseBiddingSpecialistMapper;
    @Autowired
    private PurchaseBiddingHeadMapper purchaseBiddingHeadMapper;
    @Autowired
    private PurchaseBiddingEvaResultMapper purchaseBiddingEvaResultMapper;

    @Override
    public List<PurchaseBiddingSpecialist> selectByMainId(String mainId) {
        return this.purchaseBiddingSpecialistMapper.selectByMainId(mainId);
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void saveMember(String mainId, List<PurchaseBiddingSpecialist> specialists) {
        LoginUser user = SysUtil.getLoginUser();
        List specialistList = this.purchaseBiddingSpecialistMapper.selectByMainId(mainId).stream().filter(o -> MemberTypeEnum.PROJECT.getValue().equals(o.getMemberType())).filter(o -> MemberRoleEnum.BID_PRINCIPAL.getValue().equals(o.getMemberRole())).map(PurchaseBiddingSpecialist::getSubAccount).collect(Collectors.toList());
        if (!specialistList.contains(user.getSubAccount())) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_oper_no_bidding_principal_bidding", (String)"\u53ea\u6709\u62db\u6807\u8d1f\u8d23\u4eba\u53ef\u4ee5\u64cd\u4f5c\uff01"));
        }
        PurchaseBiddingHead head = (PurchaseBiddingHead)((Object)this.purchaseBiddingHeadMapper.selectById((Serializable)((Object)mainId)));
        Date evaEndTime = head.getEvaEndTime();
        if (evaEndTime.before(new Date())) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_fail_bid_cut_off_time_arrived_bidding", (String)"\u8bc4\u6807\u622a\u6b62\u65f6\u95f4\u5df2\u5230\uff0c\u4e0d\u80fd\u64cd\u4f5c\uff01"));
        }
        List list = specialists.stream().filter(o -> MemberRoleEnum.BID_PRINCIPAL.getValue().equals(o.getMemberRole())).collect(Collectors.toList());
        if (list.isEmpty()) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_fail_not_principal", (String)"\u9879\u76ee\u6210\u5458\u5fc5\u987b\u5305\u542b\u4e00\u4e2a\u62db\u6807\u8d1f\u8d23\u4eba\uff01"));
        }
        List biddingEvaResultList = this.purchaseBiddingEvaResultMapper.selectList((Wrapper)new LambdaQueryWrapper().eq(PurchaseBiddingEvaResult::getHeadId, (Object)mainId));
        List resultSubAccountList = biddingEvaResultList.stream().map(PurchaseBiddingEvaResult::getSubAccount).distinct().collect(Collectors.toList());
        List evaBiddingList = specialists.stream().filter(o -> MemberTypeEnum.EVA_BID.getValue().equals(o.getMemberType())).map(PurchaseBiddingSpecialist::getSubAccount).collect(Collectors.toList());
        for (String subAccount : resultSubAccountList) {
            if (evaBiddingList.contains(subAccount)) continue;
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_oper_specialistNotDel", (String)"\u5df2\u7ecf\u8bc4\u6807\u7684\u4e13\u5bb6\u4e0d\u80fd\u5220\u9664\uff01"));
        }
        this.purchaseBiddingSpecialistMapper.deleteByMainId(mainId);
        for (PurchaseBiddingSpecialist specialist : specialists) {
            specialist.setElsAccount(TenantContext.getTenant());
            specialist.setHeadId(mainId);
            specialist.setId(null);
            specialist.setDeleted(CommonConstant.DEL_FLAG_0);
        }
        this.purchaseBiddingSpecialistMapper.insertBatchSomeColumn(specialists);
    }
}

