/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.bidding.controller;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.els.common.api.vo.Result;
import com.els.common.aspect.annotation.AutoLog;
import com.els.common.system.base.controller.BaseController;
import com.els.common.system.query.QueryGenerator;
import com.els.config.mybatis.TenantContext;
import com.els.modules.bidding.entity.BiddingEvaluationRegulation;
import com.els.modules.bidding.entity.BiddingEvaluationRegulationSelection;
import com.els.modules.bidding.mapper.BiddingEvaluationTemplateItemMapper;
import com.els.modules.bidding.service.BiddingEvaluationRegulationSelectionService;
import com.els.modules.bidding.service.BiddingEvaluationRegulationService;
import com.els.modules.bidding.vo.BiddingEvaluationRegulationVO;
import com.els.rpc.service.InvokeBaseRpcService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/bidding/biddingEvaluationRegulation"})
@Api(tags={"\u8bc4\u6807\u6761\u4f8b"})
public class BiddingEvaluationRegulationController
extends BaseController<BiddingEvaluationRegulation, BiddingEvaluationRegulationService> {
    @Autowired
    private BiddingEvaluationRegulationService biddingEvaluationRegulationService;
    @Autowired
    private BiddingEvaluationRegulationSelectionService biddingEvaluationRegulationSelectionService;
    @Autowired
    private InvokeBaseRpcService invokeBaseRpcService;
    @Resource
    private BiddingEvaluationTemplateItemMapper biddingEvaluationTemplateItemMapper;

    @ApiOperation(value="\u5206\u9875\u5217\u8868\u67e5\u8be2", notes="\u5206\u9875\u5217\u8868\u67e5\u8be2")
    @GetMapping(value={"/list"})
    public Result<?> queryPageList(BiddingEvaluationRegulation biddingEvaluationRegulation, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)biddingEvaluationRegulation), (Map)req.getParameterMap());
        queryWrapper.eq((Object)"els_account", (Object)TenantContext.getTenant());
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        IPage pageList = this.biddingEvaluationRegulationService.page((IPage)page, (Wrapper)queryWrapper);
        if (pageList.getRecords() != null) {
            List regulations = pageList.getRecords();
            for (BiddingEvaluationRegulation regulation : regulations) {
                int count = this.biddingEvaluationTemplateItemMapper.getByReluationId(regulation.getId(), TenantContext.getTenant());
                if (count <= 0) continue;
                regulation.setUsed("1");
            }
        }
        return Result.ok((Object)pageList);
    }

    @AutoLog(value="\u8bc4\u6807\u6761\u4f8b-\u6dfb\u52a0", operateType=2)
    @ApiOperation(value="\u6dfb\u52a0", notes="\u6dfb\u52a0")
    @PostMapping(value={"/add"})
    public Result<?> add(@RequestBody BiddingEvaluationRegulationVO biddingEvaluationRegulationPage) {
        BiddingEvaluationRegulation biddingEvaluationRegulation = new BiddingEvaluationRegulation();
        BeanUtils.copyProperties((Object)((Object)biddingEvaluationRegulationPage), (Object)((Object)biddingEvaluationRegulation));
        this.biddingEvaluationRegulationService.saveMain(biddingEvaluationRegulation, biddingEvaluationRegulationPage.getBiddingEvaluationRegulationSelectionList(), biddingEvaluationRegulationPage.getAttachmentList());
        return Result.ok((Object)((Object)biddingEvaluationRegulation));
    }

    @AutoLog(value="\u8bc4\u6807\u6761\u4f8b-\u7f16\u8f91", operateType=3)
    @ApiOperation(value="\u7f16\u8f91", notes="\u7f16\u8f91")
    @PostMapping(value={"/edit"})
    public Result<?> edit(@RequestBody BiddingEvaluationRegulationVO biddingEvaluationRegulationPage) {
        BiddingEvaluationRegulation biddingEvaluationRegulation = new BiddingEvaluationRegulation();
        BeanUtils.copyProperties((Object)((Object)biddingEvaluationRegulationPage), (Object)((Object)biddingEvaluationRegulation));
        this.biddingEvaluationRegulationService.updateMain(biddingEvaluationRegulation, biddingEvaluationRegulationPage.getBiddingEvaluationRegulationSelectionList(), biddingEvaluationRegulationPage.getAttachmentList());
        return this.commonSuccessResult(3);
    }

    @AutoLog(value="\u8bc4\u6807\u6761\u4f8b-\u901a\u8fc7id\u5220\u9664", operateType=4)
    @ApiOperation(value="\u901a\u8fc7id\u5220\u9664", notes="\u901a\u8fc7id\u5220\u9664")
    @GetMapping(value={"/delete"})
    public Result<?> delete(@RequestParam(name="id") String id) {
        this.biddingEvaluationRegulationService.delMain(id);
        return this.commonSuccessResult(4);
    }

    @AutoLog(value="\u8bc4\u6807\u6761\u4f8b-\u6279\u91cf\u5220\u9664", operateType=4)
    @ApiOperation(value="\u6279\u91cf\u5220\u9664", notes="\u6279\u91cf\u5220\u9664")
    @GetMapping(value={"/deleteBatch"})
    public Result<?> deleteBatch(@RequestParam(name="ids") String ids) {
        this.biddingEvaluationRegulationService.delBatchMain(Arrays.asList(ids.split(",")));
        return this.commonSuccessResult(4);
    }

    @ApiOperation(value="\u901a\u8fc7id\u67e5\u8be2", notes="\u901a\u8fc7id\u67e5\u8be2")
    @GetMapping(value={"/queryById"})
    public Result<?> queryById(@RequestParam(name="id") String id) {
        BiddingEvaluationRegulation biddingEvaluationRegulation = (BiddingEvaluationRegulation)((Object)this.biddingEvaluationRegulationService.getById((Serializable)((Object)id)));
        BiddingEvaluationRegulationVO biddingEvaluationRegulationVO = new BiddingEvaluationRegulationVO();
        BeanUtils.copyProperties((Object)((Object)biddingEvaluationRegulation), (Object)((Object)biddingEvaluationRegulationVO));
        List<BiddingEvaluationRegulationSelection> biddingEvaluationRegulationSelectionList = this.biddingEvaluationRegulationSelectionService.selectByMainId(id);
        biddingEvaluationRegulationVO.setBiddingEvaluationRegulationSelectionList(biddingEvaluationRegulationSelectionList);
        List attachments = this.invokeBaseRpcService.selectPurchaseAttachmentByMainId(id);
        biddingEvaluationRegulationVO.setAttachmentList(attachments);
        return Result.ok((Object)((Object)biddingEvaluationRegulationVO));
    }

    @ApiOperation(value="\u901a\u8fc7\u8bc4\u6807\u6761\u4f8bid\u67e5\u8be2\u8bc4\u6807\u6761\u4f8b\u9009\u9879", notes="\u901a\u8fc7\u8bc4\u6807\u6761\u4f8bid\u67e5\u8be2\u8bc4\u6807\u6761\u4f8b\u9009\u9879")
    @GetMapping(value={"/queryBiddingEvaluationRegulationSelectionByMainId"})
    public Result<?> queryBiddingEvaluationRegulationSelectionListByMainId(@RequestParam(name="id") String id) {
        List<BiddingEvaluationRegulationSelection> biddingEvaluationRegulationSelectionList = this.biddingEvaluationRegulationSelectionService.selectByMainId(id);
        return Result.ok(biddingEvaluationRegulationSelectionList);
    }
}

