/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.forecast.service.impl;

import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.util.I18nUtil;
import com.els.common.util.SpringContextUtils;
import com.els.common.util.SysUtil;
import com.els.modules.forecast.entity.PurchaseForecastHead;
import com.els.modules.forecast.entity.PurchaseForecastMonthItem;
import com.els.modules.forecast.entity.PurchaseForecastWeekItem;
import com.els.modules.forecast.entity.SaleForecastHead;
import com.els.modules.forecast.entity.SaleForecastMonthItem;
import com.els.modules.forecast.entity.SaleForecastWeekItem;
import com.els.modules.forecast.mapper.SaleForecastHeadMapper;
import com.els.modules.forecast.service.PurchaseForecastHeadService;
import com.els.modules.forecast.service.SaleForecastHeadService;
import com.els.modules.forecast.service.SaleForecastMonthItemService;
import com.els.modules.forecast.service.SaleForecastWeekItemService;
import com.els.modules.forecast.service.impl.PurchaseForecastHeadServiceImpl;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

@Service
public class SaleForecastHeadServiceImpl
extends BaseServiceImpl<SaleForecastHeadMapper, SaleForecastHead>
implements SaleForecastHeadService {
    @Resource
    private SaleForecastMonthItemService saleForecastMonthItemService;
    @Resource
    private SaleForecastWeekItemService saleForecastWeekItemService;

    @Override
    public void add(PurchaseForecastHead head, List<PurchaseForecastMonthItem> monthItemList, List<PurchaseForecastWeekItem> weekItemList) {
        List elsAccountList = monthItemList.stream().map(PurchaseForecastMonthItem::getToElsAccount).distinct().collect(Collectors.toList());
        ArrayList<SaleForecastHead> insertHeadList = new ArrayList<SaleForecastHead>();
        ConcurrentHashMap<Object, String> idMap = new ConcurrentHashMap<Object, String>();
        for (Object elsAccount : elsAccountList) {
            SaleForecastHead saleHead = new SaleForecastHead();
            BeanUtils.copyProperties((Object)((Object)head), (Object)((Object)saleHead));
            saleHead.setId(IdWorker.getIdStr());
            saleHead.setElsAccount((String)elsAccount);
            saleHead.setToElsAccount(head.getElsAccount());
            saleHead.setPurchaseName(SysUtil.getLoginUser().getEnterpriseName());
            saleHead.setRelationId(head.getId());
            insertHeadList.add(saleHead);
            idMap.put(elsAccount, saleHead.getId());
        }
        this.saveBatch(insertHeadList);
        ArrayList<SaleForecastMonthItem> insertMonthItemList = new ArrayList<SaleForecastMonthItem>();
        for (PurchaseForecastMonthItem monthItem : monthItemList) {
            SaleForecastMonthItem saleMonthItem = new SaleForecastMonthItem();
            BeanUtils.copyProperties((Object)((Object)monthItem), (Object)((Object)saleMonthItem));
            saleMonthItem.setId(monthItem.getRelationId());
            saleMonthItem.setElsAccount(monthItem.getToElsAccount());
            saleMonthItem.setToElsAccount(monthItem.getElsAccount());
            saleMonthItem.setRelationId(monthItem.getId());
            saleMonthItem.setHeadId((String)idMap.get(monthItem.getToElsAccount()));
            insertMonthItemList.add(saleMonthItem);
        }
        this.saleForecastMonthItemService.saveBatch(insertMonthItemList);
        ArrayList<SaleForecastWeekItem> insertWeekItemList = new ArrayList<SaleForecastWeekItem>();
        for (PurchaseForecastWeekItem weekItem : weekItemList) {
            SaleForecastWeekItem saleWeekItem = new SaleForecastWeekItem();
            BeanUtils.copyProperties((Object)((Object)weekItem), (Object)((Object)saleWeekItem));
            saleWeekItem.setId(weekItem.getRelationId());
            saleWeekItem.setElsAccount(weekItem.getToElsAccount());
            saleWeekItem.setToElsAccount(weekItem.getElsAccount());
            saleWeekItem.setRelationId(weekItem.getId());
            saleWeekItem.setHeadId((String)idMap.get(weekItem.getToElsAccount()));
            insertWeekItemList.add(saleWeekItem);
        }
        this.saleForecastWeekItemService.saveBatch(insertWeekItemList);
    }

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void confirm(SaleForecastHead saleForecastHead, List<SaleForecastMonthItem> saleForecastMonthItemList, List<SaleForecastWeekItem> saleForecastWeekItemList) {
        SaleForecastHead dbHead = (SaleForecastHead)((Object)this.getById((Serializable)((Object)saleForecastHead.getId())));
        Assert.isTrue((!"1".equals(dbHead.getConfirm()) ? 1 : 0) != 0, (String)I18nUtil.translate((String)"", (String)"\u5df2\u786e\u8ba4\u7684\u5355\u636e\u4e0d\u53ef\u91cd\u590d\u786e\u8ba4"));
        saleForecastHead.setConfirm("1");
        ((SaleForecastHeadMapper)this.baseMapper).updateById((Object)saleForecastHead);
        this.saleForecastMonthItemService.updateBatchById(saleForecastMonthItemList);
        this.saleForecastWeekItemService.updateBatchById(saleForecastWeekItemList);
        PurchaseForecastHeadService purchaseForecastHeadService = (PurchaseForecastHeadService)SpringContextUtils.getBean(PurchaseForecastHeadServiceImpl.class);
        purchaseForecastHeadService.confirm(saleForecastHead, saleForecastMonthItemList, saleForecastWeekItemList);
    }
}

