/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.enquiry.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.els.common.aspect.annotation.SrmTransaction;
import com.els.common.enumerate.AuditStatusEnum;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.system.vo.LoginUser;
import com.els.common.util.I18nUtil;
import com.els.common.util.SpringContextUtils;
import com.els.common.util.SysUtil;
import com.els.common.util.encryption.AesEncryptUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.base.api.dto.AttachmentSendDTO;
import com.els.modules.base.api.dto.ElsInitialTableDTO;
import com.els.modules.base.api.dto.PurchaseAttachmentDemandDTO;
import com.els.modules.bidding.enumerate.BusinessBillTypeEnum;
import com.els.modules.bidding.service.PurchaseClarificationInfoService;
import com.els.modules.bidding.service.impl.PurchaseClarificationInfoServiceImpl;
import com.els.modules.demand.enumerate.PurchaseRequestStatusItemEnum;
import com.els.modules.demand.service.PurchaseRequestItemService;
import com.els.modules.ebidding.enumerate.EbiddingStatusEnum;
import com.els.modules.enquiry.entity.EnquirySupplierList;
import com.els.modules.enquiry.entity.PurchaseEnquiryHead;
import com.els.modules.enquiry.entity.PurchaseEnquiryItem;
import com.els.modules.enquiry.entity.SaleEnquiryHead;
import com.els.modules.enquiry.enumerate.EnquiryQuoteWayEnum;
import com.els.modules.enquiry.enumerate.EnquiryScopeEnum;
import com.els.modules.enquiry.enumerate.EnquiryStatusEnum;
import com.els.modules.enquiry.job.utils.EnquiryJobUtil;
import com.els.modules.enquiry.mapper.EnquirySupplierListMapper;
import com.els.modules.enquiry.mapper.PurchaseEnquiryHeadMapper;
import com.els.modules.enquiry.mapper.PurchaseEnquiryItemMapper;
import com.els.modules.enquiry.service.PublicEnquiryService;
import com.els.modules.enquiry.service.PurchaseEnquiryHeadService;
import com.els.modules.enquiry.service.PurchaseEnquiryItemService;
import com.els.modules.enquiry.service.SaleEnquiryHeadService;
import com.els.modules.enquiry.service.impl.PublicEnquiryServiceImpl;
import com.els.modules.enquiry.vo.PurchaseEnquiryHeadVO;
import com.els.modules.inquiry.enumerate.PriceCreateWayEnum;
import com.els.modules.inquiry.enumerate.PricingNoticeEnum;
import com.els.modules.inquiry.enumerate.QualificationReviewEnum;
import com.els.modules.inquiry.enumerate.RegretFlagEnum;
import com.els.modules.inquiry.enumerate.SourceTypeEnum;
import com.els.modules.inquiry.enumerate.SrmPublicScopeEnum;
import com.els.modules.inquiry.qualification.entity.PurchaseQualificationReview;
import com.els.modules.inquiry.qualification.service.PurchaseExecuteReviewService;
import com.els.modules.inquiry.rpc.service.InquiryInvokeMainDataRpcService;
import com.els.modules.inquiry.service.PublishToB2BService;
import com.els.modules.material.api.dto.PurchaseMaterialRelationDTO;
import com.els.modules.price.api.dto.PurchaseInformationRecordsDTO;
import com.els.modules.price.api.enumerate.PriceSourceTypeEnum;
import com.els.modules.price.api.enumerate.PurchaseInformationPriceTypeEnum;
import com.els.rpc.service.InvokeBaseRpcService;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service
public class PurchaseEnquiryHeadServiceImpl
extends BaseServiceImpl<PurchaseEnquiryHeadMapper, PurchaseEnquiryHead>
implements PurchaseEnquiryHeadService,
PurchaseExecuteReviewService {
    @Resource
    private PurchaseEnquiryItemMapper purchaseEnquiryItemMapper;
    @Resource
    private EnquirySupplierListMapper enquirySupplierListMapper;
    @Autowired
    private PurchaseEnquiryItemService purchaseEnquiryItemService;
    @Autowired
    private SaleEnquiryHeadService saleEnquiryHeadService;
    @Autowired
    private PurchaseRequestItemService purchaseRequestItemService;
    @Autowired
    private PublishToB2BService publishToB2BService;
    @Resource
    private InvokeBaseRpcService invokeBaseRpcService;
    @Resource
    private InquiryInvokeMainDataRpcService inquiryInvokeMainDataRpcService;

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void saveMain(PurchaseEnquiryHeadVO headVO) {
        PurchaseEnquiryHeadServiceImpl.setHeadParamAndCheck(headVO, false);
        PurchaseEnquiryHead head = new PurchaseEnquiryHead();
        BeanUtils.copyProperties((Object)((Object)headVO), (Object)((Object)head));
        String enquiryNumber = this.invokeBaseRpcService.getNextCode("srmEnquiryNumber", (Object)head);
        head.setEnquiryNumber(enquiryNumber);
        super.setHeadDefaultValue((BaseEntity)head);
        ((PurchaseEnquiryHeadMapper)this.baseMapper).insert((Object)head);
        List<PurchaseEnquiryItem> itemList = headVO.getPurchaseEnquiryItemList();
        this.insertData(head, itemList, headVO.getEnquirySupplierListList(), headVO.getPurchaseAttachmentDemandList());
        this.goBackDemand(itemList, PurchaseRequestStatusItemEnum.INQUIRY_BUILT.getValue());
        BeanUtils.copyProperties((Object)((Object)head), (Object)((Object)headVO));
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void updateMain(PurchaseEnquiryHeadVO headVO) {
        PurchaseEnquiryHeadServiceImpl.setHeadParamAndCheck(headVO, false);
        PurchaseEnquiryHead head = new PurchaseEnquiryHead();
        BeanUtils.copyProperties((Object)((Object)headVO), (Object)((Object)head));
        ((PurchaseEnquiryHeadMapper)this.baseMapper).updateById((Object)head);
        this.deleteSubTable(head.getId());
        this.insertData(head, headVO.getPurchaseEnquiryItemList(), headVO.getEnquirySupplierListList(), headVO.getPurchaseAttachmentDemandList());
    }

    private void deleteSubTable(String headId) {
        this.purchaseEnquiryItemMapper.deleteByMainId(headId);
        this.enquirySupplierListMapper.deleteByMainId(headId);
        this.invokeBaseRpcService.deletePurchaseAttachmentDemandByMainId(headId);
    }

    public static void setHeadParamAndCheck(PurchaseEnquiryHeadVO headVO, boolean isPublish) {
        SysUtil.setNullCreate((BaseEntity)headVO);
        String elsAccount = TenantContext.getTenant();
        headVO.setElsAccount(elsAccount);
        headVO.setBusAccount(elsAccount);
        headVO.setEnquiryStatus(isPublish ? EnquiryStatusEnum.QUOTING.getValue() : EnquiryStatusEnum.NEW.getValue());
        headVO.setAuditStatus("1".equals(headVO.getPublishAudit()) ? AuditStatusEnum.AUDIT_NEW.getValue() : AuditStatusEnum.NO_AUDIT_REQUIRED.getValue());
        headVO.setResultAuditStatus("1".equals(headVO.getResultAudit()) ? AuditStatusEnum.AUDIT_NEW.getValue() : AuditStatusEnum.NO_AUDIT_REQUIRED.getValue());
        headVO.setOpenBidStatus("0");
        if (isPublish) {
            Date currentDate = new Date();
            headVO.setPublishTime(currentDate);
            LoginUser user = SysUtil.getLoginUser();
            headVO.setPublishUser(user.getSubAccount() + "_" + user.getRealname());
            headVO.setEnquiryDate(headVO.getEnquiryDate() == null ? currentDate : headVO.getEnquiryDate());
            headVO.setAllowDelay(StrUtil.isBlank((CharSequence)headVO.getAllowDelay()) ? "1" : headVO.getAllowDelay());
            headVO.setEnquiryScope(StrUtil.isBlank((CharSequence)headVO.getEnquiryScope()) ? EnquiryScopeEnum.INVITE.getValue() : headVO.getEnquiryScope());
            Assert.notNull((Object)headVO.getQuoteEndTime(), (String)I18nUtil.translate((String)"", (String)"\u62a5\u4ef7\u622a\u6b62\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a"));
            Assert.isTrue((boolean)headVO.getQuoteEndTime().after(new Date()), (String)I18nUtil.translate((String)"i18n_alert_suyRKIlTfUAPKI_7f71245d", (String)"\u62a5\u4ef7\u622a\u6b62\u65f6\u95f4\u5fc5\u987b\u5927\u4e8e\u5f53\u524d\u65f6\u95f4"));
            if (EnquiryScopeEnum.PUBLIC.getValue().equals(headVO.getEnquiryScope())) {
                Assert.notNull((Object)headVO.getApplyEndTime(), (String)I18nUtil.translate((String)"i18n_alert_sRyRKIxOLV_a953b64e", (String)"\u62a5\u540d\u622a\u6b62\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a"));
                Assert.isTrue((boolean)headVO.getApplyEndTime().after(new Date()), (String)I18nUtil.translate((String)"i18n_alert_sRyRKIlTfUAPKI_8dd43873", (String)"\u62a5\u540d\u622a\u6b62\u65f6\u95f4\u5fc5\u987b\u5927\u4e8e\u5f53\u524d\u65f6\u95f4"));
                Assert.isTrue((boolean)headVO.getApplyEndTime().before(headVO.getQuoteEndTime()), (String)I18nUtil.translate((String)"i18n_alert_sRyRKIlTXUsuyRKI_c93a6f5b", (String)"\u62a5\u540d\u622a\u6b62\u65f6\u95f4\u5fc5\u987b\u5c0f\u4e8e\u62a5\u4ef7\u622a\u6b62\u65f6\u95f4"));
            }
            if ("1".equals(headVO.getOpenBidBefore())) {
                Assert.hasText((String)headVO.getOpenBidPassword(), (String)I18nUtil.translate((String)"", (String)"\u5f00\u6807\u5bc6\u7801\u4e0d\u80fd\u4e3a\u7a7a"));
            }
            Assert.notEmpty(headVO.getPurchaseEnquiryItemList(), (String)I18nUtil.translate((String)"i18n_alert_cdIxOLV_e4453e71", (String)"\u884c\u9879\u76ee\u4e0d\u80fd\u4e3a\u7a7a"));
            headVO.getPurchaseEnquiryItemList().forEach(item -> {
                PurchaseEnquiryHeadServiceImpl.headToItem(headVO, item);
                Assert.notNull((Object)item.getQuotePriceWay(), (String)I18nUtil.translate((String)"i18n_alert_suCKxOLV_4d9cccf8", (String)"\u62a5\u4ef7\u65b9\u5f0f\u4e0d\u80fd\u4e3a\u7a7a"));
                if ("1".equals(headVO.getMustMaterialNumber())) {
                    Assert.hasText((String)item.getMaterialNumber(), (String)I18nUtil.translate((String)"i18n_alert_SLAoxOLV_f1cdd68b", (String)"\u7269\u6599\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a"));
                }
                if (!"1".equals(headVO.getSupplierTaxRate())) {
                    Assert.hasText((String)item.getTaxCode(), (String)I18nUtil.translate((String)"", (String)"\u884c\u4fe1\u606f\u7a0e\u7801\u4e0d\u80fd\u4e3a\u7a7a"));
                    Assert.hasText((String)item.getTaxRate(), (String)I18nUtil.translate((String)"", (String)"\u884c\u4fe1\u606f\u7a0e\u7387\u4e0d\u80fd\u4e3a\u7a7a"));
                }
                BigDecimal purchaseCycle = StrUtil.isBlank((CharSequence)item.getPurchaseCycle()) ? null : new BigDecimal(item.getPurchaseCycle());
                Assert.isTrue((purchaseCycle == null || purchaseCycle.compareTo(BigDecimal.ZERO) >= 0 ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_alert_nRsAlTLiW_d97980b4", (String)"\u91c7\u8d2d\u5468\u671f\u5fc5\u987b\u4e3a\u6b63\u6570"));
            });
            if (EnquiryScopeEnum.INVITE.getValue().equals(headVO.getEnquiryScope())) {
                Assert.notEmpty(headVO.getEnquirySupplierListList(), (String)I18nUtil.translate((String)"", (String)"\u4f9b\u5e94\u5546\u4e0d\u80fd\u4e3a\u7a7a"));
                if (headVO.getParticipateQuantity() != null) {
                    Assert.isTrue((headVO.getEnquirySupplierListList().size() >= headVO.getParticipateQuantity() ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_alert_diRdXWRlTfUEUsUWR_fa3da170", (String)"\u6240\u9009\u4f9b\u5e94\u5546\u6570\u91cf\u5fc5\u987b\u5927\u4e8e\u7b49\u4e8e\u53c2\u4e0e\u6570\u91cf"));
                }
            }
        }
    }

    private static void headToItem(PurchaseEnquiryHead head, PurchaseEnquiryItem item) {
        item.setTaxRate(StrUtil.isBlank((CharSequence)item.getTaxRate()) ? head.getTaxRate() : item.getTaxRate());
        item.setTaxCode(StrUtil.isBlank((CharSequence)item.getTaxCode()) ? head.getTaxCode() : item.getTaxCode());
        item.setCurrency(StrUtil.isBlank((CharSequence)item.getCurrency()) ? head.getCurrency() : item.getCurrency());
    }

    private void insertData(PurchaseEnquiryHead head, List<PurchaseEnquiryItem> itemList, List<EnquirySupplierList> supplierList, List<PurchaseAttachmentDemandDTO> demandList) {
        if (CollectionUtil.isNotEmpty(itemList)) {
            int itemNumber = 1;
            LoginUser sysUser = SysUtil.getLoginUser();
            for (PurchaseEnquiryItem item : itemList) {
                item.setId(null);
                item.setHeadId(head.getId());
                item.setEnquiryNumber(head.getEnquiryNumber());
                item.setItemNumber(String.valueOf(itemNumber++));
                item.setToElsAccount("");
                item.setPurchaseName(sysUser.getEnterpriseName());
                item.setItemStatus(EnquiryStatusEnum.NEW.getValue());
                item.setAuditStatus("1".equals(head.getResultAudit()) ? AuditStatusEnum.AUDIT_NEW.getValue() : AuditStatusEnum.NO_AUDIT_REQUIRED.getValue());
                item.setSourceType(StrUtil.isBlank((CharSequence)item.getSourceType()) ? SourceTypeEnum.MANUAL.getValue() : item.getSourceType());
                SysUtil.setNullCreate((BaseEntity)item);
                SysUtil.setSysParam((BaseEntity)item, (BaseEntity)head);
            }
            this.purchaseEnquiryItemMapper.insertBatchSomeColumn(itemList);
        }
        if (CollectionUtil.isNotEmpty(supplierList)) {
            for (EnquirySupplierList supplier : supplierList) {
                supplier.setId(null);
                supplier.setHeadId(head.getId());
                SysUtil.setNullCreate((BaseEntity)supplier);
                SysUtil.setSysParam((BaseEntity)supplier, (BaseEntity)head);
            }
            this.enquirySupplierListMapper.insertBatchSomeColumn(supplierList);
        }
        this.invokeBaseRpcService.addPurchaseAttachmentDemandBatch(demandList, head.getId(), "enquiry");
    }

    @Override
    public void goBackDemand(List<PurchaseEnquiryItem> itemList, String status) {
        if (CollectionUtil.isNotEmpty(itemList)) {
            List<String> idList = itemList.stream().filter(item -> StrUtil.isNotBlank((CharSequence)item.getSourceItemId())).map(PurchaseEnquiryItem::getSourceItemId).distinct().collect(Collectors.toList());
            this.purchaseRequestItemService.updateStatusById(idList, status);
        }
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void delMain(String id) {
        PurchaseEnquiryHead dbHead = (PurchaseEnquiryHead)((Object)((PurchaseEnquiryHeadMapper)this.baseMapper).selectById((Serializable)((Object)id)));
        Assert.isTrue((boolean)EnquiryStatusEnum.NEW.getValue().equals(dbHead.getEnquiryStatus()), (String)I18nUtil.translate((String)"i18n_alert_RjVIzEjtFqQG_65b871ca", (String)"\u53ea\u6709\u65b0\u5efa\u72b6\u6001\u7684\u5355\u636e\u53ef\u5220\u9664"));
        String auditStatus = dbHead.getAuditStatus();
        boolean delete = !AuditStatusEnum.AUDIT_DOING.getValue().equals(auditStatus) && !AuditStatusEnum.AUDIT_FINISH.getValue().equals(auditStatus);
        Assert.isTrue((boolean)delete, (String)I18nUtil.translate((String)"i18n_alert_UzsSUzeRjtFqQG_908d607c", (String)"\u5ba1\u6279\u4e2d\u6216\u5ba1\u6279\u901a\u8fc7\u7684\u5355\u636e\u53ef\u5220\u9664"));
        List<PurchaseEnquiryItem> purchaseEnquiryItems = this.purchaseEnquiryItemService.selectByMainId(dbHead.getId());
        this.goBackDemand(purchaseEnquiryItems, PurchaseRequestStatusItemEnum.DEMAND_POOL.getValue());
        this.purchaseEnquiryItemMapper.delete((Wrapper)new LambdaQueryWrapper().eq(PurchaseEnquiryItem::getHeadId, (Object)id));
        this.enquirySupplierListMapper.delete((Wrapper)new LambdaQueryWrapper().eq(EnquirySupplierList::getHeadId, (Object)id));
        this.invokeBaseRpcService.deletePurchaseAttachmentByMainId(id);
        this.invokeBaseRpcService.deletePurchaseAttachmentDemandByMainId(id);
        ((PurchaseEnquiryHeadMapper)this.baseMapper).delete((Wrapper)new LambdaQueryWrapper().eq(BaseEntity::getId, (Object)id));
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void delBatchMain(List<String> idList) {
        idList.forEach(this::delMain);
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void publish(PurchaseEnquiryHeadVO headVO) {
        PurchaseEnquiryHeadServiceImpl.setHeadParamAndCheck(headVO, true);
        if (StrUtil.isNotBlank((CharSequence)headVO.getOpenBidPassword())) {
            headVO.setOpenBidPassword(AesEncryptUtil.encrypt((String)headVO.getOpenBidPassword()));
        }
        PurchaseEnquiryHead head = new PurchaseEnquiryHead();
        BeanUtils.copyProperties((Object)((Object)headVO), (Object)((Object)head));
        if (StrUtil.isBlank((CharSequence)head.getId())) {
            String enquiryNumber = this.invokeBaseRpcService.getNextCode("srmEnquiryNumber", (Object)head);
            head.setEnquiryNumber(enquiryNumber);
            ((PurchaseEnquiryHeadMapper)this.baseMapper).insert((Object)head);
        } else {
            ((PurchaseEnquiryHeadMapper)this.baseMapper).updateById((Object)head);
            this.deleteSubTable(head.getId());
        }
        List<PurchaseEnquiryItem> itemList = headVO.getPurchaseEnquiryItemList();
        List<EnquirySupplierList> supplierList = headVO.getEnquirySupplierListList();
        this.insertInitTable(head.getId(), itemList);
        if (CollectionUtil.isNotEmpty(supplierList)) {
            this.publishEnquiry(head, itemList, supplierList, headVO.getPurchaseAttachmentDemandList());
        } else {
            this.insertData(head, itemList, supplierList, headVO.getPurchaseAttachmentDemandList());
        }
        if (EnquiryScopeEnum.PUBLIC.getValue().equals(head.getEnquiryScope())) {
            String publicScope = head.getPublicScope() == null ? "" : head.getPublicScope();
            PublicEnquiryService publicEnquiryService = (PublicEnquiryService)SpringContextUtils.getBean(PublicEnquiryServiceImpl.class);
            publicEnquiryService.publishNotice(head);
            if (publicScope.contains(SrmPublicScopeEnum.QQT_PLATFORM.getValue())) {
                this.publishToB2BService.publishToB2B(head, itemList);
            }
        }
        EnquiryJobUtil.createJob(head);
    }

    private void insertInitTable(String headId, List<PurchaseEnquiryItem> itemList) {
        int itemNumber = 1;
        for (PurchaseEnquiryItem item : itemList) {
            item.setItemNumber(String.valueOf(itemNumber++));
        }
        ElsInitialTableDTO elsInitialTable = new ElsInitialTableDTO();
        elsInitialTable.setRelationId(headId);
        elsInitialTable.setBusinessInfoJson(JSON.toJSONString(itemList));
        this.invokeBaseRpcService.addElsInitialTable(elsInitialTable);
    }

    @Override
    public AttachmentSendDTO publishEnquiry(PurchaseEnquiryHead head, List<PurchaseEnquiryItem> itemList, List<EnquirySupplierList> supplierList, List<PurchaseAttachmentDemandDTO> demandList) {
        String headId = head.getId();
        List<String> toElsAccountList = supplierList.stream().map(EnquirySupplierList::getToElsAccount).distinct().collect(Collectors.toList());
        List<String> materialNumberList = itemList.stream().filter(item -> StrUtil.isNotBlank((CharSequence)item.getMaterialNumber())).map(PurchaseEnquiryItem::getMaterialNumber).distinct().collect(Collectors.toList());
        Map<String, PurchaseMaterialRelationDTO> relationMap = this.inquiryInvokeMainDataRpcService.findByMaterialAndAccount(materialNumberList, toElsAccountList);
        ArrayList<PurchaseEnquiryItem> insertItemList = new ArrayList<PurchaseEnquiryItem>();
        LoginUser user = SysUtil.getLoginUser();
        for (EnquirySupplierList supplier : supplierList) {
            supplier.setId(IdWorker.getIdStr());
            supplier.setHeadId(headId);
            SysUtil.setSysParam((BaseEntity)supplier, (BaseEntity)head);
            int itemNumber = 1;
            for (PurchaseEnquiryItem item2 : itemList) {
                PurchaseEnquiryItem insertItem = new PurchaseEnquiryItem();
                BeanUtils.copyProperties((Object)((Object)item2), (Object)((Object)insertItem));
                insertItem.setId(null);
                insertItem.setHeadId(headId);
                insertItem.setSupplierId(supplier.getId());
                insertItem.setEnquiryNumber(head.getEnquiryNumber());
                insertItem.setItemNumber(String.valueOf(itemNumber++));
                insertItem.setItemStatus(EnquiryStatusEnum.QUOTING.getValue());
                insertItem.setAuditStatus("1".equals(head.getResultAudit()) ? AuditStatusEnum.AUDIT_NEW.getValue() : AuditStatusEnum.NO_AUDIT_REQUIRED.getValue());
                insertItem.setPurchaseName(user.getEnterpriseName());
                insertItem.setToElsAccount(supplier.getToElsAccount());
                insertItem.setSupplierName(supplier.getSupplierName());
                insertItem.setSupplierCode(supplier.getSupplierCode());
                if (EnquiryQuoteWayEnum.NORMAL.getValue().equals(item2.getQuotePriceWay())) {
                    insertItem.setLadderPriceJson(null);
                    insertItem.setCostFormJson(null);
                } else if (EnquiryQuoteWayEnum.LADDER.getValue().equals(item2.getQuotePriceWay())) {
                    insertItem.setCostFormJson(null);
                } else {
                    insertItem.setLadderPriceJson(null);
                }
                insertItem.setSendStatus("0");
                if (StrUtil.isNotBlank((CharSequence)item2.getMaterialNumber())) {
                    PurchaseMaterialRelationDTO relation = relationMap.get(item2.getMaterialNumber() + supplier.getToElsAccount());
                    insertItem.setSaleMaterialNumber(relation == null ? null : relation.getSaleMaterialNumber());
                }
                SysUtil.setSysParam((BaseEntity)insertItem, (BaseEntity)head);
                insertItemList.add(insertItem);
            }
        }
        this.purchaseEnquiryItemMapper.insertBatchSomeColumn(insertItemList);
        this.enquirySupplierListMapper.insertBatchSomeColumn(supplierList);
        Map<String, SaleEnquiryHead> supplierMap = this.saleEnquiryHeadService.add(head, insertItemList, supplierList);
        HashMap<String, String> idMap = new HashMap<String, String>();
        supplierMap.forEach((key, value) -> idMap.put((String)key, value.getId()));
        this.invokeBaseRpcService.sendPurchaseAttachmentDemandDemand(demandList, head.getId(), "enquiry", idMap);
        AttachmentSendDTO sendVO = new AttachmentSendDTO();
        sendVO.setElsAccount(TenantContext.getTenant());
        sendVO.setHeadId(head.getId());
        HashMap toSend = new HashMap();
        idMap.forEach((key, value) -> toSend.put(value, key));
        sendVO.setToSend(toSend);
        this.invokeBaseRpcService.sendPurchaseFile(sendVO, false);
        Map<String, JSONObject> receiveParamMap = this.getReceiveParamMap(supplierMap);
        head.setPurchaseCompanyName(user.getEnterpriseName());
        super.sendMsg(TenantContext.getTenant(), toElsAccountList, (Object)head, receiveParamMap, "enquiry", "publish");
        return sendVO;
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void publishNewSupplier(PurchaseEnquiryHeadVO headVO) {
        String headId = headVO.getId();
        PurchaseEnquiryHead dbHead = (PurchaseEnquiryHead)((Object)((PurchaseEnquiryHeadMapper)this.baseMapper).selectById((Serializable)((Object)headId)));
        Assert.isTrue((!"0".equals(dbHead.getPublishNewSupplier()) ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_alert_APtFxqhxVRdX_dac5ea44", (String)"\u5f53\u524d\u5355\u636e\u4e0d\u53ef\u53d1\u5e03\u65b0\u4f9b\u5e94\u5546"));
        Assert.isTrue((boolean)dbHead.getQuoteEndTime().after(new Date()), (String)I18nUtil.translate((String)"i18n_alert_yRKIIRWxqhxVRdX_b0725152", (String)"\u622a\u6b62\u65f6\u95f4\u5df2\u8fc7\uff0c\u4e0d\u53ef\u53d1\u5e03\u65b0\u4f9b\u5e94\u5546"));
        Assert.isTrue((!EnquiryStatusEnum.CANCEL.getValue().equals(dbHead.getEnquiryStatus()) ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_alert_IkujtFxqhxVRdX_d422af99", (String)"\u5df2\u4f5c\u5e9f\u7684\u5355\u636e\u4e0d\u53ef\u53d1\u5e03\u65b0\u4f9b\u5e94\u5546"));
        List hadList = this.enquirySupplierListMapper.selectByMainId(headId).parallelStream().map(EnquirySupplierList::getToElsAccount).distinct().collect(Collectors.toList());
        List<EnquirySupplierList> supplierList = headVO.getEnquirySupplierListList().parallelStream().filter(supplier -> !hadList.contains(supplier.getToElsAccount())).collect(Collectors.toList());
        Assert.notEmpty(supplierList, (String)I18nUtil.translate((String)"i18n_alert_APiFjRdOIOhxRrWSTKmhx_fda6d18a", (String)"\u5f53\u524d\u9009\u62e9\u7684\u4f9b\u5e94\u90fd\u5df2\u7ecf\u53d1\u5e03\u8fc7\u4e86\uff0c\u65e0\u9700\u518d\u6b21\u53d1\u5e03"));
        ElsInitialTableDTO initInfo = this.invokeBaseRpcService.selectElsInitialTableOne(headId);
        List itemList = JSON.parseArray((String)initInfo.getBusinessInfoJson(), PurchaseEnquiryItem.class);
        List demandList = this.invokeBaseRpcService.selectPurchaseAttachmentDemandByMainId(headId);
        this.publishEnquiry(dbHead, itemList, supplierList, demandList);
        PurchaseClarificationInfoService purchaseClarificationInfoService = (PurchaseClarificationInfoService)SpringContextUtils.getBean(PurchaseClarificationInfoServiceImpl.class);
        for (EnquirySupplierList supplier2 : supplierList) {
            purchaseClarificationInfoService.addClarificationInfoForSupplier(BusinessBillTypeEnum.ENQUIRY.getValue(), dbHead.getEnquiryNumber(), supplier2.getToElsAccount(), supplier2.getSupplierName());
        }
        List toElsAccountList = supplierList.stream().map(EnquirySupplierList::getToElsAccount).distinct().collect(Collectors.toList());
        String url = "enquiryNumber=" + dbHead.getEnquiryNumber();
        super.sendMsg(TenantContext.getTenant(), toElsAccountList, (Object)dbHead, url, "enquiry", "publish");
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void updateQuoteEntTime(PurchaseEnquiryHead dbHead, Date quoteEndTime) {
        PurchaseEnquiryHead updateHead = new PurchaseEnquiryHead();
        updateHead.setId(dbHead.getId());
        updateHead.setQuoteEndTime(quoteEndTime);
        this.updateById((Object)updateHead);
        this.saleEnquiryHeadService.update((Wrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().eq(SaleEnquiryHead::getRelationId, (Object)dbHead.getId())).set(SaleEnquiryHead::getQuoteEndTime, (Object)quoteEndTime));
        EnquiryJobUtil.updateJob(dbHead, quoteEndTime);
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void accept(PurchaseEnquiryHeadVO headVO) {
        PurchaseEnquiryHead dbHead = (PurchaseEnquiryHead)((Object)((PurchaseEnquiryHeadMapper)this.baseMapper).selectById((Serializable)((Object)headVO.getId())));
        Assert.isTrue(("1".equals(dbHead.getSeePrice()) || "1".equals(dbHead.getOpenBidStatus()) || new Date().after(dbHead.getQuoteEndTime()) ? 1 : 0) != 0, (String)"\u4e0d\u53ef\u63a5\u53d7\uff0c\u8bf7\u63d0\u524d\u5f00\u6807\u6216\u7b49\u5f85\u62a5\u4ef7\u7ed3\u675f");
        List<PurchaseEnquiryItem> acceptList = headVO.getPurchaseEnquiryItemList();
        acceptList.forEach(item -> {
            if (PriceCreateWayEnum.AUTO.getValue().equals(dbHead.getPriceCreateWay())) {
                Assert.hasText((String)item.getMaterialNumber(), (String)I18nUtil.translate((String)"i18n_title_pleaseSupplementMateriaCodeFirst", (String)"\u8bf7\u5148\u8865\u5145\u7269\u6599\u7f16\u7801"));
            }
            Assert.isTrue((EnquiryStatusEnum.QUOTED.getValue().equals(item.getItemStatus()) || EnquiryStatusEnum.BARGAIN.getValue().equals(item.getItemStatus()) ? 1 : 0) != 0, (String)"\u53ea\u6709\u8bae\u4ef7\u4e2d\u6216\u5df2\u62a5\u4ef7\u7684\u884c\u6570\u636e\u53ef\u63a5\u53d7");
            item.setItemStatus(EnquiryStatusEnum.ACCEPT.getValue());
        });
        String currentItemNumber = acceptList.get(0).getItemNumber();
        List<PurchaseEnquiryItem> pricedList = this.purchaseEnquiryItemService.selectByMainId(dbHead.getId()).stream().filter(item -> currentItemNumber.equals(item.getItemNumber())).collect(Collectors.toList());
        List bargainList = pricedList.stream().filter(item -> EnquiryStatusEnum.BARGAIN.getValue().equals(item.getItemStatus())).collect(Collectors.toList());
        if (bargainList.size() > 0) {
            List<SaleEnquiryHead> saleHeadList = this.saleEnquiryHeadService.selectByMainId(dbHead.getId());
            saleHeadList.forEach(head -> Assert.isTrue((boolean)head.getQuoteEndTime().before(new Date()), (String)I18nUtil.translate((String)"i18n_alert_djRdXsuyRSnqIu_a523e59f", (String)"\u6240\u6709\u4f9b\u5e94\u5546\u62a5\u4ef7\u622a\u6b62\u540e\u624d\u53ef\u5b9a\u4ef7")));
        }
        if ("1".equals(dbHead.getQuotaWay())) {
            acceptList.forEach(item -> Assert.isTrue((item.getQuota() != null && item.getQuota().compareTo(BigDecimal.ZERO) >= 0 ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_alert_vzWRxOLVWFlTfUW_f3c4a05c", (String)"\u62c6\u5206\u6570\u91cf\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u4e14\u5fc5\u987b\u5927\u4e8e0")));
            BigDecimal quotaTotal = acceptList.stream().map(PurchaseEnquiryItem::getQuota).reduce(BigDecimal.ZERO, BigDecimal::add);
            Assert.isTrue((quotaTotal.compareTo(BigDecimal.valueOf(100L)) == 0 ? 1 : 0) != 0, (String)I18nUtil.translate((String)"", (String)"\u62c6\u5206\u6570\u91cf\u4e4b\u548c\u5fc5\u987b\u7b49\u4e8e100\uff01"));
        } else {
            Assert.isTrue((acceptList.size() == 1 ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_alert_RqylIuRdX_5bcc3620", (String)"\u53ea\u53ef\u63a5\u53d7\u4e00\u5bb6\u4f9b\u5e94\u5546"));
        }
        Map acceptIdMap = acceptList.stream().collect(HashMap::new, (map, item) -> map.put(item.getId(), item.getQuota()), HashMap::putAll);
        pricedList.forEach(item -> {
            item.setItemStatus(EnquiryStatusEnum.REJECT.getValue());
            if (acceptIdMap.containsKey(item.getId())) {
                item.setQuota((BigDecimal)acceptIdMap.get(item.getId()));
                item.setItemStatus(EnquiryStatusEnum.ACCEPT.getValue());
            }
        });
        this.purchaseEnquiryItemService.updateBatchById(pricedList);
        if ("0".equals(dbHead.getResultAudit())) {
            this.priced(dbHead, pricedList);
            this.goBackDemand(pricedList, PurchaseRequestStatusItemEnum.INQUIRY_COMPLETED.getValue());
            if (PriceCreateWayEnum.AUTO.getValue().equals(dbHead.getPriceCreateWay())) {
                this.generatePriceRecord(dbHead, acceptList);
            }
        }
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void reject(PurchaseEnquiryHeadVO headVO) {
        PurchaseEnquiryHead dbHead = (PurchaseEnquiryHead)((Object)((PurchaseEnquiryHeadMapper)this.baseMapper).selectById((Serializable)((Object)headVO.getId())));
        Assert.isTrue(("1".equals(dbHead.getSeePrice()) || "1".equals(dbHead.getOpenBidStatus()) || new Date().after(dbHead.getQuoteEndTime()) ? 1 : 0) != 0, (String)"\u4e0d\u53ef\u62d2\u7edd\uff0c\u8bf7\u63d0\u524d\u5f00\u6807\u6216\u7b49\u5f85\u62a5\u4ef7\u7ed3\u675f");
        List<PurchaseEnquiryItem> rejectList = headVO.getPurchaseEnquiryItemList();
        rejectList.forEach(item -> {
            Assert.isNull((Object)item.getQuota(), (String)"\u62d2\u7edd\u5355\u636e\u4e0d\u53ef\u586b\u5199\u62c6\u5206\u6570\u91cf");
            item.setItemStatus(EnquiryStatusEnum.REJECT.getValue());
        });
        this.purchaseEnquiryItemService.updateBatchById(rejectList);
        if ("0".equals(dbHead.getResultAudit())) {
            this.priced(dbHead, rejectList);
            String currentItemNumber = rejectList.get(0).getItemNumber();
            List<PurchaseEnquiryItem> currentList = this.purchaseEnquiryItemService.selectByMainId(dbHead.getId()).stream().filter(item -> currentItemNumber.equals(item.getItemNumber())).collect(Collectors.toList());
            long count = currentList.stream().filter(item -> !EnquiryStatusEnum.ACCEPT.getValue().equals(item.getItemStatus()) && !EnquiryStatusEnum.REJECT.getValue().equals(item.getItemStatus())).count();
            if (count == 0L) {
                this.goBackDemand(currentList, PurchaseRequestStatusItemEnum.INQUIRY_COMPLETED.getValue());
            }
        }
    }

    @Override
    public void priced(PurchaseEnquiryHead dbHead, List<PurchaseEnquiryItem> pricedList) {
        List<PurchaseEnquiryItem> allList = this.purchaseEnquiryItemService.selectByMainId(dbHead.getId());
        long pricedCount = allList.stream().filter(item -> EnquiryStatusEnum.ACCEPT.getValue().equals(item.getItemStatus()) || EnquiryStatusEnum.REJECT.getValue().equals(item.getItemStatus())).count();
        if (pricedCount == (long)allList.size()) {
            dbHead.setEnquiryStatus(EnquiryStatusEnum.PRICED.getValue());
            ((PurchaseEnquiryHeadMapper)this.baseMapper).updateById((Object)dbHead);
        }
        this.saleEnquiryHeadService.priced(dbHead, pricedList);
        List<Object> toElsAccount = new ArrayList();
        if (PricingNoticeEnum.ALL.getValue().equals(dbHead.getPricingNotice())) {
            toElsAccount = pricedList.stream().map(PurchaseEnquiryItem::getToElsAccount).distinct().collect(Collectors.toList());
        } else if (PricingNoticeEnum.WIN.getValue().equals(dbHead.getPricingNotice())) {
            toElsAccount = pricedList.stream().filter(item -> EnquiryStatusEnum.ACCEPT.getValue().equals(item.getItemStatus())).map(PurchaseEnquiryItem::getToElsAccount).distinct().collect(Collectors.toList());
        }
        String url = "enquiryNumber=" + dbHead.getEnquiryNumber();
        super.sendMsg(TenantContext.getTenant(), toElsAccount, (Object)dbHead, url, "enquiry", "confirm");
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void reQuote(PurchaseEnquiryHeadVO headVO) {
        List<PurchaseEnquiryItem> reQuoteList = headVO.getPurchaseEnquiryItemList();
        reQuoteList.forEach(item -> {
            Assert.isTrue((boolean)EnquiryStatusEnum.QUOTED.getValue().equals(item.getItemStatus()), (String)I18nUtil.translate((String)"i18n_alert_RjIsujcdIqssu_cd434132", (String)"\u53ea\u6709\u5df2\u62a5\u4ef7\u7684\u884c\u9879\u76ee\u53ef\u91cd\u62a5\u4ef7"));
            item.setItemStatus(EnquiryStatusEnum.BARGAIN.getValue());
        });
        this.purchaseEnquiryItemService.updateBatchById(reQuoteList);
        Map<String, SaleEnquiryHead> supplierMap = this.saleEnquiryHeadService.reQuote(headVO, reQuoteList);
        PurchaseEnquiryHead dbHead = (PurchaseEnquiryHead)((Object)this.getById((Serializable)((Object)headVO.getId())));
        List toElsAccount = reQuoteList.stream().map(PurchaseEnquiryItem::getToElsAccount).distinct().collect(Collectors.toList());
        Map<String, JSONObject> receiveParamMap = this.getReceiveParamMap(supplierMap);
        dbHead.setQuoteEndTime(headVO.getQuoteEndTime());
        dbHead.setPurchaseCompanyName(SysUtil.getLoginUser().getEnterpriseName());
        super.sendMsg(TenantContext.getTenant(), toElsAccount, (Object)dbHead, receiveParamMap, "enquiry", "reply");
    }

    private Map<String, JSONObject> getReceiveParamMap(Map<String, SaleEnquiryHead> supplierMap) {
        ConcurrentHashMap<String, JSONObject> receiveParamMap = new ConcurrentHashMap<String, JSONObject>();
        if (CollectionUtil.isNotEmpty(supplierMap)) {
            supplierMap.forEach((key, value) -> {
                JSONObject object = new JSONObject();
                object.put("id", (Object)value.getId());
                object.put("templateNumber", (Object)value.getTemplateNumber());
                object.put("templateVersion", (Object)value.getTemplateVersion());
                object.put("busAccount", (Object)value.getBusAccount());
                object.put("supplierTaxRate", (Object)value.getSupplierTaxRate());
                receiveParamMap.put((String)key, object);
            });
        }
        return receiveParamMap;
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void cancel(PurchaseEnquiryHead dbHead) {
        dbHead.setEnquiryStatus(EnquiryStatusEnum.CANCEL.getValue());
        ((PurchaseEnquiryHeadMapper)this.baseMapper).updateById((Object)dbHead);
        this.purchaseEnquiryItemService.update((Wrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().eq(PurchaseEnquiryItem::getHeadId, (Object)dbHead.getId())).set(PurchaseEnquiryItem::getItemStatus, (Object)EnquiryStatusEnum.CANCEL.getValue()));
        this.saleEnquiryHeadService.cancel(dbHead);
        List<PurchaseEnquiryItem> purchaseEnquiryItems = this.purchaseEnquiryItemService.selectByMainId(dbHead.getId());
        this.goBackDemand(purchaseEnquiryItems, PurchaseRequestStatusItemEnum.DEMAND_POOL.getValue());
        EnquiryJobUtil.deleteJob(dbHead);
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void regret(PurchaseEnquiryHeadVO headVO) {
        String headId = headVO.getId();
        PurchaseEnquiryHead dbHead = (PurchaseEnquiryHead)((Object)((PurchaseEnquiryHeadMapper)this.baseMapper).selectById((Serializable)((Object)headId)));
        List<PurchaseEnquiryItem> webList = headVO.getPurchaseEnquiryItemList();
        List regretList = webList.stream().filter(item -> EnquiryStatusEnum.ACCEPT.getValue().equals(item.getItemStatus()) || EnquiryStatusEnum.REJECT.getValue().equals(item.getItemStatus())).collect(Collectors.toList());
        Assert.notEmpty(regretList, (String)I18nUtil.translate((String)"i18n_alert_RRylSFKmSLjImRdXjsuSnqMB_3549b86f", (String)"\u81f3\u5c11\u63a5\u53d7\u6216\u62d2\u7edd\u6b64\u7269\u6599\u7684\u4e00\u4e2a\u4f9b\u5e94\u5546\u7684\u62a5\u4ef7\u540e\u624d\u53ef\u6094\u6807"));
        String regretFlag = headVO.getRegretFlag();
        RegretFlagEnum regretFlagEnum = RegretFlagEnum.getEnumByValue(regretFlag);
        switch (regretFlagEnum) {
            case RE_SOURCE: {
                this.goBackDemand(webList, PurchaseRequestStatusItemEnum.DEMAND_POOL.getValue());
            }
            case NOT_SOURCE: {
                this.regret(dbHead, webList, EnquiryStatusEnum.REGRET.getValue());
                break;
            }
            case RE_PRICED: {
                this.regret(dbHead, webList, EnquiryStatusEnum.BARGAIN.getValue());
                break;
            }
        }
    }

    private void regret(PurchaseEnquiryHead dbHead, List<PurchaseEnquiryItem> webList, String itemStatus) {
        webList.forEach(item -> item.setItemStatus(itemStatus));
        this.purchaseEnquiryItemService.updateBatchById(webList);
        List<PurchaseEnquiryItem> allList = this.purchaseEnquiryItemService.selectByMainId(dbHead.getId());
        long regretCount = allList.stream().filter(item -> EnquiryStatusEnum.REGRET.getValue().equals(item.getItemStatus())).count();
        long bargainCount = allList.stream().filter(item -> EnquiryStatusEnum.BARGAIN.getValue().equals(item.getItemStatus())).count();
        if ((long)allList.size() == regretCount) {
            dbHead.setEnquiryStatus(EnquiryStatusEnum.REGRET.getValue());
        } else if ((long)allList.size() == bargainCount) {
            dbHead.setEnquiryStatus(EnquiryStatusEnum.BARGAIN.getValue());
        }
        ((PurchaseEnquiryHeadMapper)this.baseMapper).updateById((Object)dbHead);
        this.saleEnquiryHeadService.regret(dbHead, webList);
        String sourceNumber = dbHead.getEnquiryNumber();
        List<String> itemNumberList = webList.stream().map(PurchaseEnquiryItem::getItemNumber).distinct().collect(Collectors.toList());
        this.inquiryInvokeMainDataRpcService.cancelPurchaseInformationBySourceNumber(PriceSourceTypeEnum.ENQUIRY.getValue(), sourceNumber, itemNumberList);
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void generatePriceRecord(PurchaseEnquiryHead dbHead, List<PurchaseEnquiryItem> acceptList) {
        if (CollectionUtil.isNotEmpty(acceptList)) {
            ArrayList<PurchaseInformationRecordsDTO> recordsList = new ArrayList<PurchaseInformationRecordsDTO>();
            for (PurchaseEnquiryItem item : acceptList) {
                PurchaseInformationRecordsDTO records = new PurchaseInformationRecordsDTO();
                BeanUtils.copyProperties((Object)((Object)item), (Object)records);
                records.setPurchaseGroup(dbHead.getPurchaseGroup());
                records.setPurchaseOrg(dbHead.getPurchaseOrg());
                records.setCompany(dbHead.getCompany());
                records.setSourceType(PriceSourceTypeEnum.ENQUIRY.getValue());
                records.setSourceNumber(dbHead.getEnquiryNumber());
                records.setSourceItemNumber(item.getItemNumber());
                records.setCurrencyCode(item.getCurrency());
                records.setAuditStatus(AuditStatusEnum.AUDIT_FINISH.getValue());
                records.setPriceType(PurchaseInformationPriceTypeEnum.MATERIAL.getValue());
                recordsList.add(records);
            }
            this.inquiryInvokeMainDataRpcService.cutOffPriceDates(recordsList);
            this.inquiryInvokeMainDataRpcService.addBatch(recordsList);
            ArrayList<PurchaseEnquiryItem> updateList = new ArrayList<PurchaseEnquiryItem>();
            for (PurchaseEnquiryItem item : acceptList) {
                PurchaseEnquiryItem update = new PurchaseEnquiryItem();
                update.setId(item.getId());
                update.setSendStatus("1");
                updateList.add(update);
            }
            this.purchaseEnquiryItemService.updateBatchById(updateList);
        }
    }

    @Override
    public void executeReview(PurchaseQualificationReview review) {
        String headId = review.getRelationId();
        PurchaseEnquiryHead dbHead = (PurchaseEnquiryHead)((Object)this.getById((Serializable)((Object)headId)));
        Assert.isTrue((boolean)dbHead.getQuoteEndTime().after(new Date()), (String)I18nUtil.translate((String)"", (String)"\u5ba1\u67e5\u65f6\u95f4\u5df2\u8fc7\uff0c\u4e0d\u53ef\u5ba1\u67e5"));
        if (QualificationReviewEnum.BEFORE_QUOTE.getValue().equals(dbHead.getQualificationReview())) {
            return;
        }
        this.executeReview(dbHead, review);
    }

    @Override
    public void executeReview(PurchaseEnquiryHead dbHead, PurchaseQualificationReview review) {
        ElsInitialTableDTO initInfo = this.invokeBaseRpcService.selectElsInitialTableOne(dbHead.getId());
        List initItemList = JSON.parseArray((String)initInfo.getBusinessInfoJson(), PurchaseEnquiryItem.class);
        ArrayList supplierList = Lists.newArrayList();
        EnquirySupplierList supplier = new EnquirySupplierList();
        supplier.setToElsAccount(review.getToElsAccount());
        supplier.setSupplierCode(review.getSupplierCode());
        supplier.setSupplierName(review.getSupplierName());
        supplierList.add(supplier);
        List itemStatusList = this.purchaseEnquiryItemService.selectByMainId(dbHead.getId()).stream().filter(item -> EnquiryStatusEnum.NEW.getValue().equals(item.getItemStatus())).map(PurchaseEnquiryItem::getItemStatus).distinct().collect(Collectors.toList());
        if (itemStatusList.contains(EbiddingStatusEnum.NEW.getValue())) {
            this.deleteSubTable(dbHead.getId());
        }
        List demandList = this.invokeBaseRpcService.selectPurchaseAttachmentDemandByMainId(dbHead.getId());
        AttachmentSendDTO sendVO = this.publishEnquiry(dbHead, initItemList, supplierList, demandList);
        PurchaseClarificationInfoService purchaseClarificationInfoService = (PurchaseClarificationInfoService)SpringContextUtils.getBean(PurchaseClarificationInfoServiceImpl.class);
        purchaseClarificationInfoService.addClarificationInfoForSupplier(BusinessBillTypeEnum.ENQUIRY.getValue(), dbHead.getEnquiryNumber(), supplier.getToElsAccount(), supplier.getSupplierName());
        this.invokeBaseRpcService.updateSaleFile(sendVO);
    }
}

