/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.bidding.service.impl;

import com.els.common.aspect.annotation.SrmTransaction;
import com.els.common.constant.CommonConstant;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.util.SysUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.base.api.dto.PurchaseAttachmentDTO;
import com.els.modules.base.api.dto.SaleAttachmentDTO;
import com.els.modules.bidding.entity.SaleMentoringHead;
import com.els.modules.bidding.entity.SaleMentoringItem;
import com.els.modules.bidding.mapper.SaleMentoringHeadMapper;
import com.els.modules.bidding.mapper.SaleMentoringItemMapper;
import com.els.modules.bidding.service.PurchaseMentoringHeadService;
import com.els.modules.bidding.service.SaleMentoringHeadService;
import com.els.modules.bidding.vo.PurchaseMentoringHeadVO;
import com.els.rpc.service.InvokeBaseRpcService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SaleMentoringHeadServiceImpl
extends BaseServiceImpl<SaleMentoringHeadMapper, SaleMentoringHead>
implements SaleMentoringHeadService {
    @Autowired
    private SaleMentoringHeadMapper saleMentoringHeadMapper;
    @Autowired
    private SaleMentoringItemMapper saleMentoringItemMapper;
    @Autowired
    private PurchaseMentoringHeadService purchaseMentoringHeadService;
    @Autowired
    private InvokeBaseRpcService invokeBaseRpcService;

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void saveMain(SaleMentoringHead saleMentoringHead, List<SaleMentoringItem> saleMentoringItemList, List<SaleAttachmentDTO> attachments) {
        saleMentoringHead.setSupplierName(SysUtil.getLoginUser().getEnterpriseName());
        if (StringUtils.isBlank((CharSequence)saleMentoringHead.getSubmitStatus())) {
            saleMentoringHead.setSubmitStatus("0");
        }
        saleMentoringHead.setBusAccount(saleMentoringHead.getToElsAccount());
        saleMentoringHead.setMentoringNumber(this.invokeBaseRpcService.getNextCode("mentoringNumber", (Object)saleMentoringHead, saleMentoringHead.getBusAccount()));
        this.saleMentoringHeadMapper.insert((Object)saleMentoringHead);
        this.updateAttachments(saleMentoringHead, attachments);
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void updateMain(SaleMentoringHead saleMentoringHead, List<SaleMentoringItem> saleMentoringItemList, List<SaleAttachmentDTO> attachments) {
        this.saleMentoringHeadMapper.updateById((Object)saleMentoringHead);
        this.invokeBaseRpcService.deleteSaleAttachmentByMainId(saleMentoringHead.getId());
        this.updateAttachments(saleMentoringHead, attachments);
    }

    private void updateAttachments(SaleMentoringHead saleMentoringHead, List<SaleAttachmentDTO> attachments) {
        if (attachments != null) {
            for (SaleAttachmentDTO saleAttachment : attachments) {
                if (StringUtils.isBlank((CharSequence)saleAttachment.getHeadId())) {
                    saleAttachment.setHeadId(saleMentoringHead.getId());
                }
                saleAttachment.setId(null);
            }
            this.invokeBaseRpcService.insertSaleAttachmentBatchSomeColumn(attachments);
        }
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void delMain(String id) {
        this.saleMentoringItemMapper.deleteByMainId(id);
        this.saleMentoringHeadMapper.deleteById((Serializable)((Object)id));
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void delBatchMain(List<String> idList) {
        for (Serializable serializable : idList) {
            this.saleMentoringItemMapper.deleteByMainId(serializable.toString());
            this.saleMentoringHeadMapper.deleteById(serializable);
        }
    }

    @Override
    public void submit(SaleMentoringHead mentoringHead, List<SaleAttachmentDTO> attachments) {
        mentoringHead.setSubmitStatus("1");
        if (StringUtils.isNotBlank((CharSequence)mentoringHead.getId())) {
            this.updateMain(mentoringHead, null, attachments);
        } else {
            this.saveMain(mentoringHead, null, attachments);
        }
        PurchaseMentoringHeadVO purchaseMentoringHead = new PurchaseMentoringHeadVO();
        BeanUtils.copyProperties((Object)((Object)mentoringHead), (Object)((Object)purchaseMentoringHead));
        purchaseMentoringHead.setId(null);
        purchaseMentoringHead.setRelationId(mentoringHead.getId());
        purchaseMentoringHead.setElsAccount(mentoringHead.getToElsAccount());
        purchaseMentoringHead.setToElsAccount(mentoringHead.getElsAccount());
        purchaseMentoringHead.setReceiveTime(new Date());
        purchaseMentoringHead.setViewStatus("0");
        ArrayList<PurchaseAttachmentDTO> purchaseAttachments = null;
        if (attachments != null) {
            purchaseAttachments = new ArrayList<PurchaseAttachmentDTO>();
            ArrayList<SaleAttachmentDTO> saleAttachments = new ArrayList<SaleAttachmentDTO>();
            for (SaleAttachmentDTO saleAttachment : attachments) {
                if (StringUtils.isBlank((CharSequence)saleAttachment.getHeadId()) || StringUtils.isNotBlank((CharSequence)saleAttachment.getHeadId()) && "undefined".equals(saleAttachment.getHeadId())) {
                    saleAttachment.setHeadId(mentoringHead.getId());
                    saleAttachments.add(saleAttachment);
                }
                PurchaseAttachmentDTO purchaseAttachment = new PurchaseAttachmentDTO();
                BeanUtils.copyProperties((Object)saleAttachment, (Object)purchaseAttachment);
                purchaseAttachment.setId(null);
                purchaseAttachment.setRelationId(purchaseAttachment.getId());
                purchaseAttachment.setElsAccount(purchaseMentoringHead.getElsAccount());
                purchaseAttachment.setHeadId(purchaseMentoringHead.getId());
                purchaseAttachment.setDeleted(CommonConstant.DEL_FLAG_0);
                purchaseAttachments.add(purchaseAttachment);
            }
        }
        this.purchaseMentoringHeadService.saveMain(purchaseMentoringHead, null, purchaseAttachments);
        String url = "id=" + purchaseMentoringHead.getId();
        super.sendMsg(TenantContext.getTenant(), mentoringHead.getToElsAccount(), (Object)mentoringHead, url, "mentoring", "publish");
    }
}

