/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.demand.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.conditions.update.LambdaUpdateChainWrapper;
import com.els.api.dto.BaseDTO;
import com.els.common.aspect.annotation.SrmTransaction;
import com.els.common.enumerate.AuditStatusEnum;
import com.els.common.exception.ELSBootException;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.system.vo.LoginUser;
import com.els.common.util.I18nUtil;
import com.els.common.util.SpringContextUtils;
import com.els.common.util.SysUtil;
import com.els.modules.base.api.dto.PurchaseAttachmentDTO;
import com.els.modules.demand.entity.PurchaseRequestHead;
import com.els.modules.demand.entity.PurchaseRequestItem;
import com.els.modules.demand.enumerate.PurchaseRequestStatusEnum;
import com.els.modules.demand.enumerate.PurchaseRequestStatusItemEnum;
import com.els.modules.demand.mapper.PurchaseRequestHeadMapper;
import com.els.modules.demand.mapper.PurchaseRequestItemMapper;
import com.els.modules.demand.rpc.PurchaseInformationRecordsLocalRpcService;
import com.els.modules.demand.rpc.PurchaseMaterialHeadLocalRpcService;
import com.els.modules.demand.rpc.PurchaseMaterialSourceLocalRpcService;
import com.els.modules.demand.rpc.PurchaseOrganizationInfoLocalRpcService;
import com.els.modules.demand.service.PurchaseRequestHeadService;
import com.els.modules.demand.service.PurchaseRequestItemService;
import com.els.modules.demand.vo.PurchaseRequestHeadVO;
import com.els.modules.demand.vo.RequestMatchInfomationVO;
import com.els.modules.inquiry.rpc.service.InquiryInvokeMainDataRpcService;
import com.els.modules.inquiry.rpc.service.InquiryInvokeOrderRpcService;
import com.els.modules.material.api.dto.PurchaseMaterialHeadDTO;
import com.els.modules.material.api.dto.PurchaseMaterialHeadExtendDTO;
import com.els.modules.material.api.dto.PurchaseMaterialItemDTO;
import com.els.modules.material.api.dto.PurchaseMaterialSourceDTO;
import com.els.modules.material.api.enumerate.MaterialSourceStatusEnum;
import com.els.modules.order.api.dto.OrderMatchInfomationDTO;
import com.els.modules.order.api.dto.PurchaseOrderPermissionConfigDTO;
import com.els.modules.org.api.dto.PurchaseOrganizationInfoDTO;
import com.els.modules.price.api.dto.PurchaseInformationRecordsDTO;
import com.els.modules.price.api.enumerate.PriceStatusEnum;
import com.els.rpc.service.InvokeBaseRpcService;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

@Service
public class PurchaseRequestHeadServiceImpl
extends BaseServiceImpl<PurchaseRequestHeadMapper, PurchaseRequestHead>
implements PurchaseRequestHeadService {
    public static final String HAD_SOURCE = "HADSOURCE";
    public static final String NO_HAD_SOURCE = "NOHAHSOURCE";
    @Resource
    private PurchaseRequestHeadMapper purchaseRequestHeadMapper;
    @Resource
    private PurchaseRequestItemMapper purchaseRequestItemMapper;
    @Autowired
    private PurchaseRequestItemService purchaseRequestItemService;
    @Resource
    private PurchaseMaterialHeadLocalRpcService purchaseMaterialHeadLocalRpcService;
    @Resource
    private PurchaseInformationRecordsLocalRpcService purchaseInformationRecordsService;
    @Resource
    private PurchaseOrganizationInfoLocalRpcService purchaseOrganizationInfoService;
    @Resource
    private PurchaseMaterialSourceLocalRpcService purchaseMaterialSourceLocalRpcService;
    @Resource
    private InvokeBaseRpcService invokeBaseRpcService;
    @Resource
    private InquiryInvokeOrderRpcService inquiryInvokeOrderRpcService;
    @Resource
    private InquiryInvokeMainDataRpcService inquiryInvokeMainDataRpcService;

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void saveMain(PurchaseRequestHeadVO purchaseRequestHead, List<PurchaseRequestItem> purchaseRequestItemList, List<PurchaseAttachmentDTO> purchaseAttachmentList) {
        List<PurchaseOrganizationInfoDTO> list;
        if (StringUtils.isBlank((CharSequence)purchaseRequestHead.getRequestNumber())) {
            String nextCode = this.invokeBaseRpcService.getNextCode("srmPurchaseRequestNumber", (Object)purchaseRequestHead);
            purchaseRequestHead.setRequestNumber(nextCode);
        }
        purchaseRequestHead.setApplyDate(new Date());
        purchaseRequestHead.setRequestStatus(PurchaseRequestStatusEnum.REQUEST_NEW.getValue());
        purchaseRequestHead.setAuditStatus(AuditStatusEnum.AUDIT_NEW.getValue());
        LoginUser loginUser = SysUtil.getLoginUser();
        purchaseRequestHead.setApplicant(loginUser.getSubAccount() + "_" + loginUser.getRealname());
        if (StringUtils.isNotBlank((CharSequence)loginUser.getOrgCode()) && loginUser.getOrgCode().split(",").length == 1 && !CollectionUtils.isEmpty(list = this.purchaseOrganizationInfoService.listByIdAndCateCode(loginUser.getOrgCode().split(",")[0], loginUser.getElsAccount(), "dept"))) {
            purchaseRequestHead.setApplyDept(list.get(0).getOrgCode() + "_" + list.get(0).getOrgName());
        }
        this.purchaseRequestHeadMapper.insert((Object)purchaseRequestHead);
        this.insertData(purchaseRequestHead, purchaseRequestItemList, purchaseAttachmentList);
    }

    @Override
    @SrmTransaction(rollbackFor={Exception.class})
    public void updateMain(PurchaseRequestHeadVO purchaseRequestHead, List<PurchaseRequestItem> purchaseRequestItemList, List<PurchaseAttachmentDTO> purchaseAttachmentList) {
        if (!CollectionUtils.isEmpty(purchaseRequestItemList)) {
            BigDecimal total = purchaseRequestItemList.stream().filter(p -> p.getSubtotalAmount() != null).map(PurchaseRequestItem::getSubtotalAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
            purchaseRequestHead.setTotalAmount(total);
        }
        if ("0".equals(purchaseRequestHead.getAudit())) {
            purchaseRequestHead.setAuditStatus(AuditStatusEnum.NO_AUDIT_REQUIRED.getValue());
        } else if ("1".equals(purchaseRequestHead.getAudit()) && AuditStatusEnum.NO_AUDIT_REQUIRED.getValue().equals(purchaseRequestHead.getAuditStatus())) {
            purchaseRequestHead.setAuditStatus(AuditStatusEnum.AUDIT_NEW.getValue());
        }
        this.purchaseRequestHeadMapper.updateById((Object)purchaseRequestHead);
        this.purchaseRequestItemMapper.deleteByMainId(purchaseRequestHead.getId());
        this.invokeBaseRpcService.deletePurchaseAttachmentByMainId(purchaseRequestHead.getId());
        this.insertData(purchaseRequestHead, purchaseRequestItemList, purchaseAttachmentList);
    }

    private void insertData(PurchaseRequestHead purchaseRequestHead, List<PurchaseRequestItem> purchaseRequestItemList, List<PurchaseAttachmentDTO> purchaseAttachmentList) {
        if (!CollectionUtils.isEmpty(purchaseRequestItemList)) {
            Map<String, PurchaseOrderPermissionConfigDTO> orderPermissionConfigMap = this.getOrderPermissionConfigMap(purchaseRequestItemList);
            int count = 1;
            for (PurchaseRequestItem entity : purchaseRequestItemList) {
                entity.setUpdateBy(null);
                entity.setUpdateTime(null);
                if (null == entity.getId()) {
                    entity.setCreateBy(null);
                    entity.setCreateTime(null);
                }
                entity.setAuditStatus(purchaseRequestHead.getAuditStatus());
                entity.setHeadId(purchaseRequestHead.getId());
                entity.setItemNumber(count + "");
                entity.setId(null);
                if (PurchaseRequestStatusItemEnum.SEND_BACK.getValue().equals(entity.getItemStatus())) {
                    entity.setItemStatus(PurchaseRequestStatusItemEnum.APPROVED.getValue());
                    entity.setRole(null);
                    entity.setPurchasePrincipal(null);
                    entity.setResponsibleGroup(null);
                }
                entity.setRequestNumber(purchaseRequestHead.getRequestNumber());
                entity.setRequestType(purchaseRequestHead.getRequestType());
                if (StringUtils.isBlank((CharSequence)entity.getPurchaseType())) {
                    entity.setPurchaseType(purchaseRequestHead.getPurchaseType());
                }
                entity.setApplyDept(purchaseRequestHead.getApplyDept());
                if (StringUtils.isNotBlank((CharSequence)purchaseRequestHead.getFactory()) && StringUtils.isBlank((CharSequence)entity.getFactory())) {
                    entity.setFactory(purchaseRequestHead.getFactory());
                }
                entity.setPurchaseGroup(purchaseRequestHead.getPurchaseGroup());
                if (orderPermissionConfigMap.get(entity.getCateCode() + "_" + entity.getFactory()) != null) {
                    entity.setPurchaseOrg(orderPermissionConfigMap.get(entity.getCateCode() + "_" + entity.getFactory()).getPurchaseOrg());
                } else if (orderPermissionConfigMap.get("_" + entity.getFactory()) != null) {
                    entity.setPurchaseOrg(orderPermissionConfigMap.get("_" + entity.getFactory()).getPurchaseOrg());
                } else {
                    throw new ELSBootException("\u91c7\u8d2d\u7533\u8bf7\u884c[" + entity.getMaterialSpec() + "]\u8bf7\u5728\u91c7\u8d2d\u6743\u9650\u914d\u7f6e\u4e2d\u7ef4\u62a4\u5de5\u5382\u5bf9\u5e94\u7684\u91c7\u8d2d\u7ec4\u7ec7");
                }
                if (StringUtils.isNotEmpty((CharSequence)entity.getFactory())) {
                    PurchaseOrganizationInfoDTO purchaseOrganizationInfoDTO = this.inquiryInvokeMainDataRpcService.selectByElsAccountAndCode(purchaseRequestHead.getElsAccount(), "factory", entity.getFactory());
                    if (purchaseOrganizationInfoDTO != null) {
                        if (StringUtils.isEmpty((CharSequence)purchaseOrganizationInfoDTO.getSuperBusinessId())) {
                            throw new ELSBootException("\u7ec4\u7ec7\u8bbe\u7f6e\u4e2d\u7684\u7ec4\u7ec7\u7f16\u7801\u4e3a[" + entity.getFactory() + "]\u6ca1\u6709\u7ef4\u62a4\u4e0a\u7ea7\u4e1a\u52a1\u7ec4\u7ec7,\u8bf7\u7ef4\u62a4");
                        }
                        PurchaseOrganizationInfoDTO companyOrgInfo = this.inquiryInvokeMainDataRpcService.getById(purchaseOrganizationInfoDTO.getSuperBusinessId());
                        entity.setCompany(companyOrgInfo.getOrgCode());
                    } else {
                        throw new ELSBootException("\u7cfb\u7edf\u67e5\u8be2\u4e0d\u5230\u5de5\u5382\u4ee3\u7801\u4e3a[" + entity.getFactory() + "]\u7684\u7ec4\u7ec7\u67b6\u6784\u4fe1\u606f");
                    }
                }
                entity.setApplyDate(purchaseRequestHead.getApplyDate());
                entity.setApplicant(purchaseRequestHead.getApplicant());
                entity.setSourceNumber(purchaseRequestHead.getRequestNumber());
                entity.setSourceItemNumber(count + "");
                ++count;
                SysUtil.setSysParam((BaseEntity)entity, (BaseEntity)purchaseRequestHead);
            }
            if (!purchaseRequestItemList.isEmpty()) {
                this.purchaseRequestItemService.saveBatch(purchaseRequestItemList, 2000);
            }
        }
        if (!CollectionUtils.isEmpty(purchaseAttachmentList)) {
            for (PurchaseAttachmentDTO entity : purchaseAttachmentList) {
                entity.setCreateTime(null);
                entity.setId(null);
                entity.setCreateBy(null);
                entity.setUpdateBy(null);
                entity.setUpdateTime(null);
                entity.setHeadId(purchaseRequestHead.getId());
                SysUtil.setSysParam((BaseDTO)entity, (BaseEntity)purchaseRequestHead);
            }
            if (!purchaseAttachmentList.isEmpty()) {
                this.invokeBaseRpcService.insertPurchaseAttachmentBatchSomeColumn(purchaseAttachmentList);
            }
        }
    }

    private Map<String, PurchaseOrderPermissionConfigDTO> getOrderPermissionConfigMap(List<PurchaseRequestItem> purchaseRequestItemList) {
        ArrayList<String> cateCodeAndFactoryKeys = new ArrayList<String>();
        for (PurchaseRequestItem requestItem : purchaseRequestItemList) {
            if (cateCodeAndFactoryKeys.contains(requestItem.getCateCode() + "_" + requestItem.getFactory())) continue;
            cateCodeAndFactoryKeys.add(requestItem.getCateCode() + "_" + requestItem.getFactory());
            cateCodeAndFactoryKeys.add("_" + requestItem.getFactory());
        }
        List<PurchaseOrderPermissionConfigDTO> purchaseOrderPermissionConfigDTOList = this.inquiryInvokeOrderRpcService.getPurchaseOrderPermissionConfigList(cateCodeAndFactoryKeys);
        HashMap<String, PurchaseOrderPermissionConfigDTO> orderPermissionConfigByCodeCategoryMap = new HashMap<String, PurchaseOrderPermissionConfigDTO>();
        for (PurchaseOrderPermissionConfigDTO purchaseOrderPermissionConfigDTO : purchaseOrderPermissionConfigDTOList) {
            orderPermissionConfigByCodeCategoryMap.put(purchaseOrderPermissionConfigDTO.getCateCode() + "_" + purchaseOrderPermissionConfigDTO.getPurchaseFactory(), purchaseOrderPermissionConfigDTO);
        }
        return orderPermissionConfigByCodeCategoryMap;
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void delMain(String id) {
        this.purchaseRequestItemMapper.deleteByMainId(id);
        this.purchaseRequestHeadMapper.deleteById((Serializable)((Object)id));
        this.invokeBaseRpcService.deletePurchaseAttachmentByMainId(id);
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void delBatchMain(List<String> idList) {
        for (Serializable serializable : idList) {
            this.purchaseRequestItemMapper.deleteByMainId(serializable.toString());
            this.purchaseRequestHeadMapper.deleteById(serializable);
            this.invokeBaseRpcService.deletePurchaseAttachmentByMainId(serializable.toString());
        }
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void updateStatus(PurchaseRequestHead head) {
        PurchaseRequestHead updateBuyHead = new PurchaseRequestHead();
        updateBuyHead.setId(head.getId());
        updateBuyHead.setRequestStatus(head.getRequestStatus());
        if (PurchaseRequestStatusEnum.REQUEST_CANCAL.getValue().equals(head.getRequestStatus())) {
            ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.purchaseRequestItemService.lambdaUpdate().set(PurchaseRequestItem::getItemStatus, (Object)PurchaseRequestStatusItemEnum.CANCEL.getValue())).eq(PurchaseRequestItem::getHeadId, (Object)head.getId())).update();
        }
        this.purchaseRequestHeadMapper.updateById((Object)updateBuyHead);
    }

    @Override
    public void matchPrice(List<PurchaseRequestItem> purchaseRequestItemList) {
        ArrayList list = new ArrayList();
        if (CollectionUtils.isEmpty(purchaseRequestItemList)) {
            return;
        }
        Map<String, List> collect = purchaseRequestItemList.parallelStream().collect(Collectors.toMap(p -> p.getMaterialNumber() + "_" + p.getFactory() + "_" + p.getPurchaseOrg(), p -> {
            ArrayList<PurchaseRequestItem> getNameList = new ArrayList<PurchaseRequestItem>();
            getNameList.add((PurchaseRequestItem)((Object)p));
            return getNameList;
        }, (value1, value2) -> {
            value1.addAll(value2);
            return value1;
        }));
        ArrayList<String> list1 = new ArrayList<String>(collect.keySet());
        List<String> stringList = this.purchaseInformationRecordsService.checkPriceForSome(list1);
        if (!CollectionUtils.isEmpty(stringList)) {
            ArrayList purchaseRequestItems = new ArrayList();
            for (String s : stringList) {
                if (!collect.containsKey(s)) continue;
                purchaseRequestItems.addAll(collect.get(s));
            }
            if (!CollectionUtils.isEmpty(purchaseRequestItems)) {
                List collect1 = purchaseRequestItems.parallelStream().map(BaseEntity::getId).distinct().collect(Collectors.toList());
                ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.purchaseRequestItemService.lambdaUpdate().set(PurchaseRequestItem::getItemStatus, (Object)PurchaseRequestStatusItemEnum.WAIT_ORDER.getValue())).in(BaseEntity::getId, collect1)).update();
            }
        }
    }

    @Override
    public String matchInformationRecords(List<PurchaseRequestItem> purchaseRequestItemList) {
        ArrayList<RequestMatchInfomationVO> requestMatchInfomationVOList = new ArrayList<RequestMatchInfomationVO>();
        try {
            com.els.common.util.Assert.isNotEmpty(purchaseRequestItemList, (String)"\u9700\u6c42\u6c60\u8f6c\u8ba2\u7684\u884c\u4e0d\u80fd\u4e3a\u7a7a!");
            List ids = purchaseRequestItemList.stream().map(BaseEntity::getId).collect(Collectors.toList());
            PurchaseRequestItemService purchaseRequestItemService = (PurchaseRequestItemService)SpringContextUtils.getBean(PurchaseRequestItemService.class);
            List dbPurchaseRequestItems = purchaseRequestItemService.listByIds(ids);
            if (CollectionUtil.isEmpty((Collection)dbPurchaseRequestItems) || dbPurchaseRequestItems.size() != purchaseRequestItemList.size()) {
                throw new ELSBootException(I18nUtil.translate((String)"", (String)"\u9009\u62e9\u7684\u90e8\u5206\u8bf7\u9700\u6c42\u5728\u7cfb\u7edf\u67e5\u8be2\u4e0d\u5230\u5355\u636e"));
            }
            for (PurchaseRequestItem requestItem : dbPurchaseRequestItems) {
                BigDecimal toOrderQuantity = requestItem.getToOrderQuantity() == null ? BigDecimal.ZERO : requestItem.getToOrderQuantity();
                if (toOrderQuantity.compareTo(requestItem.getQuantity()) < 0) continue;
                throw new ELSBootException(I18nUtil.translate((String)"", (String)("\u9700\u6c42\u5355[" + requestItem.getRequestNumber() + "]\u884c\u53f7[" + requestItem.getItemNumber() + "]\u7684\u5df2\u8f6c\u8ba2\u5355\u6570\u91cf\u5fc5\u987b\u5c0f\u4e8e\u9700\u6c42\u6570\u91cf!")));
            }
            Map<String, PurchaseMaterialHeadExtendDTO> purchaseMaterialHeadExtendMap = this.getPurchaseMaterialHeadMap(purchaseRequestItemList);
            String hadSource = HAD_SOURCE;
            String noHadSource = NO_HAD_SOURCE;
            HashMap goodsMaterialNumberMap = new HashMap();
            goodsMaterialNumberMap.put(hadSource, new ArrayList());
            goodsMaterialNumberMap.put(noHadSource, new ArrayList());
            if (CollectionUtil.isNotEmpty(purchaseRequestItemList)) {
                List<RequestMatchInfomationVO> requestMatchInfomationVOS;
                if (purchaseMaterialHeadExtendMap != null) {
                    for (PurchaseRequestItem requestItem : purchaseRequestItemList) {
                        String key = requestItem.getMaterialNumber() + "_" + requestItem.getFactory();
                        PurchaseMaterialHeadExtendDTO purchaseMaterialHeadExtend = purchaseMaterialHeadExtendMap.get(key);
                        if ("1".equals(purchaseMaterialHeadExtend.getSource())) {
                            ((List)goodsMaterialNumberMap.get(hadSource)).add(requestItem);
                            continue;
                        }
                        ((List)goodsMaterialNumberMap.get(noHadSource)).add(requestItem);
                    }
                }
                if (CollectionUtil.isNotEmpty((Collection)((Collection)goodsMaterialNumberMap.get(hadSource)))) {
                    requestMatchInfomationVOS = this.doHadSourceRequest((List)goodsMaterialNumberMap.get(hadSource), purchaseMaterialHeadExtendMap);
                    requestMatchInfomationVOList.addAll(requestMatchInfomationVOS);
                }
                if (CollectionUtil.isNotEmpty((Collection)((Collection)goodsMaterialNumberMap.get(noHadSource)))) {
                    requestMatchInfomationVOS = this.doNoHadSourceRequest((List)goodsMaterialNumberMap.get(noHadSource), purchaseMaterialHeadExtendMap);
                    requestMatchInfomationVOList.addAll(requestMatchInfomationVOS);
                }
            }
        }
        catch (Exception e) {
            throw new ELSBootException(e.getMessage(), (Throwable)e, new String[0]);
        }
        String result = this.inquiryInvokeOrderRpcService.requestToCreateOrder(SysUtil.copyProperties(requestMatchInfomationVOList, OrderMatchInfomationDTO.class));
        return result;
    }

    private List<RequestMatchInfomationVO> doNoHadSourceRequest(List<PurchaseRequestItem> purchaseRequestItemList, Map<String, PurchaseMaterialHeadExtendDTO> purchaseMaterialHeadExtendMap) {
        ArrayList<RequestMatchInfomationVO> requestMatchInfomationVOList = new ArrayList<RequestMatchInfomationVO>();
        if (CollectionUtil.isNotEmpty(purchaseRequestItemList)) {
            HashMap requestMapByCatMap = new HashMap();
            for (PurchaseRequestItem requestItem : purchaseRequestItemList) {
                String key = requestItem.getMaterialNumber() + "-," + requestItem.getPurchaseOrg() + "-," + requestItem.getFactory();
                if (requestMapByCatMap.containsKey(key)) {
                    ((List)requestMapByCatMap.get(key)).add(requestItem);
                    continue;
                }
                ArrayList<PurchaseRequestItem> requestItemList = new ArrayList<PurchaseRequestItem>();
                requestItemList.add(requestItem);
                requestMapByCatMap.put(key, requestItemList);
            }
            List headIds = purchaseRequestItemList.stream().map(PurchaseRequestItem::getHeadId).distinct().collect(Collectors.toList());
            List purchaseRequestHeadList = this.purchaseRequestHeadMapper.selectBatchIds(headIds);
            Map requestHeadMap = purchaseRequestHeadList.stream().collect(Collectors.toMap(PurchaseRequestHead::getRequestNumber, Function.identity()));
            Set keys = requestMapByCatMap.keySet();
            for (String key : keys) {
                String materialNumber = key.split("-,")[0];
                String purchaseOrg = key.split("-,")[1];
                String factory = key.split("-,")[2];
                List requestItemList = (List)requestMapByCatMap.get(key);
                List<PurchaseInformationRecordsDTO> purchaseInformationRecordsList = this.purchaseInformationRecordsService.selectList(null, AuditStatusEnum.AUDIT_FINISH.getValue(), PriceStatusEnum.NORMAL.getValue(), new Date(), new Date(), materialNumber, purchaseOrg);
                if (CollectionUtil.isEmpty(purchaseInformationRecordsList)) {
                    throw new ELSBootException("\u7269\u6599\u7f16\u7801[" + materialNumber + "]\u7684\u9700\u6c42\u884c\u67e5\u627e\u4e0d\u5230\u6709\u6548\u4ef7\u683c");
                }
                PurchaseInformationRecordsDTO qualifiedPriceRecord = this.filterInformationBystrategy(purchaseInformationRecordsList, factory);
                PurchaseMaterialHeadExtendDTO purchaseMaterialHeadExtend = purchaseMaterialHeadExtendMap.get(materialNumber + "_" + factory);
                for (PurchaseRequestItem requestItem : requestItemList) {
                    if (qualifiedPriceRecord == null) continue;
                    PurchaseRequestHead requestHead = (PurchaseRequestHead)((Object)requestHeadMap.get(requestItem.getRequestNumber()));
                    RequestMatchInfomationVO requestMatchInfomationVO = new RequestMatchInfomationVO();
                    requestMatchInfomationVO.setRequestNumber(requestItem.getRequestNumber());
                    requestMatchInfomationVO.setRequestItemNumber(requestItem.getItemNumber());
                    requestMatchInfomationVO.setMaterialNumber(requestItem.getMaterialNumber());
                    requestMatchInfomationVO.setMaterialDesc(requestItem.getMaterialDesc());
                    requestMatchInfomationVO.setToElsAccount(qualifiedPriceRecord.getToElsAccount());
                    requestMatchInfomationVO.setSupplierName(qualifiedPriceRecord.getSupplierName());
                    BigDecimal toOrderQuantity = requestItem.getToOrderQuantity() == null ? BigDecimal.ZERO : requestItem.getToOrderQuantity();
                    requestMatchInfomationVO.setQuantity(requestItem.getQuantity().subtract(toOrderQuantity));
                    requestMatchInfomationVO.setToOrderQuantity(requestMatchInfomationVO.getQuantity());
                    requestMatchInfomationVO.setPreferredSupplier("0");
                    requestMatchInfomationVO.setTaxRate(qualifiedPriceRecord.getTaxRate());
                    requestMatchInfomationVO.setTaxCode(qualifiedPriceRecord.getTaxCode());
                    requestMatchInfomationVO.setPrice(qualifiedPriceRecord.getPrice());
                    requestMatchInfomationVO.setNetPirce(qualifiedPriceRecord.getNetPrice());
                    requestMatchInfomationVO.setEffectiveDate(qualifiedPriceRecord.getEffectiveDate());
                    requestMatchInfomationVO.setExpiryDate(qualifiedPriceRecord.getExpiryDate());
                    requestMatchInfomationVO.setPurchaseOrg(requestItem.getPurchaseOrg());
                    requestMatchInfomationVO.setPurchaseGroup(requestItem.getPurchaseGroup());
                    requestMatchInfomationVO.setCompany(requestItem.getCompany());
                    requestMatchInfomationVO.setJit(purchaseMaterialHeadExtend.getJit());
                    if (StringUtils.isNotBlank((CharSequence)purchaseMaterialHeadExtend.getItemFactory())) {
                        requestMatchInfomationVO.setJit(purchaseMaterialHeadExtend.getItemJit());
                    }
                    requestMatchInfomationVO.setCurrency(requestItem.getCurrency());
                    requestMatchInfomationVO.setFactory(requestItem.getFactory());
                    requestMatchInfomationVO.setStorageLocation(requestItem.getStorageLocation());
                    requestMatchInfomationVO.setRequestItemId(requestItem.getId());
                    requestMatchInfomationVO.setCheckQuality(purchaseMaterialHeadExtend.getCheckQuality());
                    requestMatchInfomationVO.setEstimate(qualifiedPriceRecord.getTemporaryPrice());
                    requestMatchInfomationVO.setLadderPriceJson(qualifiedPriceRecord.getLadderPriceJson());
                    requestMatchInfomationVO.setRequestType(requestHead.getRequestType());
                    requestMatchInfomationVO.setItemRequestType(requestItem.getPurchaseType());
                    requestMatchInfomationVO.setCheckQuality(requestItem.getCheckQuality());
                    requestMatchInfomationVO.setRequireDate(requestItem.getDeliveryDate());
                    requestMatchInfomationVO.setCateCode(requestItem.getCateCode());
                    requestMatchInfomationVO.setCateName(requestItem.getCateName());
                    if (!StringUtils.isNotEmpty((CharSequence)requestItem.getMaterialGroup())) {
                        throw new ELSBootException("\u91c7\u8d2d\u7533\u8bf7[" + requestItem.getRequestNumber() + "]\u7533\u8bf7\u884c\u53f7[" + requestItem.getItemNumber() + "]\u7269\u6599\u7ec4\u4e3a\u7a7a\uff0c\u8bf7\u8865\u5145\u540e\u518d\u6267\u884c\u8be5\u64cd\u4f5c");
                    }
                    requestMatchInfomationVO.setMaterialGroup(requestItem.getMaterialGroup());
                    requestMatchInfomationVOList.add(requestMatchInfomationVO);
                }
            }
        }
        return requestMatchInfomationVOList;
    }

    private List<RequestMatchInfomationVO> doHadSourceRequest(List<PurchaseRequestItem> purchaseRequestItemList, Map<String, PurchaseMaterialHeadExtendDTO> purchaseMaterialHeadExtendMap) {
        HashMap requestMapByCatMap = new HashMap();
        for (PurchaseRequestItem requestItem : purchaseRequestItemList) {
            String key = requestItem.getMaterialNumber() + "_" + requestItem.getPurchaseOrg() + "_" + requestItem.getFactory();
            if (requestMapByCatMap.containsKey(key)) {
                ((List)requestMapByCatMap.get(key)).add(requestItem);
                continue;
            }
            ArrayList<PurchaseRequestItem> requestItemList = new ArrayList<PurchaseRequestItem>();
            requestItemList.add(requestItem);
            requestMapByCatMap.put(key, requestItemList);
        }
        List headIds = purchaseRequestItemList.stream().map(PurchaseRequestItem::getHeadId).distinct().collect(Collectors.toList());
        List<String> materialNumbers = purchaseRequestItemList.stream().map(PurchaseRequestItem::getMaterialNumber).distinct().collect(Collectors.toList());
        List<PurchaseMaterialSourceDTO> purchaseMaterialSourceList = this.purchaseMaterialSourceLocalRpcService.selectList(materialNumbers, MaterialSourceStatusEnum.NORMAL.getValue(), new Date(), new Date());
        List purchaseRequestHeadList = this.purchaseRequestHeadMapper.selectBatchIds(headIds);
        Map<String, List<PurchaseMaterialSourceDTO>> materialNumberMapToSource = purchaseMaterialSourceList.parallelStream().collect(Collectors.groupingBy(PurchaseMaterialSourceDTO::getMaterialNumber));
        Map requestHeadMap = purchaseRequestHeadList.stream().collect(Collectors.toMap(PurchaseRequestHead::getRequestNumber, Function.identity()));
        ArrayList<RequestMatchInfomationVO> requestMatchInfomationVOList = new ArrayList<RequestMatchInfomationVO>();
        Set keys = requestMapByCatMap.keySet();
        for (String key : keys) {
            List<PurchaseInformationRecordsDTO> informationRecordsList;
            String materialNumber = key.split("_")[0];
            String purchaseOrg = key.split("_")[1];
            String factory = key.split("_")[2];
            List requestItemList = (List)requestMapByCatMap.get(key);
            List<PurchaseMaterialSourceDTO> materialSources = materialNumberMapToSource.get(materialNumber);
            PurchaseMaterialHeadExtendDTO purchaseMaterialHeadExtend = purchaseMaterialHeadExtendMap.get(materialNumber + "_" + factory);
            if (CollectionUtil.isEmpty(materialSources)) {
                throw new ELSBootException(I18nUtil.translate((String)"", (String)("\u7269\u6599\u7f16\u7801[" + materialNumber + "]\u7684\u9700\u6c42\u884c\u5728\u8d27\u6e90\u6e05\u5355\u67e5\u8be2\u4e0d\u5230\u5bf9\u5e94\u7684\u4f9b\u5e94\u5546\u6570\u636e\uff0c\u8bf7\u68c0\u67e5\u7269\u6599\u914d\u7f6e\u662f\u5426\u6b63\u786e")));
            }
            List<String> preferenceToElsAccountList = materialSources.stream().filter(item -> "1".equals(item.getPreferredSupplier())).map(PurchaseMaterialSourceDTO::getToElsAccount).distinct().collect(Collectors.toList());
            List<String> allToElsAccountList = materialSources.stream().map(PurchaseMaterialSourceDTO::getToElsAccount).distinct().collect(Collectors.toList());
            PurchaseInformationRecordsDTO qualifiedPriceRecord = null;
            if (CollectionUtil.isNotEmpty(preferenceToElsAccountList)) {
                informationRecordsList = this.purchaseInformationRecordsService.selectList(preferenceToElsAccountList, AuditStatusEnum.AUDIT_FINISH.getValue(), PriceStatusEnum.NORMAL.getValue(), new Date(), new Date(), materialNumber, purchaseOrg);
                if (CollectionUtil.isEmpty(informationRecordsList)) {
                    throw new ELSBootException("\u7269\u6599\u7f16\u7801[" + materialNumber + "]\u7684\u9700\u6c42\u884c\u67e5\u627e\u4e0d\u5230\u9996\u9009\u4f9b\u5e94\u5546[" + preferenceToElsAccountList.toString() + "]\u7684\u6709\u6548\u4ef7\u683c\u8bb0\u5f55,\u8bf7\u5148\u53bb\u5bfb\u6e90\u6216\u8005\u521b\u5efa\u4ef7\u683c");
                }
                qualifiedPriceRecord = this.filterInformationBystrategy(informationRecordsList, factory);
            } else {
                informationRecordsList = this.purchaseInformationRecordsService.selectList(allToElsAccountList, AuditStatusEnum.AUDIT_FINISH.getValue(), PriceStatusEnum.NORMAL.getValue(), new Date(), new Date(), materialNumber, purchaseOrg);
                if (CollectionUtil.isEmpty(informationRecordsList)) {
                    throw new ELSBootException("\u7269\u6599\u7f16\u7801[" + materialNumber + "]\u7684\u9700\u6c42\u884c\u67e5\u627e\u4e0d\u5230\u6709\u6548\u4ef7\u683c");
                }
                qualifiedPriceRecord = this.filterInformationBystrategy(informationRecordsList, factory);
            }
            for (PurchaseRequestItem requestItem : requestItemList) {
                if (qualifiedPriceRecord == null) continue;
                PurchaseRequestHead purchaseRequestHead = (PurchaseRequestHead)((Object)requestHeadMap.get(requestItem.getRequestNumber()));
                RequestMatchInfomationVO requestMatchInfomationVO = new RequestMatchInfomationVO();
                requestMatchInfomationVO.setRequestNumber(requestItem.getRequestNumber());
                requestMatchInfomationVO.setRequestItemNumber(requestItem.getItemNumber());
                requestMatchInfomationVO.setMaterialNumber(requestItem.getMaterialNumber());
                requestMatchInfomationVO.setMaterialDesc(requestItem.getMaterialDesc());
                requestMatchInfomationVO.setToElsAccount(qualifiedPriceRecord.getToElsAccount());
                requestMatchInfomationVO.setSupplierName(qualifiedPriceRecord.getSupplierName());
                BigDecimal toOrderQuantity = requestItem.getToOrderQuantity() == null ? BigDecimal.ZERO : requestItem.getToOrderQuantity();
                requestMatchInfomationVO.setQuantity(requestItem.getQuantity().subtract(toOrderQuantity));
                requestMatchInfomationVO.setPreferredSupplier("1");
                requestMatchInfomationVO.setToOrderQuantity(requestMatchInfomationVO.getQuantity());
                requestMatchInfomationVO.setPrice(qualifiedPriceRecord.getPrice());
                requestMatchInfomationVO.setNetPirce(qualifiedPriceRecord.getNetPrice());
                requestMatchInfomationVO.setTaxRate(qualifiedPriceRecord.getTaxRate());
                requestMatchInfomationVO.setTaxCode(qualifiedPriceRecord.getTaxCode());
                requestMatchInfomationVO.setEffectiveDate(qualifiedPriceRecord.getEffectiveDate());
                requestMatchInfomationVO.setExpiryDate(qualifiedPriceRecord.getExpiryDate());
                requestMatchInfomationVO.setPurchaseOrg(requestItem.getPurchaseOrg());
                requestMatchInfomationVO.setPurchaseGroup(requestItem.getPurchaseGroup());
                requestMatchInfomationVO.setCompany(requestItem.getCompany());
                requestMatchInfomationVO.setJit(purchaseMaterialHeadExtend.getJit());
                requestMatchInfomationVO.setLadderPriceJson(qualifiedPriceRecord.getLadderPriceJson());
                if (StringUtils.isNotBlank((CharSequence)purchaseMaterialHeadExtend.getItemFactory())) {
                    requestMatchInfomationVO.setJit(purchaseMaterialHeadExtend.getItemJit());
                }
                requestMatchInfomationVO.setCheckQuality(purchaseMaterialHeadExtend.getCheckQuality());
                requestMatchInfomationVO.setCurrency(requestItem.getCurrency());
                requestMatchInfomationVO.setFactory(requestItem.getFactory());
                requestMatchInfomationVO.setStorageLocation(requestItem.getStorageLocation());
                requestMatchInfomationVO.setRequestItemId(requestItem.getId());
                requestMatchInfomationVO.setEstimate(qualifiedPriceRecord.getTemporaryPrice());
                requestMatchInfomationVO.setRequestType(purchaseRequestHead.getRequestType());
                requestMatchInfomationVO.setRequestTypeName(purchaseRequestHead.getRequestTypeName());
                requestMatchInfomationVO.setItemRequestType(requestItem.getPurchaseType());
                requestMatchInfomationVO.setItemRequestTypeName(requestItem.getPurchaseType());
                requestMatchInfomationVO.setRequireDate(requestItem.getDeliveryDate());
                if (!StringUtils.isNotEmpty((CharSequence)requestItem.getMaterialGroup())) {
                    throw new ELSBootException("\u91c7\u8d2d\u7533\u8bf7[" + requestItem.getRequestNumber() + "]\u7533\u8bf7\u884c\u53f7[" + requestItem.getItemNumber() + "]\u7269\u6599\u7ec4\u4e3a\u7a7a\uff0c\u8bf7\u8865\u5145\u540e\u518d\u6267\u884c\u8be5\u64cd\u4f5c");
                }
                requestMatchInfomationVO.setMaterialGroup(requestItem.getMaterialGroup());
                requestMatchInfomationVO.setCheckQuality(requestItem.getCheckQuality());
                requestMatchInfomationVO.setCateCode(requestItem.getCateCode());
                requestMatchInfomationVO.setCateName(requestItem.getCateName());
                requestMatchInfomationVOList.add(requestMatchInfomationVO);
            }
        }
        return requestMatchInfomationVOList;
    }

    private PurchaseInformationRecordsDTO filterInformationBystrategy(List<PurchaseInformationRecordsDTO> informationRecordsList, String factory) {
        if (CollectionUtil.isEmpty(informationRecordsList)) {
            return null;
        }
        List PurchaseInformationRecordsByFactoryList = informationRecordsList.stream().filter(item -> factory.equals(item.getFactory())).collect(Collectors.toList());
        PurchaseInformationRecordsDTO lowerPriceInformationRecord = null;
        lowerPriceInformationRecord = CollectionUtil.isEmpty(PurchaseInformationRecordsByFactoryList) ? (PurchaseInformationRecordsDTO)informationRecordsList.stream().min(Comparator.comparing(PurchaseInformationRecordsDTO::getPrice)).orElse(null) : (PurchaseInformationRecordsDTO)PurchaseInformationRecordsByFactoryList.stream().min(Comparator.comparing(PurchaseInformationRecordsDTO::getPrice)).orElse(null);
        return lowerPriceInformationRecord;
    }

    private Map<String, PurchaseMaterialHeadExtendDTO> getPurchaseMaterialHeadMap(List<PurchaseRequestItem> purchaseRequestItemList) {
        if (CollectionUtil.isNotEmpty(purchaseRequestItemList)) {
            HashMap<String, PurchaseMaterialHeadExtendDTO> purchaseMaterialHeadExtendMap = new HashMap<String, PurchaseMaterialHeadExtendDTO>();
            List<String> materialNumbers = purchaseRequestItemList.stream().map(PurchaseRequestItem::getMaterialNumber).distinct().collect(Collectors.toList());
            List<PurchaseMaterialHeadDTO> purchaseMaterialHeadList = this.purchaseMaterialHeadLocalRpcService.listByMaterialNumbers(materialNumbers);
            Map materialByNumberMap = purchaseMaterialHeadList.stream().collect(Collectors.toMap(PurchaseMaterialHeadDTO::getMaterialNumber, Function.identity()));
            for (PurchaseRequestItem requestItem : purchaseRequestItemList) {
                String key = requestItem.getMaterialNumber() + "_" + requestItem.getFactory();
                if (purchaseMaterialHeadExtendMap.containsKey(key)) continue;
                PurchaseMaterialHeadExtendDTO purchaseMaterialHeadExtend = new PurchaseMaterialHeadExtendDTO();
                PurchaseMaterialHeadDTO purchaseMaterialHead = (PurchaseMaterialHeadDTO)materialByNumberMap.get(requestItem.getMaterialNumber());
                com.els.common.util.Assert.isNotNull((Object)purchaseMaterialHead, (String)("\u7269\u6599\u7f16\u7801:" + requestItem.getMaterialNumber() + "\u5728\u7269\u6599\u4e3b\u6570\u636e\u4e2d\u6ca1\u6709\u8be5\u6761\u7269\u6599,\u8bf7\u68c0\u67e5"));
                BeanUtils.copyProperties((Object)purchaseMaterialHead, (Object)purchaseMaterialHeadExtend);
                if (StringUtils.isNotBlank((CharSequence)requestItem.getFactory())) {
                    List<PurchaseMaterialItemDTO> purchaseMaterialItemList = this.purchaseMaterialHeadLocalRpcService.selectByMainIdAndFactory(purchaseMaterialHead.getId(), requestItem.getFactory());
                    PurchaseMaterialItemDTO purchaseMaterialItem = null;
                    if (CollectionUtil.isNotEmpty(purchaseMaterialItemList)) {
                        purchaseMaterialItem = purchaseMaterialItemList.get(0);
                    }
                    if (purchaseMaterialItem != null) {
                        purchaseMaterialHeadExtend.setSource(purchaseMaterialItem.getSource());
                        purchaseMaterialHeadExtend.setItemJit(purchaseMaterialItem.getJit());
                        purchaseMaterialHeadExtend.setItemFactory(purchaseMaterialItem.getFactory());
                    }
                }
                purchaseMaterialHeadExtendMap.put(key, purchaseMaterialHeadExtend);
            }
            return purchaseMaterialHeadExtendMap;
        }
        return null;
    }

    @Override
    public void syncRequestToOrderQuantity(List<PurchaseRequestItem> purchaseRequestItemList) {
        if (CollectionUtil.isNotEmpty(purchaseRequestItemList)) {
            ArrayList<PurchaseRequestItem> requestItemList = new ArrayList<PurchaseRequestItem>();
            for (PurchaseRequestItem requestItem : purchaseRequestItemList) {
                PurchaseRequestItem purchaseRequestItem = new PurchaseRequestItem();
                BigDecimal toOrderQuantitySum = this.inquiryInvokeOrderRpcService.selectToOrderQuantitySum(requestItem.getRequestNumber(), requestItem.getItemNumber(), requestItem.getElsAccount());
                if (toOrderQuantitySum == null) {
                    toOrderQuantitySum = BigDecimal.ZERO;
                }
                purchaseRequestItem.setId(requestItem.getId());
                purchaseRequestItem.setToOrderQuantity(toOrderQuantitySum);
                requestItemList.add(purchaseRequestItem);
            }
            this.purchaseRequestItemMapper.updateBatchById(requestItemList);
        }
    }

    @Override
    public void syncRequestatus(List<PurchaseRequestItem> requestItemList) {
        List ids = requestItemList.stream().map(BaseEntity::getId).collect(Collectors.toList());
        List purchaseRequestItems = this.purchaseRequestItemMapper.selectBatchIds(ids);
        if (CollectionUtil.isNotEmpty((Collection)purchaseRequestItems)) {
            ArrayList<PurchaseRequestItem> purchaseRequestItems1 = new ArrayList<PurchaseRequestItem>();
            for (PurchaseRequestItem requestItem : purchaseRequestItems) {
                PurchaseRequestItem purchaseRequestItem = new PurchaseRequestItem();
                purchaseRequestItem.setId(requestItem.getId());
                if (BigDecimal.ZERO.compareTo(requestItem.getToOrderQuantity()) == 0) {
                    purchaseRequestItem.setItemStatus(PurchaseRequestStatusItemEnum.WAIT_ORDER.getValue());
                } else if (BigDecimal.ZERO.compareTo(requestItem.getToOrderQuantity()) < 0) {
                    purchaseRequestItem.setItemStatus(PurchaseRequestStatusItemEnum.ORDER_BUILT.getValue());
                }
                purchaseRequestItems1.add(purchaseRequestItem);
            }
            this.purchaseRequestItemMapper.updateBatchById(purchaseRequestItems1);
        }
    }

    @Override
    public void toDemandPool(String id) {
        List<PurchaseRequestItem> collect;
        List<PurchaseRequestItem> purchaseRequestItems = this.purchaseRequestItemMapper.selectByMainId(id);
        if (CollectionUtils.isEmpty(purchaseRequestItems)) {
            throw new ELSBootException(I18nUtil.translate((String)"", (String)"\u63d0\u4ea4\u5230\u9700\u6c42\u6c60\u81f3\u5c11\u6709\u4e00\u4e2a\u884c\u9879\u76ee"));
        }
        HashMap itemStatusMap = new HashMap();
        purchaseRequestItems.forEach(item -> {
            Assert.isTrue((item.getQuantity() != null ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_alert_empty_notQuantity", (String)"\u884c\u6570\u91cf\u4e0d\u80fd\u4e3a\u7a7a"));
            Assert.isTrue((item.getQuantity().compareTo(BigDecimal.ZERO) > 0 ? 1 : 0) != 0, (String)I18nUtil.translate((String)"", (String)"\u884c\u6570\u91cf\u5c0f\u4e8e\u7b49\u4e8e0"));
            itemStatusMap.put(item.getId(), Integer.parseInt(item.getAuditStatus()));
        });
        PurchaseRequestHead purchaseRequestHead = (PurchaseRequestHead)((Object)this.getById((Serializable)((Object)id)));
        PurchaseRequestHeadVO purchaseRequestHeadVO = new PurchaseRequestHeadVO();
        BeanUtils.copyProperties((Object)((Object)purchaseRequestHead), (Object)((Object)purchaseRequestHeadVO));
        List<PurchaseRequestItem> purchaseRequestItemList = this.purchaseRequestItemService.selectByMainId(id);
        purchaseRequestHeadVO.setPurchaseRequestItemList(purchaseRequestItemList);
        if (!CollectionUtils.isEmpty(purchaseRequestItems)) {
            this.purchaseRequestItemService.toDemandPool(purchaseRequestHeadVO);
        }
        if (!CollectionUtils.isEmpty(purchaseRequestItems)) {
            LambdaQueryWrapper wrapper = Wrappers.lambdaQuery();
            wrapper.select(new SFunction[]{BaseEntity::getId, PurchaseRequestItem::getItemStatus});
            wrapper.in(BaseEntity::getId, itemStatusMap.keySet());
            List items = this.purchaseRequestItemService.list((Wrapper)wrapper);
            List ids = items.stream().filter(i -> PurchaseRequestStatusItemEnum.APPROVED.getValue().equals(i.getItemStatus()) || PurchaseRequestStatusItemEnum.SEND_BACK.getValue().equals(i.getItemStatus())).map(BaseEntity::getId).collect(Collectors.toList());
            if (!CollectionUtils.isEmpty(ids)) {
                LambdaUpdateWrapper updateWrapper = Wrappers.lambdaUpdate();
                updateWrapper.set(PurchaseRequestItem::getTacticsEntity, null);
                updateWrapper.set(PurchaseRequestItem::getTacticsObject, null);
                updateWrapper.set(PurchaseRequestItem::getItemStatus, (Object)PurchaseRequestStatusItemEnum.DEMAND_POOL.getValue());
                updateWrapper.in(BaseEntity::getId, ids);
                this.purchaseRequestItemService.update((Wrapper)updateWrapper);
            }
        }
        if (!CollectionUtils.isEmpty(collect = purchaseRequestItemList.parallelStream().filter(item -> !StringUtils.isBlank((CharSequence)item.getMaterialNumber())).collect(Collectors.toList()))) {
            this.matchPrice(collect);
        }
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().eq(BaseEntity::getId, (Object)purchaseRequestHeadVO.getId())).set(PurchaseRequestHead::getRequestStatus, (Object)PurchaseRequestStatusEnum.REQUEST_DEMAND.getValue())).update();
        List<PurchaseRequestItem> purchaseRequestItemsNew = this.purchaseRequestItemMapper.selectByMainId(id);
        List collect1 = purchaseRequestItemsNew.parallelStream().filter(item -> "sumit".equals(item.getTacticsEntity()) || "person".equals(item.getTacticsEntity())).map(PurchaseRequestItem::getTacticsObject).distinct().collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(collect1)) {
            for (String s : collect1) {
                if (!s.contains("_")) continue;
                String[] s1 = s.split("_");
                super.sendMsg(purchaseRequestHead.getElsAccount(), s1[1], (Object)purchaseRequestHead, "", "purchaseRequest", "publish");
            }
        }
    }
}

