/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.bidding.service.impl;

import cn.hutool.core.util.StrUtil;
import com.els.common.aspect.annotation.SrmTransaction;
import com.els.common.exception.ELSBootException;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.util.I18nUtil;
import com.els.common.util.IPUtils;
import com.els.config.mybatis.TenantContext;
import com.els.modules.base.api.dto.AttachmentSendDTO;
import com.els.modules.base.api.dto.SaleAttachmentDTO;
import com.els.modules.base.api.dto.SaleAttachmentDemandDTO;
import com.els.modules.bidding.entity.BiddingSupplier;
import com.els.modules.bidding.entity.PurchaseBiddingItem;
import com.els.modules.bidding.entity.SaleBiddingHead;
import com.els.modules.bidding.entity.SaleBiddingItem;
import com.els.modules.bidding.enumerate.BiddingItemStatusEnum;
import com.els.modules.bidding.enumerate.ReplyStatusEnum;
import com.els.modules.bidding.enumerate.StageTypeEnum;
import com.els.modules.bidding.mapper.BiddingSupplierMapper;
import com.els.modules.bidding.mapper.PurchaseBiddingItemMapper;
import com.els.modules.bidding.mapper.SaleBiddingHeadMapper;
import com.els.modules.bidding.mapper.SaleBiddingItemMapper;
import com.els.modules.bidding.service.PurchaseBiddingItemService;
import com.els.modules.bidding.service.SaleBiddingHeadService;
import com.els.modules.bidding.service.SaleBiddingItemService;
import com.els.modules.bidding.vo.SaleBiddingHeadVO;
import com.els.modules.inquiry.enumerate.QuoteTypeEnum;
import com.els.rpc.service.InvokeBaseRpcService;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SaleBiddingHeadServiceImpl
extends BaseServiceImpl<SaleBiddingHeadMapper, SaleBiddingHead>
implements SaleBiddingHeadService {
    private static final Logger log = LoggerFactory.getLogger(SaleBiddingHeadServiceImpl.class);
    @Autowired
    private SaleBiddingHeadMapper saleBiddingHeadMapper;
    @Autowired
    private SaleBiddingItemMapper saleBiddingItemMapper;
    @Autowired
    private SaleBiddingItemService saleBiddingItemService;
    @Autowired
    private BiddingSupplierMapper biddingSupplierMapper;
    @Autowired
    private PurchaseBiddingItemMapper purchaseBiddingItemMapper;
    @Autowired
    private PurchaseBiddingItemService purchaseBiddingItemService;
    @Autowired
    private InvokeBaseRpcService invokeBaseRpcService;

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void replyBidding(BiddingSupplier supplier, List<SaleBiddingItem> saleBiddingItemList) {
        String partEcho;
        String headId = supplier.getHeadId();
        SaleBiddingHead head = (SaleBiddingHead)((Object)this.saleBiddingHeadMapper.selectById((Serializable)((Object)headId)));
        Date echoEndTime = head.getEchoEndTime();
        Date currentTime = new Date();
        if (echoEndTime != null) {
            if (currentTime.after(echoEndTime)) {
                throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_oper_replyBidTimeOut", (String)"\u5e94\u6807\u622a\u6b62\u65f6\u95f4\u5df2\u5230\uff0c\u4e0d\u80fd\u5e94\u6807\u64cd\u4f5c\uff01"));
            }
        } else {
            Date bidBeginTime = head.getBidBeginTime();
            if (currentTime.after(bidBeginTime)) {
                throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_oper_replyBidQuoteStart", (String)"\u6295\u6807\u5f00\u59cb\u65f6\u95f4\u5df2\u5230\uff0c\u4e0d\u80fd\u5e94\u6807\u64cd\u4f5c\uff01"));
            }
        }
        BiddingSupplier dbSupplier = (BiddingSupplier)((Object)this.biddingSupplierMapper.selectById((Serializable)((Object)head.getSupplierListId())));
        if (!ReplyStatusEnum.WAIT_REPLY.getValue().equals(dbSupplier.getReplyStatus()) && !ReplyStatusEnum.NOT_NEED.getValue().equals(dbSupplier.getReplyStatus())) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_oper_repeat_edit", (String)"\u5df2\u7ecf\u54cd\u5e94\u7684\u5355\u636e\u4e0d\u80fd\u518d\u6b21\u64cd\u4f5c\uff01"));
        }
        int replyCount = 0;
        int itemCount = saleBiddingItemList.size();
        ArrayList<SaleBiddingItem> batchUpdateSaleBiddingItemList = new ArrayList<SaleBiddingItem>();
        for (SaleBiddingItem item : saleBiddingItemList) {
            String replyStatus = item.getReplyStatus();
            if ("1".equals(replyStatus)) {
                ++replyCount;
            }
            SaleBiddingItem updateItem = new SaleBiddingItem();
            updateItem.setId(item.getId());
            updateItem.setReplyStatus(replyStatus);
            int count = this.saleBiddingItemMapper.updateById((Object)updateItem);
            if (count == 0) {
                throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_APWFIKXWVVVXVSDJHrW_2fe92d52", (String)"\u5f53\u524d\u6570\u636e\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u5237\u65b0\u540e\u63d0\u4ea4\u66f4\u6539"));
            }
            batchUpdateSaleBiddingItemList.add(updateItem);
        }
        if (!batchUpdateSaleBiddingItemList.isEmpty()) {
            this.saleBiddingItemService.updateBatchById(batchUpdateSaleBiddingItemList, 2000);
        }
        if (!"1".equals(partEcho = head.getPartEcho()) && replyCount != itemCount && replyCount != 0) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_oper_partsReply", (String)"\u5f53\u524d\u5355\u636e\u4e0d\u5141\u8bb8\u90e8\u5206\u5e94\u6807\uff01"));
        }
        String replyStatus = ReplyStatusEnum.WAIT_REPLY.getValue();
        replyStatus = replyCount == itemCount ? ReplyStatusEnum.REPLYED.getValue() : (replyCount == 0 ? ReplyStatusEnum.REJECT.getValue() : ReplyStatusEnum.PART_REPLYED.getValue());
        supplier.setReplyStatus(replyStatus);
        supplier.setId(head.getSupplierListId());
        supplier.setReplyTime(new Date());
        supplier.setHeadId(head.getRelationId());
        int count = this.biddingSupplierMapper.updateById((Object)supplier);
        if (count == 0) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_APWFIKXWVVVXVSDJHrW_2fe92d52", (String)"\u5f53\u524d\u6570\u636e\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u5237\u65b0\u540e\u63d0\u4ea4\u66f4\u6539"));
        }
    }

    @Override
    public void quoteCheck(SaleBiddingHeadVO headVO) {
        String againQuote;
        Date currentTime = new Date();
        Date bidBeginTime = headVO.getBidBeginTime();
        Date bidEndTime = headVO.getBidEndTime();
        if (bidBeginTime.after(currentTime)) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_oper_quoteBidNotStart", (String)"\u6295\u6807\u5f00\u59cb\u65f6\u95f4\u672a\u5230\uff0c\u4e0d\u80fd\u6295\u6807"));
        }
        if (currentTime.after(bidEndTime)) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_oper_quoteBidTimeOut", (String)"\u6295\u6807\u622a\u6b62\u65f6\u95f4\u5df2\u8fc7\uff0c\u4e0d\u80fd\u6295\u6807"));
        }
        BiddingSupplier supplier = (BiddingSupplier)((Object)this.biddingSupplierMapper.selectById((Serializable)((Object)headVO.getSupplierListId())));
        if ("0".equals(supplier.getBidQuote())) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_oper_quoteBidByNotPermission", (String)"\u6ca1\u6709\u6295\u6807\u6743\u9650\uff0c\u4e0d\u80fd\u6295\u6807"));
        }
        if (ReplyStatusEnum.REJECT.getValue().equals(supplier.getReplyStatus())) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_oper_quoteBidByRefuseReply", (String)"\u5df2\u62d2\u7edd\u5e94\u6807\uff0c\u4e0d\u80fd\u6295\u6807"));
        }
        String needEcho = headVO.getNeedEcho();
        if ("1".equals(needEcho) && ReplyStatusEnum.WAIT_REPLY.getValue().equals(supplier.getReplyStatus())) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_oper_quoteBidByNotReply", (String)"\u5f53\u524d\u5355\u636e\u6ca1\u6709\u5e94\u6807\uff0c\u4e0d\u80fd\u6295\u6807"));
        }
        String string = againQuote = StrUtil.isBlank((CharSequence)headVO.getAgainQuote()) ? "0" : headVO.getAgainQuote();
        if (ReplyStatusEnum.QUOTE_BID.getValue().equals(supplier.getReplyStatus()) && againQuote.equals("0")) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_oper_repeat_offer", (String)"\u5df2\u7ecf\u62a5\u4ef7\uff0c\u4e0d\u53ef\u91cd\u590d\u62a5\u4ef7\uff01"));
        }
        List attachmentDemandList = headVO.getSaleAttachmentDemandList().stream().filter(o -> StageTypeEnum.QUOTE.getValue().equals(o.getStageType())).map(SaleAttachmentDemandDTO::getFileType).collect(Collectors.toList());
        List saleAttachmentList = headVO.getSaleAttachmentList().stream().filter(o -> o.getUploadElsAccount().equals(TenantContext.getTenant())).collect(Collectors.toList());
        Map<String, List<SaleAttachmentDTO>> fileMap = saleAttachmentList.stream().collect(Collectors.groupingBy(SaleAttachmentDTO::getFileType));
        for (String fileType : attachmentDemandList) {
            if (fileMap.containsKey(fileType)) continue;
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_fail_must_upload_file", (String)"\u8bf7\u6309\u7167\u8981\u6c42\u4e0a\u4f20\u5bf9\u5e94\u7c7b\u578b\u7684\u6587\u4ef6\uff01"));
        }
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void quoteBidding(SaleBiddingHead saleBiddingHead, List<SaleBiddingItem> saleBiddingItemList) {
        Date currentTime = new Date();
        String quoteType = QuoteTypeEnum.TAX_EXCLUDING.getValue();
        if (StrUtil.isNotBlank((CharSequence)saleBiddingHead.getQuoteType())) {
            quoteType = saleBiddingHead.getQuoteType();
        }
        String needEcho = saleBiddingHead.getNeedEcho();
        ArrayList<PurchaseBiddingItem> batchUpdatePurchaseBiddingItemList = new ArrayList<PurchaseBiddingItem>();
        for (SaleBiddingItem item : saleBiddingItemList) {
            if ("0".equals(item.getReplyStatus()) && "1".equals(needEcho)) continue;
            String taxRateStr = item.getTaxRate();
            if (StrUtil.isBlank((CharSequence)taxRateStr)) {
                throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_empty_notRate", (String)"\u7a0e\u7387\u4e0d\u80fd\u4e3a\u7a7a\uff01"));
            }
            BigDecimal taxRate = new BigDecimal(taxRateStr);
            if (QuoteTypeEnum.TAX_EXCLUDING.getValue().equals(quoteType)) {
                BigDecimal netPrice = item.getNetPrice();
                if (netPrice == null) {
                    throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_empty_notNetPrice", (String)"\u4e0d\u542b\u7a0e\u4ef7\u4e0d\u80fd\u4e3a\u7a7a\uff01"));
                }
                BigDecimal price = netPrice.multiply(new BigDecimal(1).add(taxRate.divide(new BigDecimal(100))));
                item.setPrice(price);
            } else {
                BigDecimal price = item.getPrice();
                if (price == null) {
                    throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_empty_notPrice", (String)"\u542b\u7a0e\u4ef7\u4e0d\u80fd\u4e3a\u7a7a\uff01"));
                }
                BigDecimal netPrice = price.divide(new BigDecimal(1).add(taxRate.divide(new BigDecimal(100))), 4, 4);
                item.setNetPrice(netPrice);
            }
            BigDecimal quantity = item.getRequireQuantity() == null ? new BigDecimal(1) : item.getRequireQuantity();
            item.setNetAmount(item.getNetPrice().multiply(quantity));
            item.setTaxAmount(item.getPrice().multiply(quantity));
            item.setItemStatus(BiddingItemStatusEnum.BID_QUOTE.getValue());
            item.setQuoteIp(IPUtils.getIpAddr());
            item.setQuoteTime(new Date());
            int quoteCount = 1;
            SaleBiddingItem dbItem = (SaleBiddingItem)((Object)this.saleBiddingItemMapper.selectById((Serializable)((Object)item.getId())));
            if (dbItem.getQuoteCount() != null) {
                quoteCount = dbItem.getQuoteCount() + 1;
            }
            item.setQuoteCount(quoteCount);
            PurchaseBiddingItem purchaseBiddingItem = new PurchaseBiddingItem();
            BeanUtils.copyProperties((Object)((Object)item), (Object)((Object)purchaseBiddingItem));
            purchaseBiddingItem.setId(item.getRelationId());
            purchaseBiddingItem.setRelationId(item.getId());
            purchaseBiddingItem.setHeadId(saleBiddingHead.getRelationId());
            purchaseBiddingItem.setElsAccount(item.getToElsAccount());
            purchaseBiddingItem.setToElsAccount(item.getElsAccount());
            batchUpdatePurchaseBiddingItemList.add(purchaseBiddingItem);
        }
        if (!saleBiddingItemList.isEmpty()) {
            this.saleBiddingItemService.updateBatchById(saleBiddingItemList, 2000);
        }
        if (!batchUpdatePurchaseBiddingItemList.isEmpty()) {
            this.purchaseBiddingItemService.updateBatchById(batchUpdatePurchaseBiddingItemList);
        }
        BiddingSupplier updateSupplier = new BiddingSupplier();
        updateSupplier.setId(saleBiddingHead.getSupplierListId());
        updateSupplier.setReplyStatus(ReplyStatusEnum.QUOTE_BID.getValue());
        updateSupplier.setReplyTime(currentTime);
        int count = this.biddingSupplierMapper.updateById((Object)updateSupplier);
        if (count == 0) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_APWFIKXWVVVXVSDJHrW_2fe92d52", (String)"\u5f53\u524d\u6570\u636e\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u5237\u65b0\u540e\u63d0\u4ea4\u66f4\u6539"));
        }
        AttachmentSendDTO sendVO = new AttachmentSendDTO();
        sendVO.setElsAccount(saleBiddingHead.getElsAccount());
        sendVO.setHeadId(saleBiddingHead.getId());
        HashMap<String, String> toSend = new HashMap<String, String>();
        toSend.put(saleBiddingHead.getRelationId(), saleBiddingHead.getToElsAccount());
        sendVO.setToSend(toSend);
        this.invokeBaseRpcService.sendSaleFile(sendVO);
        this.sendMsg(saleBiddingHead, saleBiddingHead.getToElsAccount(), "quote");
    }

    private void sendMsg(SaleBiddingHead head, String elsAccount, String operateType) {
        try {
            String url = "biddingNumber=" + head.getBiddingNumber();
            super.sendMsg(TenantContext.getTenant(), elsAccount, (Object)head, url, "bidding", operateType);
        }
        catch (Exception e) {
            log.error("sendMsg failed:", (Throwable)e);
        }
    }
}

