/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.ebidding.controller;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.els.common.api.vo.Result;
import com.els.common.aspect.annotation.AutoLog;
import com.els.common.aspect.annotation.PermissionDataOpt;
import com.els.common.aspect.annotation.PermissionDataView;
import com.els.common.enumerate.AuditStatusEnum;
import com.els.common.system.base.controller.BaseController;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.query.QueryGenerator;
import com.els.common.system.vo.LoginUser;
import com.els.common.util.I18nUtil;
import com.els.common.vo.CountVO;
import com.els.modules.demand.entity.PurchaseRequestItem;
import com.els.modules.demand.vo.PurchaseRequestHeadVO;
import com.els.modules.ebidding.entity.PurchaseEbiddingHead;
import com.els.modules.ebidding.entity.PurchaseEbiddingItem;
import com.els.modules.ebidding.entity.PurchaseEbiddingSupplier;
import com.els.modules.ebidding.enumerate.EbiddingShowEnum;
import com.els.modules.ebidding.enumerate.EbiddingStatusEnum;
import com.els.modules.ebidding.enumerate.EbiddingTypeEnum;
import com.els.modules.ebidding.enumerate.EbiddingWayEnum;
import com.els.modules.ebidding.excel.PurchaseEbiddingHeadExportServiceImpl;
import com.els.modules.ebidding.service.PurchaseEbiddingHeadService;
import com.els.modules.ebidding.service.PurchaseEbiddingItemService;
import com.els.modules.ebidding.service.PurchaseEbiddingSupplierService;
import com.els.modules.ebidding.vo.PurchaseEbiddingHeadVO;
import com.els.modules.ebidding.vo.PurchaseEbiddingSupplierVO;
import com.els.modules.enquiry.enumerate.EnquiryStatusEnum;
import com.els.modules.inquiry.enumerate.PriceCreateWayEnum;
import com.els.modules.inquiry.enumerate.SourceTypeEnum;
import com.els.modules.searchSourceConfig.service.SearSourMaterValidService;
import com.els.rpc.service.InvokeBaseRpcService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.TreeSet;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.Assert;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.servlet.ModelAndView;

@RestController
@RequestMapping(value={"/ebidding/purchaseEbiddingHead"})
@Api(tags={"\u91c7\u8d2d\u7ade\u4ef7\u5934"})
public class PurchaseEbiddingHeadController
extends BaseController<PurchaseEbiddingHead, PurchaseEbiddingHeadService> {
    @Autowired
    private PurchaseEbiddingItemService purchaseEbiddingItemService;
    @Autowired
    private PurchaseEbiddingSupplierService ebiddingSupplierService;
    @Autowired
    private SearSourMaterValidService validService;
    @Resource
    private InvokeBaseRpcService invokeBaseRpcService;

    @ApiOperation(value="\u5206\u9875\u5217\u8868\u67e5\u8be2", notes="\u5206\u9875\u5217\u8868\u67e5\u8be2")
    @GetMapping(value={"/list"})
    @PermissionDataView(businessType="ebidding")
    public Result<?> queryPageList(PurchaseEbiddingHead head, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)head), (Map)req.getParameterMap());
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        IPage pageList = ((PurchaseEbiddingHeadService)this.service).page((IPage)page, (Wrapper)queryWrapper);
        return Result.ok((Object)pageList);
    }

    @ApiOperation(value="\u5217\u8868\u9875\u9875\u7b7e\u6570\u91cf\u67e5\u8be2", notes="\u5217\u8868\u9875\u9875\u7b7e\u6570\u91cf\u67e5\u8be2")
    @GetMapping(value={"/count"})
    @PermissionDataView(businessType="ebidding")
    public Result<?> queryTabsCount(PurchaseEbiddingHead head, HttpServletRequest req) {
        String[] statuses;
        ArrayList<CountVO> result = new ArrayList<CountVO>();
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)head), (Map)req.getParameterMap());
        queryWrapper.select(new String[]{"ebidding_status", "count(0) as participate_quantity"});
        queryWrapper.groupBy((Object)"ebidding_status");
        List list = ((PurchaseEbiddingHeadService)this.service).list((Wrapper)queryWrapper);
        Map<String, Integer> countMap = list.stream().collect(Collectors.toMap(PurchaseEbiddingHead::getEbiddingStatus, PurchaseEbiddingHead::getParticipateQuantity));
        Integer all = 0;
        for (Map.Entry<String, Integer> entry : countMap.entrySet()) {
            all = all + entry.getValue();
        }
        result.add(new CountVO(I18nUtil.translate((String)"i18n_title_all", (String)"\u5168\u90e8"), "ebiddingStatus", null, all));
        String[] stringArray = statuses = new String[]{"0", "1", "3", "4", "5", "6", "7", "10", "11"};
        int n = statuses.length;
        int n2 = 0;
        while (n2 < n) {
            String status = stringArray[n2];
            Integer total = countMap.get(status) == null ? 0 : countMap.get(status);
            result.add(new CountVO(EbiddingStatusEnum.getStatusDesc(status), "ebiddingStatus", status, total));
            ++n2;
        }
        return Result.ok(result);
    }

    @ApiOperation(value="\u5408\u540c\u67e5\u8be2\u7ade\u4ef7\u884c\u5206\u9875\u4fe1\u606f", notes="\u5408\u540c\u67e5\u8be2\u7ade\u4ef7\u884c\u5206\u9875\u4fe1\u606f")
    @GetMapping(value={"/contractQueryEbidding"})
    @PermissionDataView(businessType="ebidding")
    public Result<?> contractQueryEbidding(PurchaseEbiddingItem item, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)item), (Map)req.getParameterMap());
        ((LambdaQueryWrapper)((LambdaQueryWrapper)queryWrapper.lambda().eq(PurchaseEbiddingItem::getAuditStatus, (Object)AuditStatusEnum.AUDIT_FINISH.getValue())).eq(PurchaseEbiddingItem::getItemStatus, (Object)EbiddingStatusEnum.BID_WIN.getValue())).orderByDesc(BaseEntity::getCreateTime);
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        IPage pageList = this.purchaseEbiddingItemService.page((IPage)page, (Wrapper)queryWrapper);
        return Result.ok((Object)pageList);
    }

    @ApiOperation(value="\u8ba2\u5355\u67e5\u8be2\u7ade\u4ef7\u884c\u5206\u9875\u4fe1\u606f", notes="\u8ba2\u5355\u67e5\u8be2\u7ade\u4ef7\u884c\u5206\u9875\u4fe1\u606f")
    @GetMapping(value={"/orderQueryEbiddingByDesc"})
    @PermissionDataView(businessType="ebidding")
    public Result<?> orderQueryEbiddingByDesc(PurchaseEbiddingItem item, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)item), (Map)req.getParameterMap());
        ((LambdaQueryWrapper)((LambdaQueryWrapper)queryWrapper.lambda().eq(PurchaseEbiddingItem::getItemStatus, (Object)EbiddingStatusEnum.BID_WIN.getValue())).eq(PurchaseEbiddingItem::getMaterialDesc, (Object)item.getMaterialDesc())).and(qw -> {
            Object object = ((LambdaQueryWrapper)((LambdaQueryWrapper)qw.isNull(PurchaseEbiddingItem::getMaterialNumber)).or()).eq(PurchaseEbiddingItem::getMaterialNumber, (Object)"");
        });
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        IPage pageList = this.purchaseEbiddingItemService.page((IPage)page, (Wrapper)queryWrapper);
        return Result.ok((Object)pageList);
    }

    @ApiOperation(value="\u4f9b\u5e94\u5546\u753b\u50cf\u67e5\u8be2\u8be2\u4ef7", notes="\u4f9b\u5e94\u5546\u753b\u50cf\u67e5\u8be2\u8be2\u4ef7")
    @GetMapping(value={"/supplierPortraitCount"})
    public Result<?> supplierPortraitCount(@RequestParam(name="toElsAccount") String toElsAccount) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(PurchaseEbiddingItem::getToElsAccount, (Object)toElsAccount);
        List allList = this.purchaseEbiddingItemService.list((Wrapper)queryWrapper);
        long participationCount = allList.parallelStream().map(PurchaseEbiddingItem::getHeadId).distinct().count();
        long biddingWinCount = allList.parallelStream().filter(item -> EbiddingStatusEnum.BID_SUCCESS.getValue().equals(item.getItemStatus())).map(PurchaseEbiddingItem::getHeadId).distinct().count();
        HashMap<String, Long> returnMap = new HashMap<String, Long>();
        returnMap.put("participationCount", participationCount);
        returnMap.put("biddingWinCount", biddingWinCount);
        return Result.ok(returnMap);
    }

    @AutoLog(value="\u91c7\u8d2d\u7ade\u4ef7-\u9700\u6c42\u6c60\u8f6c\u7ade\u4ef7")
    @ApiOperation(value="\u9700\u6c42\u6c60\u8f6c\u7ade\u4ef7", notes="\u9700\u6c42\u6c60\u8f6c\u8be2\u4ef7")
    @PostMapping(value={"/requestToEbidding"})
    public Result<?> requestToEbidding(@RequestBody PurchaseRequestHeadVO requestHeadVO) {
        String templateNumber = requestHeadVO.getTemplateNumber();
        String templateVersion = requestHeadVO.getTemplateVersion();
        Assert.hasText((String)templateNumber, (String)I18nUtil.translate((String)"i18n_alert_empty_notTempNum", (String)"\u6a21\u677f\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a"));
        Assert.hasText((String)templateVersion, (String)I18nUtil.translate((String)"i18n_alert_empty_notTempVersion", (String)"\u6a21\u677f\u7248\u672c\u53f7\u4e0d\u80fd\u4e3a\u7a7a"));
        PurchaseEbiddingHead head = new PurchaseEbiddingHead();
        head.setTemplateNumber(templateNumber);
        head.setTemplateVersion(Integer.valueOf(templateVersion));
        head.setTemplateName(requestHeadVO.getTemplateName());
        head.setTemplateAccount(requestHeadVO.getTemplateAccount());
        String elsAccount = this.getTenantId();
        head.setElsAccount(elsAccount);
        head.setBusAccount(elsAccount);
        ArrayList<PurchaseEbiddingItem> itemList = new ArrayList<PurchaseEbiddingItem>();
        List<PurchaseRequestItem> requestItemList = requestHeadVO.getPurchaseRequestItemList();
        List orgList = requestItemList.stream().map(item -> item.getPurchaseOrg() == null ? "" : item.getPurchaseOrg()).distinct().collect(Collectors.toList());
        Assert.isTrue((orgList.size() == 1 ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_alert_oper_no_the_same_purchase_organization", (String)"\u76f8\u540c\u91c7\u8d2d\u7ec4\u7ec7\u624d\u53ef\u8f6c\u5355"));
        this.validService.requestPoolValid("1", requestItemList.get(0).getPurchaseOrg(), requestItemList);
        for (PurchaseRequestItem requestItem : requestItemList) {
            PurchaseEbiddingItem item2 = new PurchaseEbiddingItem();
            BeanUtils.copyProperties((Object)((Object)requestItem), (Object)((Object)item2));
            item2.setRequireQuantity(requestItem.getQuantity());
            item2.setSourceType(SourceTypeEnum.REQUEST.getValue());
            item2.setSourceNumber(requestItem.getRequestNumber());
            item2.setSourceItemNumber(requestItem.getItemNumber());
            item2.setSourceItemId(requestItem.getId());
            item2.setPriceUnit(requestItem.getUnitPrice());
            item2.setQuantityUnit(requestItem.getUnitQuantity());
            item2.setRequireQuantity(requestItem.getQuantity());
            item2.setRequireDate(requestItem.getApplyDate());
            item2.setPrice(null);
            item2.setNetPrice(null);
            item2.setTotalAmount(null);
            item2.setNetTotalAmount(null);
            item2.setTaxAmount(null);
            item2.setNetAmount(null);
            itemList.add(item2);
        }
        head.setCompany(requestItemList.get(0).getCompany());
        if ("person".equals(requestItemList.get(0).getTacticsEntity())) {
            head.setPurchasePrincipal(requestItemList.get(0).getTacticsObject());
        } else {
            LoginUser sysUser = this.getCurrentUser();
            head.setPurchasePrincipal(String.valueOf(sysUser.getSubAccount()) + "_" + sysUser.getRealname());
        }
        ((PurchaseEbiddingHeadService)this.service).saveMain(head, itemList, null, null);
        return Result.ok((String)("\u8f6c\u7ade\u4ef7\u6210\u529f,\u7ade\u4ef7\u5355\u53f7\u4e3a:" + head.getEbiddingNumber()));
    }

    @AutoLog(value="\u91c7\u8d2d\u7ade\u4ef7-\u6dfb\u52a0")
    @ApiOperation(value="\u6dfb\u52a0", notes="\u6dfb\u52a0")
    @PostMapping(value={"/add"})
    @RequiresPermissions(value={"purchaseEbiddingHead:add"})
    @PermissionDataOpt(businessType="ebidding", beanClass=PurchaseEbiddingHeadService.class)
    public Result<?> add(@RequestBody PurchaseEbiddingHeadVO headVO) {
        Assert.hasText((String)headVO.getTemplateNumber(), (String)I18nUtil.translate((String)"i18n_alert_empty_notTempNum", (String)"\u6a21\u677f\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a"));
        Assert.notNull((Object)headVO.getTemplateVersion(), (String)I18nUtil.translate((String)"i18n_alert_empty_notTempVersion", (String)"\u6a21\u677f\u7248\u672c\u4e0d\u80fd\u4e3a\u7a7a"));
        PurchaseEbiddingHead purchaseEbiddingHead = new PurchaseEbiddingHead();
        BeanUtils.copyProperties((Object)((Object)headVO), (Object)((Object)purchaseEbiddingHead));
        String elsAccount = this.getTenantId();
        purchaseEbiddingHead.setElsAccount(elsAccount);
        purchaseEbiddingHead.setBusAccount(elsAccount);
        ((PurchaseEbiddingHeadService)this.service).saveMain(purchaseEbiddingHead, headVO.getPurchaseEbiddingItemList(), headVO.getPurchaseEbiddingSupplierList(), headVO.getPurchaseAttachmentDemandList());
        return Result.ok((Object)((Object)purchaseEbiddingHead));
    }

    @AutoLog(value="\u91c7\u8d2d\u7ade\u4ef7-\u7f16\u8f91")
    @ApiOperation(value="\u7f16\u8f91", notes="\u7f16\u8f91")
    @PostMapping(value={"/edit"})
    @RequiresPermissions(value={"purchaseEbiddingHead:edit"})
    @PermissionDataOpt(businessType="ebidding", beanClass=PurchaseEbiddingHeadService.class)
    public Result<?> edit(@RequestBody PurchaseEbiddingHeadVO headVO) {
        Assert.hasText((String)headVO.getId(), (String)I18nUtil.translate((String)"i18n_alert_empty_header_id", (String)"\u5934\u4fe1\u606fid\u4e0d\u80fd\u4e3a\u7a7a"));
        PurchaseEbiddingHead purchaseEbiddingHead = new PurchaseEbiddingHead();
        BeanUtils.copyProperties((Object)((Object)headVO), (Object)((Object)purchaseEbiddingHead));
        String elsAccount = this.getTenantId();
        purchaseEbiddingHead.setElsAccount(elsAccount);
        purchaseEbiddingHead.setBusAccount(elsAccount);
        ((PurchaseEbiddingHeadService)this.service).updateMain(purchaseEbiddingHead, headVO.getPurchaseEbiddingItemList(), headVO.getPurchaseEbiddingSupplierList(), headVO.getPurchaseAttachmentDemandList());
        return this.commonSuccessResult(3);
    }

    @AutoLog(value="\u91c7\u8d2d\u7ade\u4ef7-\u5220\u9664")
    @ApiOperation(value="\u5220\u9664", notes="\u5220\u9664")
    @GetMapping(value={"/delete"})
    @RequiresPermissions(value={"purchaseEbiddingHead:delete"})
    @PermissionDataOpt(businessType="ebidding", beanClass=PurchaseEbiddingHeadService.class)
    public Result<?> delete(@RequestParam(name="id") String id) {
        ((PurchaseEbiddingHeadService)this.service).delete(id);
        return this.commonSuccessResult(4);
    }

    @AutoLog(value="\u91c7\u8d2d\u7ade\u4ef7-\u53d1\u5e03")
    @ApiOperation(value="\u53d1\u5e03", notes="\u53d1\u5e03")
    @PostMapping(value={"/publish"})
    @RequiresPermissions(value={"purchaseEbiddingHead:publish"})
    @PermissionDataOpt(businessType="ebidding", beanClass=PurchaseEbiddingHeadService.class)
    public Result<?> publish(@RequestBody PurchaseEbiddingHeadVO headVO) {
        this.validService.publishEbidding(headVO.getPurchaseOrg(), headVO.getPurchaseEbiddingItemList());
        Assert.hasText((String)headVO.getTemplateNumber(), (String)I18nUtil.translate((String)"i18n_alert_empty_notTempNum", (String)"\u6a21\u677f\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a"));
        Assert.notNull((Object)headVO.getTemplateVersion(), (String)I18nUtil.translate((String)"i18n_alert_empty_notTempVersion", (String)"\u6a21\u677f\u7248\u672c\u4e0d\u80fd\u4e3a\u7a7a"));
        if (StrUtil.isBlank((CharSequence)headVO.getEbiddingNumber())) {
            headVO.setEbiddingNumber(this.invokeBaseRpcService.getNextCode("srmEbiddingNumber", (Object)headVO));
        }
        String elsAccount = this.getTenantId();
        headVO.setElsAccount(elsAccount);
        headVO.setBusAccount(elsAccount);
        ((PurchaseEbiddingHeadService)this.service).publish(headVO);
        return this.commonSuccessResult(3);
    }

    @AutoLog(value="\u91c7\u8d2d\u7ade\u4ef7-\u624b\u52a8\u5f00\u542f\u7ade\u4ef7")
    @ApiOperation(value="\u624b\u52a8\u5f00\u542f\u7ade\u4ef7", notes="\u624b\u52a8\u5f00\u542f\u7ade\u4ef7")
    @PostMapping(value={"/manualStartBid"})
    @RequiresPermissions(value={"purchaseEbiddingHead:manualStartBid"})
    @PermissionDataOpt(businessType="ebidding", beanClass=PurchaseEbiddingHeadService.class)
    public Result<?> manualStartBid(@RequestBody PurchaseEbiddingHeadVO headVO) {
        ((PurchaseEbiddingHeadService)this.service).manualStartBid(headVO);
        return this.commonSuccessResult(3);
    }

    @AutoLog(value="\u91c7\u8d2d\u7ade\u4ef7-\u624b\u52a8\u7ed3\u675f\u7ade\u4ef7")
    @ApiOperation(value="\u624b\u52a8\u7ed3\u675f\u7ade\u4ef7", notes="\u624b\u52a8\u7ed3\u675f\u7ade\u4ef7")
    @PostMapping(value={"/manualEndBid"})
    @RequiresPermissions(value={"purchaseEbiddingHead:manualEndBid"})
    @PermissionDataOpt(businessType="ebidding", beanClass=PurchaseEbiddingHeadService.class)
    public Result<?> manualEndBid(@RequestBody PurchaseEbiddingHeadVO headVO) {
        ((PurchaseEbiddingHeadService)this.service).manualEndBid(headVO);
        return this.commonSuccessResult(3);
    }

    @AutoLog(value="\u91c7\u8d2d\u7ade\u4ef7-\u521b\u5efa\u65b0\u8f6e\u6b21")
    @ApiOperation(value="\u521b\u5efa\u65b0\u8f6e\u6b21", notes="\u521b\u5efa\u65b0\u8f6e\u6b21")
    @PostMapping(value={"/createNewRound"})
    @RequiresPermissions(value={"purchaseEbiddingHead:createNewRound"})
    @PermissionDataOpt(businessType="ebidding", beanClass=PurchaseEbiddingHeadService.class)
    public Result<?> createNewRound(@RequestBody PurchaseEbiddingHeadVO headVO) {
        ((PurchaseEbiddingHeadService)this.service).createNewRound(headVO);
        return this.commonSuccessResult(3);
    }

    @AutoLog(value="\u91c7\u8d2d\u7ade\u4ef7-\u5b9a\u6807")
    @ApiOperation(value="\u5b9a\u6807", notes="\u5b9a\u6807")
    @PostMapping(value={"/confirmBid"})
    @RequiresPermissions(value={"purchaseEbiddingHead:confirmBid"})
    @PermissionDataOpt(businessType="ebidding", beanClass=PurchaseEbiddingHeadService.class)
    public Result<?> confirmBid(@RequestBody PurchaseEbiddingHeadVO headVO) {
        ((PurchaseEbiddingHeadService)this.service).confirmBid(headVO);
        return this.commonSuccessResult(3);
    }

    @AutoLog(value="\u91c7\u8d2d\u7ade\u4ef7-\u4f5c\u5e9f")
    @ApiOperation(value="\u4f5c\u5e9f", notes="\u4f5c\u5e9f")
    @GetMapping(value={"/cancel"})
    @RequiresPermissions(value={"purchaseEbiddingHead:cancel"})
    @PermissionDataOpt(businessType="ebidding", beanClass=PurchaseEbiddingHeadService.class)
    public Result<?> cancel(@RequestParam(name="id") String id) {
        PurchaseEbiddingHead dbHead = (PurchaseEbiddingHead)((Object)((PurchaseEbiddingHeadService)this.service).getById((Serializable)((Object)id)));
        String[] array = new String[]{EbiddingStatusEnum.WAIT_BIDDING.getValue(), EbiddingStatusEnum.BIDDING_END.getValue()};
        List<String> ebiddingStatusList = Arrays.asList(array);
        Assert.isTrue((boolean)ebiddingStatusList.contains(dbHead.getEbiddingStatus()), (String)I18nUtil.translate((String)"", (String)"\u53ea\u6709\u5f85\u7ade\u4ef7\u6216\u7ade\u4ef7\u7ed3\u675f\u7684\u5355\u636e\u53ef\u4f5c\u5e9f"));
        ((PurchaseEbiddingHeadService)this.service).cancel(dbHead);
        return this.commonSuccessResult(3);
    }

    @ApiOperation(value="\u8be6\u60c5\u9875\u9762\u67e5\u8be2\u63a5\u53e3", notes="\u8be6\u60c5\u9875\u9762\u67e5\u8be2\u63a5\u53e3")
    @GetMapping(value={"/queryById"})
    public Result<?> queryById(@RequestParam(name="id") String id) {
        PurchaseEbiddingHead dbHead = (PurchaseEbiddingHead)((Object)((PurchaseEbiddingHeadService)this.service).getById((Serializable)((Object)id)));
        PurchaseEbiddingHeadVO headVO = new PurchaseEbiddingHeadVO();
        BeanUtils.copyProperties((Object)((Object)dbHead), (Object)((Object)headVO));
        List<PurchaseEbiddingItem> dbItemList = this.purchaseEbiddingItemService.selectByMainId(id);
        List distinctList = dbItemList.stream().collect(Collectors.collectingAndThen(Collectors.toCollection(() -> new TreeSet<PurchaseEbiddingItem>(Comparator.comparing(PurchaseEbiddingItem::getItemNumber))), ArrayList::new));
        headVO.setPurchaseEbiddingItemList(distinctList);
        List<PurchaseEbiddingSupplier> dbSupplierList = this.ebiddingSupplierService.selectByMainId(id);
        headVO.setPurchaseEbiddingSupplierList(dbSupplierList);
        if (EnquiryStatusEnum.NEW.getValue().equals(dbHead.getEbiddingStatus()) || CollectionUtil.isEmpty(dbSupplierList)) {
            ArrayList<PurchaseEbiddingSupplierVO> supplierVOList = new ArrayList<PurchaseEbiddingSupplierVO>();
            for (PurchaseEbiddingSupplier purchaseEbiddingSupplier : dbSupplierList) {
                PurchaseEbiddingSupplierVO vo = new PurchaseEbiddingSupplierVO();
                BeanUtils.copyProperties((Object)((Object)purchaseEbiddingSupplier), (Object)((Object)vo));
                supplierVOList.add(vo);
            }
            headVO.setPurchaseEbiddingSupplierQuoteList(supplierVOList);
        } else {
            headVO.setPurchaseEbiddingSupplierQuoteList(this.getSupplierQuote(dbHead, dbItemList, dbSupplierList));
            for (PurchaseEbiddingSupplierVO vo : headVO.getPurchaseEbiddingSupplierQuoteList()) {
                this.purchaseShow(vo.getPurchaseEbiddingItemList(), dbHead, false);
            }
        }
        List attachmentDemandBuyList = this.invokeBaseRpcService.selectPurchaseAttachmentDemandByMainId(id);
        headVO.setPurchaseAttachmentDemandList(attachmentDemandBuyList);
        List list = this.invokeBaseRpcService.selectPurchaseAttachmentByMainId(id);
        headVO.setPurchaseAttachmentList(list);
        return Result.ok((Object)((Object)headVO));
    }

    private List<PurchaseEbiddingSupplierVO> getSupplierQuote(PurchaseEbiddingHead dbHead, List<PurchaseEbiddingItem> dbItemList, List<PurchaseEbiddingSupplier> dbSupplierList) {
        Map<String, List<PurchaseEbiddingItem>> itemMap = dbItemList.stream().collect(Collectors.groupingBy(PurchaseEbiddingItem::getToElsAccount));
        ArrayList<PurchaseEbiddingSupplierVO> list = new ArrayList<PurchaseEbiddingSupplierVO>();
        for (PurchaseEbiddingSupplier supplier : dbSupplierList) {
            PurchaseEbiddingSupplierVO supplierVO = new PurchaseEbiddingSupplierVO();
            BeanUtils.copyProperties((Object)((Object)supplier), (Object)((Object)supplierVO));
            if (EbiddingWayEnum.PACKAGE.getValue().equals(dbHead.getEbiddingWay())) {
                List<PurchaseEbiddingItem> packageList = itemMap.get(supplier.getToElsAccount()).stream().limit(1L).collect(Collectors.toList());
                packageList.forEach(item -> {
                    PurchaseEbiddingItem purchaseEbiddingItem = item.setMaterialDesc(EbiddingWayEnum.PACKAGE.getDesc());
                });
                supplierVO.setPurchaseEbiddingItemList(packageList);
            } else {
                supplierVO.setPurchaseEbiddingItemList(itemMap.get(supplier.getToElsAccount()));
            }
            list.add(supplierVO);
        }
        return list;
    }

    @ApiOperation(value="\u7ade\u4ef7\u5927\u5385\u5934,\u7269\u6599\u4fe1\u606f\u67e5\u8be2", notes="\u7ade\u4ef7\u5927\u5385\u5934,\u7269\u6599\u4fe1\u606f\u67e5\u8be2")
    @GetMapping(value={"/queryBidLobbyDetail"})
    public Result<?> queryBidLobbyDetail(@RequestParam(name="id") String id, @RequestParam(name="itemNumber") String itemNumber) {
        PurchaseEbiddingHead dbHead = (PurchaseEbiddingHead)((Object)((PurchaseEbiddingHeadService)this.service).getById((Serializable)((Object)id)));
        List<PurchaseEbiddingItem> dbItemList = this.purchaseEbiddingItemService.selectByMainId(id);
        List distinctList = dbItemList.parallelStream().collect(Collectors.collectingAndThen(Collectors.toCollection(() -> new TreeSet<PurchaseEbiddingItem>(Comparator.comparing(PurchaseEbiddingItem::getItemNumber))), ArrayList::new));
        PurchaseEbiddingHeadVO headVO = new PurchaseEbiddingHeadVO();
        BeanUtils.copyProperties((Object)((Object)dbHead), (Object)((Object)headVO));
        headVO.setServiceTime(new Date());
        List itemList = dbItemList.parallelStream().filter(item -> item.getItemNumber().equals(itemNumber)).collect(Collectors.toList());
        if (EbiddingWayEnum.SINGLE.getValue().equals(dbHead.getEbiddingWay())) {
            Optional<PurchaseEbiddingItem> minOptional = itemList.parallelStream().filter(item -> item.getPrice() != null).min(Comparator.comparing(PurchaseEbiddingItem::getPrice));
            minOptional.ifPresent(purchaseEbiddingItem -> headVO.setMinPrice(purchaseEbiddingItem.getPrice()));
            Optional<PurchaseEbiddingItem> maxOptional = itemList.parallelStream().filter(item -> item.getPrice() != null).max(Comparator.comparing(PurchaseEbiddingItem::getPrice));
            maxOptional.ifPresent(purchaseEbiddingItem -> headVO.setMaxPrice(purchaseEbiddingItem.getPrice()));
        } else {
            Optional<PurchaseEbiddingItem> minOptional = itemList.parallelStream().filter(item -> item.getTotalAmount() != null).min(Comparator.comparing(PurchaseEbiddingItem::getTotalAmount));
            minOptional.ifPresent(purchaseEbiddingItem -> headVO.setMinPrice(purchaseEbiddingItem.getTotalAmount()));
            Optional<PurchaseEbiddingItem> maxOptional = itemList.parallelStream().filter(item -> item.getTotalAmount() != null).max(Comparator.comparing(PurchaseEbiddingItem::getTotalAmount));
            maxOptional.ifPresent(purchaseEbiddingItem -> headVO.setMaxPrice(purchaseEbiddingItem.getTotalAmount()));
        }
        headVO.setPurchaseEbiddingItemList(distinctList);
        return Result.ok((Object)((Object)headVO));
    }

    @ApiOperation(value="\u7ade\u4ef7\u5927\u5385\u62a5\u4ef7\u884c\u4fe1\u606f\u67e5\u8be2", notes="\u7ade\u4ef7\u5927\u5385\u62a5\u4ef7\u884c\u4fe1\u606f\u67e5\u8be2")
    @GetMapping(value={"/queryBidLobbyQuote"})
    public Result<?> queryBidLobbyQuote(@RequestParam(name="id") String id, @RequestParam(name="itemNumber") String itemNumber) {
        PurchaseEbiddingHead dbHead = (PurchaseEbiddingHead)((Object)((PurchaseEbiddingHeadService)this.service).getById((Serializable)((Object)id)));
        List<PurchaseEbiddingItem> dbItemList = this.purchaseEbiddingItemService.selectByMainId(id).parallelStream().filter(item -> item.getItemNumber().equals(itemNumber)).collect(Collectors.toList());
        this.purchaseShow(dbItemList, dbHead, true);
        PurchaseEbiddingHeadVO purchaseHead = new PurchaseEbiddingHeadVO();
        BeanUtils.copyProperties((Object)((Object)dbHead), (Object)((Object)purchaseHead));
        purchaseHead.setPurchaseEbiddingItemList(dbItemList);
        return Result.ok((Object)((Object)purchaseHead));
    }

    private void purchaseShow(List<PurchaseEbiddingItem> itemList, PurchaseEbiddingHead head, boolean rank) {
        String purchaseShow;
        String ebiddingWay = head.getEbiddingWay();
        String ebiddingType = head.getEbiddingType();
        String string = purchaseShow = head.getPurchaseShow() == null ? "" : head.getPurchaseShow();
        if (EbiddingStatusEnum.BIDDING.getValue().equals(head.getEbiddingStatus())) {
            if (purchaseShow.contains(EbiddingShowEnum.RANK.getValue()) && rank) {
                this.rank(itemList, ebiddingWay, ebiddingType);
            }
            if (!purchaseShow.contains(EbiddingShowEnum.PRICE.getValue())) {
                itemList.parallelStream().forEach(item -> {
                    item.setPrice(null);
                    item.setNetPrice(null);
                    item.setTotalAmount(null);
                    item.setNetTotalAmount(null);
                    item.setTaxAmount(null);
                    item.setNetAmount(null);
                });
            }
            if (!purchaseShow.contains(EbiddingShowEnum.NAME.getValue())) {
                itemList.parallelStream().forEach(item -> {
                    PurchaseEbiddingItem purchaseEbiddingItem = item.setSupplierName(null);
                });
            }
        } else if (rank) {
            this.rank(itemList, ebiddingWay, ebiddingType);
        }
    }

    private void rank(List<PurchaseEbiddingItem> itemList, String ebiddingWay, String ebiddingType) {
        List sortList = EbiddingWayEnum.SINGLE.getValue().equals(ebiddingWay) ? (EbiddingTypeEnum.FORWARD_BID.getValue().equals(ebiddingType) ? itemList.parallelStream().filter(item -> item.getPrice() != null).sorted(Comparator.comparing(PurchaseEbiddingItem::getPrice).reversed().thenComparing(PurchaseEbiddingItem::getQuoteTime)).collect(Collectors.toList()) : itemList.parallelStream().filter(item -> item.getPrice() != null).sorted(Comparator.comparing(PurchaseEbiddingItem::getPrice).thenComparing(PurchaseEbiddingItem::getQuoteTime)).collect(Collectors.toList())) : (EbiddingTypeEnum.FORWARD_BID.getValue().equals(ebiddingType) ? itemList.parallelStream().filter(item -> item.getTotalAmount() != null).sorted(Comparator.comparing(PurchaseEbiddingItem::getTotalAmount).reversed().thenComparing(PurchaseEbiddingItem::getQuoteTime)).collect(Collectors.toList()) : itemList.parallelStream().filter(item -> item.getTotalAmount() != null).sorted(Comparator.comparing(PurchaseEbiddingItem::getTotalAmount).thenComparing(PurchaseEbiddingItem::getQuoteTime)).collect(Collectors.toList()));
        int i = 0;
        while (i < sortList.size()) {
            for (PurchaseEbiddingItem item2 : itemList) {
                if (!item2.getId().equals(((PurchaseEbiddingItem)((Object)sortList.get(i))).getId())) continue;
                int rank = i + 1;
                item2.setQuoteRank(rank);
                break;
            }
            ++i;
        }
        itemList.sort(Comparator.comparing(PurchaseEbiddingItem::getQuoteRank, Comparator.nullsLast(Integer::compareTo)));
    }

    @AutoLog(value="\u91c7\u8d2d\u7ade\u4ef7-\u751f\u6210\u4ef7\u683c\u4fe1\u606f\u8bb0\u5f55")
    @ApiOperation(value="\u751f\u6210\u4ef7\u683c\u4fe1\u606f\u8bb0\u5f55", notes="\u751f\u6210\u4ef7\u683c\u4fe1\u606f\u8bb0\u5f55")
    @GetMapping(value={"/generatePriceRecord"})
    @RequiresPermissions(value={"purchaseEbiddingHead:generatePriceRecord"})
    public Result<?> generatePriceRecord(@RequestParam(name="headId") String headId) {
        PurchaseEbiddingHead dbHead = (PurchaseEbiddingHead)((Object)((PurchaseEbiddingHeadService)this.service).getById((Serializable)((Object)headId)));
        Assert.notNull((Object)((Object)dbHead), (String)I18nUtil.translate((String)"", (String)"\u6570\u636e\u4e0d\u5b58\u5728\u6216\u5df2\u88ab\u5220\u9664"));
        Assert.isTrue((boolean)EbiddingStatusEnum.BID_SUCCESS.getValue().equals(dbHead.getEbiddingStatus()), (String)I18nUtil.translate((String)"", (String)"\u53ea\u6709\u7ade\u4ef7\u5b8c\u6210\u7684\u5355\u636e\u624d\u53ef\u751f\u6210\u4ef7\u683c\u4fe1\u606f\u8bb0\u5f55"));
        if (!"0".equals(dbHead.getResultAudit())) {
            Assert.isTrue((boolean)AuditStatusEnum.AUDIT_FINISH.getValue().equals(dbHead.getResultAuditStatus()), (String)I18nUtil.translate((String)"", (String)"\u53ea\u6709\u5ba1\u6279\u901a\u8fc7\u7684\u5355\u636e\u624d\u53ef\u751f\u6210\u4ef7\u683c\u4fe1\u606f\u8bb0\u5f55"));
        }
        Assert.isTrue((!PriceCreateWayEnum.NOT.getValue().equals(dbHead.getPriceCreateWay()) ? 1 : 0) != 0, (String)I18nUtil.translate((String)"", (String)"\u6b64\u5355\u636e\u4e0d\u53ef\u751f\u6210\u4ef7\u683c\u4fe1\u606f\u8bb0\u5f55"));
        Assert.isTrue((boolean)PriceCreateWayEnum.MANUAL.getValue().equals(dbHead.getPriceCreateWay()), (String)I18nUtil.translate((String)"", (String)"\u521b\u5efa\u4ef7\u683c\u65b9\u5f0f\u4e3a\u81ea\u52a8\u521b\u5efa\uff0c\u4e0d\u53ef\u624b\u52a8\u751f\u6210"));
        List<PurchaseEbiddingItem> acceptList = this.purchaseEbiddingItemService.selectByMainId(dbHead.getId()).stream().filter(item -> EbiddingStatusEnum.BID_WIN.getValue().equals(item.getItemStatus())).collect(Collectors.toList());
        Assert.notEmpty(acceptList, (String)I18nUtil.translate((String)"", (String)"\u6ca1\u6709\u53ef\u4ee5\u751f\u6210\u4fe1\u606f\u8bb0\u5f55\u7684\u884c\u4fe1\u606f"));
        acceptList.forEach(item -> {
            if (PriceCreateWayEnum.MANUAL.getValue().equals(dbHead.getPriceCreateWay())) {
                Assert.hasText((String)item.getMaterialNumber(), (String)I18nUtil.translate((String)"", (String)"\u8bf7\u5148\u8865\u5145\u7269\u6599\u7f16\u7801"));
            }
            Assert.isTrue((!"1".equals(item.getSendStatus()) ? 1 : 0) != 0, (String)I18nUtil.translate((String)"", (String)"\u6b64\u5355\u636e\u5df2\u7ecf\u751f\u6210\u8fc7\u4fe1\u606f\u8bb0\u5f55\u4e86\uff0c\u4e0d\u53ef\u91cd\u590d\u751f\u6210"));
        });
        ((PurchaseEbiddingHeadService)this.service).generatePriceRecord(dbHead, acceptList);
        return this.commonSuccessResult(3);
    }

    @AutoLog(value="\u91c7\u8d2d\u7ade\u4ef7-\u53d8\u66f4")
    @ApiOperation(value="\u53d8\u66f4", notes="\u53d8\u66f4")
    @PostMapping(value={"/regret"})
    @RequiresPermissions(value={"purchaseEbiddingHead:regret"})
    @PermissionDataOpt(businessType="ebidding", beanClass=PurchaseEbiddingHeadService.class)
    public Result<?> regret(@RequestBody PurchaseEbiddingHeadVO headVO) {
        Assert.hasText((String)headVO.getRegretFlag(), (String)I18nUtil.translate((String)"", (String)"\u6094\u6807\u6807\u8bc6\u4e0d\u80fd\u4e3a\u7a7a"));
        Assert.hasText((String)headVO.getId(), (String)I18nUtil.translate((String)"i18n_alert_empty_header_id", (String)"\u5934\u4fe1\u606fid\u4e0d\u80fd\u4e3a\u7a7a"));
        ((PurchaseEbiddingHeadService)this.service).regret(headVO);
        return this.commonSuccessResult(3);
    }

    @AutoLog(value="\u91c7\u8d2d\u7ade\u4ef7-\u8865\u5145\u7269\u6599")
    @ApiOperation(value="\u8865\u5145\u7269\u6599", notes="\u8865\u5145\u7269\u6599")
    @PostMapping(value={"/replenishMaterialNumber"})
    @RequiresPermissions(value={"purchaseEbiddingHead:replenishMaterialNumber"})
    @PermissionDataOpt(businessType="ebidding", beanClass=PurchaseEbiddingHeadService.class)
    public Result<?> replenishMaterialNumber(@RequestBody PurchaseEbiddingItem webItem) {
        Assert.notNull((Object)((Object)webItem), (String)I18nUtil.translate((String)"", (String)"\u8865\u5145\u884c\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a"));
        this.purchaseEbiddingItemService.replenishMaterialNumber(webItem);
        return this.commonSuccessResult(3);
    }

    @GetMapping(value={"/exportXls"})
    @PermissionDataView(businessType="ebidding")
    @RequiresPermissions(value={"purchaseEbiddingHead:export"})
    public ModelAndView exportXls(HttpServletRequest request, @RequestParam Map<String, Object> object) {
        return super.exportXls(request, object, PurchaseEbiddingHeadExportServiceImpl.class);
    }
}

