/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.enquiry.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.els.common.aspect.annotation.SrmTransaction;
import com.els.common.exception.ELSBootException;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.system.vo.LoginUser;
import com.els.common.util.I18nUtil;
import com.els.common.util.SysUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.base.api.dto.AttachmentSendDTO;
import com.els.modules.enquiry.entity.EnquirySupplierList;
import com.els.modules.enquiry.entity.PurchaseEnquiryHead;
import com.els.modules.enquiry.entity.PurchaseEnquiryItem;
import com.els.modules.enquiry.entity.SaleEnquiryHead;
import com.els.modules.enquiry.entity.SaleEnquiryItem;
import com.els.modules.enquiry.enumerate.EnquiryQuoteTypeEnum;
import com.els.modules.enquiry.enumerate.EnquiryQuoteWayEnum;
import com.els.modules.enquiry.enumerate.EnquiryStatusEnum;
import com.els.modules.enquiry.mapper.PurchaseEnquiryHeadMapper;
import com.els.modules.enquiry.mapper.SaleEnquiryHeadMapper;
import com.els.modules.enquiry.service.EnquirySubstituteHeadService;
import com.els.modules.enquiry.service.PurchaseEnquiryItemService;
import com.els.modules.enquiry.service.SaleEnquiryHeadService;
import com.els.modules.enquiry.service.SaleEnquiryItemHisService;
import com.els.modules.enquiry.service.SaleEnquiryItemService;
import com.els.modules.enquiry.vo.PurchaseEnquiryHeadVO;
import com.els.rpc.service.InvokeBaseRpcService;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service
public class SaleEnquiryHeadServiceImpl
extends BaseServiceImpl<SaleEnquiryHeadMapper, SaleEnquiryHead>
implements SaleEnquiryHeadService {
    @Resource
    private PurchaseEnquiryHeadMapper purchaseEnquiryHeadMapper;
    @Autowired
    private PurchaseEnquiryItemService purchaseEnquiryItemService;
    @Autowired
    private SaleEnquiryItemService saleEnquiryItemService;
    @Autowired
    private SaleEnquiryItemHisService saleEnquiryItemHisService;
    @Autowired
    private EnquirySubstituteHeadService enquirySubstituteHeadService;
    @Resource
    private InvokeBaseRpcService invokeBaseRpcService;

    @Override
    public List<SaleEnquiryHead> selectByMainId(String relationId) {
        return ((SaleEnquiryHeadMapper)this.baseMapper).selectByMainId(relationId);
    }

    @Override
    public Map<String, SaleEnquiryHead> add(PurchaseEnquiryHead head, List<PurchaseEnquiryItem> itemList, List<EnquirySupplierList> supplierList) {
        ArrayList<SaleEnquiryHead> saleHeadList = new ArrayList<SaleEnquiryHead>();
        LoginUser user = SysUtil.getLoginUser();
        for (EnquirySupplierList supplier : supplierList) {
            SaleEnquiryHead saleHead = new SaleEnquiryHead();
            BeanUtils.copyProperties((Object)((Object)head), (Object)((Object)saleHead));
            SysUtil.setSysParam((BaseEntity)saleHead, (BaseEntity)head);
            saleHead.setId(null);
            saleHead.setRelationId(head.getId());
            saleHead.setElsAccount(supplier.getToElsAccount());
            saleHead.setToElsAccount(supplier.getElsAccount());
            saleHead.setPurchaseName(user.getEnterpriseName());
            saleHead.setSupplierName(supplier.getSupplierName());
            saleHead.setSupplierListId(supplier.getId());
            saleHead.setEnquiryStatus(EnquiryStatusEnum.QUOTING.getValue());
            saleHeadList.add(saleHead);
        }
        this.saveBatch(saleHeadList, 2000);
        Map<String, SaleEnquiryHead> supplierMap = saleHeadList.parallelStream().collect(Collectors.toMap(BaseEntity::getElsAccount, Function.identity()));
        ArrayList<SaleEnquiryItem> saleItemList = new ArrayList<SaleEnquiryItem>();
        for (PurchaseEnquiryItem item : itemList) {
            SaleEnquiryItem saleItem = new SaleEnquiryItem();
            BeanUtils.copyProperties((Object)((Object)item), (Object)((Object)saleItem));
            saleItem.setId(null);
            saleItem.setElsAccount(item.getToElsAccount());
            saleItem.setRelationId(item.getId());
            saleItem.setHeadId(supplierMap.get(item.getToElsAccount()).getId());
            saleItem.setToElsAccount(item.getElsAccount());
            saleItemList.add(saleItem);
        }
        this.saleEnquiryItemService.saveBatch(saleItemList, 2000);
        this.enquirySubstituteHeadService.add(saleHeadList, saleItemList, supplierList);
        return supplierMap;
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void save(SaleEnquiryHead saleHead, List<SaleEnquiryItem> saleItemList) {
        List<SaleEnquiryItem> updateList;
        if (CollectionUtil.isNotEmpty(saleItemList) && CollectionUtil.isNotEmpty(updateList = saleItemList.parallelStream().filter(item -> EnquiryStatusEnum.QUOTING.getValue().equals(item.getItemStatus()) || EnquiryStatusEnum.BARGAIN.getValue().equals(item.getItemStatus())).collect(Collectors.toList()))) {
            updateList.forEach(item -> this.compute(saleHead.getQuoteType(), (SaleEnquiryItem)((Object)item), false));
            this.saleEnquiryItemService.updateBatchById(updateList);
            int count = ((SaleEnquiryHeadMapper)this.baseMapper).updateById((Object)saleHead);
            if (count == 0) {
                throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_APWFIKXWVVVXVSDJHrW_2fe92d52", (String)"\u5f53\u524d\u6570\u636e\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u5237\u65b0\u540e\u63d0\u4ea4\u66f4\u6539"));
            }
            this.enquirySubstituteHeadService.save(saleHead, updateList);
        }
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void quote(SaleEnquiryHead saleHead, List<SaleEnquiryItem> saleItemList) {
        int count;
        List<SaleEnquiryItem> quoteList = saleItemList.parallelStream().filter(item -> EnquiryStatusEnum.QUOTING.getValue().equals(item.getItemStatus()) || EnquiryStatusEnum.BARGAIN.getValue().equals(item.getItemStatus())).collect(Collectors.toList());
        Assert.notEmpty(quoteList, (String)I18nUtil.translate((String)"i18n_alert_BjqIsujcdI_b6f15cad", (String)"\u6ca1\u6709\u53ef\u4ee5\u62a5\u4ef7\u7684\u884c\u9879\u76ee"));
        if (EnquiryStatusEnum.QUOTING.getValue().equals(saleHead.getEnquiryStatus())) {
            saleHead.setEnquiryStatus(EnquiryStatusEnum.QUOTED.getValue());
        }
        if ((count = ((SaleEnquiryHeadMapper)this.baseMapper).updateById((Object)saleHead)) == 0) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_APWFIKXWVVVXVSDJHrW_2fe92d52", (String)"\u5f53\u524d\u6570\u636e\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u5237\u65b0\u540e\u63d0\u4ea4\u66f4\u6539"));
        }
        PurchaseEnquiryHead purchaseHead = new PurchaseEnquiryHead();
        purchaseHead.setId(saleHead.getRelationId());
        purchaseHead.setEnquiryStatus(EnquiryStatusEnum.BARGAIN.getValue());
        count = this.purchaseEnquiryHeadMapper.updateById((Object)purchaseHead);
        if (count == 0) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_APWFIKXWVVVXVSDJHrW_2fe92d52", (String)"\u5f53\u524d\u6570\u636e\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u5237\u65b0\u540e\u63d0\u4ea4\u66f4\u6539"));
        }
        quoteList.forEach(item -> {
            if ("1".equals(saleHead.getSupplierTaxRate())) {
                item.setTaxRate(StrUtil.isBlank((CharSequence)item.getTaxRate()) ? saleHead.getTaxRate() : item.getTaxRate());
                item.setTaxCode(StrUtil.isBlank((CharSequence)item.getTaxCode()) ? saleHead.getTaxCode() : item.getTaxCode());
                Assert.hasText((String)item.getTaxCode(), (String)I18nUtil.translate((String)"", (String)"\u884c\u4fe1\u606f\u7a0e\u7801\u4e0d\u80fd\u4e3a\u7a7a"));
                Assert.hasText((String)item.getTaxRate(), (String)I18nUtil.translate((String)"", (String)"\u884c\u4fe1\u606f\u7a0e\u7387\u4e0d\u80fd\u4e3a\u7a7a"));
            }
            this.compute(saleHead.getQuoteType(), (SaleEnquiryItem)((Object)item), true);
        });
        this.saleEnquiryItemService.updateBatchById(quoteList);
        ArrayList<PurchaseEnquiryItem> purchaseList = new ArrayList<PurchaseEnquiryItem>();
        for (SaleEnquiryItem saleItem : quoteList) {
            PurchaseEnquiryItem purchaseItem = new PurchaseEnquiryItem();
            BeanUtils.copyProperties((Object)((Object)saleItem), (Object)((Object)purchaseItem));
            purchaseItem.setHeadId(saleHead.getRelationId());
            purchaseItem.setId(saleItem.getRelationId());
            purchaseItem.setRelationId(saleItem.getId());
            purchaseItem.setElsAccount(saleItem.getToElsAccount());
            purchaseItem.setToElsAccount(saleItem.getElsAccount());
            purchaseList.add(purchaseItem);
        }
        this.purchaseEnquiryItemService.updateBatchById(purchaseList);
        this.enquirySubstituteHeadService.quote(saleHead, quoteList);
        List<SaleEnquiryItem> needRecordList = quoteList.stream().filter(item -> "0".equals(item.getQuotePrice())).collect(Collectors.toList());
        this.saleEnquiryItemHisService.saveQuoteItemHis(saleHead, needRecordList);
        AttachmentSendDTO sendVO = new AttachmentSendDTO();
        sendVO.setElsAccount(TenantContext.getTenant());
        sendVO.setHeadId(saleHead.getId());
        ConcurrentHashMap<String, String> toSend = new ConcurrentHashMap<String, String>(1);
        toSend.put(saleHead.getRelationId(), saleHead.getToElsAccount());
        sendVO.setToSend(toSend);
        this.invokeBaseRpcService.sendSaleFile(sendVO);
        String url = "id=" + saleHead.getRelationId();
        super.sendMsg(saleHead.getElsAccount(), saleHead.getToElsAccount(), (Object)saleHead, url, "enquiry", "quote");
    }

    private void compute(String quoteType, SaleEnquiryItem item, boolean isQuote) {
        item.setQuotePrice(StrUtil.isBlank((CharSequence)item.getQuotePrice()) ? "0" : item.getQuotePrice());
        if ("0".equals(item.getQuotePrice())) {
            BigDecimal taxRate = StrUtil.isBlank((CharSequence)item.getTaxRate()) ? BigDecimal.ZERO : new BigDecimal(item.getTaxRate()).divide(BigDecimal.valueOf(100L));
            BigDecimal requireQuantity = item.getRequireQuantity() == null ? BigDecimal.ONE : item.getRequireQuantity();
            BigDecimal price = item.getPrice();
            BigDecimal netPrice = item.getNetPrice();
            if (EnquiryQuoteWayEnum.LADDER.getValue().equals(item.getQuotePriceWay())) {
                Assert.hasText((String)item.getLadderPriceJson(), (String)I18nUtil.translate((String)"i18n_alert_yDVHxOLV_4e601437", (String)"\u9636\u68af\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a"));
                JSONArray ladderPriceArray = JSONArray.parseArray((String)item.getLadderPriceJson());
                boolean flag = true;
                for (Object obj : ladderPriceArray) {
                    JSONObject ladderPriceJson = (JSONObject)obj;
                    BigDecimal ladderPrice = ladderPriceJson.getBigDecimal("price");
                    BigDecimal ladderNetPrice = ladderPriceJson.getBigDecimal("netPrice");
                    BigDecimal ladderQuantity = ladderPriceJson.getBigDecimal("ladderQuantity");
                    Assert.notNull((Object)ladderQuantity, (String)I18nUtil.translate((String)"i18n_alert_yDWRxOV_8ad66f92", (String)"\u9636\u68af\u6570\u91cf\u4e0d\u80fd\u7a7a"));
                    if (EnquiryQuoteTypeEnum.TAX_INCLUDING.getValue().equals(quoteType)) {
                        Assert.notNull((Object)ladderPrice, (String)I18nUtil.translate((String)"i18n_alert_yDVHsxfuxOLV_cabd5ffe", (String)"\u9636\u68af\u4fe1\u606f\u4e2d\u542b\u7a0e\u4ef7\u4e0d\u80fd\u4e3a\u7a7a"));
                        ladderNetPrice = ladderPrice.divide(BigDecimal.ONE.add(taxRate), 6, 4);
                    } else {
                        Assert.notNull((Object)ladderNetPrice, (String)I18nUtil.translate((String)"i18n_alert_yDVHsxxfuxOLV_68dce0dd", (String)"\u9636\u68af\u4fe1\u606f\u4e2d\u4e0d\u542b\u7a0e\u4ef7\u4e0d\u80fd\u4e3a\u7a7a"));
                        ladderPrice = ladderNetPrice.multiply(BigDecimal.ONE.add(taxRate)).setScale(6, 4);
                    }
                    ladderPriceJson.put("price", (Object)ladderPrice.setScale(6, 4));
                    ladderPriceJson.put("netPrice", (Object)ladderNetPrice.setScale(6, 4));
                    ladderPriceJson.put("taxAmount", (Object)ladderPrice.multiply(requireQuantity).setScale(6, 4));
                    ladderPriceJson.put("netAmount", (Object)ladderNetPrice.multiply(requireQuantity).setScale(6, 4));
                    if (requireQuantity.compareTo(ladderQuantity) < 0) continue;
                    price = ladderPrice.setScale(6, 4);
                    netPrice = ladderNetPrice.setScale(6, 4);
                    flag = false;
                }
                if (flag) {
                    price = ladderPriceArray.getJSONObject(0).getBigDecimal("price").setScale(6, 4);
                    netPrice = ladderPriceArray.getJSONObject(0).getBigDecimal("netPrice").setScale(6, 4);
                }
            }
            if (EnquiryQuoteTypeEnum.TAX_INCLUDING.getValue().equals(quoteType)) {
                Assert.notNull((Object)price, (String)I18nUtil.translate((String)"i18n_alert_empty_notPrice", (String)"\u542b\u7a0e\u4ef7\u4e0d\u80fd\u4e3a\u7a7a"));
                netPrice = price.divide(BigDecimal.ONE.add(taxRate), 6, 4);
            } else {
                Assert.notNull((Object)netPrice, (String)I18nUtil.translate((String)"i18n_alert_empty_notNetPrice", (String)"\u4e0d\u542b\u7a0e\u4ef7\u4e0d\u80fd\u4e3a\u7a7a"));
                price = netPrice.multiply(BigDecimal.ONE.add(taxRate)).setScale(6, 4);
            }
            item.setPrice(price.setScale(6, 4));
            item.setNetPrice(netPrice.setScale(6, 4));
            item.setTaxAmount(price.multiply(requireQuantity).setScale(6, 4));
            item.setNetAmount(netPrice.multiply(requireQuantity).setScale(6, 4));
            if (isQuote) {
                item.setItemStatus(EnquiryStatusEnum.QUOTED.getValue());
                item.setQuoteTime(new Date());
                item.setQuoteCount(item.getQuoteCount() == null ? 1 : item.getQuoteCount() + 1);
            }
        } else {
            this.cleanPrice(item);
            item.setItemStatus(isQuote ? EnquiryStatusEnum.CAN_NOT_QUOTE.getValue() : item.getItemStatus());
        }
    }

    private void cleanPrice(SaleEnquiryItem item) {
        String quotePriceWay = item.getQuotePriceWay();
        if (EnquiryQuoteWayEnum.LADDER.getValue().equals(quotePriceWay)) {
            JSONArray ladderPriceArray = StrUtil.isNotBlank((CharSequence)item.getLadderPriceJson()) ? JSONArray.parseArray((String)item.getLadderPriceJson()) : new JSONArray();
            for (Object obj : ladderPriceArray) {
                JSONObject ladderPriceJson = (JSONObject)obj;
                ladderPriceJson.put("taxAmount", null);
                ladderPriceJson.put("netAmount", null);
                ladderPriceJson.put("price", null);
                ladderPriceJson.put("netPrice", null);
            }
        }
        item.setPrice(null);
        item.setNetPrice(null);
        item.setTaxAmount(null);
        item.setNetAmount(null);
    }

    @Override
    public Map<String, SaleEnquiryHead> reQuote(PurchaseEnquiryHeadVO headVO, List<PurchaseEnquiryItem> reQuoteList) {
        List<SaleEnquiryItem> updateList = this.getUpdateList(reQuoteList);
        this.saleEnquiryItemService.updateBatchById(updateList);
        List elsAccountList = reQuoteList.stream().map(PurchaseEnquiryItem::getToElsAccount).distinct().collect(Collectors.toList());
        List<SaleEnquiryHead> headList = ((SaleEnquiryHeadMapper)this.baseMapper).selectByMainId(headVO.getId()).stream().filter(head -> elsAccountList.contains(head.getElsAccount())).collect(Collectors.toList());
        headList.forEach(head -> {
            head.setEnquiryStatus(EnquiryStatusEnum.BARGAIN.getValue());
            head.setQuoteEndTime(headVO.getQuoteEndTime());
        });
        this.updateBatchById(headList);
        this.enquirySubstituteHeadService.reQuote(headList, updateList);
        return headList.stream().collect(Collectors.toMap(BaseEntity::getElsAccount, Function.identity()));
    }

    @Override
    public void priced(PurchaseEnquiryHead dbHead, List<PurchaseEnquiryItem> pricedList) {
        List<SaleEnquiryItem> updateList = this.getUpdateList(pricedList);
        this.saleEnquiryItemService.updateBatchById(updateList);
        if (EnquiryStatusEnum.PRICED.getValue().equals(dbHead.getEnquiryStatus())) {
            this.update((Wrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().eq(SaleEnquiryHead::getRelationId, (Object)dbHead.getId())).set(SaleEnquiryHead::getEnquiryStatus, (Object)EnquiryStatusEnum.PRICED.getValue()));
        }
        this.enquirySubstituteHeadService.priced(dbHead, updateList);
    }

    private List<SaleEnquiryItem> getUpdateList(List<PurchaseEnquiryItem> itemList) {
        ArrayList<SaleEnquiryItem> updateList = new ArrayList<SaleEnquiryItem>();
        for (PurchaseEnquiryItem item : itemList) {
            SaleEnquiryItem saleItem = new SaleEnquiryItem();
            BeanUtils.copyProperties((Object)((Object)item), (Object)((Object)saleItem));
            saleItem.setId(item.getRelationId());
            saleItem.setElsAccount(item.getToElsAccount());
            saleItem.setRelationId(item.getId());
            saleItem.setHeadId(null);
            saleItem.setToElsAccount(item.getElsAccount());
            updateList.add(saleItem);
        }
        return updateList;
    }

    @Override
    public void cancel(PurchaseEnquiryHead head) {
        this.update((Wrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().eq(SaleEnquiryHead::getRelationId, (Object)head.getId())).set(SaleEnquiryHead::getEnquiryStatus, (Object)EnquiryStatusEnum.CANCEL.getValue()));
        this.saleEnquiryItemService.update((Wrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().eq(SaleEnquiryItem::getEnquiryNumber, (Object)head.getEnquiryNumber())).eq(SaleEnquiryItem::getToElsAccount, (Object)head.getElsAccount())).set(SaleEnquiryItem::getItemStatus, (Object)EnquiryStatusEnum.CANCEL.getValue()));
        this.enquirySubstituteHeadService.cancel(head);
    }

    @Override
    public void regret(PurchaseEnquiryHead head, List<PurchaseEnquiryItem> webList) {
        List<SaleEnquiryItem> updateList = this.getUpdateList(webList);
        this.saleEnquiryItemService.updateBatchById(updateList);
        List elsAccountList = webList.stream().map(PurchaseEnquiryItem::getToElsAccount).distinct().collect(Collectors.toList());
        this.update((Wrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().in(BaseEntity::getElsAccount, elsAccountList)).eq(SaleEnquiryHead::getRelationId, (Object)head.getId())).set(SaleEnquiryHead::getEnquiryStatus, (Object)head.getEnquiryStatus()));
        this.enquirySubstituteHeadService.regret(head, updateList);
    }
}

