/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.searchSourceConfig.service.impl;

import com.els.common.util.AssertI18nUtil;
import com.els.modules.bidding.entity.PurchaseBiddingItem;
import com.els.modules.demand.entity.PurchaseRequestItem;
import com.els.modules.ebidding.entity.PurchaseEbiddingItem;
import com.els.modules.enquiry.entity.PurchaseEnquiryItem;
import com.els.modules.searchSourceConfig.enums.AmountThresholdValidEnum;
import com.els.modules.searchSourceConfig.enums.I18nSearSourEnum;
import com.els.modules.searchSourceConfig.mapper.PurchaseSearchSourceConfigHeadMapper;
import com.els.modules.searchSourceConfig.service.SearSourMaterValidService;
import com.els.modules.searchSourceConfig.utils.SearSourConfigUtil;
import com.els.modules.searchSourceConfig.vo.MaterialDataValidParamVo;
import com.els.modules.searchSourceConfig.vo.MaterialDataVo;
import com.els.modules.searchSourceConfig.vo.PurAmountThresItemVo;
import com.els.modules.searchSourceConfig.vo.PurSourceTypeItemVo;
import com.els.modules.searchSourceConfig.vo.base.IMaterialDataValidParam;
import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
public class SearSourMaterValidServiceImpl
implements SearSourMaterValidService {
    @Resource
    private PurchaseSearchSourceConfigHeadMapper headMapper;

    private void validSearSourType(IMaterialDataValidParam validParam) {
        List<PurSourceTypeItemVo> itemVos = this.headMapper.getMaterSourType(validParam.getPurOrgCode());
        if (CollectionUtils.isEmpty(itemVos)) {
            return;
        }
        Map<String, Long> materialGroup = validParam.getMaterialDataVos().stream().collect(Collectors.groupingBy(MaterialDataVo::getCateCode, Collectors.counting()));
        itemVos.forEach(itemVo -> {
            if (!materialGroup.containsKey(itemVo.getCateCode())) {
                return;
            }
            String configType = SearSourConfigUtil.validSearSourType(validParam.getSearchSourceType(), itemVo.getSearchSourceType());
            AssertI18nUtil.isTrue((configType != null ? 1 : 0) != 0, (Enum)I18nSearSourEnum.SAVE_SEAR_SOUR_NO_CONFIG, (String[])new String[]{itemVo.getCateCode(), configType == null ? "1" : configType});
        });
    }

    private void validSubmitMaterial(IMaterialDataValidParam validParam) {
        List<PurAmountThresItemVo> itemVos = this.headMapper.getMaterAmountThres(validParam.getPurOrgCode());
        if (CollectionUtils.isEmpty(itemVos)) {
            return;
        }
        Map<String, Long> materialGroup = validParam.getMaterialDataVos().stream().collect(Collectors.groupingBy(MaterialDataVo::getCateCode, Collectors.counting()));
        itemVos.forEach(itemVo -> {
            if (!materialGroup.containsKey(itemVo.getCateCode())) {
                return;
            }
            String configType = SearSourConfigUtil.validSearSourType(validParam.getSearchSourceType(), itemVo.getSearchSourceType());
            AssertI18nUtil.isTrue((configType != null ? 1 : 0) != 0, (Enum)I18nSearSourEnum.SUBMIT_SEAR_SOUR_NO_CONFIG, (String[])new String[]{itemVo.getCateCode(), configType == null ? "1" : configType});
            AmountThresholdValidEnum.validAmountThres(itemVo, validParam.getMaterialDataVos());
        });
    }

    @Override
    public void validMaterial(MaterialDataValidParamVo validParamVo) {
        if (StringUtils.isBlank((CharSequence)validParamVo.getPurOrgCode()) || CollectionUtils.isEmpty(validParamVo.getMaterialDataVos())) {
            return;
        }
        List<MaterialDataVo> dataVos = validParamVo.getMaterialDataVos().stream().filter(dataVo -> StringUtils.isNotBlank((CharSequence)dataVo.getCateCode())).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(dataVos)) {
            return;
        }
        validParamVo.setMaterialDataVos(dataVos);
        this.validSearSourType(validParamVo);
    }

    @Override
    @Transactional(readOnly=true, rollbackFor={Exception.class})
    public void publishEnquiry(String purchaseOrg, List<PurchaseEnquiryItem> itemList) {
        if (StringUtils.isBlank((CharSequence)purchaseOrg) || CollectionUtils.isEmpty(itemList)) {
            return;
        }
        List itemVos = itemList.stream().filter(item -> StringUtils.isNotBlank((CharSequence)item.getCateCode())).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(itemVos)) {
            return;
        }
        MaterialDataValidParamVo validParamVo = new MaterialDataValidParamVo();
        validParamVo.setPurOrgCode(purchaseOrg).setSearchSourceType("0");
        List<MaterialDataVo> materialDataVos = itemVos.stream().map(item -> {
            MaterialDataVo materialDataVo = new MaterialDataVo();
            materialDataVo.setCateCode(item.getCateCode()).setMaterialNumber(item.getMaterialNumber()).setAmount(BigDecimal.ZERO);
            return materialDataVo;
        }).collect(Collectors.toList());
        validParamVo.setMaterialDataVos(materialDataVos);
        this.validSubmitMaterial(validParamVo);
    }

    @Override
    @Transactional(readOnly=true, rollbackFor={Exception.class})
    public void publishEbidding(String purchaseOrg, List<PurchaseEbiddingItem> itemList) {
        if (StringUtils.isBlank((CharSequence)purchaseOrg) || CollectionUtils.isEmpty(itemList)) {
            return;
        }
        List itemVos = itemList.stream().filter(item -> StringUtils.isNotBlank((CharSequence)item.getCateCode())).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(itemVos)) {
            return;
        }
        MaterialDataValidParamVo validParamVo = new MaterialDataValidParamVo();
        validParamVo.setPurOrgCode(purchaseOrg).setSearchSourceType("1");
        List<MaterialDataVo> materialDataVos = itemVos.stream().map(item -> {
            MaterialDataVo materialDataVo = new MaterialDataVo();
            materialDataVo.setCateCode(item.getCateCode()).setMaterialNumber(item.getMaterialNumber()).setAmount(BigDecimal.ZERO);
            return materialDataVo;
        }).collect(Collectors.toList());
        validParamVo.setMaterialDataVos(materialDataVos);
        this.validSubmitMaterial(validParamVo);
    }

    @Override
    @Transactional(readOnly=true, rollbackFor={Exception.class})
    public void publishBidding(String purchaseOrg, List<PurchaseBiddingItem> itemList) {
        if (StringUtils.isBlank((CharSequence)purchaseOrg) || CollectionUtils.isEmpty(itemList)) {
            return;
        }
        List itemVos = itemList.stream().filter(item -> StringUtils.isNotBlank((CharSequence)item.getCateCode())).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(itemVos)) {
            return;
        }
        MaterialDataValidParamVo validParamVo = new MaterialDataValidParamVo();
        validParamVo.setPurOrgCode(purchaseOrg).setSearchSourceType("2");
        List<MaterialDataVo> materialDataVos = itemVos.stream().map(item -> {
            MaterialDataVo materialDataVo = new MaterialDataVo();
            materialDataVo.setCateCode(item.getCateCode()).setMaterialNumber(item.getMaterialNumber()).setAmount(BigDecimal.ZERO);
            return materialDataVo;
        }).collect(Collectors.toList());
        validParamVo.setMaterialDataVos(materialDataVos);
        this.validSubmitMaterial(validParamVo);
    }

    @Override
    @Transactional(readOnly=true, rollbackFor={Exception.class})
    public void requestPoolValid(String searchSourceType, String purchaseOrg, List<PurchaseRequestItem> itemList) {
        if (StringUtils.isBlank((CharSequence)purchaseOrg) || CollectionUtils.isEmpty(itemList)) {
            return;
        }
        List itemVos = itemList.stream().filter(item -> StringUtils.isNotBlank((CharSequence)item.getCateCode())).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(itemVos)) {
            return;
        }
        MaterialDataValidParamVo validParamVo = new MaterialDataValidParamVo();
        validParamVo.setPurOrgCode(purchaseOrg).setSearchSourceType(searchSourceType);
        List<MaterialDataVo> materialDataVos = itemVos.stream().map(item -> {
            MaterialDataVo materialDataVo = new MaterialDataVo();
            materialDataVo.setCateCode(item.getCateCode()).setMaterialNumber(item.getMaterialNumber());
            BigDecimal amount = item.getBudgetPrice() == null || item.getQuantity() == null ? BigDecimal.ZERO : item.getQuantity().multiply(item.getBudgetPrice());
            materialDataVo.setAmount(amount);
            return materialDataVo;
        }).collect(Collectors.toList());
        validParamVo.setMaterialDataVos(materialDataVos);
        this.validSubmitMaterial(validParamVo);
    }
}

