/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.bidding.service.impl;

import com.els.api.dto.BaseDTO;
import com.els.common.aspect.annotation.SrmTransaction;
import com.els.common.constant.CommonConstant;
import com.els.common.exception.ELSBootException;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.util.I18nUtil;
import com.els.common.util.SysUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.base.api.dto.PurchaseAttachmentDTO;
import com.els.modules.base.api.dto.SaleAttachmentDTO;
import com.els.modules.bidding.entity.BiddingSupplier;
import com.els.modules.bidding.entity.PurchaseBiddingHead;
import com.els.modules.bidding.entity.PurchaseMentoringHead;
import com.els.modules.bidding.entity.PurchaseMentoringItem;
import com.els.modules.bidding.entity.SaleMentoringHead;
import com.els.modules.bidding.entity.SaleMentoringItem;
import com.els.modules.bidding.enumerate.BusinessBillTypeEnum;
import com.els.modules.bidding.mapper.PurchaseMentoringHeadMapper;
import com.els.modules.bidding.mapper.PurchaseMentoringItemMapper;
import com.els.modules.bidding.mapper.SaleMentoringHeadMapper;
import com.els.modules.bidding.mapper.SaleMentoringItemMapper;
import com.els.modules.bidding.service.BiddingSupplierService;
import com.els.modules.bidding.service.PurchaseBiddingHeadService;
import com.els.modules.bidding.service.PurchaseMentoringHeadService;
import com.els.modules.bidding.service.PurchaseMentoringItemService;
import com.els.modules.ebidding.entity.PurchaseEbiddingSupplier;
import com.els.modules.ebidding.service.PurchaseEbiddingSupplierService;
import com.els.modules.enquiry.entity.EnquirySupplierList;
import com.els.modules.enquiry.service.EnquirySupplierListService;
import com.els.rpc.service.InvokeBaseRpcService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PurchaseMentoringHeadServiceImpl
extends BaseServiceImpl<PurchaseMentoringHeadMapper, PurchaseMentoringHead>
implements PurchaseMentoringHeadService {
    @Autowired
    private PurchaseMentoringHeadMapper purchaseMentoringHeadMapper;
    @Autowired
    private PurchaseMentoringItemMapper purchaseMentoringItemMapper;
    @Autowired
    private SaleMentoringHeadMapper saleMentoringHeadMapper;
    @Autowired
    private SaleMentoringItemMapper saleMentoringItemMapper;
    @Autowired
    private PurchaseEbiddingSupplierService purchaseEbiddingSupplierService;
    @Autowired
    private EnquirySupplierListService enquirySupplierListService;
    @Autowired
    private PurchaseBiddingHeadService purchaseBiddingHeadService;
    @Autowired
    private BiddingSupplierService biddingSupplierService;
    @Autowired
    private PurchaseMentoringItemService purchaseMentoringItemService;
    @Autowired
    private InvokeBaseRpcService invokeBaseRpcService;

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void saveMain(PurchaseMentoringHead purchaseMentoringHead, List<PurchaseMentoringItem> purchaseMentoringItemList, List<PurchaseAttachmentDTO> attachments) {
        this.purchaseMentoringHeadMapper.insert((Object)purchaseMentoringHead);
        this.insertData(purchaseMentoringHead, purchaseMentoringItemList, attachments);
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void updateMain(PurchaseMentoringHead purchaseMentoringHead, List<PurchaseMentoringItem> purchaseMentoringItemList, List<PurchaseAttachmentDTO> attachments) {
        int count = this.purchaseMentoringHeadMapper.updateById((Object)purchaseMentoringHead);
        if (count == 0) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_APWFIKXWVVVXVSDJHrW_2fe92d52", (String)"\u5f53\u524d\u6570\u636e\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u5237\u65b0\u540e\u63d0\u4ea4\u66f4\u6539"));
        }
        this.purchaseMentoringItemMapper.deleteByMainId(purchaseMentoringHead.getId());
        if (attachments != null && attachments.size() > 0) {
            this.invokeBaseRpcService.deletePurchaseAttachmentByMainId(purchaseMentoringHead.getId());
        }
        this.insertData(purchaseMentoringHead, purchaseMentoringItemList, attachments);
    }

    private void insertData(PurchaseMentoringHead purchaseMentoringHead, List<PurchaseMentoringItem> purchaseMentoringItemList, List<PurchaseAttachmentDTO> attachments) {
        if (purchaseMentoringItemList != null && purchaseMentoringItemList.size() > 0) {
            for (PurchaseMentoringItem entity : purchaseMentoringItemList) {
                entity.setHeadId(purchaseMentoringHead.getId());
                SysUtil.setSysParam((BaseEntity)entity, (BaseEntity)purchaseMentoringHead);
            }
            if (!purchaseMentoringItemList.isEmpty()) {
                this.purchaseMentoringItemService.saveBatch(purchaseMentoringItemList, 2000);
            }
        }
        if (attachments != null && attachments.size() > 0) {
            for (PurchaseAttachmentDTO attachment : attachments) {
                attachment.setHeadId(purchaseMentoringHead.getId());
                attachment.setUploadElsAccount(purchaseMentoringHead.getElsAccount());
                attachment.setBusinessType("purchase_mentoring");
                SysUtil.setSysParam((BaseDTO)attachment, (BaseEntity)purchaseMentoringHead);
                attachment.setId(null);
            }
            this.invokeBaseRpcService.insertPurchaseAttachmentBatchSomeColumn(attachments);
        }
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void delMain(String id) {
        this.purchaseMentoringItemMapper.deleteByMainId(id);
        this.purchaseMentoringHeadMapper.deleteById((Serializable)((Object)id));
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void delBatchMain(List<String> idList) {
        for (Serializable serializable : idList) {
            this.purchaseMentoringItemMapper.deleteByMainId(serializable.toString());
            this.purchaseMentoringHeadMapper.deleteById(serializable);
        }
    }

    @Override
    public void publish(PurchaseMentoringHead purchaseMentoringHead, List<PurchaseMentoringItem> purchaseMentoringItemList, List<PurchaseAttachmentDTO> attachments, PurchaseMentoringItem purchaseMentoringItem) {
        if (purchaseMentoringHead.getMentoringTimes() == null) {
            purchaseMentoringHead.setMentoringTimes(1);
        } else {
            purchaseMentoringHead.setMentoringTimes(purchaseMentoringHead.getMentoringTimes() + 1);
        }
        this.purchaseMentoringHeadMapper.updateById((Object)purchaseMentoringHead);
        if (StringUtils.isNotBlank((CharSequence)purchaseMentoringItem.getId())) {
            purchaseMentoringItem.setAnswerStatus("1");
            this.purchaseMentoringItemMapper.updateById((Object)purchaseMentoringItem);
        } else {
            purchaseMentoringItem.setHeadId(purchaseMentoringHead.getId());
            SysUtil.setSysParam((BaseEntity)purchaseMentoringItem, (BaseEntity)purchaseMentoringHead);
            purchaseMentoringItem.setDeleted(CommonConstant.DEL_FLAG_0);
            purchaseMentoringItem.setAnswerStatus("1");
            purchaseMentoringItem.setElsAccount(purchaseMentoringHead.getElsAccount());
            purchaseMentoringItem.setToElsAccount(purchaseMentoringHead.getToElsAccount());
            this.purchaseMentoringItemMapper.insert((Object)purchaseMentoringItem);
        }
        if ("0".equals(purchaseMentoringHead.getMentoringObject())) {
            SaleMentoringHead saleMentoringHead = (SaleMentoringHead)((Object)this.saleMentoringHeadMapper.selectById((Serializable)((Object)purchaseMentoringHead.getRelationId())));
            if (saleMentoringHead != null) {
                this.updateSaleMentoring(purchaseMentoringHead, purchaseMentoringItem, saleMentoringHead);
            }
        } else {
            PurchaseBiddingHead biddingHead;
            List<EnquirySupplierList> supplierList;
            List<PurchaseEbiddingSupplier> dbSupplierList;
            HashMap<String, String> suppliers = null;
            if (purchaseMentoringHead.getBusinessType().equals(BusinessBillTypeEnum.EBIDDING.getValue()) && (dbSupplierList = this.purchaseEbiddingSupplierService.selectByMainId(purchaseMentoringHead.getBusinessId())) != null && dbSupplierList.size() > 0) {
                suppliers = new HashMap<String, String>();
                for (PurchaseEbiddingSupplier purchaseEbiddingSupplier : dbSupplierList) {
                    suppliers.put(purchaseEbiddingSupplier.getToElsAccount(), purchaseEbiddingSupplier.getSupplierName());
                }
                this.sendToSupplier(purchaseMentoringHead, purchaseMentoringItem, attachments, suppliers);
            }
            if (purchaseMentoringHead.getBusinessType().equals(BusinessBillTypeEnum.ENQUIRY.getValue()) && (supplierList = this.enquirySupplierListService.selectByMainId(purchaseMentoringHead.getBusinessId())) != null && supplierList.size() > 0) {
                suppliers = new HashMap();
                for (EnquirySupplierList enquirySupplierList : supplierList) {
                    suppliers.put(enquirySupplierList.getToElsAccount(), enquirySupplierList.getSupplierName());
                }
                this.sendToSupplier(purchaseMentoringHead, purchaseMentoringItem, attachments, suppliers);
            }
            if (purchaseMentoringHead.getBusinessType().equals(BusinessBillTypeEnum.CALL_BIDS.getValue()) && (biddingHead = (PurchaseBiddingHead)((Object)this.purchaseBiddingHeadService.getById((Serializable)((Object)purchaseMentoringHead.getBusinessId())))) != null) {
                suppliers = new HashMap();
                List<BiddingSupplier> biddingSupplierList = this.biddingSupplierService.selectByMainId(biddingHead.getId());
                for (BiddingSupplier biddingSupplier : biddingSupplierList) {
                    suppliers.put(biddingSupplier.getToElsAccount(), biddingSupplier.getSupplierName());
                }
                this.sendToSupplier(purchaseMentoringHead, purchaseMentoringItem, attachments, suppliers);
            }
        }
    }

    public void updateSaleMentoring(PurchaseMentoringHead purchaseMentoringHead, PurchaseMentoringItem purchaseMentoringItem, SaleMentoringHead saleMentoringHead) {
        SaleMentoringItem item = new SaleMentoringItem();
        BeanUtils.copyProperties((Object)((Object)purchaseMentoringItem), (Object)((Object)item));
        item.setId(null);
        item.setRelationId(purchaseMentoringItem.getId());
        item.setHeadId(purchaseMentoringHead.getRelationId());
        item.setElsAccount(purchaseMentoringHead.getToElsAccount());
        item.setToElsAccount(purchaseMentoringHead.getElsAccount());
        item.setViewStatus("0");
        this.saleMentoringItemMapper.insert((Object)item);
        if (StringUtils.isBlank((CharSequence)saleMentoringHead.getRelationId())) {
            saleMentoringHead.setRelationId(purchaseMentoringHead.getId());
        }
        saleMentoringHead.setMentoringTimes(purchaseMentoringHead.getMentoringTimes());
        if (saleMentoringHead.getUnreadTimes() == null) {
            saleMentoringHead.setUnreadTimes(1);
        } else {
            saleMentoringHead.setUnreadTimes(saleMentoringHead.getUnreadTimes() + 1);
        }
        this.saleMentoringHeadMapper.updateById((Object)saleMentoringHead);
    }

    public void sendToSupplier(PurchaseMentoringHead purchaseMentoringHead, PurchaseMentoringItem purchaseMentoringItem, List<PurchaseAttachmentDTO> attachments, Map<String, String> suppliers) {
        if (suppliers != null && suppliers.size() > 0) {
            Set<String> toElsAccounts = suppliers.keySet();
            ArrayList<String> recevieAccount = new ArrayList<String>();
            for (String string : toElsAccounts) {
                this.saveSaleMentoring(purchaseMentoringHead, purchaseMentoringItem, string, suppliers.get(string), attachments);
                recevieAccount.add(string);
            }
            String url = "id=" + purchaseMentoringHead.getRelationId();
            super.sendMsg(TenantContext.getTenant(), recevieAccount, (Object)purchaseMentoringHead, url, "mentoring", "reply");
        }
    }

    public void saveSaleMentoring(PurchaseMentoringHead purchaseMentoringHead, PurchaseMentoringItem purchaseMentoringItem, String toELsAccount, String supplierName, List<PurchaseAttachmentDTO> attachments) {
        SaleMentoringHead mentoringHead = (SaleMentoringHead)((Object)this.saleMentoringHeadMapper.selectById((Serializable)((Object)purchaseMentoringHead.getRelationId())));
        if (mentoringHead != null && toELsAccount.equals(mentoringHead.getElsAccount())) {
            this.updateSaleMentoring(purchaseMentoringHead, purchaseMentoringItem, mentoringHead);
        } else {
            mentoringHead = new SaleMentoringHead();
            BeanUtils.copyProperties((Object)((Object)purchaseMentoringHead), (Object)((Object)mentoringHead));
            mentoringHead.setId(null);
            mentoringHead.setElsAccount(toELsAccount);
            mentoringHead.setToElsAccount(mentoringHead.getElsAccount());
            mentoringHead.setSupplierName(supplierName);
            mentoringHead.setRelationId(purchaseMentoringHead.getId());
            mentoringHead.setUnreadTimes(1);
            this.saleMentoringHeadMapper.insert((Object)mentoringHead);
            SaleMentoringItem item = new SaleMentoringItem();
            BeanUtils.copyProperties((Object)((Object)purchaseMentoringItem), (Object)((Object)item));
            item.setId(null);
            item.setRelationId(purchaseMentoringItem.getId());
            item.setHeadId(mentoringHead.getId());
            item.setElsAccount(mentoringHead.getElsAccount());
            item.setToElsAccount(mentoringHead.getToElsAccount());
            item.setViewStatus("0");
            this.saleMentoringItemMapper.insert((Object)item);
            if (attachments != null && attachments.size() > 0) {
                ArrayList<SaleAttachmentDTO> saleAttachments = new ArrayList<SaleAttachmentDTO>();
                for (PurchaseAttachmentDTO purchaseAttachment : attachments) {
                    SaleAttachmentDTO attachment = new SaleAttachmentDTO();
                    BeanUtils.copyProperties((Object)purchaseAttachment, (Object)attachment);
                    attachment.setId(null);
                    attachment.setRelationId(mentoringHead.getId());
                    attachment.setElsAccount(mentoringHead.getElsAccount());
                    attachment.setHeadId(mentoringHead.getId());
                    attachment.setDeleted(CommonConstant.DEL_FLAG_0);
                    saleAttachments.add(attachment);
                }
                this.invokeBaseRpcService.insertSaleAttachmentBatchSomeColumn(saleAttachments);
            }
        }
    }

    @Override
    public void addMentoringInfoForSupplier(String businessType, String businessNumber, String toElsAccount, String supplierName) {
        List<PurchaseMentoringHead> heads = this.purchaseMentoringHeadMapper.getByKey(TenantContext.getTenant(), businessType, businessNumber);
        if (heads != null && heads.size() > 0) {
            for (PurchaseMentoringHead purchaseMentoringHead : heads) {
                if ((!"0".equals(purchaseMentoringHead.getMentoringObject()) || !toElsAccount.equals(purchaseMentoringHead.getToElsAccount())) && "0".equals(purchaseMentoringHead.getMentoringObject())) continue;
                List<PurchaseMentoringItem> items = this.purchaseMentoringItemMapper.selectByMainId(purchaseMentoringHead.getId());
                List attachments = this.invokeBaseRpcService.selectPurchaseAttachmentByMainId(purchaseMentoringHead.getId());
                for (PurchaseMentoringItem item : items) {
                    if (!"1".equals(item.getAnswerStatus())) continue;
                    this.saveSaleMentoring(purchaseMentoringHead, item, toElsAccount, supplierName, attachments);
                }
            }
        }
    }
}

