/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.bidding.adapter;

import com.alibaba.fastjson.JSONObject;
import com.els.common.enumerate.AuditStatusEnum;
import com.els.common.system.vo.MsgParamsVO;
import com.els.common.util.MqUtil;
import com.els.common.util.SysUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.account.api.dto.ElsSubAccountDTO;
import com.els.modules.bidding.entity.BiddingEvaluationTemplateHead;
import com.els.modules.bidding.enumerate.BiddingEvaluationTemplateStatusEnum;
import com.els.modules.bidding.mapper.BiddingEvaluationTemplateHeadMapper;
import com.els.modules.uflo.dto.AuditInputParamDTO;
import com.els.modules.uflo.dto.AuditOutputParamDTO;
import com.els.modules.uflo.rpc.service.AuditOptCallBackService;
import com.els.rpc.service.InvokeAccountRpcService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class BiddingEvaluationTemplateAdapter
implements AuditOptCallBackService {
    @Resource
    private BiddingEvaluationTemplateHeadMapper biddingEvaluationTemplateHeadMapper;
    @Resource
    private InvokeAccountRpcService invokeAccountRpcService;

    public void startCallBack(AuditInputParamDTO inputParamVO, AuditOutputParamDTO outputParamVO) {
        String params = inputParamVO.getParams();
        BiddingEvaluationTemplateHead evaluationTemplateHead = (BiddingEvaluationTemplateHead)((Object)JSONObject.parseObject((String)params, BiddingEvaluationTemplateHead.class));
        evaluationTemplateHead.setAuditStatus(outputParamVO.getAuditStatus());
        evaluationTemplateHead.setTemplateStatus(BiddingEvaluationTemplateStatusEnum.INVALID.getValue());
        evaluationTemplateHead.setFlowId(outputParamVO.getProcessRootId());
        this.biddingEvaluationTemplateHeadMapper.updateById((Object)evaluationTemplateHead);
        for (String account : outputParamVO.getNextAuditUserList()) {
            MsgParamsVO msgParamsVO = this.parameterAssemble(inputParamVO, outputParamVO, account);
            MqUtil.sendBusMsg((String)TenantContext.getTenant(), (String)inputParamVO.getBusinessType(), (String)"submitAudit", (MsgParamsVO)msgParamsVO);
        }
    }

    public void completeCallBack(AuditInputParamDTO inputParamVO, AuditOutputParamDTO outputParamVO) {
        this.updateStatus(inputParamVO, outputParamVO);
        if (AuditStatusEnum.AUDIT_FINISH.getValue().equals(outputParamVO.getAuditStatus())) {
            BiddingEvaluationTemplateHead evaluationTemplateHead = (BiddingEvaluationTemplateHead)((Object)this.biddingEvaluationTemplateHeadMapper.selectById((Serializable)((Object)inputParamVO.getBusinessId())));
            evaluationTemplateHead.setAuditStatus(outputParamVO.getAuditStatus());
            evaluationTemplateHead.setTemplateStatus(BiddingEvaluationTemplateStatusEnum.TAKE_EFFECT.getValue());
            this.biddingEvaluationTemplateHeadMapper.updateById((Object)evaluationTemplateHead);
            MsgParamsVO msgParamsVO = this.parameterAssemble(inputParamVO, outputParamVO, outputParamVO.getSubmitUser());
            MqUtil.sendBusMsg((String)TenantContext.getTenant(), (String)inputParamVO.getBusinessType(), (String)"auditPass", (MsgParamsVO)msgParamsVO);
        } else {
            for (String account : outputParamVO.getNextAuditUserList()) {
                MsgParamsVO msgParamsVO = this.parameterAssemble(inputParamVO, outputParamVO, account);
                MqUtil.sendBusMsg((String)TenantContext.getTenant(), (String)inputParamVO.getBusinessType(), (String)"submitAudit", (MsgParamsVO)msgParamsVO);
            }
        }
    }

    public void rejectCallBack(AuditInputParamDTO inputParamVO, AuditOutputParamDTO outputParamVO) {
        this.updateStatus(inputParamVO, outputParamVO);
        MsgParamsVO msgParamsVO = this.parameterAssemble(inputParamVO, outputParamVO, outputParamVO.getSubmitUser());
        MqUtil.sendBusMsg((String)TenantContext.getTenant(), (String)inputParamVO.getBusinessType(), (String)"auditReject", (MsgParamsVO)msgParamsVO);
    }

    public void cancelCallBack(AuditInputParamDTO inputParamVO, AuditOutputParamDTO outputParamVO) {
        this.updateStatus(inputParamVO, outputParamVO);
    }

    public void updateStatus(AuditInputParamDTO inputParamVO, AuditOutputParamDTO outputParamVO) {
        BiddingEvaluationTemplateHead biddingEvaluationTemplateHead = new BiddingEvaluationTemplateHead();
        biddingEvaluationTemplateHead.setId(inputParamVO.getBusinessId());
        biddingEvaluationTemplateHead.setAuditStatus(outputParamVO.getAuditStatus());
        biddingEvaluationTemplateHead.setFlowId(outputParamVO.getProcessRootId());
        this.biddingEvaluationTemplateHeadMapper.updateById((Object)biddingEvaluationTemplateHead);
    }

    private MsgParamsVO parameterAssemble(AuditInputParamDTO inputParamVO, AuditOutputParamDTO outputParamVO, String account) {
        MsgParamsVO msgParamsVO = new MsgParamsVO();
        ArrayList<ElsSubAccountDTO> accountList = new ArrayList<ElsSubAccountDTO>();
        HashMap<String, ArrayList<ElsSubAccountDTO>> receiverMap = new HashMap<String, ArrayList<ElsSubAccountDTO>>();
        ElsSubAccountDTO subAccount = this.invokeAccountRpcService.getAccount(TenantContext.getTenant(), account.split("_").length > 1 ? account.split("_")[1] : account.split("_")[0]);
        accountList.add(subAccount);
        receiverMap.put(TenantContext.getTenant(), accountList);
        msgParamsVO.setReceiverMap(receiverMap);
        String outAuditPassUrl = SysUtil.getOutAuditPassUrl((ElsSubAccountDTO)subAccount, (String)outputParamVO.getProcessRootId(), (String)inputParamVO.getBusinessType(), (String)inputParamVO.getBusinessId());
        String outAuditRejectUrl = SysUtil.getOutAuditRejectUrl((ElsSubAccountDTO)subAccount, (String)outputParamVO.getProcessRootId(), (String)inputParamVO.getBusinessType(), (String)inputParamVO.getBusinessId());
        Map<String, String> paramMap = inputParamVO.getVariables() == null ? new HashMap() : inputParamVO.getVariables();
        paramMap.put("userName", subAccount.getRealname());
        paramMap.put("outAuditPassUrl", outAuditPassUrl);
        paramMap.put("outAuditRejectUrl", outAuditRejectUrl);
        if (account.split("_").length > 2) {
            paramMap.put("taskId", account.split("_")[2]);
        }
        msgParamsVO.setParams(paramMap);
        HashMap<String, JSONObject> receiveParamMap = new HashMap<String, JSONObject>();
        JSONObject paramObj = new JSONObject();
        paramObj.put("businessId", (Object)inputParamVO.getBusinessId());
        paramObj.put("businessType", (Object)inputParamVO.getBusinessType());
        receiveParamMap.put(TenantContext.getTenant(), paramObj);
        msgParamsVO.setReceiveParamMap(receiveParamMap);
        return msgParamsVO;
    }
}

