/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.enquiry.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.els.common.exception.ELSBootException;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.util.I18nUtil;
import com.els.modules.enquiry.entity.EnquirySubstituteHead;
import com.els.modules.enquiry.entity.EnquirySubstituteItem;
import com.els.modules.enquiry.entity.EnquirySupplierList;
import com.els.modules.enquiry.entity.PurchaseEnquiryHead;
import com.els.modules.enquiry.entity.SaleEnquiryHead;
import com.els.modules.enquiry.entity.SaleEnquiryItem;
import com.els.modules.enquiry.enumerate.EnquiryStatusEnum;
import com.els.modules.enquiry.mapper.EnquirySubstituteHeadMapper;
import com.els.modules.enquiry.service.EnquirySubstituteHeadService;
import com.els.modules.enquiry.service.EnquirySubstituteItemService;
import com.els.modules.enquiry.service.EnquirySupplierListService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class EnquirySubstituteHeadServiceImpl
extends BaseServiceImpl<EnquirySubstituteHeadMapper, EnquirySubstituteHead>
implements EnquirySubstituteHeadService {
    @Autowired
    private EnquirySubstituteItemService enquirySubstituteItemService;
    @Autowired
    private EnquirySupplierListService enquirySupplierListService;

    private List<EnquirySubstituteItem> copyItem(List<SaleEnquiryItem> saleItemList) {
        ArrayList<EnquirySubstituteItem> substituteItemList = new ArrayList<EnquirySubstituteItem>();
        for (SaleEnquiryItem saleItem : saleItemList) {
            EnquirySubstituteItem item = new EnquirySubstituteItem();
            BeanUtils.copyProperties((Object)((Object)saleItem), (Object)((Object)item));
            substituteItemList.add(item);
        }
        return substituteItemList;
    }

    private List<EnquirySubstituteHead> copyHead(List<SaleEnquiryHead> saleHeadList) {
        ArrayList<EnquirySubstituteHead> substituteHeadList = new ArrayList<EnquirySubstituteHead>();
        for (SaleEnquiryHead saleHead : saleHeadList) {
            EnquirySubstituteHead head = new EnquirySubstituteHead();
            BeanUtils.copyProperties((Object)((Object)saleHead), (Object)((Object)head));
            substituteHeadList.add(head);
        }
        return substituteHeadList;
    }

    @Override
    public void add(List<SaleEnquiryHead> saleHeadList, List<SaleEnquiryItem> saleItemList, List<EnquirySupplierList> supplierList) {
        List needInsertSupplier = supplierList.stream().filter(supplier -> "0".equals(supplier.getNeedCoordination())).map(EnquirySupplierList::getToElsAccount).collect(Collectors.toList());
        if (CollectionUtil.isNotEmpty(needInsertSupplier)) {
            List<SaleEnquiryHead> needInsertHeadList = saleHeadList.stream().filter(head -> needInsertSupplier.contains(head.getElsAccount())).collect(Collectors.toList());
            List<EnquirySubstituteHead> insertHeadList = this.copyHead(needInsertHeadList);
            this.saveBatch(insertHeadList);
            List insertHeadId = needInsertHeadList.stream().map(BaseEntity::getId).collect(Collectors.toList());
            List<SaleEnquiryItem> needInsertItemList = saleItemList.stream().filter(item -> insertHeadId.contains(item.getHeadId())).collect(Collectors.toList());
            List<EnquirySubstituteItem> insertItemList = this.copyItem(needInsertItemList);
            this.enquirySubstituteItemService.saveBatch(insertItemList);
        }
    }

    @Override
    public void save(SaleEnquiryHead updateHead, List<SaleEnquiryItem> updateItemList) {
        this.updateMain(updateHead, updateItemList);
    }

    @Override
    public void quote(SaleEnquiryHead updateHead, List<SaleEnquiryItem> updateItemList) {
        this.updateMain(updateHead, updateItemList);
    }

    private void updateMain(SaleEnquiryHead updateHead, List<SaleEnquiryItem> updateItemList) {
        String supplierId;
        EnquirySupplierList supplier;
        if (CollectionUtil.isNotEmpty(updateItemList) && "0".equals((supplier = (EnquirySupplierList)((Object)this.enquirySupplierListService.getById((Serializable)((Object)(supplierId = updateItemList.get(0).getSupplierId()))))).getNeedCoordination())) {
            EnquirySubstituteHead head = new EnquirySubstituteHead();
            BeanUtils.copyProperties((Object)((Object)updateHead), (Object)((Object)head));
            boolean b = this.updateById((Object)head);
            if (!b) {
                throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_APWFIKXWVVVXVSDJHrW_2fe92d52", (String)"\u5f53\u524d\u6570\u636e\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u5237\u65b0\u540e\u63d0\u4ea4\u66f4\u6539"));
            }
            List<EnquirySubstituteItem> updateList = this.copyItem(updateItemList);
            this.enquirySubstituteItemService.updateBatchById(updateList);
        }
    }

    @Override
    public void reQuote(List<SaleEnquiryHead> headList, List<SaleEnquiryItem> reQuoteList) {
        List<EnquirySubstituteItem> updateList = this.getUpdateItemList(reQuoteList);
        if (CollectionUtil.isNotEmpty(updateList)) {
            List<EnquirySubstituteHead> reQuoteHeadList = this.copyHead(headList);
            this.updateBatchById(reQuoteHeadList);
            this.enquirySubstituteItemService.updateBatchById(updateList);
        }
    }

    @Override
    public void priced(PurchaseEnquiryHead dbHead, List<SaleEnquiryItem> pricedList) {
        List<EnquirySubstituteItem> updateList = this.getUpdateItemList(pricedList);
        if (CollectionUtil.isNotEmpty(updateList)) {
            this.enquirySubstituteItemService.updateBatchById(updateList);
            if (EnquiryStatusEnum.PRICED.getValue().equals(dbHead.getEnquiryStatus())) {
                this.update((Wrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().eq(SaleEnquiryHead::getRelationId, (Object)dbHead.getId())).set(SaleEnquiryHead::getEnquiryStatus, (Object)EnquiryStatusEnum.PRICED.getValue()));
            }
        }
    }

    @Override
    public void cancel(PurchaseEnquiryHead head) {
        List supplierList = this.enquirySupplierListService.selectByMainId(head.getId()).stream().filter(supplier -> "0".equals(supplier.getNeedCoordination())).collect(Collectors.toList());
        if (CollectionUtil.isNotEmpty(supplierList)) {
            this.update((Wrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().eq(SaleEnquiryHead::getRelationId, (Object)head.getId())).set(SaleEnquiryHead::getEnquiryStatus, (Object)EnquiryStatusEnum.CANCEL.getValue()));
            this.enquirySubstituteItemService.update((Wrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().eq(SaleEnquiryItem::getEnquiryNumber, (Object)head.getEnquiryNumber())).eq(SaleEnquiryItem::getToElsAccount, (Object)head.getElsAccount())).set(SaleEnquiryItem::getItemStatus, (Object)EnquiryStatusEnum.CANCEL.getValue()));
        }
    }

    @Override
    public void regret(PurchaseEnquiryHead head, List<SaleEnquiryItem> regretList) {
        List<EnquirySubstituteItem> updateList = this.getUpdateItemList(regretList);
        if (CollectionUtil.isNotEmpty(updateList)) {
            this.enquirySubstituteItemService.updateBatchById(updateList);
            List elsAccountList = updateList.stream().map(BaseEntity::getElsAccount).distinct().collect(Collectors.toList());
            this.update((Wrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().in(BaseEntity::getElsAccount, elsAccountList)).eq(SaleEnquiryHead::getRelationId, (Object)head.getId())).set(SaleEnquiryHead::getEnquiryStatus, (Object)head.getEnquiryStatus()));
        }
    }

    private List<EnquirySubstituteItem> getUpdateItemList(List<SaleEnquiryItem> itemList) {
        List<EnquirySubstituteItem> substituteItemList = new ArrayList<EnquirySubstituteItem>();
        List supplierIds = itemList.stream().map(SaleEnquiryItem::getSupplierId).collect(Collectors.toList());
        List supplierIdList = this.enquirySupplierListService.listByIds(supplierIds).stream().filter(supplier -> "0".equals(supplier.getNeedCoordination())).map(BaseEntity::getId).collect(Collectors.toList());
        if (CollectionUtil.isNotEmpty(supplierIdList)) {
            List<SaleEnquiryItem> updateItemList = itemList.stream().filter(item -> supplierIdList.contains(item.getSupplierId())).collect(Collectors.toList());
            substituteItemList = this.copyItem(updateItemList);
        }
        return substituteItemList;
    }
}

