/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.lp.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import com.els.common.aspect.annotation.SrmTransaction;
import com.els.common.constant.CommonConstant;
import com.els.common.enumerate.AuditStatusEnum;
import com.els.common.exception.ELSBootException;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.system.vo.LoginUser;
import com.els.common.util.SysUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.delivery.api.dto.PurchaseOrderDeliveryPlanDTO;
import com.els.modules.demand.entity.PurchaseRequestHead;
import com.els.modules.demand.entity.PurchaseRequestItem;
import com.els.modules.demand.service.PurchaseRequestHeadService;
import com.els.modules.demand.service.PurchaseRequestItemService;
import com.els.modules.inquiry.rpc.service.InquiryInvokeOrderRpcService;
import com.els.modules.lp.entity.PurchaseLpSolveCapacityItem;
import com.els.modules.lp.entity.PurchaseLpSolveHead;
import com.els.modules.lp.entity.PurchaseLpSolvePriceItem;
import com.els.modules.lp.entity.PurchaseLpSolveRequesItem;
import com.els.modules.lp.entity.PurchaseLpSolveResultItem;
import com.els.modules.lp.enumerate.LpManageStatusEnum;
import com.els.modules.lp.enumerate.LpSolveResultStatusEnum;
import com.els.modules.lp.mapper.PurchaseLpSolveCapacityItemMapper;
import com.els.modules.lp.mapper.PurchaseLpSolveHeadMapper;
import com.els.modules.lp.mapper.PurchaseLpSolvePriceItemMapper;
import com.els.modules.lp.mapper.PurchaseLpSolveRequesItemMapper;
import com.els.modules.lp.mapper.PurchaseLpSolveResultItemMapper;
import com.els.modules.lp.service.PurchaseLpSolveHeadService;
import com.els.modules.lp.utils.LpOptimator;
import com.els.modules.order.api.dto.PurchaseOrderGenarateConfigDTO;
import com.els.modules.order.api.dto.PurchaseOrderHeadDTO;
import com.els.modules.order.api.dto.PurchaseOrderItemDTO;
import com.els.modules.order.api.enumerate.OrderItemSendStatusEnum;
import com.els.modules.order.api.enumerate.OrderItemStatusEnum;
import com.els.modules.order.api.enumerate.OrderSourceTypeEnum;
import com.els.rpc.service.InvokeBaseRpcService;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
public class PurchaseLpSolveHeadServiceImpl
extends BaseServiceImpl<PurchaseLpSolveHeadMapper, PurchaseLpSolveHead>
implements PurchaseLpSolveHeadService {
    @Autowired
    private PurchaseLpSolveHeadMapper purchaseLpSolveHeadMapper;
    @Autowired
    private PurchaseLpSolveRequesItemMapper purchaseLpSolveRequesItemMapper;
    @Autowired
    private PurchaseLpSolvePriceItemMapper purchaseLpSolvePriceItemMapper;
    @Autowired
    private PurchaseLpSolveResultItemMapper purchaseLpSolveResultItemMapper;
    @Autowired
    private PurchaseLpSolveCapacityItemMapper purchaseLpSolveCapacityItemMapper;
    @Resource
    private InvokeBaseRpcService baseRpcService;
    @Autowired
    private PurchaseRequestItemService purchaseRequestItemService;
    @Autowired
    private PurchaseRequestHeadService purchaseRequestHeadService;
    @Resource
    private InquiryInvokeOrderRpcService inquiryInvokeOrderRpcService;

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void saveMain(PurchaseLpSolveHead purchaseLpSolveHead, List<PurchaseLpSolveRequesItem> purchaseLpSolveRequesItemList, List<PurchaseLpSolvePriceItem> purchaseLpSolvePriceItemList, List<PurchaseLpSolveResultItem> purchaseLpSolveResultItemList, List<PurchaseLpSolveCapacityItem> purchaseLpSolveCapacityItemList) {
        LoginUser loginUser = SysUtil.getLoginUser();
        purchaseLpSolveHead.setBusAccount(loginUser.getElsAccount());
        purchaseLpSolveHead.setElsAccount(loginUser.getElsAccount());
        purchaseLpSolveHead.setDocumentNumber(this.baseRpcService.getNextCode("purchaseLpManage", (Object)purchaseLpSolveHead));
        super.setHeadDefaultValue((BaseEntity)purchaseLpSolveHead);
        if ("1".equals(purchaseLpSolveHead.getAudit())) {
            purchaseLpSolveHead.setAuditStatus(AuditStatusEnum.AUDIT_NEW.getValue());
        } else {
            purchaseLpSolveHead.setAuditStatus(AuditStatusEnum.NO_AUDIT_REQUIRED.getValue());
        }
        this.purchaseLpSolveHeadMapper.insert((Object)purchaseLpSolveHead);
        this.insertData(purchaseLpSolveHead, purchaseLpSolveRequesItemList, purchaseLpSolvePriceItemList, purchaseLpSolveResultItemList, purchaseLpSolveCapacityItemList);
    }

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void updateMain(PurchaseLpSolveHead purchaseLpSolveHead, List<PurchaseLpSolveRequesItem> purchaseLpSolveRequesItemList, List<PurchaseLpSolvePriceItem> purchaseLpSolvePriceItemList, List<PurchaseLpSolveResultItem> purchaseLpSolveResultItemList, List<PurchaseLpSolveCapacityItem> purchaseLpSolveCapacityItemList) {
        this.purchaseLpSolveHeadMapper.updateById((Object)purchaseLpSolveHead);
        this.purchaseLpSolveRequesItemMapper.deleteByMainId(purchaseLpSolveHead.getId());
        this.purchaseLpSolvePriceItemMapper.deleteByMainId(purchaseLpSolveHead.getId());
        this.purchaseLpSolveResultItemMapper.deleteByMainId(purchaseLpSolveHead.getId());
        this.purchaseLpSolveCapacityItemMapper.deleteByMainId(purchaseLpSolveHead.getId());
        this.insertData(purchaseLpSolveHead, purchaseLpSolveRequesItemList, purchaseLpSolvePriceItemList, purchaseLpSolveResultItemList, purchaseLpSolveCapacityItemList);
    }

    private void insertData(PurchaseLpSolveHead purchaseLpSolveHead, List<PurchaseLpSolveRequesItem> purchaseLpSolveRequesItemList, List<PurchaseLpSolvePriceItem> purchaseLpSolvePriceItemList, List<PurchaseLpSolveResultItem> purchaseLpSolveResultItemList, List<PurchaseLpSolveCapacityItem> purchaseLpSolveCapacityItemList) {
        if (!CollectionUtils.isEmpty(purchaseLpSolveRequesItemList)) {
            for (PurchaseLpSolveRequesItem purchaseLpSolveRequesItem : purchaseLpSolveRequesItemList) {
                purchaseLpSolveRequesItem.setHeadId(purchaseLpSolveHead.getId());
                SysUtil.setSysParam((BaseEntity)purchaseLpSolveRequesItem, (BaseEntity)purchaseLpSolveHead);
                purchaseLpSolveRequesItem.setDocumentNumber(purchaseLpSolveHead.getDocumentNumber());
                if (purchaseLpSolveRequesItem.getRequestQuantity() == null) {
                    throw new ELSBootException("\u91c7\u8d2d\u9700\u6c42\u4e2d\u91c7\u8d2d\u7533\u8bf7\u53f7:" + purchaseLpSolveRequesItem.getRequestNumber() + "\u7533\u8bf7\u884c\u53f7:" + purchaseLpSolveRequesItem.getRequestItemNumber() + "\u7684\u9700\u6c42\u6570\u91cf\u4e0d\u80fd\u4e3a\u7a7a,\u8bf7\u5220\u9664\u8be5\u884c\u6570\u636e\u6216\u8005\u91cd\u65b0\u9009\u53d6!");
                }
                if (purchaseLpSolveRequesItem.getDeliveryDate().compareTo(purchaseLpSolveHead.getQuotaStartDate()) >= 0 && purchaseLpSolveRequesItem.getDeliveryDate().compareTo(purchaseLpSolveHead.getQuotaEndDate()) <= 0) continue;
                throw new ELSBootException("\u91c7\u8d2d\u9700\u6c42\u4e2d\u91c7\u8d2d\u7533\u8bf7\u53f7:" + purchaseLpSolveRequesItem.getRequestNumber() + "\u7533\u8bf7\u884c\u53f7:" + purchaseLpSolveRequesItem.getRequestItemNumber() + "\u7684\u8981\u6c42\u4ea4\u671f\u4e0d\u5728\u914d\u989d\u671f\u95f4\u5185,\u8bf7\u5220\u9664\u8be5\u884c\u6570\u636e\u6216\u8005\u91cd\u65b0\u9009\u53d6!");
            }
            if (!purchaseLpSolveRequesItemList.isEmpty()) {
                this.purchaseLpSolveRequesItemMapper.insertBatchSomeColumn(purchaseLpSolveRequesItemList);
            }
        }
        if (!CollectionUtils.isEmpty(purchaseLpSolvePriceItemList)) {
            for (PurchaseLpSolvePriceItem purchaseLpSolvePriceItem : purchaseLpSolvePriceItemList) {
                purchaseLpSolvePriceItem.setHeadId(purchaseLpSolveHead.getId());
                SysUtil.setSysParam((BaseEntity)purchaseLpSolvePriceItem, (BaseEntity)purchaseLpSolveHead);
                purchaseLpSolvePriceItem.setDocumentNumber(purchaseLpSolveHead.getDocumentNumber());
                purchaseLpSolvePriceItem.setId(null);
                if (purchaseLpSolvePriceItem.getMolecule() == null) {
                    purchaseLpSolvePriceItem.setMolecule(1);
                }
                if (purchaseLpSolvePriceItem.getDenominator() != null) continue;
                purchaseLpSolvePriceItem.setDenominator(1);
            }
            if (!purchaseLpSolvePriceItemList.isEmpty()) {
                this.purchaseLpSolvePriceItemMapper.insertBatchSomeColumn(purchaseLpSolvePriceItemList);
            }
        }
        if (!CollectionUtils.isEmpty(purchaseLpSolveResultItemList)) {
            for (PurchaseLpSolveResultItem purchaseLpSolveResultItem : purchaseLpSolveResultItemList) {
                purchaseLpSolveResultItem.setHeadId(purchaseLpSolveHead.getId());
                SysUtil.setSysParam((BaseEntity)purchaseLpSolveResultItem, (BaseEntity)purchaseLpSolveHead);
                purchaseLpSolveResultItem.setDocumentNumber(purchaseLpSolveHead.getDocumentNumber());
            }
            if (!purchaseLpSolveResultItemList.isEmpty()) {
                this.purchaseLpSolveResultItemMapper.insertBatchSomeColumn(purchaseLpSolveResultItemList);
            }
        }
        if (!CollectionUtils.isEmpty(purchaseLpSolveCapacityItemList)) {
            for (PurchaseLpSolveCapacityItem purchaseLpSolveCapacityItem : purchaseLpSolveCapacityItemList) {
                purchaseLpSolveCapacityItem.setHeadId(purchaseLpSolveHead.getId());
                SysUtil.setSysParam((BaseEntity)purchaseLpSolveCapacityItem, (BaseEntity)purchaseLpSolveHead);
                purchaseLpSolveCapacityItem.setDocumentNumber(purchaseLpSolveHead.getDocumentNumber());
            }
            if (!purchaseLpSolveCapacityItemList.isEmpty()) {
                this.purchaseLpSolveCapacityItemMapper.insertBatchSomeColumn(purchaseLpSolveCapacityItemList);
            }
        }
    }

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void delMain(String id) {
        this.purchaseLpSolveRequesItemMapper.deleteByMainId(id);
        this.purchaseLpSolvePriceItemMapper.deleteByMainId(id);
        this.purchaseLpSolveResultItemMapper.deleteByMainId(id);
        this.purchaseLpSolveCapacityItemMapper.deleteByMainId(id);
        this.purchaseLpSolveHeadMapper.deleteById((Serializable)((Object)id));
    }

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void delBatchMain(List<String> idList) {
        for (Serializable serializable : idList) {
            this.purchaseLpSolveRequesItemMapper.deleteByMainId(serializable.toString());
            this.purchaseLpSolvePriceItemMapper.deleteByMainId(serializable.toString());
            this.purchaseLpSolveResultItemMapper.deleteByMainId(serializable.toString());
            this.purchaseLpSolveCapacityItemMapper.deleteByMainId(serializable.toString());
            this.purchaseLpSolveHeadMapper.deleteById(serializable);
        }
    }

    @Override
    @SrmTransaction
    public void startRun(PurchaseLpSolveHead purchaseLpSolveHead, List<PurchaseLpSolveRequesItem> lpSolveRequesItemList, List<PurchaseLpSolvePriceItem> lpSolvePriceItemList, List<PurchaseLpSolveCapacityItem> lpSolveCapacityItemList) {
        Map<String, BigDecimal> requestQuantityByMaterialMap = this.readyMaterialQuantityData(lpSolveRequesItemList);
        Map<String, Map<String, PurchaseLpSolvePriceItem>> priceByMaterialNumberMap = this.readySupplierPriceData(lpSolvePriceItemList);
        Map<String, BigDecimal> supplierCapacityMap = this.readySupplierCapacityData(lpSolveCapacityItemList);
        List<String> toElsAccountList = lpSolvePriceItemList.stream().map(PurchaseLpSolvePriceItem::getToElsAccount).distinct().sorted().collect(Collectors.toList());
        List<String> materialNumberList = lpSolveRequesItemList.stream().map(PurchaseLpSolveRequesItem::getMaterialNumber).distinct().collect(Collectors.toList());
        int[][] stEqMatrix = new int[materialNumberList.size()][];
        int[] stEqRest = new int[materialNumberList.size()];
        int[][] stLeMatrix = new int[toElsAccountList.size()][];
        int[] stLeRest = new int[toElsAccountList.size()];
        int[] goal = new int[toElsAccountList.size() * materialNumberList.size()];
        this.buildLpSolveConstrain(requestQuantityByMaterialMap, supplierCapacityMap, toElsAccountList, materialNumberList, stEqMatrix, stEqRest, stLeMatrix, stLeRest);
        this.buildLpSolveGoal(priceByMaterialNumberMap, toElsAccountList, materialNumberList, goal);
        purchaseLpSolveHead.setDocumentStatus(LpManageStatusEnum.RUNNING.getValue());
        this.startRunLpSolve(purchaseLpSolveHead, requestQuantityByMaterialMap, priceByMaterialNumberMap, toElsAccountList, materialNumberList, stEqMatrix, stEqRest, stLeMatrix, stLeRest, goal);
    }

    @Override
    public String lpSolveManageToCreateOrder(PurchaseLpSolveHead purchaseLpSolveHead, List<PurchaseLpSolveRequesItem> lpSolveRequesItemList, List<PurchaseLpSolvePriceItem> lpSolvePriceItemList, List<PurchaseLpSolveResultItem> lpSolveResultItemList) {
        LoginUser loginUser = SysUtil.getLoginUser();
        HashMap<String, Object> lpSolveResultItemMap = new HashMap<String, Object>();
        List requestItemIds = lpSolveRequesItemList.stream().map(PurchaseLpSolveRequesItem::getRequestItemId).distinct().collect(Collectors.toList());
        List requestItemList = this.purchaseRequestItemService.listByIds(requestItemIds);
        List requestHeadIds = requestItemList.stream().map(PurchaseRequestItem::getHeadId).distinct().collect(Collectors.toList());
        List requestHeadList = this.purchaseRequestHeadService.listByIds(requestHeadIds);
        Map<String, PurchaseOrderGenarateConfigDTO> stringPurchaseOrderGenarateConfigDTOMap = this.queryOrderGenrateConfigByMap(requestHeadList, requestItemList);
        Map requestItemByIdMap = requestItemList.stream().collect(Collectors.toMap(BaseEntity::getId, Function.identity()));
        Map requestHeadByIdMap = requestHeadList.stream().collect(Collectors.toMap(BaseEntity::getId, Function.identity()));
        Map lpSolveRequesItemMap = lpSolveRequesItemList.stream().collect(Collectors.toMap(PurchaseLpSolveRequesItem::getMaterialNumber, Function.identity()));
        for (PurchaseLpSolveResultItem lpSolveResultItem : lpSolveResultItemList) {
            Object lpSolveResultItemListTemp;
            if (lpSolveResultItemMap.containsKey(lpSolveResultItem.getToElsAccount())) {
                lpSolveResultItemListTemp = new ArrayList();
                lpSolveResultItemListTemp.add(lpSolveResultItem);
                lpSolveResultItemMap.put(lpSolveResultItem.getToElsAccount(), lpSolveResultItemListTemp);
                continue;
            }
            lpSolveResultItemListTemp = (List)lpSolveResultItemMap.get(lpSolveResultItem.getToElsAccount());
            lpSolveResultItemListTemp.add(lpSolveResultItem);
            lpSolveResultItemMap.put(lpSolveResultItem.getToElsAccount(), lpSolveResultItemListTemp);
        }
        ArrayList<PurchaseOrderHeadDTO> purchaseOrderHeadDTOList = new ArrayList<PurchaseOrderHeadDTO>();
        Set keys = lpSolveResultItemMap.keySet();
        for (String key : keys) {
            List lpSolveResultItemByToElsAccountList = (List)lpSolveResultItemMap.get(key);
            PurchaseOrderHeadDTO purchaseOrderHead = new PurchaseOrderHeadDTO();
            ArrayList<PurchaseOrderItemDTO> purchaseOrderItemList = new ArrayList<PurchaseOrderItemDTO>();
            ArrayList<PurchaseOrderDeliveryPlanDTO> purchaseOrderDeliveryPlanList = new ArrayList<PurchaseOrderDeliveryPlanDTO>();
            int i = 1;
            for (PurchaseLpSolveResultItem purchaseLpSolveResultItem : lpSolveResultItemByToElsAccountList) {
                PurchaseOrderItemDTO purchaseOrderItem = new PurchaseOrderItemDTO();
                purchaseOrderItem.setItemNumber("" + i++);
                purchaseOrderItem.setMaterialNumber(purchaseLpSolveResultItem.getMaterialNumber());
                purchaseOrderItem.setMaterialDesc(purchaseLpSolveResultItem.getMaterialDesc());
                purchaseOrderItem.setMaterialGroup(purchaseLpSolveResultItem.getMaterialGroup());
                purchaseOrderItem.setCateCode(purchaseLpSolveResultItem.getCateCode());
                purchaseOrderItem.setCateName(purchaseLpSolveResultItem.getCateName());
                purchaseOrderItem.setQuantity(purchaseLpSolveResultItem.getResultQuantity());
                purchaseOrderItem.setCurrency(purchaseLpSolveResultItem.getCurrencyCode());
                purchaseOrderItem.setReceiveQuantity(BigDecimal.ZERO);
                purchaseOrderItem.setOnWayQuantity(BigDecimal.ZERO);
                purchaseOrderItem.setDeliveryQuantity(BigDecimal.ZERO);
                purchaseOrderItem.setClose(Integer.valueOf(Integer.parseInt("0")));
                purchaseOrderItem.setFreeze(Integer.valueOf(Integer.parseInt("0")));
                purchaseOrderItem.setItemStatus(OrderItemStatusEnum.UN_CONFIRM.getValue());
                purchaseOrderItem.setSendStatus(OrderItemSendStatusEnum.NO_PUBLISH.getValue());
                purchaseOrderItem.setJit("1");
                purchaseOrderItem.setDeleteOrder(Integer.valueOf(Integer.parseInt("0")));
                purchaseOrderItem.setReturned(Integer.valueOf(Integer.parseInt("0")));
                purchaseOrderItem.setEstimate(Integer.valueOf(Integer.parseInt("0")));
                purchaseOrderItem.setSourceType(OrderSourceTypeEnum.NO_PRICE_PURCHASE_REQUEST.getValue());
                purchaseOrderItem.setSourceNumber(purchaseLpSolveResultItem.getDocumentNumber());
                purchaseOrderItem.setSourceId(purchaseLpSolveResultItem.getId());
                purchaseOrderItemList.add(purchaseOrderItem);
            }
            if (CollectionUtil.isNotEmpty(purchaseOrderItemList)) {
                int deliveryItemCount = 1;
                for (PurchaseOrderItemDTO orderItem : purchaseOrderItemList) {
                    PurchaseOrderDeliveryPlanDTO orderDeliveryPlan = new PurchaseOrderDeliveryPlanDTO();
                    orderDeliveryPlan.setItemNumber(deliveryItemCount + "");
                    orderDeliveryPlan.setOrderItemNumber(orderItem.getItemNumber());
                    orderDeliveryPlan.setQuantity(orderItem.getQuantity());
                    orderDeliveryPlan.setPlanDeliveryQuantity(orderItem.getQuantity());
                    orderDeliveryPlan.setPlanDeliveryDate(orderItem.getRequireDate());
                    orderDeliveryPlan.setRequireDate(orderItem.getRequireDate());
                    ++deliveryItemCount;
                    purchaseOrderDeliveryPlanList.add(orderDeliveryPlan);
                }
            }
            purchaseOrderHead.setPurchaseGroup(purchaseLpSolveHead.getPurchaseGroup());
            purchaseOrderHead.setPurchaseOrg(purchaseLpSolveHead.getPurchaseOrg());
            purchaseOrderHead.setCompany(purchaseLpSolveHead.getCompany());
            purchaseOrderHead.setCurrency(((PurchaseLpSolveResultItem)((Object)lpSolveResultItemByToElsAccountList.get(0))).getCurrencyCode());
            purchaseOrderHead.setSourceType(OrderSourceTypeEnum.NO_PRICE_PURCHASE_REQUEST.getValue());
            purchaseOrderHead.setBusAccount(TenantContext.getTenant());
            purchaseOrderHead.setPurchasePrincipal(loginUser.getSubAccount() + "_" + loginUser.getRealname());
            purchaseOrderHead.setPurchaseOrderItemList(purchaseOrderItemList);
            purchaseOrderHead.setPurchaseOrderDeliveryPlanList(purchaseOrderDeliveryPlanList);
            purchaseOrderHeadDTOList.add(purchaseOrderHead);
        }
        String result = this.inquiryInvokeOrderRpcService.requestToCreateOrder(purchaseOrderHeadDTOList);
        return result;
    }

    public void startRunLpSolve(PurchaseLpSolveHead purchaseLpSolveHead, Map<String, BigDecimal> requestQuantityByMaterialMap, Map<String, Map<String, PurchaseLpSolvePriceItem>> priceByMaterialNumberMap, List<String> toElsAccountList, List<String> materialNumberList, int[][] stEqMatrix, int[] stEqRest, int[][] stLeMatrix, int[] stLeRest, int[] goal) {
        try {
            LpOptimator.optimate(goal, stLeMatrix, null, stEqMatrix, stLeRest, null, stEqRest, new int[0]);
            String objective = LpOptimator.getObjective();
            System.out.println(objective);
            double[] variables = LpOptimator.getVariables();
            for (int i = 0; i < variables.length; ++i) {
                System.out.print(variables[i] + " ");
                if ((i + 1) % 10 != 0) continue;
                System.out.println("");
            }
            ArrayList<PurchaseLpSolveResultItem> resultItemList = new ArrayList<PurchaseLpSolveResultItem>();
            int rowNumber = 1;
            for (int i = 0; i < variables.length; ++i) {
                PurchaseLpSolvePriceItem purchaseLpSolvePriceItem;
                int columnNumber = (i + 1) % toElsAccountList.size();
                Double assignValue = variables[i];
                if (assignValue != null && assignValue > 0.0 && (purchaseLpSolvePriceItem = priceByMaterialNumberMap.get(materialNumberList.get(rowNumber - 1)).get(toElsAccountList.get(columnNumber - 1))) != null) {
                    PurchaseLpSolveResultItem purchaseLpSolveResultItem = new PurchaseLpSolveResultItem();
                    purchaseLpSolveResultItem.setHeadId(purchaseLpSolveHead.getId());
                    purchaseLpSolveResultItem.setDocumentNumber(purchaseLpSolveHead.getDocumentNumber());
                    purchaseLpSolveResultItem.setItemStatus(LpSolveResultStatusEnum.UN_ORDER.getValue());
                    purchaseLpSolveResultItem.setMaterialNumber(purchaseLpSolvePriceItem.getMaterialNumber());
                    purchaseLpSolveResultItem.setMaterialName(purchaseLpSolvePriceItem.getMaterialName());
                    purchaseLpSolveResultItem.setMaterialDesc(purchaseLpSolvePriceItem.getMaterialDesc());
                    purchaseLpSolveResultItem.setMaterialGroup(purchaseLpSolvePriceItem.getMaterialGroup());
                    purchaseLpSolveResultItem.setCateCode(purchaseLpSolvePriceItem.getCateCode());
                    purchaseLpSolveResultItem.setCateName(purchaseLpSolvePriceItem.getCateName());
                    purchaseLpSolveResultItem.setToElsAccount(purchaseLpSolvePriceItem.getToElsAccount());
                    purchaseLpSolveResultItem.setSupplierCode(purchaseLpSolvePriceItem.getSupplierCode());
                    purchaseLpSolveResultItem.setSupplierName(purchaseLpSolvePriceItem.getSupplierName());
                    purchaseLpSolveResultItem.setCurrencyCode(purchaseLpSolvePriceItem.getCurrencyCode());
                    purchaseLpSolveResultItem.setTaxCode(purchaseLpSolvePriceItem.getTaxCode());
                    purchaseLpSolveResultItem.setTaxRate(purchaseLpSolvePriceItem.getTaxRate());
                    purchaseLpSolveResultItem.setPrice(purchaseLpSolvePriceItem.getPrice());
                    purchaseLpSolveResultItem.setNetPrice(purchaseLpSolvePriceItem.getNetPrice());
                    purchaseLpSolveResultItem.setMolecule(purchaseLpSolvePriceItem.getMolecule());
                    purchaseLpSolveResultItem.setDenominator(purchaseLpSolvePriceItem.getDenominator());
                    BigDecimal molecule = new BigDecimal(purchaseLpSolveResultItem.getMolecule() + "");
                    BigDecimal denominator = new BigDecimal(purchaseLpSolveResultItem.getDenominator() + "");
                    BigDecimal resultPrice = purchaseLpSolvePriceItem.getPrice().multiply(molecule.divide(denominator, 2, 4));
                    purchaseLpSolveResultItem.setResultPrice(resultPrice);
                    purchaseLpSolveResultItem.setResultQuantity(new BigDecimal(assignValue));
                    purchaseLpSolveResultItem.setResultAmount(purchaseLpSolveResultItem.getResultPrice().multiply(purchaseLpSolveResultItem.getResultQuantity()));
                    BigDecimal requestQuantity = requestQuantityByMaterialMap.get(materialNumberList.get(rowNumber - 1));
                    if (requestQuantity != null) {
                        purchaseLpSolveResultItem.setResultQuantityPercent(purchaseLpSolveResultItem.getResultQuantity().divide(requestQuantity, 2, RoundingMode.HALF_UP));
                    }
                    purchaseLpSolveResultItem.setResultPersonQuantity(purchaseLpSolveResultItem.getResultQuantity());
                    purchaseLpSolveResultItem.setResultPersonAmount(purchaseLpSolveResultItem.getResultAmount());
                    purchaseLpSolveResultItem.setResultPersonQuantityPercent(purchaseLpSolveResultItem.getResultQuantityPercent());
                    purchaseLpSolveResultItem.setDeleted(CommonConstant.DEL_FLAG_0);
                    purchaseLpSolveResultItem.setCreateBy(purchaseLpSolveHead.getCreateBy());
                    purchaseLpSolveResultItem.setCreateTime(purchaseLpSolveHead.getCreateTime());
                    purchaseLpSolveResultItem.setUpdateTime(purchaseLpSolveHead.getUpdateTime());
                    purchaseLpSolveResultItem.setUpdateBy(purchaseLpSolveHead.getUpdateBy());
                    resultItemList.add(purchaseLpSolveResultItem);
                }
                if (columnNumber != toElsAccountList.size() - 1) continue;
                ++rowNumber;
            }
            if (CollectionUtil.isNotEmpty(resultItemList)) {
                this.purchaseLpSolveResultItemMapper.insertBatchSomeColumn(resultItemList);
            }
            PurchaseLpSolveHead purchaseLpSolveHeadParam = new PurchaseLpSolveHead();
            purchaseLpSolveHeadParam.setId(purchaseLpSolveHead.getId());
            purchaseLpSolveHeadParam.setDocumentStatus(LpManageStatusEnum.RUNNING_FINISH.getValue());
            purchaseLpSolveHeadParam.setLpResult(objective);
            purchaseLpSolveHeadParam.setLpPeopleResult(objective);
            purchaseLpSolveHeadParam.setRealRunTime(LpOptimator.getTimeout() + "");
            purchaseLpSolveHeadParam.setRealRepeatTime(LpOptimator.getScaling() + "");
            purchaseLpSolveHeadParam.setDifValue("0");
            this.purchaseLpSolveHeadMapper.updateById((Object)purchaseLpSolveHeadParam);
        }
        catch (Exception e) {
            throw new ELSBootException((Throwable)e);
        }
    }

    private void buildLpSolveGoal(Map<String, Map<String, PurchaseLpSolvePriceItem>> priceByMaterialNumberMap, List<String> toElsAccountList, List<String> materialNumberList, int[] goal) {
        int count = 0;
        for (int i = 0; i < materialNumberList.size(); ++i) {
            for (int j = 0; j < toElsAccountList.size(); ++j) {
                BigDecimal price;
                PurchaseLpSolvePriceItem purchaseLpSolvePriceItem = priceByMaterialNumberMap.get(materialNumberList.get(i)).get(toElsAccountList.get(j));
                goal[count] = purchaseLpSolvePriceItem != null ? ((price = purchaseLpSolvePriceItem.getPrice()) != null ? price.intValue() : 9999999) : 9999999;
                ++count;
            }
        }
    }

    private void buildLpSolveConstrain(Map<String, BigDecimal> requestQuantityByMaterialMap, Map<String, BigDecimal> supplierCapacityMap, List<String> toElsAccountList, List<String> materialNumberList, int[][] stEqMatrix, int[] stEqRest, int[][] stLeMatrix, int[] stLeRest) {
        int j;
        int i;
        int m;
        int k;
        for (k = 0; k < materialNumberList.size(); ++k) {
            m = 0;
            for (i = 0; i < materialNumberList.size(); ++i) {
                for (j = 0; j < toElsAccountList.size(); ++j) {
                    if (materialNumberList.get(k).equals(materialNumberList.get(i))) {
                        if (stEqMatrix[k] == null) {
                            stEqMatrix[k] = new int[toElsAccountList.size() * materialNumberList.size()];
                        }
                        stEqMatrix[k][m] = 1;
                    } else {
                        if (stEqMatrix[k] == null) {
                            stEqMatrix[k] = new int[toElsAccountList.size() * materialNumberList.size()];
                        }
                        stEqMatrix[k][m] = 0;
                    }
                    ++m;
                }
            }
            stEqRest[k] = requestQuantityByMaterialMap.get(materialNumberList.get(k)).intValue();
        }
        for (k = 0; k < toElsAccountList.size(); ++k) {
            m = 0;
            for (i = 0; i < materialNumberList.size(); ++i) {
                for (j = 0; j < toElsAccountList.size(); ++j) {
                    if (toElsAccountList.get(k).equals(toElsAccountList.get(j))) {
                        if (stLeMatrix[k] == null) {
                            stLeMatrix[k] = new int[toElsAccountList.size() * materialNumberList.size()];
                        }
                        stLeMatrix[k][m] = 1;
                    } else {
                        if (stLeMatrix[k] == null) {
                            stLeMatrix[k] = new int[toElsAccountList.size() * materialNumberList.size()];
                        }
                        stLeMatrix[k][m] = 0;
                    }
                    ++m;
                }
            }
            stLeRest[k] = supplierCapacityMap.get(toElsAccountList.get(k)).intValue();
        }
    }

    private Map<String, BigDecimal> readySupplierCapacityData(List<PurchaseLpSolveCapacityItem> lpSolveCapacityItemList) {
        HashMap<String, BigDecimal> supplierCapacityMap = new HashMap<String, BigDecimal>();
        for (PurchaseLpSolveCapacityItem purchaseLpSolveCapacityItem : lpSolveCapacityItemList) {
            supplierCapacityMap.put(purchaseLpSolveCapacityItem.getToElsAccount(), purchaseLpSolveCapacityItem.getCapacity());
        }
        return supplierCapacityMap;
    }

    private Map<String, Map<String, PurchaseLpSolvePriceItem>> readySupplierPriceData(List<PurchaseLpSolvePriceItem> lpSolvePriceItemList) {
        HashMap<String, Map<String, PurchaseLpSolvePriceItem>> priceByMaterialNumberMap = new HashMap<String, Map<String, PurchaseLpSolvePriceItem>>();
        for (PurchaseLpSolvePriceItem purchaseLpSolvePriceItem : lpSolvePriceItemList) {
            if (priceByMaterialNumberMap.containsKey(purchaseLpSolvePriceItem.getMaterialNumber())) {
                Map priceByToElsAccountMap = (Map)priceByMaterialNumberMap.get(purchaseLpSolvePriceItem.getMaterialNumber());
                if (priceByToElsAccountMap.containsKey(purchaseLpSolvePriceItem.getToElsAccount())) {
                    if (((PurchaseLpSolvePriceItem)((Object)priceByToElsAccountMap.get(purchaseLpSolvePriceItem.getToElsAccount()))).getPrice().compareTo(purchaseLpSolvePriceItem.getPrice()) <= 0) continue;
                    priceByToElsAccountMap.put(purchaseLpSolvePriceItem.getToElsAccount(), purchaseLpSolvePriceItem);
                    continue;
                }
                priceByToElsAccountMap.put(purchaseLpSolvePriceItem.getToElsAccount(), purchaseLpSolvePriceItem);
                continue;
            }
            HashMap<String, PurchaseLpSolvePriceItem> lpSolvePriceItemMap = new HashMap<String, PurchaseLpSolvePriceItem>();
            lpSolvePriceItemMap.put(purchaseLpSolvePriceItem.getToElsAccount(), purchaseLpSolvePriceItem);
            priceByMaterialNumberMap.put(purchaseLpSolvePriceItem.getMaterialNumber(), lpSolvePriceItemMap);
        }
        return priceByMaterialNumberMap;
    }

    private Map<String, BigDecimal> readyMaterialQuantityData(List<PurchaseLpSolveRequesItem> lpSolveRequesItemList) {
        HashMap<String, BigDecimal> requestQuantityByMaterialMap = new HashMap<String, BigDecimal>();
        for (PurchaseLpSolveRequesItem purchaseLpSolveRequesItem : lpSolveRequesItemList) {
            if (requestQuantityByMaterialMap.containsKey(purchaseLpSolveRequesItem.getMaterialNumber())) {
                requestQuantityByMaterialMap.put(purchaseLpSolveRequesItem.getMaterialNumber(), ((BigDecimal)requestQuantityByMaterialMap.get(purchaseLpSolveRequesItem.getMaterialNumber())).add(purchaseLpSolveRequesItem.getRequestQuantity()));
                continue;
            }
            requestQuantityByMaterialMap.put(purchaseLpSolveRequesItem.getMaterialNumber(), purchaseLpSolveRequesItem.getRequestQuantity() == null ? BigDecimal.ZERO : purchaseLpSolveRequesItem.getRequestQuantity());
        }
        return requestQuantityByMaterialMap;
    }

    private Map<String, PurchaseOrderGenarateConfigDTO> queryOrderGenrateConfigByMap(List<PurchaseRequestHead> purchaseRequestHeadList, List<PurchaseRequestItem> purchaseRequestItemList) {
        HashMap<String, PurchaseOrderGenarateConfigDTO> resultMap = new HashMap<String, PurchaseOrderGenarateConfigDTO>();
        ArrayList<String> keys = new ArrayList<String>();
        if (CollectionUtil.isNotEmpty(purchaseRequestItemList)) {
            Map requestHeadMap = purchaseRequestHeadList.stream().collect(Collectors.toMap(PurchaseRequestHead::getRequestNumber, Function.identity()));
            for (PurchaseRequestItem requestItem : purchaseRequestItemList) {
                PurchaseRequestHead requestHead = (PurchaseRequestHead)((Object)requestHeadMap.get(requestItem.getRequestNumber()));
                if (keys.contains(requestItem.getMaterialGroup() + "_" + requestHead.getRequestType() + "_" + requestItem.getRequestType())) continue;
                keys.add(requestItem.getMaterialGroup() + "_" + requestHead.getRequestType() + "_" + requestItem.getPurchaseType());
            }
            List<PurchaseOrderGenarateConfigDTO> orderGenarateConfigDTOList = this.inquiryInvokeOrderRpcService.queryOrderGenrateConfig(keys);
            if (CollectionUtil.isNotEmpty(orderGenarateConfigDTOList)) {
                for (PurchaseOrderGenarateConfigDTO purchaseOrderGenarateConfigDTO : orderGenarateConfigDTOList) {
                    if (resultMap.containsKey(purchaseOrderGenarateConfigDTO.getConfigTypeValue() + "_" + purchaseOrderGenarateConfigDTO.getPurchaseRequestType() + "_" + purchaseOrderGenarateConfigDTO.getItemPurchaseType())) continue;
                    resultMap.put(purchaseOrderGenarateConfigDTO.getConfigTypeValue() + "_" + purchaseOrderGenarateConfigDTO.getPurchaseRequestType() + "_" + purchaseOrderGenarateConfigDTO.getItemPurchaseType(), purchaseOrderGenarateConfigDTO);
                }
            }
        }
        return resultMap;
    }
}

