/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.ebidding.service.impl;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.els.modules.demand.service.PurchaseRequestItemService;
import com.els.modules.ebidding.entity.PurchaseEbiddingItem;
import com.els.modules.ebidding.mapper.PurchaseEbiddingItemMapper;
import com.els.modules.ebidding.service.PurchaseEbiddingItemService;
import com.els.modules.inquiry.enumerate.SourceTypeEnum;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PurchaseEbiddingItemServiceImpl
extends ServiceImpl<PurchaseEbiddingItemMapper, PurchaseEbiddingItem>
implements PurchaseEbiddingItemService {
    @Autowired
    private PurchaseRequestItemService purchaseRequestItemService;

    @Override
    public List<PurchaseEbiddingItem> selectByMainId(String mainId) {
        return ((PurchaseEbiddingItemMapper)this.baseMapper).selectByMainId(mainId);
    }

    @Override
    public void deleteByMainId(String mainId) {
        ((PurchaseEbiddingItemMapper)this.baseMapper).deleteByMainId(mainId);
    }

    @Override
    public void updateBidResultBatch(List<PurchaseEbiddingItem> purchaseItemList) {
        ((PurchaseEbiddingItemMapper)this.baseMapper).updateBidResultBatch(purchaseItemList);
    }

    @Override
    public PurchaseEbiddingItem selectOneByMainIdAndItemNumber(String headId, String itemNumber) {
        return ((PurchaseEbiddingItemMapper)this.baseMapper).selectOneByMainIdAndItemNumber(headId, itemNumber);
    }

    @Override
    public void replenishMaterialNumber(PurchaseEbiddingItem webItem) {
        List<PurchaseEbiddingItem> itemList = this.selectByMainId(webItem.getHeadId()).stream().filter(item -> item.getItemNumber().equals(webItem.getItemNumber())).collect(Collectors.toList());
        itemList.forEach(item -> {
            item.setMaterialNumber(webItem.getMaterialNumber());
            item.setMaterialDesc(webItem.getMaterialDesc());
            item.setMaterialGroup(webItem.getMaterialGroup());
            item.setMaterialSpec(webItem.getMaterialSpec());
            item.setMaterialGroupName(webItem.getMaterialGroupName());
        });
        this.updateBatchById(itemList);
        PurchaseEbiddingItem item2 = (PurchaseEbiddingItem)((Object)itemList.get(0));
        if (SourceTypeEnum.REQUEST.getValue().equals(item2.getSourceType()) && StringUtils.isNotBlank((CharSequence)item2.getSourceItemId())) {
            this.purchaseRequestItemService.replenishMaterial(item2.getSourceItemId(), item2.getMaterialNumber(), item2.getMaterialDesc(), item2.getMaterialGroup(), item2.getMaterialSpec());
        }
    }
}

