/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.enquiry.adapter;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.els.aspect.DictAspect;
import com.els.common.api.vo.Result;
import com.els.common.enumerate.AuditStatusEnum;
import com.els.common.system.vo.MsgParamsVO;
import com.els.common.util.MqUtil;
import com.els.common.util.SpringContextUtils;
import com.els.common.util.SysUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.account.api.dto.ElsSubAccountDTO;
import com.els.modules.demand.enumerate.PurchaseRequestStatusItemEnum;
import com.els.modules.enquiry.entity.PurchaseEnquiryHead;
import com.els.modules.enquiry.entity.PurchaseEnquiryItem;
import com.els.modules.enquiry.enumerate.EnquiryStatusEnum;
import com.els.modules.enquiry.service.PurchaseEnquiryHeadService;
import com.els.modules.enquiry.service.PurchaseEnquiryItemService;
import com.els.modules.enquiry.vo.PurchaseEnquiryHeadVO;
import com.els.modules.inquiry.enumerate.PriceCreateWayEnum;
import com.els.modules.uflo.dto.AuditInputParamDTO;
import com.els.modules.uflo.dto.AuditOutputParamDTO;
import com.els.modules.uflo.enums.WorkFlowType;
import com.els.modules.uflo.rpc.service.AuditOptCallBackService;
import com.els.rpc.service.InvokeAccountRpcService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ResultEnquiryAdapter
implements AuditOptCallBackService {
    @Autowired
    private PurchaseEnquiryHeadService purchaseEnquiryHeadService;
    @Autowired
    private PurchaseEnquiryItemService purchaseEnquiryItemService;
    @Resource
    private InvokeAccountRpcService invokeAccountRpcService;

    public void startCallBack(AuditInputParamDTO inputParamVO, AuditOutputParamDTO outputParamVO) {
        this.updateAuditStatus(inputParamVO, outputParamVO);
        String operataion = "resultSubmitAudit";
        if (WorkFlowType.BPMN.getValue().equals(outputParamVO.getBpmnType())) {
            operataion = outputParamVO.getBpmnType() + "_" + "resultSubmitAudit";
        }
        this.sendMsg(inputParamVO, outputParamVO, operataion);
    }

    public void completeCallBack(AuditInputParamDTO inputParamVO, AuditOutputParamDTO outputParamVO) {
        this.updateAuditStatus(inputParamVO, outputParamVO);
        if (AuditStatusEnum.AUDIT_FINISH.getValue().equals(outputParamVO.getAuditStatus())) {
            this.sendMsg(inputParamVO, outputParamVO, "auditPass");
        } else {
            String operataion = "submitAudit";
            if (WorkFlowType.BPMN.getValue().equals(outputParamVO.getBpmnType())) {
                operataion = outputParamVO.getBpmnType() + "_" + "submitAudit";
            }
            this.sendMsg(inputParamVO, outputParamVO, operataion);
        }
    }

    public void rejectCallBack(AuditInputParamDTO inputParamVO, AuditOutputParamDTO outputParamVO) {
        this.updateAuditStatus(inputParamVO, outputParamVO);
        this.sendMsg(inputParamVO, outputParamVO, "auditReject");
    }

    public void cancelCallBack(AuditInputParamDTO inputParamVO, AuditOutputParamDTO outputParamVO) {
        this.updateAuditStatus(inputParamVO, outputParamVO);
    }

    private void updateAuditStatus(AuditInputParamDTO inputParamVO, AuditOutputParamDTO outputParamVO) {
        String businessId = inputParamVO.getBusinessId();
        String headId = businessId.split("_")[0];
        List<String> itemNumbers = Arrays.asList(businessId.split("_")[1].split(","));
        String flowId = outputParamVO.getProcessRootId();
        String auditStatus = outputParamVO.getAuditStatus();
        String bpmnType = outputParamVO.getBpmnType();
        this.purchaseEnquiryItemService.update((Wrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().eq(PurchaseEnquiryItem::getHeadId, (Object)headId)).in(PurchaseEnquiryItem::getItemNumber, itemNumbers)).set(PurchaseEnquiryItem::getAuditStatus, (Object)auditStatus)).set(PurchaseEnquiryItem::getWorkFlowType, (Object)bpmnType)).set(PurchaseEnquiryItem::getFlowId, (Object)flowId));
        if (AuditStatusEnum.AUDIT_FINISH.getValue().equals(outputParamVO.getAuditStatus())) {
            PurchaseEnquiryHead dbHead;
            List<PurchaseEnquiryItem> itemList = this.purchaseEnquiryItemService.selectByMainId(headId);
            List finishList = itemList.stream().filter(item -> AuditStatusEnum.AUDIT_FINISH.getValue().equals(item.getAuditStatus())).collect(Collectors.toList());
            if (itemList.size() == finishList.size()) {
                PurchaseEnquiryHead head = new PurchaseEnquiryHead();
                head.setId(headId);
                head.setResultAuditStatus(auditStatus);
                head.setWorkFlowType(outputParamVO.getBpmnType());
                this.purchaseEnquiryHeadService.updateById((Object)head);
            }
            if ("1".equals((dbHead = (PurchaseEnquiryHead)((Object)this.purchaseEnquiryHeadService.getById((Serializable)((Object)headId)))).getResultAudit())) {
                List<PurchaseEnquiryItem> pricedList = itemList.stream().filter(item -> EnquiryStatusEnum.ACCEPT.getValue().equals(item.getItemStatus()) || EnquiryStatusEnum.REJECT.getValue().equals(item.getItemStatus())).filter(item -> itemNumbers.contains(item.getItemNumber())).collect(Collectors.toList());
                this.purchaseEnquiryHeadService.priced(dbHead, pricedList);
                this.purchaseEnquiryHeadService.goBackDemand(pricedList, PurchaseRequestStatusItemEnum.INQUIRY_COMPLETED.getValue());
                if (PriceCreateWayEnum.AUTO.getValue().equals(dbHead.getPriceCreateWay())) {
                    List<PurchaseEnquiryItem> acceptList = itemList.stream().filter(item -> EnquiryStatusEnum.ACCEPT.getValue().equals(item.getItemStatus())).filter(item -> itemNumbers.contains(item.getItemNumber())).collect(Collectors.toList());
                    this.purchaseEnquiryHeadService.generatePriceRecord(dbHead, acceptList);
                }
            }
        }
    }

    private void sendMsg(AuditInputParamDTO inputParamVO, AuditOutputParamDTO outputParamVO, String optType) {
        String elsAccount = TenantContext.getTenant();
        if (AuditStatusEnum.AUDIT_FINISH.getValue().equals(outputParamVO.getAuditStatus()) || AuditStatusEnum.AUDIT_REJECT.getValue().equals(outputParamVO.getAuditStatus())) {
            MsgParamsVO msgParamsVO = this.parameterAssemble(inputParamVO, outputParamVO, outputParamVO.getSubmitUser());
            MqUtil.sendBusMsg((String)elsAccount, (String)"enquiry", (String)optType, (MsgParamsVO)msgParamsVO);
        } else {
            for (String account : outputParamVO.getNextAuditUserList()) {
                MsgParamsVO msgParamsVO = this.parameterAssemble(inputParamVO, outputParamVO, account);
                MqUtil.sendBusMsg((String)elsAccount, (String)"enquiry", (String)optType, (MsgParamsVO)msgParamsVO);
            }
        }
    }

    private MsgParamsVO parameterAssemble(AuditInputParamDTO inputParamVO, AuditOutputParamDTO outputParamVO, String account) {
        MsgParamsVO msgParamsVO = new MsgParamsVO();
        ArrayList<ElsSubAccountDTO> accountList = new ArrayList<ElsSubAccountDTO>();
        HashMap<String, ArrayList<ElsSubAccountDTO>> receiverMap = new HashMap<String, ArrayList<ElsSubAccountDTO>>();
        ElsSubAccountDTO subAccount = this.invokeAccountRpcService.getAccount(TenantContext.getTenant(), account.split("_")[1]);
        accountList.add(subAccount);
        receiverMap.put(TenantContext.getTenant(), accountList);
        msgParamsVO.setReceiverMap(receiverMap);
        String flowId = outputParamVO.getProcessRootId();
        String headId = inputParamVO.getBusinessId().split("_")[0];
        String businessType = inputParamVO.getBusinessType();
        String outAuditPassUrl = SysUtil.getOutAuditPassUrl((ElsSubAccountDTO)subAccount, (String)flowId, (String)businessType, (String)headId);
        String outAuditRejectUrl = SysUtil.getOutAuditRejectUrl((ElsSubAccountDTO)subAccount, (String)flowId, (String)businessType, (String)headId);
        PurchaseEnquiryHead head = (PurchaseEnquiryHead)((Object)this.purchaseEnquiryHeadService.getById((Serializable)((Object)headId)));
        PurchaseEnquiryHeadVO headVO = new PurchaseEnquiryHeadVO();
        BeanUtils.copyProperties((Object)((Object)head), (Object)((Object)headVO));
        List<String> itemNumbers = Arrays.asList(inputParamVO.getBusinessId().split("_")[1].split(","));
        List<PurchaseEnquiryItem> itemList = this.purchaseEnquiryItemService.selectByMainId(headId).stream().filter(item -> itemNumbers.contains(item.getItemNumber())).collect(Collectors.toList());
        headVO.setPurchaseEnquiryItemList(itemList);
        Result result = Result.ok((Object)((Object)headVO));
        ((DictAspect)SpringContextUtils.getBean(DictAspect.class)).parseDictText((Object)result);
        JSONObject jsonObject = (JSONObject)result.getResult();
        Map paramMap = (Map)JSON.parse((String)jsonObject.toString());
        paramMap.put("userName", subAccount.getRealname());
        paramMap.put("outAuditPassUrl", outAuditPassUrl);
        paramMap.put("outAuditRejectUrl", outAuditRejectUrl);
        msgParamsVO.setParams((Object)paramMap);
        HashMap<String, JSONObject> receiveParamMap = new HashMap<String, JSONObject>();
        JSONObject paramObj = new JSONObject();
        paramObj.put("businessId", (Object)inputParamVO.getBusinessId());
        paramObj.put("businessType", (Object)inputParamVO.getBusinessType());
        if (account.split("_").length > 2) {
            paramObj.put("taskId", (Object)account.split("_")[2]);
        }
        receiveParamMap.put(TenantContext.getTenant(), paramObj);
        msgParamsVO.setReceiveParamMap(receiveParamMap);
        return msgParamsVO;
    }
}

