/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.bidding.service.impl;

import cn.hutool.core.bean.BeanUtil;
import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.els.common.aspect.annotation.SrmTransaction;
import com.els.common.enumerate.AuditStatusEnum;
import com.els.common.exception.ELSBootException;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.vo.LoginUser;
import com.els.common.util.I18nUtil;
import com.els.common.util.IPUtils;
import com.els.common.util.SysUtil;
import com.els.modules.bidding.entity.BiddingSupplier;
import com.els.modules.bidding.entity.PurchaseBiddingHead;
import com.els.modules.bidding.entity.PurchaseBiddingItem;
import com.els.modules.bidding.entity.PurchaseBiddingSpecialist;
import com.els.modules.bidding.entity.SaleBiddingHead;
import com.els.modules.bidding.entity.SaleBiddingItem;
import com.els.modules.bidding.enumerate.BiddingItemStatusEnum;
import com.els.modules.bidding.enumerate.BiddingStatusEnum;
import com.els.modules.bidding.enumerate.MemberRoleEnum;
import com.els.modules.bidding.enumerate.MemberTypeEnum;
import com.els.modules.bidding.enumerate.ReplyStatusEnum;
import com.els.modules.bidding.enumerate.RiskTypeEnum;
import com.els.modules.bidding.mapper.BiddingSupplierMapper;
import com.els.modules.bidding.mapper.PurchaseBiddingHeadMapper;
import com.els.modules.bidding.mapper.PurchaseBiddingItemMapper;
import com.els.modules.bidding.mapper.PurchaseBiddingSpecialistMapper;
import com.els.modules.bidding.mapper.SaleBiddingHeadMapper;
import com.els.modules.bidding.mapper.SaleBiddingItemMapper;
import com.els.modules.bidding.service.BiddingSupplierService;
import com.els.modules.bidding.service.PurchaseBiddingItemService;
import com.els.modules.bidding.service.SaleBiddingItemService;
import com.els.modules.bidding.vo.BiddingSupplierVO;
import com.els.modules.bidding.vo.SupplierInvesttreeInfoVO;
import com.els.modules.bidding.vo.SupplierRelationFindResultVO;
import com.els.modules.demand.entity.PurchaseRequestItem;
import com.els.modules.demand.enumerate.PurchaseRequestStatusItemEnum;
import com.els.modules.demand.mapper.PurchaseRequestItemMapper;
import com.els.modules.demand.service.PurchaseRequestItemService;
import com.els.modules.inquiry.enumerate.PriceCreateWayEnum;
import com.els.modules.inquiry.rpc.service.InquiryInvokeMainDataRpcService;
import com.els.modules.inquiry.rpc.service.InquiryInvokeSupplierRpcService;
import com.els.modules.price.api.dto.PurchaseInformationRecordsDTO;
import com.els.modules.price.api.enumerate.PriceSourceTypeEnum;
import com.els.modules.price.api.enumerate.PurchaseInformationPriceTypeEnum;
import com.els.modules.supplier.api.dto.EnterpriseRiskDTO;
import com.els.modules.supplier.api.dto.SupplierCompanyHoldingDTO;
import com.els.modules.supplier.api.dto.SupplierHumanHoldingDTO;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service
public class BiddingSupplierServiceImpl
extends ServiceImpl<BiddingSupplierMapper, BiddingSupplier>
implements BiddingSupplierService {
    @Resource
    private BiddingSupplierMapper biddingSupplierMapper;
    @Resource
    private PurchaseBiddingHeadMapper purchaseBiddingHeadMapper;
    @Resource
    private PurchaseBiddingItemMapper purchaseBiddingItemMapper;
    @Resource
    private PurchaseBiddingItemService purchaseBiddingItemService;
    @Resource
    private SaleBiddingHeadMapper saleBiddingHeadMapper;
    @Resource
    private SaleBiddingItemMapper saleBiddingItemMapper;
    @Resource
    private SaleBiddingItemService saleBiddingItemService;
    @Resource
    private PurchaseBiddingSpecialistMapper purchaseBiddingSpecialistMapper;
    @Autowired
    private PurchaseRequestItemMapper purchaseRequestItemMapper;
    @Autowired
    private PurchaseRequestItemService purchaseRequestItemService;
    @Resource
    private InquiryInvokeMainDataRpcService inquiryInvokeMainDataRpcService;
    @Resource
    private InquiryInvokeSupplierRpcService inquiryInvokeSupplierRpcService;

    @Override
    public List<BiddingSupplier> selectByMainId(String mainId) {
        return this.biddingSupplierMapper.selectByMainId(mainId);
    }

    private void check(String id) {
        LoginUser user = SysUtil.getLoginUser();
        List specialistList = this.purchaseBiddingSpecialistMapper.selectByMainId(id).stream().filter(o -> MemberTypeEnum.PROJECT.getValue().equals(o.getMemberType())).filter(o -> MemberRoleEnum.BID_PRINCIPAL.getValue().equals(o.getMemberRole())).map(PurchaseBiddingSpecialist::getSubAccount).collect(Collectors.toList());
        if (!specialistList.contains(user.getSubAccount())) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_oper_no_bidding_principal_bidding", (String)"\u53ea\u6709\u62db\u6807\u8d1f\u8d23\u4eba\u53ef\u4ee5\u64cd\u4f5c\uff01"));
        }
    }

    private void checkParam(PurchaseBiddingHead head, List<BiddingSupplierVO> list) {
        this.check(head.getId());
        String quoteWay = head.getQuotaWay();
        HashMap<String, BigDecimal> checkQuotaMap = new HashMap<String, BigDecimal>();
        for (BiddingSupplierVO supplierVO : list) {
            List<PurchaseBiddingItem> purchaseBiddingItemList = supplierVO.getPurchaseBiddingItemList();
            for (PurchaseBiddingItem item : purchaseBiddingItemList) {
                if ("1".equals(quoteWay)) {
                    if (BiddingItemStatusEnum.BIDDING_WIN.getValue().equals(item.getItemStatus())) {
                        if (item.getPrice() == null) {
                            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_oper_no_quotation_bidding", (String)"\u672a\u62a5\u4ef7\u7684\u884c\u9879\u4e0d\u80fd\u8bbe\u7f6e\u4e2d\u6807\uff01"));
                        }
                        if (item.getQuota() == null) {
                            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_empty_no_input_split_proportion_bidding", (String)"\u8bf7\u8f93\u5165\u5bf9\u5e94\u4e2d\u6807\u9879\u7684\u62c6\u5206\u6bd4\u7387%\uff01"));
                        }
                        if (checkQuotaMap.containsKey(item.getItemNumber())) {
                            checkQuotaMap.put(item.getItemNumber(), ((BigDecimal)checkQuotaMap.get(item.getItemNumber())).add(item.getQuota()));
                            continue;
                        }
                        checkQuotaMap.put(item.getItemNumber(), item.getQuota());
                        continue;
                    }
                    if (item.getQuota() == null) continue;
                    throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_fail_input_split_proportion_no_win_bid_bidding", (String)"\u672a\u4e2d\u6807\u9879\u4e0d\u80fd\u5f55\u5165\u62c6\u5206\u6bd4\u7387%\uff01"));
                }
                if (BiddingItemStatusEnum.BIDDING_WIN.getValue().equals(item.getItemStatus())) {
                    if (item.getPrice() == null) {
                        throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_oper_no_quotation_bidding", (String)"\u672a\u62a5\u4ef7\u7684\u884c\u9879\u4e0d\u80fd\u8bbe\u7f6e\u4e2d\u6807\uff01"));
                    }
                    item.setQuota(BigDecimal.valueOf(100L));
                    if (checkQuotaMap.containsKey(item.getItemNumber())) {
                        checkQuotaMap.put(item.getItemNumber(), ((BigDecimal)checkQuotaMap.get(item.getItemNumber())).add(item.getQuota()));
                        continue;
                    }
                    checkQuotaMap.put(item.getItemNumber(), item.getQuota());
                    continue;
                }
                if (item.getQuota() == null || item.getQuota().compareTo(BigDecimal.ZERO) == 0) continue;
                throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_fail_input_split_proportion_no_win_bid_bidding", (String)"\u672a\u4e2d\u6807\u9879\u4e0d\u80fd\u5f55\u5165\u62c6\u5206\u6bd4\u7387%\uff01"));
            }
        }
        for (String itemNumber : checkQuotaMap.keySet()) {
            BigDecimal quota = (BigDecimal)checkQuotaMap.get(itemNumber);
            if (quota == null || quota.compareTo(BigDecimal.valueOf(100L)) == 0) continue;
            if (!"1".equals(quoteWay)) {
                throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_fail_split_proportion_no_eq_100_bidding", (String)"\u4e2d\u6807\u6bd4\u7387\u4e4b\u548c\u5fc5\u987b\u7b49\u4e8e100%"));
            }
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_fail_must_select_one_supplier_bidding", (String)"\u53ea\u80fd\u9009\u62e9\u4e00\u5bb6\u4f9b\u5e94\u5546\u4e2d\u6807\uff01"));
        }
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void confirmBid(String headId, List<BiddingSupplierVO> list) {
        PurchaseBiddingHead head = (PurchaseBiddingHead)((Object)this.purchaseBiddingHeadMapper.selectById((Serializable)((Object)headId)));
        this.optConfirmBid(head, list);
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void saveConfirmBid(String headId, List<BiddingSupplierVO> list) {
        PurchaseBiddingHead head = (PurchaseBiddingHead)((Object)this.purchaseBiddingHeadMapper.selectById((Serializable)((Object)headId)));
        this.optConfirmBid(head, list);
    }

    private void optConfirmBid(PurchaseBiddingHead head, List<BiddingSupplierVO> list) {
        if (!BiddingStatusEnum.EVA_BIDDING.getValue().equals(head.getBiddingStatus()) && !BiddingStatusEnum.CONFIRM_ING.getValue().equals(head.getBiddingStatus())) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_fail_status_can_not_determine_bid_bidding", (String)"\u5f53\u524d\u72b6\u6001\u4e0d\u80fd\u5b9a\u6807\uff01"));
        }
        this.checkParam(head, list);
        ArrayList<PurchaseBiddingItem> batchUpdate = new ArrayList<PurchaseBiddingItem>();
        for (BiddingSupplierVO supplierVO : list) {
            List<PurchaseBiddingItem> purchaseBiddingItemList = supplierVO.getPurchaseBiddingItemList();
            for (PurchaseBiddingItem item : purchaseBiddingItemList) {
                if (BiddingItemStatusEnum.BIDDING_WIN.getValue().equals(item.getItemStatus())) continue;
                item.setItemStatus(BiddingItemStatusEnum.BIDDING_FAIL.getValue());
            }
            batchUpdate.addAll(purchaseBiddingItemList);
        }
        if (!batchUpdate.isEmpty()) {
            this.purchaseBiddingItemService.updateBatchById(batchUpdate, 2000);
        }
        LoginUser user = SysUtil.getLoginUser();
        PurchaseBiddingHead purchaseBiddingHead = new PurchaseBiddingHead();
        purchaseBiddingHead.setId(head.getId());
        purchaseBiddingHead.setBiddingStatus(BiddingStatusEnum.CONFIRM_ED.getValue());
        purchaseBiddingHead.setConfirmBidIp(IPUtils.getIpAddr());
        purchaseBiddingHead.setConfirmBidBy(user.getSubAccount());
        int count = this.purchaseBiddingHeadMapper.updateById((Object)purchaseBiddingHead);
        if (count == 0) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_APWFIKXWVVVXVSDJHrW_2fe92d52", (String)"\u5f53\u524d\u6570\u636e\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u5237\u65b0\u540e\u63d0\u4ea4\u66f4\u6539"));
        }
        String resultAudit = head.getResultAudit();
        if (!"1".equals(resultAudit)) {
            this.publish(head.getId());
        }
    }

    @Override
    public List<BiddingSupplierVO> findConfirmBidList(String headId, boolean isCheck) {
        if (isCheck) {
            this.check(headId);
        }
        List biddingSupplierList = this.biddingSupplierMapper.selectByMainId(headId).stream().filter(o -> o.getReplyStatus().equals(ReplyStatusEnum.QUOTE_BID.getValue())).collect(Collectors.toList());
        List<PurchaseBiddingItem> purchaseBiddingItemList = this.purchaseBiddingItemMapper.selectByMainId(headId);
        Map<String, List<PurchaseBiddingItem>> itemMap = purchaseBiddingItemList.stream().collect(Collectors.groupingBy(PurchaseBiddingItem::getToElsAccount));
        ArrayList<BiddingSupplierVO> resultList = new ArrayList<BiddingSupplierVO>();
        for (BiddingSupplier supplier : biddingSupplierList) {
            BiddingSupplierVO supplierVO = new BiddingSupplierVO();
            BeanUtil.copyProperties((Object)((Object)supplier), (Object)((Object)supplierVO), (String[])new String[0]);
            supplierVO.setPurchaseBiddingItemList(itemMap.get(supplier.getToElsAccount()));
            resultList.add(supplierVO);
        }
        return resultList;
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void publish(String headId) {
        BigDecimal budgetAmount;
        List<BiddingSupplier> biddingSupplierList = this.biddingSupplierMapper.selectByMainId(headId);
        List<PurchaseBiddingItem> purchaseBiddingItemList = this.purchaseBiddingItemMapper.selectByMainId(headId);
        SaleBiddingHead saleBiddingHead = new SaleBiddingHead();
        saleBiddingHead.setRelationId(headId);
        saleBiddingHead.setBiddingStatus(BiddingStatusEnum.CONFIRM_ED.getValue());
        this.saleBiddingHeadMapper.update((Object)saleBiddingHead, (Wrapper)new QueryWrapper().eq((Object)"relation_id", (Object)headId));
        HashMap<String, String> supplierMap = new HashMap<String, String>();
        BigDecimal totalAmount = BigDecimal.ZERO;
        ArrayList<SaleBiddingItem> batchUpdateSaleBiddingItemList = new ArrayList<SaleBiddingItem>();
        ArrayList<PurchaseRequestItem> batchUpdatePurchaseRequestItemList = new ArrayList<PurchaseRequestItem>();
        for (PurchaseBiddingItem purchaseBiddingItem : purchaseBiddingItemList) {
            SaleBiddingItem saleItem = new SaleBiddingItem();
            saleItem.setId(purchaseBiddingItem.getRelationId());
            saleItem.setItemStatus(purchaseBiddingItem.getItemStatus());
            saleItem.setQuota(purchaseBiddingItem.getQuota());
            batchUpdateSaleBiddingItemList.add(saleItem);
            if (!BiddingItemStatusEnum.BIDDING_WIN.getValue().equals(purchaseBiddingItem.getItemStatus())) continue;
            supplierMap.put(purchaseBiddingItem.getToElsAccount(), "true");
            BigDecimal price = purchaseBiddingItem.getPrice();
            BigDecimal quota = purchaseBiddingItem.getQuota();
            BigDecimal quantity = purchaseBiddingItem.getRequireQuantity() == null ? BigDecimal.valueOf(1L) : purchaseBiddingItem.getRequireQuantity();
            BigDecimal amount = price.multiply(quota.divide(BigDecimal.valueOf(100L)).multiply(quantity));
            totalAmount = totalAmount.add(amount);
            if (!StringUtils.isNotBlank((CharSequence)purchaseBiddingItem.getSourceItemId())) continue;
            PurchaseRequestItem requestItem = new PurchaseRequestItem();
            requestItem.setId(purchaseBiddingItem.getSourceItemId());
            requestItem.setItemStatus(PurchaseRequestStatusItemEnum.TENDER_COMPLETED.getValue());
            batchUpdatePurchaseRequestItemList.add(requestItem);
        }
        if (!batchUpdateSaleBiddingItemList.isEmpty()) {
            this.saleBiddingItemService.updateBatchById(batchUpdateSaleBiddingItemList, 2000);
        }
        if (!batchUpdatePurchaseRequestItemList.isEmpty()) {
            this.purchaseRequestItemService.updateBatchById(batchUpdatePurchaseRequestItemList, 2000);
        }
        ArrayList<BiddingSupplier> batchUpdateBiddingSupplierList = new ArrayList<BiddingSupplier>();
        for (BiddingSupplier supplier : biddingSupplierList) {
            BiddingSupplier updateSupplier = new BiddingSupplier();
            updateSupplier.setId(supplier.getId());
            if (supplierMap.containsKey(supplier.getToElsAccount())) {
                updateSupplier.setBiddingStatus(BiddingItemStatusEnum.BIDDING_WIN.getValue());
            } else {
                updateSupplier.setBiddingStatus(BiddingItemStatusEnum.BIDDING_FAIL.getValue());
            }
            batchUpdateBiddingSupplierList.add(updateSupplier);
        }
        if (!batchUpdateBiddingSupplierList.isEmpty()) {
            this.updateBatchById(batchUpdateBiddingSupplierList, 2000);
        }
        PurchaseBiddingHead purchaseBiddingHead = (PurchaseBiddingHead)((Object)this.purchaseBiddingHeadMapper.selectById((Serializable)((Object)headId)));
        String priceCreateWay = purchaseBiddingHead.getPriceCreateWay();
        if (PriceCreateWayEnum.AUTO.getValue().equals(priceCreateWay)) {
            this.createPriceInfo(purchaseBiddingHead, purchaseBiddingItemList);
        }
        if ((budgetAmount = purchaseBiddingHead.getBudgetAmount()) != null) {
            BigDecimal economyAmount = budgetAmount.subtract(totalAmount);
            BigDecimal economyRate = economyAmount.divide(budgetAmount, 4, 4).multiply(BigDecimal.valueOf(100L));
            PurchaseBiddingHead updateHead = new PurchaseBiddingHead();
            updateHead.setEconomyAmount(economyAmount);
            updateHead.setEconomyRate(economyRate);
            updateHead.setId(purchaseBiddingHead.getId());
            int count = this.purchaseBiddingHeadMapper.updateById((Object)updateHead);
            if (count == 0) {
                throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_APWFIKXWVVVXVSDJHrW_2fe92d52", (String)"\u5f53\u524d\u6570\u636e\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u5237\u65b0\u540e\u63d0\u4ea4\u66f4\u6539"));
            }
        }
    }

    private void createPriceInfo(PurchaseBiddingHead head, List<PurchaseBiddingItem> purchaseBiddingItemList) {
        List<PurchaseBiddingItem> acceptList = purchaseBiddingItemList.stream().filter(o -> BiddingItemStatusEnum.BIDDING_WIN.getValue().equals(o.getItemStatus())).collect(Collectors.toList());
        acceptList.forEach(item -> {
            if (!PriceCreateWayEnum.NOT.getValue().equals(head.getPriceCreateWay())) {
                Assert.hasText((String)item.getMaterialNumber(), (String)I18nUtil.translate((String)"", (String)"\u8bf7\u5148\u8865\u5145\u7269\u6599\u7f16\u7801"));
            }
        });
        ArrayList<PurchaseInformationRecordsDTO> recordsList = new ArrayList<PurchaseInformationRecordsDTO>();
        for (PurchaseBiddingItem item2 : acceptList) {
            PurchaseInformationRecordsDTO records = new PurchaseInformationRecordsDTO();
            BeanUtils.copyProperties((Object)((Object)item2), (Object)records);
            records.setSourceType(PriceSourceTypeEnum.BIDDING.getValue());
            records.setSourceNumber(head.getBiddingNumber());
            records.setSourceItemNumber(item2.getItemNumber());
            records.setAuditStatus(AuditStatusEnum.AUDIT_FINISH.getValue());
            records.setPriceType(PurchaseInformationPriceTypeEnum.MATERIAL.getValue());
            records.setCompany(head.getCompany());
            records.setPurchaseOrg(head.getPurchaseOrg());
            records.setPurchaseGroup(head.getPurchaseGroup());
            records.setCurrencyCode(item2.getCurrency());
            this.inquiryInvokeMainDataRpcService.checkPriceIfExistByBidding(records);
            recordsList.add(records);
        }
        this.inquiryInvokeMainDataRpcService.cutOffPriceDates(recordsList);
        this.inquiryInvokeMainDataRpcService.addBatch(recordsList);
    }

    @Override
    public void manualCreatePrce(String headId) {
        this.check(headId);
        PurchaseBiddingHead head = (PurchaseBiddingHead)((Object)this.purchaseBiddingHeadMapper.selectById((Serializable)((Object)headId)));
        if (!BiddingStatusEnum.CONFIRM_ED.getValue().equals(head.getBiddingStatus())) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_fail_status_can_not_add_price_record", (String)"\u5f53\u524d\u72b6\u6001\u4e0d\u80fd\u751f\u6210\u4ef7\u683c\u8bb0\u5f55\uff01"));
        }
        String resultAudit = head.getResultAudit();
        if ("1".equals(resultAudit) && !AuditStatusEnum.AUDIT_FINISH.getValue().equals(head.getResultAuditStatus())) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_fail_add_price_record_by_approved", (String)"\u5b9a\u4ef7\u5ba1\u6279\u901a\u8fc7\u540e\u624d\u80fd\u751f\u6210\u4ef7\u683c\u8bb0\u5f55\uff01"));
        }
        List<PurchaseBiddingItem> purchaseBiddingItemList = this.purchaseBiddingItemMapper.selectByMainId(headId);
        this.createPriceInfo(head, purchaseBiddingItemList);
    }

    @Override
    public void replenishMaterialNumber(PurchaseBiddingItem webItem) {
        List itemList = this.purchaseBiddingItemMapper.selectByMainId(webItem.getHeadId()).stream().filter(item -> item.getItemNumber().equals(webItem.getItemNumber())).collect(Collectors.toList());
        List<String> itemIds = itemList.stream().map(BaseEntity::getId).collect(Collectors.toList());
        this.purchaseBiddingItemMapper.updateMaterialBatchById(webItem, itemIds);
    }

    @Override
    public List<SupplierRelationFindResultVO> queryRiskRelationFind(Map<String, BiddingSupplier> biddingSupplierMap) {
        ArrayList<SupplierRelationFindResultVO> relationFindResultList = new ArrayList<SupplierRelationFindResultVO>();
        Set<String> elsAccountList = biddingSupplierMap.keySet();
        List<EnterpriseRiskDTO> riskDTOS = this.inquiryInvokeSupplierRpcService.queryRiskRelationFind(elsAccountList);
        if (riskDTOS.isEmpty()) {
            return relationFindResultList;
        }
        Map riskDTOMap = riskDTOS.parallelStream().collect(Collectors.toMap(EnterpriseRiskDTO::getElsAccount, Function.identity()));
        HashMap<String, Map<String, String>> supplierInvesttreeMap = new HashMap<String, Map<String, String>>();
        HashMap<String, Map<String, String>> supplierHumanHoldingMap = new HashMap<String, Map<String, String>>();
        HashMap<String, Map<String, String>> supplierCompanyHoldingMap = new HashMap<String, Map<String, String>>();
        for (String elsAccount : riskDTOMap.keySet()) {
            EnterpriseRiskDTO enterpriseRiskDTO = (EnterpriseRiskDTO)riskDTOMap.get(elsAccount);
            HashMap supplierMap = new HashMap();
            enterpriseRiskDTO.getSupplierInvesttreeList().parallelStream().forEach(supplierInvesttreeDTO -> {
                supplierMap.put(supplierInvesttreeDTO.getCreditCode(), supplierInvesttreeDTO.getSupplierName());
                this.getAllSupplierCreditCode(supplierMap, supplierInvesttreeDTO.getChildren());
            });
            supplierInvesttreeMap.put(elsAccount, supplierMap);
            Map<String, String> humanHoldingMap = enterpriseRiskDTO.getSupplierHumanHoldingList().parallelStream().collect(Collectors.toMap(SupplierHumanHoldingDTO::getCid, SupplierHumanHoldingDTO::getName, (key1, key2) -> key2));
            supplierHumanHoldingMap.put(elsAccount, humanHoldingMap);
            Map<String, String> companyHoldingMap = enterpriseRiskDTO.getSupplierCompanyHoldingList().parallelStream().collect(Collectors.toMap(SupplierCompanyHoldingDTO::getCid, SupplierCompanyHoldingDTO::getName, (key1, key2) -> key2));
            supplierCompanyHoldingMap.put(elsAccount, companyHoldingMap);
        }
        relationFindResultList.addAll(this.analyseSupplierRelationRisk(biddingSupplierMap, supplierInvesttreeMap, RiskTypeEnum.INVESTTREE.getValue()));
        relationFindResultList.addAll(this.analyseSupplierRelationRisk(biddingSupplierMap, supplierHumanHoldingMap, RiskTypeEnum.HUMANHOLDING.getValue()));
        relationFindResultList.addAll(this.analyseSupplierRelationRisk(biddingSupplierMap, supplierCompanyHoldingMap, RiskTypeEnum.COMPANYHOLD.getValue()));
        return relationFindResultList;
    }

    private List<SupplierRelationFindResultVO> analyseSupplierRelationRisk(Map<String, BiddingSupplier> biddingSupplierMap, Map<String, Map<String, String>> supplierInvesttreeMap, String type) {
        ArrayList<SupplierRelationFindResultVO> relationFindResultList = new ArrayList<SupplierRelationFindResultVO>();
        ArrayList<String> hadCheckedSupplierElsAccount = new ArrayList<String>();
        for (String elsAccount : supplierInvesttreeMap.keySet()) {
            Map<String, String> supplierMap = supplierInvesttreeMap.get(elsAccount);
            hadCheckedSupplierElsAccount.add(elsAccount);
            for (String nextElsAccount : supplierInvesttreeMap.keySet()) {
                if (hadCheckedSupplierElsAccount.contains(nextElsAccount)) continue;
                Map<String, String> nextSupplierMap = supplierInvesttreeMap.get(nextElsAccount);
                Set<String> compareKeySet = nextSupplierMap.keySet();
                for (String compareKey : compareKeySet) {
                    if (!supplierMap.containsKey(compareKey)) continue;
                    SupplierRelationFindResultVO findResultVO = new SupplierRelationFindResultVO();
                    findResultVO.setSourceName(biddingSupplierMap.get(elsAccount).getSupplierName());
                    findResultVO.setToName(biddingSupplierMap.get(nextElsAccount).getSupplierName());
                    findResultVO.setResult(nextSupplierMap.get(compareKey));
                    findResultVO.setType(type);
                    relationFindResultList.add(findResultVO);
                }
            }
        }
        return relationFindResultList;
    }

    private void getAllSupplierCreditCode(Map<String, String> supplierMap, String children) {
        if (StringUtils.isBlank((CharSequence)children) || "[]".equals(children)) {
            return;
        }
        List supplierInvesttreeInfos = JSON.parseArray((String)children, SupplierInvesttreeInfoVO.class);
        supplierInvesttreeInfos.parallelStream().forEach(supplierInvesttreeInfo -> {
            if (StringUtils.isNotBlank((CharSequence)supplierInvesttreeInfo.getCreditCode())) {
                supplierMap.put(supplierInvesttreeInfo.getCreditCode(), supplierInvesttreeInfo.getName());
            }
            this.getAllSupplierCreditCode(supplierMap, supplierInvesttreeInfo.getChildren());
        });
    }
}

