/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.ebidding.websocket;

import cn.hutool.core.lang.UUID;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import javax.websocket.OnClose;
import javax.websocket.OnMessage;
import javax.websocket.OnOpen;
import javax.websocket.Session;
import javax.websocket.server.PathParam;
import javax.websocket.server.ServerEndpoint;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
@ServerEndpoint(value="/websocket/bidding/{ebiddingNumber}")
public class EbiddingWebSocket {
    private static final Logger log = LoggerFactory.getLogger(EbiddingWebSocket.class);
    private Session session;
    private String ebiddingNumber;
    private String id;
    private static Map<String, List<EbiddingWebSocket>> clientMap = new ConcurrentHashMap<String, List<EbiddingWebSocket>>();

    @OnOpen
    public void onOpen(Session session, @PathParam(value="ebiddingNumber") String ebiddingNumber) {
        try {
            this.session = session;
            this.ebiddingNumber = ebiddingNumber;
            this.id = UUID.randomUUID().toString();
            List<EbiddingWebSocket> clients = clientMap.get(ebiddingNumber);
            if (clients == null) {
                clients = new ArrayList<EbiddingWebSocket>();
            }
            clients.add(this);
            clientMap.put(ebiddingNumber, clients);
        }
        catch (Exception e) {
            log.error("\u3010EbiddingWebSocket\u6d88\u606f\u3011\u5efa\u7acb\u8fde\u63a5\u5f02\u5e38");
        }
    }

    @OnClose
    public void onClose() {
        try {
            List<EbiddingWebSocket> clients = clientMap.get(this.ebiddingNumber);
            if (clients != null) {
                List result = clients.parallelStream().filter(socket -> !this.id.equals(socket.id)).collect(Collectors.toList());
                clientMap.put(this.ebiddingNumber, result);
            }
            log.info("\u3010EbiddingWebSocket\u6d88\u606f\u3011\u8fde\u63a5\u65ad\u5f00");
        }
        catch (Exception e) {
            log.error("\u3010EbiddingWebSocket\u6d88\u606f\u3011\u65ad\u5f00\u8fde\u63a5\u5f02\u5e38");
        }
    }

    @OnMessage
    public void onMessage(String message) {
        this.session.getAsyncRemote().sendText("heartcheck");
    }

    public static void sendQuoteMessage(String ebiddingNumber, String message) {
        List<EbiddingWebSocket> clients = clientMap.get(ebiddingNumber);
        if (clients != null && !clients.isEmpty()) {
            for (EbiddingWebSocket socket : clients) {
                if (socket.session == null || !socket.session.isOpen()) continue;
                try {
                    socket.session.getAsyncRemote().sendText(message);
                }
                catch (Exception e) {
                    log.error("printStackTrace:", (Throwable)e);
                }
            }
        }
    }
}

