/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.searchSourceConfig.enums;

import com.els.common.util.AssertI18nUtil;
import com.els.modules.searchSourceConfig.enums.I18nSearSourEnum;
import com.els.modules.searchSourceConfig.utils.BigDecimalUtil;
import com.els.modules.searchSourceConfig.vo.MaterialDataVo;
import com.els.modules.searchSourceConfig.vo.PurAmountThresItemVo;
import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;

public enum AmountThresholdValidEnum {
    ROW("0"){

        @Override
        public void amountThreValid(String cateCode, String amountThreshold, List<MaterialDataVo> materDataVos) {
            materDataVos.forEach(materialDataVo -> {
                if (!cateCode.equals(materialDataVo.getCateCode()) || materialDataVo.getAmount() == null) {
                    return;
                }
                AssertI18nUtil.isTrue((boolean)BigDecimalUtil.bigThan(materialDataVo.getAmount(), amountThreshold), (Enum)I18nSearSourEnum.ROW_BIG_THAN_AMOUNT_THRESHOLD, (String[])new String[]{StringUtils.isNotBlank((CharSequence)materialDataVo.getMaterialNumber()) ? materialDataVo.getMaterialNumber() : materialDataVo.getCateCode(), "\u6309\u884c\u7edf\u8ba1", amountThreshold});
            });
        }
    }
    ,
    MATERIAL("1"){

        @Override
        public void amountThreValid(String cateCode, String amountThreshold, List<MaterialDataVo> materDataVos) {
            BigDecimal total = materDataVos.stream().filter(dataVo -> dataVo.getAmount() != null && Objects.equals(cateCode, dataVo.getCateCode())).map(MaterialDataVo::getAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
            AssertI18nUtil.isTrue((boolean)BigDecimalUtil.bigThan(total, amountThreshold), (Enum)I18nSearSourEnum.BIG_THAN_AMOUNT_THRESHOLD, (String[])new String[]{cateCode, "\u6309\u7269\u6599\u5206\u7c7b\u7edf\u8ba1", amountThreshold});
        }
    }
    ,
    ALL("2"){

        @Override
        public void amountThreValid(String materType, String amountThreshold, List<MaterialDataVo> materDataVos) {
        }
    };

    private final String statisticalType;
    private static final Map<String, AmountThresholdValidEnum> enumMap;

    public abstract void amountThreValid(String var1, String var2, List<MaterialDataVo> var3);

    public String statisticalType() {
        return this.statisticalType;
    }

    private AmountThresholdValidEnum(String statisticalType) {
        this.statisticalType = statisticalType;
    }

    public static AmountThresholdValidEnum of(String statisticalType) {
        AmountThresholdValidEnum typeEnum = enumMap.get(statisticalType);
        AssertI18nUtil.isTrue((typeEnum == null ? 1 : 0) != 0, (Enum)I18nSearSourEnum.STATISTICAL_TYPE_NOT_FOUND, (String[])new String[]{statisticalType});
        return typeEnum;
    }

    public static void validAmountThres(PurAmountThresItemVo itemVo, List<MaterialDataVo> materDataVos) {
        AmountThresholdValidEnum.of(itemVo.getStatisticalType()).amountThreValid(itemVo.getCateCode(), itemVo.getAmountThreshold(), materDataVos);
    }

    static {
        enumMap = Stream.of(AmountThresholdValidEnum.values()).collect(Collectors.toMap(AmountThresholdValidEnum::statisticalType, e -> e));
    }
}

